# Check if target still exists - if not, abort
execute unless entity @e[tag=rocket_turret_target] run tag @s remove rocket_firing
execute unless entity @e[tag=rocket_turret_target] run tag @s add dispenser_turret_cooldown
execute unless entity @e[tag=rocket_turret_target] run scoreboard players set @s turret_cooldown_timer 120
execute unless entity @e[tag=rocket_turret_target] run return 0

# Rotate loom to track target
execute store result score #this_id turret_beam_tick run scoreboard players get @s turret_beam_tick
execute as @e[type=block_display,tag=dispenser_turret_display] if score @s turret_beam_tick = #this_id turret_beam_tick at @s facing entity @e[tag=rocket_turret_target,limit=1,sort=nearest] feet run tp @s ~ ~ ~ ~ ~

# Fire sound
playsound minecraft:block.respawn_anchor.deplete block @a[distance=..40] ~ ~ ~ 2 1.5 1

# Draw beam
execute positioned ~ ~0.5 ~ facing entity @e[tag=rocket_turret_target,limit=1] feet run function dispenser_turret:rocket_beam_recursive

# Deal damage to main target
damage @e[tag=rocket_turret_target,limit=1] 10

# AOE damage at target location
execute at @e[tag=rocket_turret_target,limit=1] run damage @e[type=#dispenser_turret:targets,distance=..4,limit=5,sort=nearest,tag=!rocket_turret_target] 5

# Explosion particles at target
execute at @e[tag=rocket_turret_target,limit=1] run particle minecraft:explosion_emitter ~ ~1 ~ 0 0 0 0 1 force
execute at @e[tag=rocket_turret_target,limit=1] run particle minecraft:flame ~ ~1 ~ 2 2 2 0.3 100 force
execute at @e[tag=rocket_turret_target,limit=1] run particle minecraft:smoke ~ ~1 ~ 2 2 2 0.2 50 force
execute at @e[tag=rocket_turret_target,limit=1] run playsound minecraft:entity.generic.explode block @a[distance=..50] ~ ~ ~ 2 1 1

# Turret sounds and particles
playsound minecraft:entity.blaze.shoot block @a[distance=..40] ~ ~ ~ 2 0.8 1
playsound minecraft:entity.firework_rocket.launch block @a[distance=..40] ~ ~ ~ 1.5 1.5 1
particle minecraft:electric_spark ~ ~0.5 ~ 0.2 0.2 0.2 0.1 15 force
particle minecraft:smoke ~ ~0.5 ~ 0.2 0.2 0.2 0.05 10 force
particle minecraft:cloud ~ ~0.5 ~ 0.2 0.2 0.2 0.05 8 force

# Shake animation
scoreboard players set @s turret_anim_timer 12
tag @s add dispenser_turret_animating

# Decrement shot counter
scoreboard players remove @s turret_rapid_shots 1

# If more shots remaining, switch to new random target
execute if score @s turret_rapid_shots matches 1.. run tag @e[tag=rocket_turret_target] remove rocket_turret_target
execute if score @s turret_rapid_shots matches 1.. at @s run tag @e[type=#dispenser_turret:targets,distance=..50,limit=1,sort=random] add rocket_turret_target

# If out of shots, end burst and go on cooldown
execute if score @s turret_rapid_shots matches ..0 run tag @e[tag=rocket_turret_target] remove rocket_turret_target
execute if score @s turret_rapid_shots matches ..0 run tag @s remove rocket_firing
execute if score @s turret_rapid_shots matches ..0 run tag @s add dispenser_turret_cooldown
execute if score @s turret_rapid_shots matches ..0 run scoreboard players set @s turret_cooldown_timer 120
execute if score @s turret_rapid_shots matches ..0 run playsound minecraft:block.respawn_anchor.deplete block @a[distance=..40] ~ ~ ~ 2 0.5 1
