# Clear old rocket targets globally
tag @e[tag=rocket_turret_target] remove rocket_turret_target

# Check if any targets exist in range
execute unless entity @e[type=#dispenser_turret:targets,distance=..50] run return 0

# Find the highest concentration of enemies (requires at least 2 within 4 blocks)
function dispenser_turret:find_enemy_concentration

# If valid concentration found, use it
execute if score #found_concentration turret_beam_tick matches 1.. run tag @e[type=#dispenser_turret:targets,distance=..50,limit=1,sort=nearest,tag=concentration_best] add rocket_turret_target

# Otherwise, fallback to nearest single target (50 block range for rocket mode - long range artillery)
execute if score #found_concentration turret_beam_tick matches 0 run tag @e[type=#dispenser_turret:targets,distance=..50,limit=1,sort=nearest] add rocket_turret_target

# Clear concentration tags
tag @e[tag=concentration_best] remove concentration_best

# Verify we found a target
execute unless entity @e[tag=rocket_turret_target,distance=..50] run return 0

# Sounds and particles
playsound minecraft:entity.firework_rocket.launch block @a[distance=..40] ~ ~ ~ 2 1.5 1
playsound minecraft:block.trial_spawner.about_to_spawn_item block @a[distance=..40] ~ ~ ~ 1.5 2 1
particle minecraft:firework ~ ~0.5 ~ 0.4 0.4 0.4 0.2 30 force
particle minecraft:flame ~ ~0.5 ~ 0.3 0.3 0.3 0.1 25 force

# Start charging (60 tick charge time for dramatic effect)
tag @s add dispenser_turret_charging
scoreboard players set @s turret_charge_timer 60
scoreboard players set @s turret_sound_timer 0
