# Convert spawner markers to actual turrets (reactive - only when spawned)
execute as @e[type=minecraft:marker,tag=dispenser_turret_spawner] at @s run function dispenser_turret:spawn_turret

# Handle raising sequence for newly spawned turrets (4 tick delay = 0.2 seconds per stage)
execute as @e[type=minecraft:marker,tag=dispenser_raising] if score @s turret_raise_timer matches 1.. run scoreboard players remove @s turret_raise_timer 1
execute as @e[type=minecraft:marker,tag=dispenser_raising] if score @s turret_raise_timer matches 0 if score @s turret_raise_stage matches ..2 at @s run function dispenser_turret:continue_raising
execute as @e[type=minecraft:marker,tag=dispenser_raising] if score @s turret_raise_stage matches 3.. at @s run function dispenser_turret:complete_raising

# Find turrets with nearby hostile mobs and shoot lasers (reduced to every 2 ticks, exclude raising turrets)
execute if score #global_tick dispenser_global_timer matches 0..1 as @e[type=minecraft:marker,tag=dispenser_turret,tag=!dispenser_raising] at @s run function dispenser_turret:turret_scan

# Handle charging turrets (keep every tick for responsiveness)
execute as @e[type=minecraft:marker,tag=dispenser_turret_charging,tag=rocket_mode] at @s run function dispenser_turret:handle_charging_rocket
execute as @e[type=minecraft:marker,tag=dispenser_turret_charging,tag=!rocket_mode] at @s run function dispenser_turret:handle_charging

# Handle flame mode charging (separate from normal charging)
execute as @e[type=minecraft:marker,tag=flame_charging] at @s run function dispenser_turret:flame_handle_charging

# Handle mortar mode charging (separate from normal charging)
execute as @e[type=minecraft:marker,tag=mortar_charging] at @s run function dispenser_turret:mortar_handle_charging

# Handle mortar fast spin after firing (2 seconds of fast spinning)
execute as @e[type=minecraft:marker,tag=mortar_fast_spin] at @s run function dispenser_turret:mortar_fast_spin

# Handle mortar idle rotation (slow spin when not charging, not fast spinning)
execute as @e[type=minecraft:marker,tag=dispenser_turret,tag=mortar_mode] unless entity @s[tag=mortar_charging] unless entity @s[tag=mortar_fast_spin] at @s run function dispenser_turret:mortar_idle_spin

# Handle minigun firing (shoots every 2 ticks, only for turrets with minigun_firing tag)
execute as @e[type=minecraft:marker,tag=dispenser_turret,tag=minigun_firing] run scoreboard players add @s turret_sound_timer 1
execute as @e[type=minecraft:marker,tag=dispenser_turret,tag=minigun_firing] if score @s turret_sound_timer matches 2.. run scoreboard players set @s turret_sound_timer 0
execute as @e[type=minecraft:marker,tag=dispenser_turret,tag=minigun_firing] if score @s turret_sound_timer matches 0 at @s run function dispenser_turret:minigun_fire

# Handle rocket firing (shoots every 10 ticks, uses separate timer)
execute as @e[type=minecraft:marker,tag=dispenser_turret,tag=rocket_firing] if score @s turret_rocket_timer matches 0 at @s run function dispenser_turret:rocket_fire
execute as @e[type=minecraft:marker,tag=dispenser_turret,tag=rocket_firing] run scoreboard players add @s turret_rocket_timer 1
execute as @e[type=minecraft:marker,tag=dispenser_turret,tag=rocket_firing] if score @s turret_rocket_timer matches 10.. run scoreboard players set @s turret_rocket_timer 0

# Handle cooldown timers (keep every tick)
execute as @e[type=minecraft:marker,tag=dispenser_turret_cooldown] run function dispenser_turret:handle_cooldown

# Handle command block animation (keep every tick for smooth animation)
execute as @e[type=minecraft:marker,tag=dispenser_turret_animating] at @s run function dispenser_turret:handle_animation

# Handle punch detection on interaction entities
execute as @e[type=interaction,tag=dispenser_interaction,nbt={attack:{}}] at @s run function dispenser_turret:handle_punch

# Handle right-click to toggle firing mode
execute as @e[type=interaction,tag=dispenser_interaction,nbt={interaction:{}}] at @s run function dispenser_turret:toggle_firing_mode

# Handle punch timer countdown and reset
execute as @e[type=interaction,tag=dispenser_interaction] if score @s turret_punch_timer matches 1.. run scoreboard players remove @s turret_punch_timer 1
execute as @e[type=interaction,tag=dispenser_interaction] if score @s turret_punch_timer matches 0 run scoreboard players set @s turret_punch_count 0

# Handle automatic lowering sequence (2 tick delay = 0.1 seconds)
execute as @e[type=interaction,tag=dispenser_interaction,tag=dispenser_lowering] if score @s turret_lower_timer matches 1.. run scoreboard players remove @s turret_lower_timer 1
execute as @e[type=interaction,tag=dispenser_interaction,tag=dispenser_lowering] if score @s turret_lower_timer matches 0 if score @s turret_punch_count matches ..5 at @s run function dispenser_turret:continue_lowering
execute as @e[type=interaction,tag=dispenser_interaction,tag=dispenser_lowering] if score @s turret_punch_count matches 6.. at @s run function dispenser_turret:remove_turret_final

# Global timer for staggered checks
scoreboard players add #global_tick dispenser_global_timer 1
execute if score #global_tick dispenser_global_timer matches 10.. run scoreboard players set #global_tick dispenser_global_timer 0

# Add custom trade to wandering traders (check every 20 ticks for performance)
execute if score #global_tick dispenser_global_timer matches 0 as @e[type=wandering_trader,tag=!dispenser_turret_trader_modified] run function dispenser_turret:wandering_trader_trades
