/*
 * Decompiled with CFR 0.152.
 */
package com.kyphis.gigaremo.compat;

import com.kyphis.gigaremo.Config;
import com.kyphis.gigaremo.block.ModBlocks;
import com.kyphis.gigaremo.block.custom.Gigaremoblue_EBlock;
import com.kyphis.gigaremo.block.custom.Gigaremogreen_EBlock;
import com.kyphis.gigaremo.block.custom.Gigaremored_EBlock;
import com.kyphis.gigaremo.block.custom.Gigaremoyellow_EBlock;
import com.kyphis.gigaremo.compat.moveskills.GigaremoFlood;
import com.kyphis.gigaremo.compat.moveskills.GigaremoLightning;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public final class PixelmonMoveSkillCompat {
    private static final int SEARCH_RADIUS = 1;

    private PixelmonMoveSkillCompat() {
    }

    public static void tryInit() {
        block11: {
            Method addMoveSkill;
            Class<?> moveSkillClass;
            try {
                Object floodSkill = GigaremoFlood.create();
                if (floodSkill != null) {
                    moveSkillClass = Class.forName("com.pixelmonmod.pixelmon.api.moveskills.MoveSkill");
                    addMoveSkill = moveSkillClass.getMethod("addMoveSkill", moveSkillClass);
                    addMoveSkill.invoke(null, floodSkill);
                }
            }
            catch (Throwable floodSkill) {
                // empty catch block
            }
            try {
                Object lightningSkill = GigaremoLightning.create();
                if (lightningSkill == null) break block11;
                moveSkillClass = Class.forName("com.pixelmonmod.pixelmon.api.moveskills.MoveSkill");
                try {
                    Method removeMoveSkill = moveSkillClass.getMethod("removeMoveSkill", String.class);
                    removeMoveSkill.invoke(null, "lightning_bolt");
                }
                catch (Throwable removeMoveSkill) {
                    // empty catch block
                }
                addMoveSkill = moveSkillClass.getMethod("addMoveSkill", moveSkillClass);
                addMoveSkill.invoke(null, lightningSkill);
            }
            catch (Throwable lightningSkill) {
                // empty catch block
            }
        }
        try {
            Class<?> pixelmonClass = Class.forName("com.pixelmonmod.pixelmon.Pixelmon");
            Field eventBusField = pixelmonClass.getDeclaredField("EVENT_BUS");
            Object eventBus = eventBusField.get(null);
            if (eventBus == null) {
                return;
            }
            Class<?> useMoveSkillEventClass = Class.forName("com.pixelmonmod.pixelmon.api.events.moveskills.UseMoveSkillEvent");
            Method addListener = PixelmonMoveSkillCompat.findAddListenerMethod(eventBus.getClass());
            if (addListener == null) {
                return;
            }
            Consumer<Object> consumer = evt -> {
                try {
                    PixelmonMoveSkillCompat.handleUseMoveSkillEvent(evt);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            };
            addListener.invoke(eventBus, useMoveSkillEventClass, consumer);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static Method findAddListenerMethod(Class<?> busClass) {
        for (Method m : busClass.getMethods()) {
            Class<?>[] params;
            if (!m.getName().equals("addListener") || (params = m.getParameterTypes()).length != 2 || params[0] != Class.class) continue;
            return m;
        }
        return null;
    }

    private static void handleUseMoveSkillEvent(Object event) throws Exception {
        if (event == null) {
            return;
        }
        Class<?> evtClass = event.getClass();
        Field moveSkillField = evtClass.getDeclaredField("moveSkill");
        moveSkillField.setAccessible(true);
        Object moveSkill = moveSkillField.get(event);
        if (moveSkill == null) {
            return;
        }
        Method idMethod = moveSkill.getClass().getMethod("id", new Class[0]);
        String moveId = (String)idMethod.invoke(moveSkill, new Object[0]);
        if (moveId == null) {
            return;
        }
        String idLower = moveId.toLowerCase();
        BlockPos targetPos = null;
        ServerLevel serverLevel = null;
        Level world = null;
        Field dataField = evtClass.getDeclaredField("data");
        dataField.setAccessible(true);
        Object data = dataField.get(event);
        if (!(data instanceof Tuple)) {
            return;
        }
        Tuple tuple = (Tuple)data;
        Object a = tuple.getA();
        if (!(a instanceof BlockPos)) {
            return;
        }
        BlockPos blockPos = (BlockPos)a;
        targetPos = blockPos;
        Field pixelmonField = evtClass.getDeclaredField("pixelmon");
        pixelmonField.setAccessible(true);
        Object pixelmon = pixelmonField.get(event);
        if (pixelmon != null) {
            try {
                Method levelGetter = pixelmon.getClass().getMethod("level", new Class[0]);
                Object lvl = levelGetter.invoke(pixelmon, new Object[0]);
                if (lvl instanceof Level) {
                    Level l;
                    world = l = (Level)lvl;
                }
            }
            catch (NoSuchMethodException ignored) {
                try {
                    Field levelField = pixelmon.getClass().getDeclaredField("level");
                    levelField.setAccessible(true);
                    Object lvl = levelField.get(pixelmon);
                    if (lvl instanceof Level) {
                        Level l;
                        world = l = (Level)lvl;
                    }
                }
                catch (NoSuchFieldException levelField) {
                    // empty catch block
                }
            }
        }
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel sL = (ServerLevel)world;
        serverLevel = sL;
        GigaremoType type = null;
        if (idLower.equals("flood")) {
            type = GigaremoType.RED;
        } else if (idLower.contains("ignite") || idLower.contains("fire")) {
            type = GigaremoType.GREEN;
            if (((Boolean)Config.WATERLOGGED_PROTECTION.get()).booleanValue()) {
                BlockPos upper;
                BlockState upperState;
                BlockState targetState = serverLevel.getBlockState(targetPos);
                BlockPos lower = targetPos;
                if (targetState.hasProperty((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) && targetState.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) == DoubleBlockHalf.UPPER) {
                    lower = targetPos.below();
                }
                if ((upperState = serverLevel.getBlockState(upper = lower.above())).hasProperty((Property)BlockStateProperties.WATERLOGGED) && ((Boolean)upperState.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
                    try {
                        Method cooldownGetter = moveSkill.getClass().getMethod("cooldown", new Class[0]);
                        int cd = (Integer)cooldownGetter.invoke(moveSkill, new Object[0]);
                        boolean invokedCooldown = false;
                        for (Method m : evtClass.getMethods()) {
                            if (!m.getName().toLowerCase().contains("cooldown")) continue;
                            try {
                                m.invoke(event, cd);
                                invokedCooldown = true;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {}
                            break;
                        }
                    }
                    catch (Throwable cooldownGetter) {
                        // empty catch block
                    }
                    try {
                        Method cancelMethod = evtClass.getMethod("setCanceled", Boolean.TYPE);
                        cancelMethod.invoke(event, true);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    return;
                }
            }
        } else if (idLower.contains("rocksmash") || idLower.contains("rock_smash") || idLower.contains("rock smash")) {
            type = GigaremoType.YELLOW;
        }
        if (type == null) {
            return;
        }
        GigaremoType finalType = type;
        BlockPos finalTargetPos = targetPos;
        ServerLevel finalServerLevel = serverLevel;
        serverLevel.getServer().execute(() -> {
            BlockPos found = PixelmonMoveSkillCompat.findNearestMatchingGigaremo(finalServerLevel, finalTargetPos, finalType, 1);
            BlockPos usePos = found != null ? found : finalTargetPos;
            PixelmonMoveSkillCompat.breakGigaremoAt(finalServerLevel, usePos, finalType);
        });
    }

    private static BlockPos findNearestMatchingGigaremo(ServerLevel serverLevel, BlockPos center, GigaremoType type, int radius) {
        double bestDistSq = Double.MAX_VALUE;
        BlockPos best = null;
        int cx = center.getX();
        int cy = center.getY();
        int cz = center.getZ();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    double distSq;
                    BlockPos p = new BlockPos(cx + dx, cy + dy, cz + dz);
                    BlockState s = serverLevel.getBlockState(p);
                    if (!type.matchesBlock(s.getBlock())) continue;
                    BlockPos lower = p;
                    if (s.hasProperty((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) && s.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) == DoubleBlockHalf.UPPER) {
                        lower = p.below();
                    }
                    if (!((distSq = center.distSqr((Vec3i)lower)) < bestDistSq)) continue;
                    bestDistSq = distSq;
                    best = lower;
                }
            }
        }
        return best;
    }

    private static void breakGigaremoAt(ServerLevel serverLevel, BlockPos pos, GigaremoType type) {
        BlockPos upperPos;
        BlockState upperState;
        Objects.requireNonNull(serverLevel);
        BlockState targeted = serverLevel.getBlockState(pos);
        if (type == GigaremoType.RED && targeted.getFluidState().isSourceOfType((Fluid)Fluids.WATER)) {
            for (Direction dir : Direction.values()) {
                BlockPos adj = pos.relative(dir);
                BlockState adjState = serverLevel.getBlockState(adj);
                if (!type.matchesBlock(adjState.getBlock())) continue;
                targeted = adjState;
                pos = adj;
                break;
            }
        }
        BlockPos lowerPos = null;
        BlockState lowerState = null;
        if (type.matchesBlock(targeted.getBlock())) {
            if (targeted.hasProperty((Property)BlockStateProperties.DOUBLE_BLOCK_HALF)) {
                if (targeted.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) == DoubleBlockHalf.UPPER) {
                    lowerPos = pos.below();
                    lowerState = serverLevel.getBlockState(lowerPos);
                } else {
                    lowerPos = pos;
                    lowerState = targeted;
                }
            } else {
                lowerPos = pos;
                lowerState = targeted;
            }
        } else {
            BlockState below = serverLevel.getBlockState(pos.below());
            if (type.matchesBlock(below.getBlock())) {
                lowerPos = pos.below();
                lowerState = below;
            } else {
                BlockState above = serverLevel.getBlockState(pos.above());
                if (type.matchesBlock(above.getBlock())) {
                    lowerPos = pos.above().below();
                    lowerState = serverLevel.getBlockState(lowerPos);
                } else {
                    return;
                }
            }
        }
        if (lowerPos == null || lowerState == null) {
            return;
        }
        if (!type.matchesBlock(lowerState.getBlock())) {
            return;
        }
        if (!type.isActive(lowerState)) {
            return;
        }
        if (type == GigaremoType.GREEN && ((Boolean)Config.WATERLOGGED_PROTECTION.get()).booleanValue() && (upperState = serverLevel.getBlockState(upperPos = lowerPos.above())).hasProperty((Property)BlockStateProperties.WATERLOGGED) && ((Boolean)upperState.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            return;
        }
        BlockPos upperPos2 = lowerPos.above();
        upperState = serverLevel.getBlockState(upperPos2);
        boolean lowerWater = lowerState.hasProperty((Property)BlockStateProperties.WATERLOGGED) && (Boolean)lowerState.getValue((Property)BlockStateProperties.WATERLOGGED) != false;
        boolean upperWater = upperState.hasProperty((Property)BlockStateProperties.WATERLOGGED) && (Boolean)upperState.getValue((Property)BlockStateProperties.WATERLOGGED) != false;
        double x = (double)lowerPos.getX() + 0.5;
        double y = (double)lowerPos.getY() + 0.5;
        double z = (double)lowerPos.getZ() + 0.5;
        serverLevel.playSound(null, x, y, z, (Holder)SoundEvents.GENERIC_EXPLODE, SoundSource.BLOCKS, 1.0f, 1.0f);
        serverLevel.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
        serverLevel.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, lowerState), x, y, z, 80, 0.5, 0.5, 0.5, 0.05);
        serverLevel.setBlock(lowerPos, Blocks.AIR.defaultBlockState(), 35);
        serverLevel.setBlock(upperPos2, Blocks.AIR.defaultBlockState(), 35);
        BlockState brokenState = type.brokenBlock().defaultBlockState();
        if (brokenState.hasProperty((Property)BlockStateProperties.WATERLOGGED) && lowerWater) {
            brokenState = (BlockState)brokenState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true));
        }
        serverLevel.setBlock(lowerPos, brokenState, 3);
        if (brokenState.hasProperty((Property)BlockStateProperties.WATERLOGGED) && ((Boolean)brokenState.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            serverLevel.scheduleTick(lowerPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)serverLevel));
        }
        if (upperWater) {
            serverLevel.setBlock(upperPos2, Blocks.WATER.defaultBlockState(), 3);
            serverLevel.scheduleTick(upperPos2, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)serverLevel));
        }
    }

    private static enum GigaremoType {
        BLUE{

            @Override
            boolean matchesBlock(Object block) {
                return block == ModBlocks.GIGAREMOBLUE_EBLOCK.get();
            }

            @Override
            boolean isActive(BlockState state) {
                return (Boolean)state.getValue((Property)Gigaremoblue_EBlock.ACTIVE);
            }

            @Override
            Block brokenBlock() {
                return (Block)ModBlocks.BROKEN_GIGAREMOBLUE.get();
            }
        }
        ,
        GREEN{

            @Override
            boolean matchesBlock(Object block) {
                return block == ModBlocks.GIGAREMOGREEN_EBLOCK.get();
            }

            @Override
            boolean isActive(BlockState state) {
                return (Boolean)state.getValue((Property)Gigaremogreen_EBlock.ACTIVE);
            }

            @Override
            Block brokenBlock() {
                return (Block)ModBlocks.BROKEN_GIGAREMOGREEN.get();
            }
        }
        ,
        YELLOW{

            @Override
            boolean matchesBlock(Object block) {
                return block == ModBlocks.GIGAREMOYELLOW_EBLOCK.get();
            }

            @Override
            boolean isActive(BlockState state) {
                return (Boolean)state.getValue((Property)Gigaremoyellow_EBlock.ACTIVE);
            }

            @Override
            Block brokenBlock() {
                return (Block)ModBlocks.BROKEN_GIGAREMOYELLOW.get();
            }
        }
        ,
        RED{

            @Override
            boolean matchesBlock(Object block) {
                return block == ModBlocks.GIGAREMORED_EBLOCK.get();
            }

            @Override
            boolean isActive(BlockState state) {
                return (Boolean)state.getValue((Property)Gigaremored_EBlock.ACTIVE);
            }

            @Override
            Block brokenBlock() {
                return (Block)ModBlocks.BROKEN_GIGAREMORED.get();
            }
        };


        abstract boolean matchesBlock(Object var1);

        abstract boolean isActive(BlockState var1);

        abstract Block brokenBlock();
    }
}

