/*
 * Decompiled with CFR 0.152.
 */
package com.kyphis.gigaremo.compat.moveskills;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Random;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class GigaremoFlood {
    public static Object create() {
        try {
            Class<?> moveSkillClass = Class.forName("com.pixelmonmod.pixelmon.api.moveskills.MoveSkill");
            Object moveSkill = moveSkillClass.getConstructor(String.class).newInstance("flood");
            Method name = moveSkillClass.getMethod("name", String.class);
            Method descriptions = moveSkillClass.getMethod("descriptions", String[].class);
            Method sprite = moveSkillClass.getMethod("sprite", ResourceLocation.class);
            Method cooldown = moveSkillClass.getMethod("cooldown", Integer.TYPE);
            Method usePP = moveSkillClass.getMethod("usePP", Boolean.TYPE);
            Method addAnyMoves = moveSkillClass.getMethod("addAnyMoves", String[].class);
            Method rangeMethod = moveSkillClass.getMethod("range", Integer.TYPE);
            Method behaviourBlockTarget = moveSkillClass.getMethod("behaviourBlockTarget", BiFunction.class);
            name.invoke(moveSkill, "pixelmon.moveskill.flood");
            descriptions.invoke(moveSkill, new Object[]{new String[]{"pixelmon.moveskill.flood.description1", "pixelmon.moveskill.flood.description2"}});
            Class<?> rlClass = Class.forName("net.minecraft.resources.ResourceLocation");
            Method rlFactory = rlClass.getMethod("fromNamespaceAndPath", String.class, String.class);
            Object rl = rlFactory.invoke(null, "gigaremo", "textures/gui/overlay/externalmoves/flood.png");
            sprite.invoke(moveSkill, rl);
            cooldown.invoke(moveSkill, 800);
            usePP.invoke(moveSkill, true);
            rangeMethod.invoke(moveSkill, 7);
            addAnyMoves.invoke(moveSkill, new Object[]{new String[]{"Brine", "Chilling Water", "Hydro Cannon", "Hydro Pump", "Liquidation", "Octazooka", "Soak", "Surf", "Water Gun", "Water Pulse", "Water Sport", "Water Spout", "Waterfall", "Wave Crash", "Whirlpool"}});
            BiFunction<Object, Object, Integer> fn = (pixelmon, data) -> {
                try {
                    BlockPos pos = null;
                    Direction face = null;
                    if (data instanceof Tuple) {
                        Tuple tup = (Tuple)data;
                        Object a = tup.getA();
                        Object b = tup.getB();
                        if (a instanceof BlockPos) {
                            pos = (BlockPos)a;
                        } else if (b instanceof BlockPos) {
                            pos = (BlockPos)b;
                        }
                        if (b instanceof Direction) {
                            face = (Direction)b;
                        } else if (a instanceof Direction) {
                            face = (Direction)a;
                        }
                    } else if (data instanceof BlockPos) {
                        BlockPos bp;
                        pos = bp = (BlockPos)data;
                    }
                    if (pos == null) {
                        return -1;
                    }
                    Level level = null;
                    if (pixelmon instanceof Entity) {
                        Entity e = (Entity)pixelmon;
                        level = e.level();
                    } else if (pixelmon != null) {
                        try {
                            Method levelGetter = pixelmon.getClass().getMethod("level", new Class[0]);
                            Object lvl = levelGetter.invoke(pixelmon, new Object[0]);
                            if (lvl instanceof Level) {
                                Level l;
                                level = l = (Level)lvl;
                            }
                        }
                        catch (NoSuchMethodException ignored) {
                            try {
                                Field levelField = pixelmon.getClass().getDeclaredField("level");
                                levelField.setAccessible(true);
                                Object lvl = levelField.get(pixelmon);
                                if (lvl instanceof Level) {
                                    Level l;
                                    level = l = (Level)lvl;
                                }
                            }
                            catch (NoSuchFieldException levelField) {
                                // empty catch block
                            }
                        }
                    }
                    if (!(level instanceof ServerLevel)) {
                        return -1;
                    }
                    ServerLevel serverLevel = (ServerLevel)level;
                    BlockState targetState = serverLevel.getBlockState(pos);
                    String dimPath = serverLevel.dimension().location().getPath();
                    if (dimPath != null && dimPath.contains("nether")) {
                        if (targetState.is(Blocks.LAVA) && targetState.getFluidState().isSourceOfType((Fluid)Fluids.LAVA)) {
                            Random rand = new Random();
                            BlockState replacement = rand.nextInt(100) == 0 ? Blocks.CRYING_OBSIDIAN.defaultBlockState() : Blocks.OBSIDIAN.defaultBlockState();
                            serverLevel.setBlock(pos, replacement, 3);
                            return 800;
                        }
                        return -1;
                    }
                    if (targetState.is(Blocks.CAULDRON) || targetState.is(Blocks.WATER_CAULDRON)) {
                        BlockState newState = Blocks.WATER_CAULDRON.defaultBlockState();
                        try {
                            newState = (BlockState)newState.setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(3));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        serverLevel.setBlock(pos, newState, 3);
                        return 800;
                    }
                    if (targetState.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
                        boolean already = false;
                        try {
                            already = (Boolean)targetState.getValue((Property)BlockStateProperties.WATERLOGGED);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (!already) {
                            serverLevel.setBlock(pos, (BlockState)targetState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
                            serverLevel.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)serverLevel));
                            return 800;
                        }
                        return -1;
                    }
                    BlockPos placePos = pos;
                    if (face != null) {
                        placePos = pos.relative(face);
                    }
                    if (serverLevel.getBlockState(placePos).isAir()) {
                        serverLevel.setBlock(placePos, Blocks.WATER.defaultBlockState(), 3);
                        serverLevel.scheduleTick(placePos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)serverLevel));
                        return 800;
                    }
                    return -1;
                }
                catch (Throwable ignored) {
                    return -1;
                }
            };
            behaviourBlockTarget.invoke(moveSkill, fn);
            return moveSkill;
        }
        catch (Throwable ignored) {
            return null;
        }
    }
}

