/*
 * Decompiled with CFR 0.152.
 */
package com.kyphis.gigaremo.compat.moveskills;

import com.kyphis.gigaremo.Config;
import com.kyphis.gigaremo.block.ModBlocks;
import com.kyphis.gigaremo.block.custom.Gigaremoblue_EBlock;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class GigaremoLightning {
    public static Object create() {
        try {
            Class<?> moveSkillClass = Class.forName("com.pixelmonmod.pixelmon.api.moveskills.MoveSkill");
            Object moveSkill = moveSkillClass.getConstructor(String.class).newInstance("lightning_bolt");
            Method name = moveSkillClass.getMethod("name", String.class);
            Method descriptions = moveSkillClass.getMethod("descriptions", String[].class);
            Method cooldownSetter = moveSkillClass.getMethod("cooldown", Integer.TYPE);
            Method range = moveSkillClass.getMethod("range", Integer.TYPE);
            Method usePP = moveSkillClass.getMethod("usePP", Boolean.TYPE);
            Method sprite = moveSkillClass.getMethod("sprite", Class.forName("net.minecraft.resources.ResourceLocation"));
            name.invoke(moveSkill, "pixelmon.moveskill.lightning_bolt");
            descriptions.invoke(moveSkill, new Object[]{new String[]{"pixelmon.moveskill.lightning_bolt.description"}});
            int defaultBaseCooldown = 500;
            cooldownSetter.invoke(moveSkill, 500);
            range.invoke(moveSkill, 7);
            usePP.invoke(moveSkill, true);
            Class<?> rlClass = Class.forName("net.minecraft.resources.ResourceLocation");
            Method fromNamespaceAndPath = rlClass.getMethod("fromNamespaceAndPath", String.class, String.class);
            Object rl = fromNamespaceAndPath.invoke(null, "pixelmon", "textures/gui/overlay/externalmoves/lightning.png");
            sprite.invoke(moveSkill, rl);
            Method addAnyMoves = moveSkillClass.getMethod("addAnyMoves", String[].class);
            addAnyMoves.invoke(moveSkill, new Object[]{new String[]{"Thunderbolt", "Bolt Strike", "Thunder", "Spark", "Discharge", "Fusion Bolt", "Thunder Shock"}});
            Method behaviour = moveSkillClass.getMethod("behaviour", BiFunction.class, Class.forName("[Lcom.pixelmonmod.pixelmon.api.moveskills.MoveSkill$TargetType;"));
            BiFunction<Object, Object, Integer> fn = (pixelmon, data) -> {
                try {
                    LightningBolt bolt;
                    BlockPos pos = null;
                    if (data != null) {
                        if (data instanceof Tuple) {
                            Tuple tup = (Tuple)data;
                            Object a = tup.getA();
                            if (a instanceof BlockPos) {
                                BlockPos bp;
                                pos = bp = (BlockPos)a;
                            } else if (a instanceof LivingEntity) {
                                LivingEntity le = (LivingEntity)a;
                                pos = le.blockPosition();
                            }
                        } else if (data instanceof LivingEntity) {
                            LivingEntity le = (LivingEntity)data;
                            pos = le.blockPosition();
                        } else if (data instanceof BlockPos) {
                            BlockPos bp;
                            pos = bp = (BlockPos)data;
                        }
                    }
                    if (pos == null) {
                        return -1;
                    }
                    Level level = null;
                    try {
                        Method levelGetter = pixelmon.getClass().getMethod("level", new Class[0]);
                        Object lvl = levelGetter.invoke(pixelmon, new Object[0]);
                        if (lvl instanceof Level) {
                            Level l;
                            level = l = (Level)lvl;
                        }
                    }
                    catch (NoSuchMethodException ignored) {
                        try {
                            Field levelField = pixelmon.getClass().getDeclaredField("level");
                            levelField.setAccessible(true);
                            Object lvl = levelField.get(pixelmon);
                            if (lvl instanceof Level) {
                                Level l;
                                level = l = (Level)lvl;
                            }
                        }
                        catch (NoSuchFieldException levelField) {
                            // empty catch block
                        }
                    }
                    if (!(level instanceof ServerLevel)) {
                        return -1;
                    }
                    ServerLevel world = (ServerLevel)level;
                    ServerPlayer owner = null;
                    try {
                        Method ownerGetter = pixelmon.getClass().getMethod("getOwner", new Class[0]);
                        Object o = ownerGetter.invoke(pixelmon, new Object[0]);
                        if (o instanceof ServerPlayer) {
                            ServerPlayer p;
                            owner = p = (ServerPlayer)o;
                        }
                    }
                    catch (NoSuchMethodException ownerGetter) {
                        // empty catch block
                    }
                    int baseCooldown = 500;
                    try {
                        Method cooldownGetter = moveSkill.getClass().getMethod("cooldown", new Class[0]);
                        Object cdObj = cooldownGetter.invoke(moveSkill, new Object[0]);
                        if (cdObj instanceof Number) {
                            baseCooldown = ((Number)cdObj).intValue();
                        }
                    }
                    catch (Throwable cooldownGetter) {
                        // empty catch block
                    }
                    int speedStat = 0;
                    try {
                        Method getPokemon = pixelmon.getClass().getMethod("getPokemon", new Class[0]);
                        Object pokemon = getPokemon.invoke(pixelmon, new Object[0]);
                        if (pokemon != null) {
                            Class<?> battleStatsType = Class.forName("com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType");
                            Iterator speedEnum = battleStatsType.getField("SPEED").get(null);
                            Method getStat = pokemon.getClass().getMethod("getStat", battleStatsType);
                            Object statVal = getStat.invoke(pokemon, speedEnum);
                            if (statVal instanceof Number) {
                                speedStat = ((Number)statVal).intValue();
                            }
                        }
                    }
                    catch (Throwable getPokemon) {
                        // empty catch block
                    }
                    int finalCooldown = Math.max(0, baseCooldown - speedStat);
                    if (((Boolean)Config.LIGHTNING_ROD_PROTECTION.get()).booleanValue()) {
                        int radius = 5;
                        BlockPos rodPos = null;
                        for (BlockPos check : BlockPos.betweenClosed((BlockPos)pos.offset(-radius, -radius, -radius), (BlockPos)pos.offset(radius, radius, radius))) {
                            if (!world.getBlockState(check).is(Blocks.LIGHTNING_ROD)) continue;
                            rodPos = check.immutable();
                            break;
                        }
                        if (rodPos != null) {
                            LightningBolt lightning = (LightningBolt)EntityType.LIGHTNING_BOLT.create((Level)world);
                            if (lightning != null) {
                                lightning.moveTo((double)rodPos.getX() + 0.5, (double)rodPos.getY(), (double)rodPos.getZ() + 0.5);
                                world.addFreshEntity((Entity)lightning);
                            }
                            return finalCooldown;
                        }
                    }
                    if (world.getBlockState(pos).getBlock() == ModBlocks.GIGAREMOBLUE_EBLOCK.get()) {
                        Gigaremoblue_EBlock.onMoveSkillHit(world, pos, owner);
                        bolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create((Level)world);
                        if (bolt != null) {
                            bolt.moveTo((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
                            world.addFreshEntity((Entity)bolt);
                        }
                        return finalCooldown;
                    }
                    bolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create((Level)world);
                    if (bolt != null) {
                        bolt.moveTo((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
                        world.addFreshEntity((Entity)bolt);
                        return finalCooldown;
                    }
                    return -1;
                }
                catch (Throwable ignored) {
                    return -1;
                }
            };
            Class<?> targetType = Class.forName("com.pixelmonmod.pixelmon.api.moveskills.MoveSkill$TargetType");
            Object blockTarget = targetType.getField("BLOCK").get(null);
            Object miscTarget = targetType.getField("MISC_ENTITY").get(null);
            Object arr = Array.newInstance(targetType, 2);
            Array.set(arr, 0, blockTarget);
            Array.set(arr, 1, miscTarget);
            behaviour.invoke(moveSkill, fn, arr);
            return moveSkill;
        }
        catch (Throwable t) {
            return null;
        }
    }
}

