/*
 * Decompiled with CFR 0.152.
 */
package com.kyphis.gigaremo.event;

import com.kyphis.gigaremo.Config;
import com.kyphis.gigaremo.block.ModBlocks;
import com.kyphis.gigaremo.block.custom.Gigaremogreen_EBlock;
import com.kyphis.gigaremo.compat.PixelmonMoveSkillCompat;
import java.lang.reflect.Method;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;

public final class GigaremoEvents {
    private GigaremoEvents() {
    }

    public static void register(IEventBus modEventBus) {
        NeoForge.EVENT_BUS.addListener(GigaremoEvents::onServerStarting);
        NeoForge.EVENT_BUS.addListener(GigaremoEvents::onProjectileImpact);
        NeoForge.EVENT_BUS.addListener(GigaremoEvents::onPlayerRightClickBlock);
        NeoForge.EVENT_BUS.addListener(GigaremoEvents::onPlayerLeftClickBlock);
    }

    private static void onServerStarting(ServerStartingEvent event) {
        PixelmonMoveSkillCompat.tryInit();
    }

    private static void onProjectileImpact(ProjectileImpactEvent event) {
        if (!((Boolean)Config.GREEN_IGNITION_DESTRUCTION.get()).booleanValue()) {
            return;
        }
        Object rawProjectile = null;
        try {
            Method m = event.getClass().getMethod("getProjectile", new Class[0]);
            rawProjectile = m.invoke((Object)event, new Object[0]);
        }
        catch (Exception ignore) {
            try {
                Method m2 = event.getClass().getMethod("getEntity", new Class[0]);
                rawProjectile = m2.invoke((Object)event, new Object[0]);
            }
            catch (Exception m2) {
                // empty catch block
            }
        }
        if (!(rawProjectile instanceof Projectile)) {
            return;
        }
        Projectile projectile = (Projectile)rawProjectile;
        Level level = projectile.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BlockHitResult blockHit = null;
        try {
            Method m = event.getClass().getMethod("getRayTraceResult", new Class[0]);
            Object ray = m.invoke((Object)event, new Object[0]);
            if (ray instanceof BlockHitResult) {
                BlockHitResult bhr;
                blockHit = bhr = (BlockHitResult)ray;
            }
        }
        catch (Throwable m) {
            // empty catch block
        }
        if (blockHit != null) {
            AbstractArrow arrow;
            BlockPos posHit = blockHit.getBlockPos();
            if (posHit == null) {
                return;
            }
            BlockState hitState = serverLevel.getBlockState(posHit);
            BlockPos lowerPos = null;
            if (hitState.getBlock() == ModBlocks.GIGAREMOGREEN_EBLOCK.get()) {
                lowerPos = hitState.hasProperty(Gigaremogreen_EBlock.HALF) ? (hitState.getValue(Gigaremogreen_EBlock.HALF) == DoubleBlockHalf.UPPER ? posHit.below() : posHit) : posHit;
            } else {
                BlockState below = serverLevel.getBlockState(posHit.below());
                if (below.getBlock() == ModBlocks.GIGAREMOGREEN_EBLOCK.get()) {
                    lowerPos = posHit.below();
                } else {
                    BlockState above = serverLevel.getBlockState(posHit.above());
                    if (above.getBlock() == ModBlocks.GIGAREMOGREEN_EBLOCK.get()) {
                        lowerPos = posHit.above().below();
                    }
                }
            }
            if (lowerPos == null) {
                return;
            }
            BlockState lowerState = serverLevel.getBlockState(lowerPos);
            if (lowerState.getBlock() != ModBlocks.GIGAREMOGREEN_EBLOCK.get()) {
                return;
            }
            boolean active = false;
            try {
                active = (Boolean)lowerState.getValue((Property)Gigaremogreen_EBlock.ACTIVE);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!active) {
                return;
            }
            BlockState upperState = serverLevel.getBlockState(lowerPos.above());
            boolean upperWater = false;
            try {
                upperWater = (Boolean)upperState.getValue((Property)BlockStateProperties.WATERLOGGED);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (upperWater) {
                return;
            }
            boolean isFireProjectile = false;
            if (projectile instanceof AbstractArrow && (arrow = (AbstractArrow)projectile).isOnFire()) {
                isFireProjectile = true;
            }
            String idStr = projectile.getType().toShortString().toLowerCase();
            if (!isFireProjectile && (idStr.contains("fire") || idStr.contains("blaze") || idStr.contains("ghast") || idStr.contains("fire_charge"))) {
                isFireProjectile = true;
            }
            if (isFireProjectile) {
                Gigaremogreen_EBlock.onMoveSkillHit(serverLevel, lowerPos, null);
            }
        }
    }

    private static void onPlayerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        boolean isIgnitionItem;
        if (!((Boolean)Config.GREEN_IGNITION_DESTRUCTION.get()).booleanValue()) {
            return;
        }
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BlockPos pos = event.getPos();
        BlockState state = level.getBlockState(pos);
        if (state == null) {
            return;
        }
        BlockPos lowerPos = null;
        if (state.getBlock() == ModBlocks.GIGAREMOGREEN_EBLOCK.get()) {
            lowerPos = state.getValue(Gigaremogreen_EBlock.HALF) == DoubleBlockHalf.UPPER ? pos.below() : pos;
        } else {
            BlockState below = level.getBlockState(pos.below());
            if (below.getBlock() == ModBlocks.GIGAREMOGREEN_EBLOCK.get()) {
                lowerPos = pos.below();
            } else {
                BlockState above = level.getBlockState(pos.above());
                if (above.getBlock() == ModBlocks.GIGAREMOGREEN_EBLOCK.get()) {
                    lowerPos = pos.above().below();
                }
            }
        }
        if (lowerPos == null) {
            return;
        }
        BlockState lowerState = serverLevel.getBlockState(lowerPos);
        if (lowerState.getBlock() != ModBlocks.GIGAREMOGREEN_EBLOCK.get()) {
            return;
        }
        boolean active = false;
        try {
            active = (Boolean)lowerState.getValue((Property)Gigaremogreen_EBlock.ACTIVE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!active) {
            return;
        }
        BlockState upperState = serverLevel.getBlockState(lowerPos.above());
        boolean upperWater = false;
        try {
            upperWater = (Boolean)upperState.getValue((Property)BlockStateProperties.WATERLOGGED);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (upperWater) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (stack == null) {
            return;
        }
        boolean bl = isIgnitionItem = stack.getItem() == Items.FLINT_AND_STEEL || stack.getItem() == Items.FIRE_CHARGE;
        if (isIgnitionItem) {
            ServerPlayer sp = null;
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer p;
                sp = p = (ServerPlayer)player;
            }
            Gigaremogreen_EBlock.onMoveSkillHit(serverLevel, lowerPos, sp);
        }
    }

    private static void onPlayerLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        ItemStack itemStack;
        if (!((Boolean)Config.GREEN_IGNITION_DESTRUCTION.get()).booleanValue()) {
            return;
        }
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BlockPos pos = event.getPos();
        BlockState state = level.getBlockState(pos);
        if (state == null) {
            return;
        }
        BlockPos lowerPos = null;
        if (state.getBlock() == ModBlocks.GIGAREMOGREEN_EBLOCK.get()) {
            lowerPos = state.getValue(Gigaremogreen_EBlock.HALF) == DoubleBlockHalf.UPPER ? pos.below() : pos;
        } else {
            BlockState below = level.getBlockState(pos.below());
            if (below.getBlock() == ModBlocks.GIGAREMOGREEN_EBLOCK.get()) {
                lowerPos = pos.below();
            } else {
                BlockState above = level.getBlockState(pos.above());
                if (above.getBlock() == ModBlocks.GIGAREMOGREEN_EBLOCK.get()) {
                    lowerPos = pos.above().below();
                }
            }
        }
        if (lowerPos == null) {
            return;
        }
        BlockState lowerState = serverLevel.getBlockState(lowerPos);
        if (lowerState.getBlock() != ModBlocks.GIGAREMOGREEN_EBLOCK.get()) {
            return;
        }
        boolean active = false;
        try {
            active = (Boolean)lowerState.getValue((Property)Gigaremogreen_EBlock.ACTIVE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!active) {
            return;
        }
        BlockState upperState = serverLevel.getBlockState(lowerPos.above());
        boolean upperWater = false;
        try {
            upperWater = (Boolean)upperState.getValue((Property)BlockStateProperties.WATERLOGGED);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (upperWater) {
            return;
        }
        Player actor = event.getEntity();
        if (actor == null) {
            return;
        }
        if (actor instanceof Player) {
            Player p = actor;
            itemStack = p.getItemInHand(InteractionHand.MAIN_HAND);
        } else {
            itemStack = ItemStack.EMPTY;
        }
        ItemStack main = itemStack;
        Holder.Reference fireAspect = serverLevel.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.FIRE_ASPECT);
        int fireAspectLevel = main.getEnchantmentLevel((Holder)fireAspect);
        if (fireAspectLevel > 0) {
            ServerPlayer sp = null;
            if (actor instanceof ServerPlayer) {
                ServerPlayer p;
                sp = p = (ServerPlayer)actor;
            }
            Gigaremogreen_EBlock.onMoveSkillHit(serverLevel, lowerPos, sp);
        }
    }
}

