/*
 * Decompiled with CFR 0.152.
 */
package com.kyphis.gigaremo.block.custom;

import com.kyphis.gigaremo.block.ModBlocks;
import com.kyphis.gigaremo.block.entity.Gigaremoblue_EBlockEntity;
import com.kyphis.gigaremo.block.entity.ModBlockEntities;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Gigaremoblue_EBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty ACTIVE = BooleanProperty.create((String)"active");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;
    public static final MapCodec<Gigaremoblue_EBlock> CODEC = Gigaremoblue_EBlock.simpleCodec(Gigaremoblue_EBlock::new);

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public Gigaremoblue_EBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)ACTIVE, (Comparable)Boolean.FALSE)).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ACTIVE, WATERLOGGED, HALF});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockPos pos;
        Level level = ctx.getLevel();
        if (!level.getBlockState((pos = ctx.getClickedPos()).above()).canBeReplaced(ctx)) {
            return null;
        }
        FluidState fs = level.getFluidState(pos);
        boolean water = fs.getType() == Fluids.WATER;
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(water))).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false));
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (!level.isClientSide) {
            BlockState upper = (BlockState)((BlockState)state.setValue(HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(pos.above()).getType() == Fluids.WATER));
            level.setBlock(pos.above(), upper, 3);
        }
        super.setPlacedBy(level, pos, state, placer, stack);
    }

    public BlockState updateShape(BlockState state, Direction dir, BlockState neighbor, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        BlockState down;
        BlockState up;
        if (state.getValue(HALF) == DoubleBlockHalf.LOWER && dir == Direction.UP) {
            try {
                if (neighbor.getBlock() == this && neighbor.hasProperty((Property)WATERLOGGED) && ((Boolean)neighbor.getValue((Property)WATERLOGGED)).booleanValue() && !((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
                    BlockState newState = (BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true));
                    world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
                    state = newState;
                }
            }
            catch (Exception newState) {
                // empty catch block
            }
        }
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        if (state.getValue(HALF) == DoubleBlockHalf.LOWER && dir == Direction.UP && ((up = world.getBlockState(pos.above())).getBlock() != this || up.getValue(HALF) != DoubleBlockHalf.UPPER)) {
            return Blocks.AIR.defaultBlockState();
        }
        if (state.getValue(HALF) == DoubleBlockHalf.UPPER && dir == Direction.DOWN && ((down = world.getBlockState(pos.below())).getBlock() != this || down.getValue(HALF) != DoubleBlockHalf.LOWER)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, dir, neighbor, world, pos, neighborPos);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return Shapes.empty();
    }

    protected boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, world, pos, oldState, isMoving);
        if (!world.isClientSide && ((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() == newState.getBlock()) {
            super.onRemove(state, level, pos, newState, isMoving);
            return;
        }
        if (state.getValue(HALF) == DoubleBlockHalf.LOWER) {
            BlockPos up = pos.above();
            if (level.getBlockState(up).getBlock() == this) {
                level.setBlock(up, Blocks.AIR.defaultBlockState(), 35);
            }
        } else {
            BlockPos down = pos.below();
            if (level.getBlockState(down).getBlock() == this) {
                level.setBlock(down, Blocks.AIR.defaultBlockState(), 35);
            }
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        if (state.getValue(HALF) == DoubleBlockHalf.LOWER) {
            return new Gigaremoblue_EBlockEntity(pos, state);
        }
        return null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return Gigaremoblue_EBlock.createTickerHelper(type, ModBlockEntities.GIGAREMOBLUE_EBLOCK_BE.get(), Gigaremoblue_EBlockEntity::tick);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        Optional maybeItem = level.registryAccess().registryOrThrow(Registries.ITEM).getOptional(ResourceLocation.fromNamespaceAndPath((String)"pixelmon", (String)"black_tumblestone"));
        if (maybeItem.isPresent() && stack.is((Item)maybeItem.get()) && !((Boolean)state.getValue((Property)ACTIVE)).booleanValue()) {
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            BlockPos lowerPos = state.getValue(HALF) == DoubleBlockHalf.UPPER ? pos.below() : pos;
            BlockState lower = level.getBlockState(lowerPos);
            BlockState upper = level.getBlockState(lowerPos.above());
            level.setBlock(lowerPos, (BlockState)lower.setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(true)), 3);
            level.setBlock(lowerPos.above(), (BlockState)upper.setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(true)), 3);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public static Optional<Item> lookupExternalItem(Level level, String namespace, String path) {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path);
        return level.registryAccess().registryOrThrow(Registries.ITEM).getOptional(id);
    }

    public static void onMoveSkillHit(ServerLevel serverLevel, BlockPos pos, ServerPlayer player) {
        if (serverLevel == null) {
            return;
        }
        serverLevel.getServer().execute(() -> {
            try {
                BlockState lowerState;
                BlockPos lowerPos;
                block28: {
                    BlockState targeted = serverLevel.getBlockState(pos);
                    if (targeted.getBlock() == ModBlocks.GIGAREMOBLUE_EBLOCK.get()) {
                        if (targeted.hasProperty((Property)BlockStateProperties.DOUBLE_BLOCK_HALF)) {
                            try {
                                if (targeted.getValue(HALF) == DoubleBlockHalf.UPPER) {
                                    lowerPos = pos.below();
                                    lowerState = serverLevel.getBlockState(lowerPos);
                                    break block28;
                                }
                                lowerPos = pos;
                                lowerState = targeted;
                            }
                            catch (Exception e) {
                                lowerPos = pos;
                                lowerState = targeted;
                            }
                        } else {
                            lowerPos = pos;
                            lowerState = targeted;
                        }
                    } else {
                        BlockState below = serverLevel.getBlockState(pos.below());
                        if (below.getBlock() == ModBlocks.GIGAREMOBLUE_EBLOCK.get()) {
                            lowerPos = pos.below();
                            lowerState = below;
                        } else {
                            BlockState above = serverLevel.getBlockState(pos.above());
                            if (above.getBlock() == ModBlocks.GIGAREMOBLUE_EBLOCK.get()) {
                                lowerPos = pos;
                                lowerState = serverLevel.getBlockState(lowerPos);
                            } else {
                                return;
                            }
                        }
                    }
                }
                if (lowerState.getBlock() != ModBlocks.GIGAREMOBLUE_EBLOCK.get()) {
                    return;
                }
                boolean active = false;
                try {
                    active = (Boolean)lowerState.getValue((Property)ACTIVE);
                }
                catch (Exception above) {
                    // empty catch block
                }
                if (!active) {
                    return;
                }
                BlockPos upperPos = lowerPos.above();
                BlockState upperState = serverLevel.getBlockState(upperPos);
                boolean lowerWater = false;
                boolean upperWater = false;
                try {
                    lowerWater = (Boolean)lowerState.getValue((Property)BlockStateProperties.WATERLOGGED);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    upperWater = (Boolean)upperState.getValue((Property)BlockStateProperties.WATERLOGGED);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                double x = (double)lowerPos.getX() + 0.5;
                double y = (double)lowerPos.getY() + 0.5;
                double z = (double)lowerPos.getZ() + 0.5;
                serverLevel.playSound(null, x, y, z, (Holder)SoundEvents.GENERIC_EXPLODE, SoundSource.BLOCKS, 1.0f, 1.0f);
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
                BlockParticleOption blockParticles = new BlockParticleOption(ParticleTypes.BLOCK, lowerState);
                serverLevel.sendParticles((ParticleOptions)blockParticles, x, y, z, 80, 0.5, 0.5, 0.5, 0.05);
                serverLevel.setBlock(upperPos, Blocks.AIR.defaultBlockState(), 35);
                serverLevel.setBlock(lowerPos, Blocks.AIR.defaultBlockState(), 35);
                Block broken = (Block)ModBlocks.BROKEN_GIGAREMOBLUE.get();
                BlockState brokenState = broken.defaultBlockState();
                try {
                    if (brokenState.hasProperty((Property)BlockStateProperties.WATERLOGGED) && lowerWater) {
                        brokenState = (BlockState)brokenState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                serverLevel.setBlock(lowerPos, brokenState, 3);
                try {
                    if (brokenState.hasProperty((Property)BlockStateProperties.WATERLOGGED) && ((Boolean)brokenState.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
                        serverLevel.scheduleTick(lowerPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)serverLevel));
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (upperWater) {
                    serverLevel.setBlock(upperPos, Blocks.WATER.defaultBlockState(), 3);
                    serverLevel.scheduleTick(upperPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)serverLevel));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
    }

    public float getDestroyProgress(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        float base;
        if (player.isCreative()) {
            return super.getDestroyProgress(state, player, level, pos);
        }
        if (state.hasProperty((Property)ACTIVE) && ((Boolean)state.getValue((Property)ACTIVE)).booleanValue() && (base = super.getDestroyProgress(state, player, level, pos)) > 0.0f) {
            return base / 50.0f;
        }
        return super.getDestroyProgress(state, player, level, pos);
    }
}

