/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.tomalbrc.filament.Filament;
import de.tomalbrc.filament.behaviour.BehaviourConfigMap;
import de.tomalbrc.filament.behaviour.Behaviours;
import de.tomalbrc.filament.behaviour.decoration.Seat;
import de.tomalbrc.filament.behaviour.item.Armor;
import de.tomalbrc.filament.behaviour.item.Cosmetic;
import de.tomalbrc.filament.behaviour.item.Elytra;
import de.tomalbrc.filament.behaviour.item.Hoe;
import de.tomalbrc.filament.behaviour.item.Shears;
import de.tomalbrc.filament.behaviour.item.Shovel;
import de.tomalbrc.filament.behaviour.item.Stripper;
import de.tomalbrc.filament.data.BlockData;
import de.tomalbrc.filament.data.DecorationData;
import de.tomalbrc.filament.data.ItemData;
import de.tomalbrc.filament.data.properties.BlockProperties;
import de.tomalbrc.filament.data.properties.BlockStateMappedProperty;
import de.tomalbrc.filament.data.properties.DecorationProperties;
import de.tomalbrc.filament.data.properties.ItemProperties;
import de.tomalbrc.filament.data.resource.BlockResource;
import de.tomalbrc.filament.data.resource.ItemResource;
import de.tomalbrc.filament.registry.BlockRegistry;
import de.tomalbrc.filament.registry.DecorationRegistry;
import de.tomalbrc.filament.registry.ItemRegistry;
import de.tomalbrc.filament.util.BlockDataBuilder;
import de.tomalbrc.filament.util.DecorationDataBuilder;
import de.tomalbrc.filament.util.ItemBuilder;
import de.tomalbrc.filament.util.Json;
import de.tomalbrc.filament.util.RegUtil;
import eu.pb4.placeholders.api.TextParserUtils;
import eu.pb4.polymer.blocks.api.BlockModelType;
import eu.pb4.polymer.blocks.api.PolymerBlockModel;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import eu.pb4.polymer.resourcepack.api.ResourcePackBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1304;
import net.minecraft.class_1322;
import net.minecraft.class_1738;
import net.minecraft.class_1743;
import net.minecraft.class_1770;
import net.minecraft.class_1792;
import net.minecraft.class_1794;
import net.minecraft.class_1802;
import net.minecraft.class_1820;
import net.minecraft.class_1821;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3619;
import net.minecraft.class_5151;
import net.minecraft.class_7923;
import net.minecraft.class_811;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.yaml.snakeyaml.Yaml;

public class NexoImporter {
    public static void importAll() {
        Path root = FabricLoader.getInstance().getGameDir().resolve("nexo");
        if (!Files.exists(root, new LinkOption[0])) {
            try {
                Files.createDirectories(root, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        Object2ObjectOpenHashMap redirects = new Object2ObjectOpenHashMap();
        try (Stream<Path> stream = Files.list(root);){
            stream.forEach(arg_0 -> NexoImporter.lambda$importAll$0((Map)redirects, arg_0));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void importPack(Path path, Map<String, String> fileRedirects) {
        String dirName = FilenameUtils.getBaseName((String)path.toString());
        try (Stream<Path> stream = Files.walk(path.resolve("items"), new FileVisitOption[0]);){
            stream.forEach(file -> {
                try {
                    Path filename = file.toAbsolutePath();
                    String ext = FilenameUtils.getExtension((String)filename.toString());
                    String baseName = FilenameUtils.getBaseName((String)filename.toString());
                    if (baseName.startsWith(".")) {
                        return;
                    }
                    if (ext.equals("yml") || ext.equals("yaml")) {
                        FileInputStream inputStream = new FileInputStream(file.toFile());
                        NexoImporter.importSingleFile(dirName, inputStream, fileRedirects);
                    }
                }
                catch (Throwable e) {
                    Filament.LOGGER.error("Error loading nexo file", e);
                }
            });
        }
        catch (Throwable e) {
            Filament.LOGGER.error("Error reading nexo directory", e);
        }
        Object2ObjectOpenHashMap filemap = new Object2ObjectOpenHashMap();
        Object2ObjectOpenHashMap texturePaths = new Object2ObjectOpenHashMap();
        Object2ObjectOpenHashMap orphans = new Object2ObjectOpenHashMap();
        Path packPath = path.resolve("pack");
        try (Stream<Path> walk = Files.walk(packPath, new FileVisitOption[0]);){
            walk.forEach(arg_0 -> NexoImporter.lambda$importPack$4(packPath, (Map)orphans, (Map)texturePaths, (Map)filemap, fileRedirects, arg_0));
        }
        catch (Throwable e) {
            Filament.LOGGER.error("Error reading nexo pack assets", e);
        }
        Map<String, byte[]> atlases = NexoImporter.generateAtlasJson((Map<String, Set<class_2960>>)texturePaths, (Map<String, Set<class_2960>>)orphans);
        for (Map.Entry<String, byte[]> entry : atlases.entrySet()) {
            filemap.put("assets/minecraft/atlases/blocks.json", entry.getValue());
            filemap.put("assets/minecraft/atlases/particle.json", entry.getValue());
        }
        PolymerResourcePackUtils.RESOURCE_PACK_CREATION_EVENT.register(arg_0 -> NexoImporter.lambda$importPack$5((Map)filemap, arg_0));
    }

    public static String getTextureParent(String fullPath) {
        String normalized = fullPath.replace("\\", "/");
        String prefix = "assets/";
        String texturesToken = "/textures/";
        int assetsIndex = normalized.indexOf(prefix);
        if (assetsIndex == -1) {
            return null;
        }
        int texturesIndex = normalized.indexOf(texturesToken, assetsIndex);
        if (texturesIndex == -1) {
            return null;
        }
        String afterTextures = normalized.substring(texturesIndex + texturesToken.length());
        int lastSlash = afterTextures.lastIndexOf(47);
        if (lastSlash == -1) {
            return "";
        }
        return afterTextures.substring(0, lastSlash);
    }

    public static String getNamespace(String fullPath) {
        String normalized = fullPath.replace("\\", "/");
        String prefix = "assets/";
        String texturesToken = "/textures/";
        int assetsIndex = normalized.indexOf(prefix);
        int texturesIndex = normalized.indexOf(texturesToken, assetsIndex);
        if (assetsIndex == -1 || texturesIndex == -1) {
            return null;
        }
        return normalized.substring(assetsIndex + prefix.length(), texturesIndex);
    }

    private static Map<String, byte[]> generateAtlasJson(Map<String, Set<class_2960>> sourceDirs, Map<String, Set<class_2960>> orphans) {
        JsonObject source;
        Object2ObjectOpenHashMap sourcesMap = new Object2ObjectOpenHashMap();
        for (Map.Entry<String, Set<class_2960>> entry : sourceDirs.entrySet()) {
            for (class_2960 class_29602 : entry.getValue()) {
                source = new JsonObject();
                source.addProperty("type", "directory");
                source.addProperty("prefix", class_29602.method_12832() + "/");
                source.addProperty("source", class_29602.method_12832());
                sourcesMap.computeIfAbsent(entry.getKey(), x -> new JsonArray()).add((JsonElement)source);
            }
        }
        for (Map.Entry<String, Set<class_2960>> entry : orphans.entrySet()) {
            for (class_2960 class_29603 : entry.getValue()) {
                source = new JsonObject();
                source.addProperty("type", "single");
                source.addProperty("sprite", class_29603.toString());
                source.addProperty("resource", class_29603.toString());
                sourcesMap.computeIfAbsent(entry.getKey(), x -> new JsonArray()).add((JsonElement)source);
            }
        }
        Gson gson = new GsonBuilder().create();
        Object2ObjectOpenHashMap res = new Object2ObjectOpenHashMap();
        for (Map.Entry entry : sourcesMap.entrySet()) {
            JsonObject root = new JsonObject();
            root.add("sources", (JsonElement)entry.getValue());
            res.put((String)entry.getKey(), gson.toJson((JsonElement)root).getBytes(StandardCharsets.UTF_8));
        }
        return res;
    }

    public static void importSingleFile(String baseName, InputStream inputStream, Map<String, String> fileRedirects) {
        Yaml yaml = new Yaml();
        Map elements = (Map)yaml.load(inputStream);
        for (Map.Entry element : elements.entrySet()) {
            NexoImporter.processElement(((String)element.getKey()).contains(":") ? class_2960.method_60654((String)((String)element.getKey())) : class_2960.method_60655((String)baseName.toLowerCase(), (String)((String)element.getKey()).toLowerCase()), element.getValue(), fileRedirects);
        }
    }

    private static void processElement(class_2960 id, Object data, Map<String, String> fileRedirects) {
        String material;
        String name = NexoImporter.getValue("displayname", data, String.class);
        if (name == null) {
            name = NexoImporter.getValue("itemname", data, String.class);
        }
        String components = NexoImporter.getValue("Components", data, String.class);
        class_9323 xmap = null;
        if (components != null) {
            try {
                class_9323 jsonData = (class_9323)Json.GSON.fromJson(new Gson().toJson((Object)components), class_9323.class);
                if (jsonData != null) {
                    xmap = jsonData;
                }
            }
            catch (Exception e) {
                Filament.LOGGER.error("Could not load components for nexo item {}", (Object)id, (Object)e);
            }
        }
        class_9323.class_9324 builder = class_9323.method_57827();
        if (xmap != null) {
            builder.method_57839(xmap);
        }
        if (name != null) {
            builder.method_57840(class_9334.field_50239, (Object)TextUtil.formatText(name));
        }
        class_1792 vanillaItem = (material = NexoImporter.getValue("material", data, String.class)) != null ? (class_1792)RegUtil.getValue(class_7923.field_41178, class_2960.method_60654((String)material.toLowerCase())) : class_1802.field_18138;
        List attr = NexoImporter.getValue("AttributeModifiers", data, List.class);
        if (attr != null) {
            NexoImporter.handleOraxenAttributes(attr, builder);
        }
        Map<String, Object> mechanics = NexoImporter.getMap("Mechanics", data);
        Map<String, Object> customBlock = null;
        Map<String, Object> furniture = null;
        Integer dur = null;
        if (mechanics != null) {
            customBlock = NexoImporter.getMap("custom_block", mechanics);
            furniture = NexoImporter.getMap("furniture", mechanics);
            dur = NexoImporter.getValue("durability", mechanics, Integer.class);
        }
        if (dur != null) {
            builder.method_57840(class_9334.field_50072, dur);
        }
        if (customBlock != null || furniture != null) {
            if (customBlock != null) {
                NexoImporter.addBlock(id, data, furniture, vanillaItem, name, builder);
            } else {
                NexoImporter.addDecoration(id, data, furniture, vanillaItem, name, builder);
            }
        } else {
            NexoImporter.addItem(id, data, vanillaItem, name, builder, fileRedirects);
        }
    }

    private static void handleOraxenAttributes(List<?> attr, class_9323.class_9324 builder) {
        class_9285.class_9286 attrBuilder = class_9285.method_57480();
        try {
            for (Object o : attr) {
                Number amount = NexoImporter.getValue("amount", o, Number.class);
                String attribute = NexoImporter.getValue("attribute", o, String.class);
                Integer operation = NexoImporter.getValue("operation", o, Integer.class);
                class_1304 slot = class_1304.valueOf((String)NexoImporter.getValue("slot", o, String.class));
                String str = attribute.toLowerCase().replace("_", ".");
                class_2960 attrId = class_2960.method_60654((String)str);
                attrBuilder.method_57487(RegUtil.get(class_7923.field_41190, attrId), new class_1322(class_2960.method_60655((String)"filament", (String)"armor"), amount.doubleValue(), Arrays.stream(class_1322.class_1323.values()).filter(y -> y.method_56082() == operation.intValue()).findAny().orElseThrow()), class_9274.method_59524((class_1304)slot));
            }
        }
        catch (Exception e) {
            Filament.LOGGER.error("Error reading attribute", (Throwable)e);
        }
        builder.method_57840(class_9334.field_49636, (Object)attrBuilder.method_57486());
    }

    private static void addBlock(class_2960 id, Object data, Map<String, Object> furniture, class_1792 vanillaItem, String name, class_9323.class_9324 builder) {
        String model = NexoImporter.getValue("model", data, String.class);
        BlockProperties props = new BlockProperties();
        props.destroyTime = 2.0f;
        props.explosionResistance = 2.0f;
        props.solid = true;
        props.transparent = false;
        props.allowsSpawning = true;
        Integer lightObj = NexoImporter.getValue("light", furniture, Integer.class);
        if (lightObj != null) {
            props.lightEmission = BlockStateMappedProperty.of((Object)lightObj);
        }
        BlockData blockData = new BlockDataBuilder(id, new BlockResource(Map.of("default", new PolymerBlockModel(class_2960.method_60654((String)model), 0, 0, false, 0)))).vanillaItem(vanillaItem).displayName(TextUtil.formatText(name)).components(builder.method_57838()).blockModelType((BlockStateMappedProperty<BlockModelType>)BlockStateMappedProperty.of((Object)BlockModelType.FULL_BLOCK)).properties(props).build();
        BlockRegistry.register((BlockData)blockData);
    }

    private static void addDecoration(class_2960 id, Object data, Map<String, Object> furniture, class_1792 vanillaItem, String name, class_9323.class_9324 builder) {
        List barriers;
        Map<String, Object> drop;
        boolean waterloggable;
        Map<String, Object> placing;
        Integer lightObj;
        Map<String, Object> pack = NexoImporter.getMap("Pack", data);
        String model = NexoImporter.getValue("model", pack, String.class);
        BehaviourConfigMap behaviourConfigMap = new BehaviourConfigMap();
        if (model == null) {
            return;
        }
        DecorationProperties props = new DecorationProperties();
        props.destroyTime = 0.5f;
        props.explosionResistance = 0.5f;
        props.solid = false;
        props.transparent = true;
        props.allowsSpawning = false;
        props.pushReaction = class_3619.field_15972;
        Boolean rotObj = NexoImporter.getValue("rotatable", furniture, Boolean.class);
        if (rotObj == Boolean.TRUE || rotObj == null) {
            props.rotate = true;
            String restrictedRot = NexoImporter.getValue("restricted_rotation", furniture, String.class);
            props.rotateSmooth = restrictedRot != null ? restrictedRot.equals("STRICT") : true;
        }
        if ((lightObj = NexoImporter.getValue("light", furniture, Integer.class)) != null) {
            props.lightEmission = BlockStateMappedProperty.of((Object)lightObj);
        }
        if ((placing = NexoImporter.getMap("limited_placing", furniture)) != null) {
            props.placement = new DecorationProperties.Placement(NexoImporter.getValue("wall", placing, Boolean.class) == Boolean.TRUE, NexoImporter.getValue("floor", placing, Boolean.class) == Boolean.TRUE, NexoImporter.getValue("roof", placing, Boolean.class) == Boolean.TRUE);
        }
        boolean bl = waterloggable = NexoImporter.getValue("waterloggable", furniture, Boolean.class) == Boolean.TRUE;
        if (waterloggable) {
            props.waterloggable = true;
        }
        props.drops = (drop = NexoImporter.getMap("drop", furniture)) != null;
        String type = NexoImporter.getValue("type", furniture, String.class);
        boolean forceItemFrame = false;
        if (type != null && type.endsWith("ITEM_FRAME")) {
            props.display = class_811.field_4319;
            forceItemFrame = true;
            if (type.startsWith("GLOW")) {
                props.glow = true;
            }
        }
        Boolean barrier = NexoImporter.getValue("barrier", furniture, Boolean.class);
        ObjectArrayList blocks = new ObjectArrayList();
        if (barrier != null && barrier.booleanValue()) {
            blocks.add(new DecorationData.BlockConfig(new Vector3f(), new Vector3f(1.0f)));
        }
        if ((barriers = NexoImporter.getValue("barriers", furniture, List.class)) != null) {
            for (Object blockConf : barriers) {
                String s;
                boolean origin;
                boolean bl2 = origin = blockConf instanceof String && (s = (String)blockConf).equals("origin");
                if (origin) {
                    blocks.add(new DecorationData.BlockConfig(new Vector3f(), new Vector3f(1.0f)));
                    continue;
                }
                Integer x = NexoImporter.getValue("x", blockConf, Integer.class);
                Integer y = NexoImporter.getValue("y", blockConf, Integer.class);
                Integer z = NexoImporter.getValue("z", blockConf, Integer.class);
                blocks.add(new DecorationData.BlockConfig(new Vector3f(x == null ? 0.0f : (float)x.intValue(), y == null ? 0.0f : (float)y.intValue(), z == null ? 0.0f : (float)z.intValue()).rotateY((float)Math.PI).round(), new Vector3f(1.0f)));
            }
        }
        Seat.SeatConfig filamentSeats = new Seat.SeatConfig();
        Map<String, Object> seat = NexoImporter.getMap("seat", furniture);
        if (seat != null) {
            Float height = NexoImporter.getValue("height", seat, Float.class);
            Float yaw = NexoImporter.getValue("yaw", seat, Float.class);
            yaw = yaw == null ? Float.valueOf(180.0f) : Float.valueOf(yaw.floatValue() - 180.0f);
            if (height == null) {
                height = Float.valueOf(0.0f);
            }
            if (blocks.isEmpty()) {
                Seat.SeatConfigData seatConf = new Seat.SeatConfigData();
                seatConf.offset = new Vector3f();
                filamentSeats.add((Object)seatConf);
            } else {
                for (DecorationData.BlockConfig blockConfig : blocks) {
                    Seat.SeatConfigData seatConf = new Seat.SeatConfigData();
                    seatConf.offset = new Vector3f((Vector3fc)blockConfig.origin().add(0.0f, 0.5f + height.floatValue(), 0.0f, new Vector3f()));
                    seatConf.direction = yaw.floatValue();
                    filamentSeats.add((Object)seatConf);
                }
            }
        }
        if (!filamentSeats.isEmpty()) {
            behaviourConfigMap.put(Behaviours.SEAT, (Object)filamentSeats);
        }
        if (blocks.isEmpty()) {
            props.destroyTime = 0.0f;
        }
        DecorationData decorationData = new DecorationDataBuilder(id).vanillaItem(vanillaItem).displayName(TextUtil.formatText(name)).itemResource(NexoImporter.defaultItemResource(class_2960.method_60654((String)model))).behaviourConfig(behaviourConfigMap).components(builder.method_57838()).properties(props).blocks((List<DecorationData.BlockConfig>)(blocks.isEmpty() ? null : blocks)).size(blocks.isEmpty() ? new Vector2f(1.0f, 1.0f) : null).itemFrame(forceItemFrame).build();
        DecorationRegistry.register((DecorationData)decorationData);
    }

    private static ItemResource defaultItemResource(class_2960 model) {
        return ItemResource.of(Map.of("default", model), null, null);
    }

    private static ItemResource texturedItemResource(class_2960 model, String parent_model, Map<String, class_2960> textures) {
        return ItemResource.of(Map.of("default", model), (class_2960)(parent_model != null ? class_2960.method_60654((String)parent_model) : null), !textures.isEmpty() ? Map.of("default", textures) : null);
    }

    private static void addItem(class_2960 id, Object data, class_1792 vanillaItem, String name, class_9323.class_9324 builder, Map<String, String> fileRedirects) {
        Map<String, Object> pack = NexoImporter.getMap("Pack", data);
        String model = NexoImporter.getValue("model", pack, String.class);
        if (model == null) {
            return;
        }
        ItemProperties props = new ItemProperties();
        props.copyComponents = true;
        props.copyTags = true;
        BehaviourConfigMap behaviourConfigMap = new BehaviourConfigMap();
        String parent_model = NexoImporter.getValue("parent_model", pack, String.class);
        String texture = NexoImporter.getValue("texture", pack, String.class);
        List textureList = NexoImporter.getValue("textures", pack, List.class);
        Object2ObjectOpenHashMap textures = new Object2ObjectOpenHashMap();
        if (texture != null || textureList != null) {
            if (parent_model == null) {
                parent_model = "item/generated";
            }
            if (texture != null) {
                textures.put("layer0", class_2960.method_60654((String)texture));
            } else {
                for (int i = 0; i < textureList.size(); ++i) {
                    textures.put("layer" + i, class_2960.method_60654((String)((String)textureList.get(i))));
                }
            }
        }
        Map<String, Object> mechanics = NexoImporter.getMap("Mechanics", data);
        Map<String, Object> customArmor = NexoImporter.getMap("#CustomArmor", pack);
        if (customArmor != null) {
            String l1 = customArmor.get("layer1").toString();
            String l2 = customArmor.get("layer2").toString();
            String src1 = "assets/minecraft/textures/" + l1 + ".png";
            String src2 = "assets/minecraft/textures/" + l2 + ".png";
            String[] pathParts = l1.replace("_layer_1", "").split("/");
            String path = pathParts[pathParts.length - 1];
            fileRedirects.put(src1, "assets/minecraft/textures/trims/models/armor/" + path + ".png");
            fileRedirects.put(src2, "assets/minecraft/textures/trims/models/armor/" + path + "_leggings.png");
            Armor.Config conf = new Armor.Config();
            conf.trim = true;
            conf.texture = class_2960.method_60656((String)path);
            if (vanillaItem instanceof class_1738) {
                class_1738 armorItem = (class_1738)vanillaItem;
                conf.slot = armorItem.method_7685();
            }
            behaviourConfigMap.put(Behaviours.ARMOR, (Object)conf);
        }
        if (vanillaItem instanceof class_1770) {
            behaviourConfigMap.put(Behaviours.ELYTRA, (Object)new Elytra.Config());
        }
        if (mechanics != null) {
            if (mechanics.containsKey("cosmetic") && vanillaItem instanceof class_5151) {
                class_5151 equipable = (class_5151)vanillaItem;
                Cosmetic.Config conf = new Cosmetic.Config();
                conf.slot = equipable.method_7685();
                behaviourConfigMap.put(Behaviours.COSMETIC, (Object)conf);
            }
            if (mechanics.containsKey("hat")) {
                Armor.Config conf = new Armor.Config();
                conf.slot = class_1304.field_6169;
                behaviourConfigMap.put(Behaviours.COSMETIC, (Object)conf);
            }
        }
        if (vanillaItem instanceof class_1821) {
            behaviourConfigMap.put(Behaviours.SHOVEL, (Object)new Shovel.Config());
        }
        if (vanillaItem instanceof class_1794) {
            behaviourConfigMap.put(Behaviours.HOE, (Object)new Hoe.Config());
        }
        if (vanillaItem instanceof class_1820) {
            behaviourConfigMap.put(Behaviours.SHEARS, (Object)new Shears.Config());
        }
        if (vanillaItem instanceof class_1743) {
            behaviourConfigMap.put(Behaviours.STRIPPER, (Object)new Stripper.Config());
        }
        ItemData itemData = new ItemBuilder(id).vanillaItem(vanillaItem).displayName(TextUtil.formatText(name)).itemResource(NexoImporter.texturedItemResource(class_2960.method_60654((String)model), parent_model, (Map<String, class_2960>)textures)).properties(props).components(builder.method_57838()).build();
        ItemRegistry.register((ItemData)itemData);
    }

    @Nullable
    public static Map<String, Object> getMap(String key, Object obj) {
        Map map;
        Object value;
        if (obj instanceof Map && (value = (map = (Map)obj).get(key)) instanceof Map) {
            return (Map)value;
        }
        return null;
    }

    public static <T> T getValue(String key, Object obj, Class<T> clazz) {
        Map map;
        Object value;
        if (obj instanceof Map && clazz.isInstance(value = (map = (Map)obj).get(key))) {
            return clazz.cast(value);
        }
        return null;
    }

    private static /* synthetic */ void lambda$importPack$5(Map filemap, ResourcePackBuilder resourcePackBuilder) {
        filemap.forEach((arg_0, arg_1) -> ((ResourcePackBuilder)resourcePackBuilder).addData(arg_0, arg_1));
    }

    private static /* synthetic */ void lambda$importPack$4(Path packPath, Map orphans, Map texturePaths, Map filemap, Map fileRedirects, Path filepath) {
        if (filepath.toFile().isDirectory()) {
            return;
        }
        try (FileInputStream stream = new FileInputStream(filepath.toFile());){
            Object relativePath = packPath.relativize(filepath).toString().replace("\\", "/");
            if (!((String)relativePath).startsWith("assets/")) {
                relativePath = "assets/minecraft/" + (String)relativePath;
            }
            String ns = NexoImporter.getNamespace((String)relativePath);
            String dir = NexoImporter.getTextureParent((String)relativePath);
            if (dir != null && ((String)relativePath).endsWith(".png") && ns != null) {
                if (dir.isBlank()) {
                    String[] split = ((String)relativePath).split("/textures/");
                    orphans.computeIfAbsent(ns, x -> new ObjectArraySet()).add(class_2960.method_60655((String)ns, (String)split[split.length - 1].replace(".png", "")));
                } else {
                    texturePaths.computeIfAbsent(ns, x -> new ObjectArraySet()).add(class_2960.method_60655((String)ns, (String)dir));
                }
            }
            filemap.put((String)fileRedirects.getOrDefault(relativePath, relativePath), stream.readAllBytes());
        }
        catch (Throwable e) {
            Filament.LOGGER.error("Error reading nexo asset", e);
        }
    }

    private static /* synthetic */ void lambda$importAll$0(Map redirects, Path x) {
        NexoImporter.importPack(x, redirects);
    }

    private static class TextUtil {
        private TextUtil() {
        }

        public static class_2561 formatText(String text) {
            return TextParserUtils.formatText((String)text);
        }
    }
}

