/*
 * Decompiled with CFR 0.152.
 */
package stranik.dev.nametaghider;

import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.NotNull;

public final class NametagHiderPlugin
extends JavaPlugin
implements Listener {
    private static final String DefaultDisplayName = "NametagHide";
    private static final String DefaultNameTeam = "nametagHide";
    private static final String DefaultNicknameFormat = "%nickname%";
    private static final String NameTeamPath = "scoreboardTeam.name";
    private static final String DisplayNamePath = "scoreboardTeam.displayName";
    private static final String NicknameFormatPath = "nicknameFormat";
    private static final String UseRightClickViewPath = "rightClickView";
    private static final String EnabledPath = "enabled";

    public void onEnable() {
        this.saveDefaultConfig();
        PluginManager pluginManager = this.getServer().getPluginManager();
        pluginManager.registerEvents((Listener)this, (Plugin)this);
        this.prepareScoreboardTeam();
    }

    private void prepareScoreboardTeam() {
        String displayName = this.getDisplayName();
        Team team = this.getTeam();
        team.setDisplayName(displayName);
        team.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.NEVER);
        team.setCanSeeFriendlyInvisibles(false);
        this.addAllUserToTeam(team);
    }

    private void addAllUserToTeam(Team team) {
        if (team == null) {
            return;
        }
        for (Player player : this.getServer().getOnlinePlayers()) {
            if (team.hasPlayer((OfflinePlayer)player)) continue;
            team.addPlayer((OfflinePlayer)player);
        }
    }

    public void onDisable() {
    }

    private void deleteTeam() {
        String nameTeam;
        Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
        Team team = scoreboard.getTeam(nameTeam = this.getNameTeam());
        if (team == null) {
            return;
        }
        team.unregister();
    }

    private String getDisplayName() {
        String displayName = this.getConfig().getString(DisplayNamePath);
        if (displayName == null || displayName.trim().isEmpty()) {
            return DefaultDisplayName;
        }
        return displayName;
    }

    private String getNameTeam() {
        String nameTeam = this.getConfig().getString(NameTeamPath);
        if (nameTeam == null || nameTeam.trim().isEmpty()) {
            return DefaultNameTeam;
        }
        return nameTeam;
    }

    private String getNicknameFormat() {
        String nicknameFormat = this.getConfig().getString(NicknameFormatPath);
        if (nicknameFormat == null || nicknameFormat.trim().isEmpty()) {
            return DefaultNicknameFormat;
        }
        return nicknameFormat;
    }

    private boolean getUseRightClickView() {
        return this.getConfig().getBoolean(UseRightClickViewPath);
    }

    private boolean getEnable() {
        return this.getConfig().getBoolean(EnabledPath);
    }

    private Team getTeam() {
        String nameTeam;
        Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
        Team team = scoreboard.getTeam(nameTeam = this.getNameTeam());
        if (team == null) {
            team = scoreboard.registerNewTeam(nameTeam);
        }
        return team;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!sender.hasPermission("nametagHider.commands")) {
            return false;
        }
        if (args.length == 1 && args[0].equalsIgnoreCase("reload")) {
            this.reloadConfig();
            sender.sendMessage("Config successfully reloaded");
            return true;
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("set-rc")) {
            this.getConfig().set(UseRightClickViewPath, (Object)Boolean.parseBoolean(args[1]));
            this.saveConfig();
            sender.sendMessage("Use right click rule set to: " + this.getUseRightClickView());
            return true;
        }
        if (args.length == 1 && args[0].equalsIgnoreCase("set-rc")) {
            sender.sendMessage("Use right click rule: " + this.getUseRightClickView());
            return true;
        }
        if (args.length == 2 && args[0].equalsIgnoreCase(EnabledPath)) {
            boolean enabled = Boolean.parseBoolean(args[1]);
            if (enabled && !this.getEnable()) {
                this.prepareScoreboardTeam();
            } else if (!enabled && this.getEnable()) {
                this.deleteTeam();
            }
            this.getConfig().set(EnabledPath, (Object)enabled);
            this.saveConfig();
            sender.sendMessage("Enabled set to: " + this.getEnable() + " successfully");
            return true;
        }
        if (args.length == 1 && args[0].equalsIgnoreCase(EnabledPath)) {
            sender.sendMessage("Enabled: " + this.getEnable());
            return true;
        }
        if (args.length == 1 && args[0].equalsIgnoreCase("info")) {
            sender.sendMessage("Enabled: " + this.getEnable() + "\nUse right click rule: " + this.getUseRightClickView() + "\n");
            return true;
        }
        return false;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        if (args.length == 1) {
            if (args[0].trim().isEmpty()) {
                return List.of("reload", "set-rc", EnabledPath, "info");
            }
            if ("reload".startsWith(args[0]) && !"reload".equals(args[0])) {
                return List.of("reload");
            }
            if ("set-rc".startsWith(args[0]) && !"set-rc".equals(args[0])) {
                return List.of("set-rc");
            }
            if (EnabledPath.startsWith(args[0]) && !EnabledPath.equals(args[0])) {
                return List.of(EnabledPath);
            }
            if ("info".startsWith(args[0]) && !"info".equals(args[0])) {
                return List.of("info");
            }
        }
        if (args.length == 2 && (args[0].equalsIgnoreCase("set-rc") || args[0].equalsIgnoreCase(EnabledPath))) {
            if (args[1].trim().isEmpty()) {
                return List.of("true", "false");
            }
            if ("true".startsWith(args[1]) && !"true".equals(args[1])) {
                return List.of("true");
            }
            if ("false".startsWith(args[1]) && !"false".equals(args[1])) {
                return List.of("false");
            }
        }
        return new ArrayList<String>();
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent e) {
        if (!this.getEnable()) {
            return;
        }
        Team team = this.getTeam();
        team.addPlayer((OfflinePlayer)e.getPlayer());
    }

    @EventHandler
    public void onPlayerInteractEntity(PlayerInteractEntityEvent e) {
        if (!this.getUseRightClickView() || !this.getEnable()) {
            return;
        }
        Entity entity = e.getRightClicked();
        if (entity instanceof Player) {
            Player target = (Player)entity;
            Player source = e.getPlayer();
            String message = this.getNicknameFormat().replace(DefaultNicknameFormat, target.getName());
            source.sendActionBar(() -> Component.text((String)message));
        }
    }
}

