/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.goety_cataclysm.client.render;

import com.Polarice3.goety_cataclysm.common.entities.projectiles.IgnisFireball;
import com.github.L_Ender.cataclysm.client.model.entity.Ignis_Fireball_Model;
import com.github.L_Ender.cataclysm.client.render.CMRenderTypes;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class IgnisFireballRenderer
extends EntityRenderer<IgnisFireball> {
    private static final ResourceLocation IGNIS_FIRE_BALL = new ResourceLocation("cataclysm", "textures/entity/ignis_fireball.png");
    private static final ResourceLocation IGNIS_FIRE_BALL_SOUL = new ResourceLocation("cataclysm", "textures/entity/ignis_fireball_soul.png");
    private static final ResourceLocation TRAIL_TEXTURE = new ResourceLocation("cataclysm", "textures/particle/storm.png");
    public Ignis_Fireball_Model model;
    private final RandomSource random = RandomSource.m_216327_();

    public IgnisFireballRenderer(EntityRendererProvider.Context manager) {
        super(manager);
        this.model = new Ignis_Fireball_Model();
    }

    protected int getBlockLightLevel(IgnisFireball entity, BlockPos pos) {
        return 15;
    }

    public void render(IgnisFireball entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        matrixStackIn.m_85836_();
        float f = this.rotLerp(entityIn.f_19859_, entityIn.m_146908_(), partialTicks);
        float f1 = Mth.m_14179_((float)partialTicks, (float)entityIn.f_19860_, (float)entityIn.m_146909_());
        float f2 = (float)entityIn.f_19797_ + partialTicks;
        matrixStackIn.m_85837_(0.0, (double)0.3f, 0.0);
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(Mth.m_14031_((float)(f2 * 0.1f)) * 180.0f));
        matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14089_((float)(f2 * 0.1f)) * 180.0f));
        matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(Mth.m_14031_((float)(f2 * 0.15f)) * 360.0f));
        this.model.m_6973_((Entity)entityIn, 0.0f, 0.0f, 0.0f, f, f1);
        VertexConsumer VertexConsumer2 = bufferIn.m_6299_(this.model.m_103119_(this.getTextureLocation(entityIn)));
        this.model.m_7695_(matrixStackIn, VertexConsumer2, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStackIn.m_85849_();
        if (entityIn.hasTrail()) {
            double x = Mth.m_14139_((double)partialTicks, (double)entityIn.f_19790_, (double)entityIn.m_20185_());
            double y = Mth.m_14139_((double)partialTicks, (double)entityIn.f_19791_, (double)entityIn.m_20186_());
            double z = Mth.m_14139_((double)partialTicks, (double)entityIn.f_19792_, (double)entityIn.m_20189_());
            float ran = 0.04f;
            float r = (!entityIn.isSoul() ? 0.8039216f : 0.3254902f) + this.random.m_188501_() * ran;
            float g = (!entityIn.isSoul() ? 0.49411765f : 0.9372549f) + this.random.m_188501_() * ran;
            float b = (!entityIn.isSoul() ? 0.0f : 0.95686275f) + this.random.m_188501_() * ran;
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_(-x, -y, -z);
            this.renderTrail(entityIn, partialTicks, matrixStackIn, bufferIn, r, g, b, 1.0f, packedLightIn);
            matrixStackIn.m_85849_();
        }
        super.m_7392_((Entity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    public ResourceLocation getTextureLocation(IgnisFireball entity) {
        return entity.isSoul() ? IGNIS_FIRE_BALL_SOUL : IGNIS_FIRE_BALL;
    }

    private void renderTrail(IgnisFireball entityIn, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, float trailR, float trailG, float trailB, float trailA, int packedLightIn) {
        int sampleSize = 10;
        float trailHeight = 0.2f;
        float trailYRot = 0.0f;
        float trailZRot = 0.0f;
        Vec3 topAngleVec = new Vec3((double)trailHeight, (double)trailHeight, 0.0).m_82524_(trailYRot).m_82535_(trailZRot);
        Vec3 bottomAngleVec = new Vec3((double)(-trailHeight), (double)(-trailHeight), 0.0).m_82524_(trailYRot).m_82535_(trailZRot);
        Vec3 drawFrom = entityIn.getTrailPosition(0, partialTicks);
        PoseStack.Pose posestack$pose = poseStack.m_85850_();
        Matrix4f matrix4f = posestack$pose.m_252922_();
        Matrix3f matrix3f = posestack$pose.m_252943_();
        VertexConsumer vertexconsumer = bufferIn.m_6299_(CMRenderTypes.getLightTrailEffect((ResourceLocation)TRAIL_TEXTURE));
        for (int samples = 0; samples < sampleSize; ++samples) {
            Vec3 sample = entityIn.getTrailPosition(samples + 2, partialTicks);
            float u1 = (float)samples / (float)sampleSize;
            float u2 = u1 + 1.0f / (float)sampleSize;
            this.addVertex(vertexconsumer, matrix4f, matrix3f, drawFrom, bottomAngleVec, trailR, trailG, trailB, u1, 1.0f, packedLightIn);
            this.addVertex(vertexconsumer, matrix4f, matrix3f, sample, bottomAngleVec, trailR, trailG, trailB, u2, 1.0f, packedLightIn);
            this.addVertex(vertexconsumer, matrix4f, matrix3f, sample, topAngleVec, trailR, trailG, trailB, u2, 0.0f, packedLightIn);
            this.addVertex(vertexconsumer, matrix4f, matrix3f, drawFrom, topAngleVec, trailR, trailG, trailB, u1, 0.0f, packedLightIn);
            drawFrom = sample;
        }
    }

    private void addVertex(VertexConsumer consumer, Matrix4f matrix, Matrix3f matrix3, Vec3 pos, Vec3 offset, float r, float g, float b, float u, float v, int light) {
        consumer.m_252986_(matrix, (float)(pos.f_82479_ + offset.f_82479_), (float)(pos.f_82480_ + offset.f_82480_), (float)(pos.f_82481_ + offset.f_82481_)).m_85950_(r, g, b, 1.0f).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    private float rotLerp(float prevRotation, float rotation, float partialTicks) {
        float f;
        for (f = rotation - prevRotation; f < -180.0f; f += 360.0f) {
        }
        while (f >= 180.0f) {
            f -= 360.0f;
        }
        return prevRotation + partialTicks * f;
    }
}

