/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.goety_cataclysm.client.render.model;

import com.Polarice3.Goety.client.render.animation.NecromancerAnimations;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.goety_cataclysm.common.entities.neutral.AbstractDraugrNecromancer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class DraugrNecromancerModel<T extends AbstractDraugrNecromancer>
extends HierarchicalModel<T> {
    public final ModelPart root;
    private final ModelPart skeleton;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart jaw;
    private final ModelPart hat;
    private final ModelPart horns;
    private final ModelPart right_arm;
    private final ModelPart staff;
    private final ModelPart handle;
    private final ModelPart group;
    private final ModelPart staffhead;
    private final ModelPart right_pauldron;
    private final ModelPart left_arm;
    private final ModelPart leftItem;
    private final ModelPart left_pauldron;
    private final ModelPart pants;
    private final ModelPart middle;
    private final ModelPart cape;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;

    public DraugrNecromancerModel(ModelPart root) {
        this.root = root;
        this.skeleton = root.m_171324_("skeleton");
        this.body = this.skeleton.m_171324_("body");
        this.head = this.body.m_171324_("head");
        this.jaw = this.head.m_171324_("jaw");
        this.hat = this.head.m_171324_("hat");
        this.horns = this.hat.m_171324_("horns");
        this.right_arm = this.body.m_171324_("right_arm");
        this.staff = this.right_arm.m_171324_("staff");
        this.handle = this.staff.m_171324_("handle");
        this.group = this.staff.m_171324_("group");
        this.staffhead = this.staff.m_171324_("staffhead");
        this.right_pauldron = this.right_arm.m_171324_("right_pauldron");
        this.left_arm = this.body.m_171324_("left_arm");
        this.leftItem = this.left_arm.m_171324_("leftItem");
        this.left_pauldron = this.left_arm.m_171324_("left_pauldron");
        this.pants = this.body.m_171324_("pants");
        this.middle = this.pants.m_171324_("middle");
        this.cape = this.body.m_171324_("cape");
        this.rightLeg = this.skeleton.m_171324_("right_leg");
        this.leftLeg = this.skeleton.m_171324_("left_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition skeleton = partdefinition.m_171599_("skeleton", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = skeleton.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 16).m_171488_(-4.0f, -12.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 112).m_171488_(-4.0f, -12.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)0.0f, (float)-12.0f, (float)0.0f, (float)0.0f, (float)-0.2618f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-12.0f, (float)0.0f, (float)0.0f, (float)0.2618f, (float)0.0f));
        PartDefinition jaw = head.m_171599_("jaw", CubeListBuilder.m_171558_().m_171514_(0, 71).m_171488_(-3.0f, -2.5f, -2.0f, 6.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-2.5f, (float)-1.0f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition hat = head.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.0f, -8.75f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition horns = hat.m_171599_("horns", CubeListBuilder.m_171558_().m_171514_(28, 92).m_171488_(-9.0f, -39.0f, 0.0f, 18.0f, 10.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition right_arm = body.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171488_(-1.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(32, 112).m_171488_(-1.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)-5.0f, (float)-10.0f, (float)0.0f, (float)-1.3963f, (float)0.2618f, (float)0.0f));
        PartDefinition staff = right_arm.m_171599_("staff", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)10.0f, (float)5.5f, (float)1.4399f, (float)0.0f, (float)0.0f));
        PartDefinition handle = staff.m_171599_("handle", CubeListBuilder.m_171558_().m_171514_(60, 39).m_171488_(0.5f, -16.0f, -19.0f, 1.0f, 24.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.0f, (float)7.0f, (float)19.0f));
        PartDefinition group = staff.m_171599_("group", CubeListBuilder.m_171558_().m_171514_(56, 47).m_171488_(0.5f, -19.0f, -21.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(56, 47).m_171488_(2.5f, -19.0f, -19.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(56, 47).m_171488_(-1.5f, -19.0f, -19.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(56, 47).m_171488_(0.5f, -19.0f, -17.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(48, 56).m_171488_(0.5f, -17.0f, -21.0f, 1.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(48, 62).m_171488_(-1.5f, -17.0f, -19.0f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.0f, (float)7.0f, (float)19.0f));
        PartDefinition staffhead = staff.m_171599_("staffhead", CubeListBuilder.m_171558_().m_171514_(48, 50).m_171488_(-0.5f, -20.0f, -20.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.0f, (float)7.0f, (float)19.0f));
        PartDefinition right_pauldron = right_arm.m_171599_("right_pauldron", CubeListBuilder.m_171558_().m_171514_(0, 48).m_171488_(-4.0f, -4.0f, -3.0f, 5.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)1.0f, (float)1.0472f, (float)-0.0873f, (float)-0.2618f));
        PartDefinition left_arm = body.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171480_().m_171488_(-1.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(24, 112).m_171480_().m_171488_(-1.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.01f)).m_171555_(false), PartPose.m_171423_((float)5.0f, (float)-10.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0873f));
        PartDefinition leftItem = left_arm.m_171599_("leftItem", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)1.0f, (float)7.0f, (float)1.0f));
        PartDefinition left_pauldron = left_arm.m_171599_("left_pauldron", CubeListBuilder.m_171558_().m_171514_(0, 48).m_171480_().m_171488_(-1.0f, -4.0f, -3.0f, 5.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)1.0f));
        PartDefinition pants = body.m_171599_("pants", CubeListBuilder.m_171558_().m_171514_(16, 32).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition middle = pants.m_171599_("middle", CubeListBuilder.m_171558_().m_171514_(40, 36).m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 10.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-2.0f));
        PartDefinition cape = body.m_171599_("cape", CubeListBuilder.m_171558_().m_171514_(24, 64).m_171488_(-8.0f, 0.0f, -2.0f, 16.0f, 24.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-12.0f, (float)1.0f));
        PartDefinition right_leg = skeleton.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(32, 112).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)-2.0f, (float)-12.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0436f));
        PartDefinition left_leg = skeleton.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171480_().m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(24, 112).m_171480_().m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.01f)).m_171555_(false), PartPose.m_171423_((float)2.0f, (float)-12.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1309f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)128);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        if (!entity.m_21224_()) {
            if (((AbstractDraugrNecromancer)((Object)entity)).cantDo > 0) {
                this.head.f_104205_ = 0.3f * Mth.m_14031_((float)(0.45f * ageInTicks));
                this.head.f_104203_ = 0.4f;
            } else {
                this.animateHeadLookTarget(netHeadYaw, headPitch);
            }
        }
        this.m_233381_(((AbstractDraugrNecromancer)((Object)entity)).idleAnimationState, NecromancerAnimations.ALERT, ageInTicks);
        if (this.f_102609_) {
            this.rightLeg.f_104203_ = -1.4137167f;
            this.rightLeg.f_104204_ = 0.31415927f;
            this.rightLeg.f_104205_ = 0.07853982f;
            this.leftLeg.f_104203_ = -1.4137167f;
            this.leftLeg.f_104204_ = -0.31415927f;
            this.leftLeg.f_104205_ = -0.07853982f;
        } else if (!entity.isIdleOrNoAnimation()) {
            this.animateWalk(entity, limbSwing, limbSwingAmount);
        } else {
            this.m_267799_(NecromancerAnimations.WALK, limbSwing, limbSwingAmount, 2.5f, 20.0f);
        }
        this.m_233385_(((AbstractDraugrNecromancer)((Object)entity)).attackAnimationState, NecromancerAnimations.ATTACK, ageInTicks, entity.getAttackSpeed());
        this.m_233381_(((AbstractDraugrNecromancer)((Object)entity)).summonAnimationState, NecromancerAnimations.SUMMON, ageInTicks);
        this.m_233381_(((AbstractDraugrNecromancer)((Object)entity)).spellAnimationState, NecromancerAnimations.SPELL, ageInTicks);
    }

    private void animateWalk(T entity, float limbSwing, float limbSwingAmount) {
        float f = 1.0f;
        if (entity.m_21256_() > 4) {
            f = (float)entity.m_20184_().m_82556_();
            f /= 0.2f;
            f = f * f * f;
        }
        if (f < 1.0f) {
            f = 1.0f;
        }
        this.cape.f_104203_ = MathHelper.modelDegrees((float)10.0f) + Mth.m_14154_((float)(Mth.m_14089_((float)(limbSwing * 0.6662f)) * 0.7f * limbSwingAmount / f));
        this.rightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount * 0.5f;
        this.leftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount * 0.5f;
    }

    private void animateHeadLookTarget(float netHeadYaw, float headPitch) {
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

