/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.goety_cataclysm.common.entities.ally.golem;

import com.Polarice3.Goety.api.entities.IAutoRideable;
import com.Polarice3.Goety.api.items.magic.IWand;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.projectiles.Pyroclast;
import com.Polarice3.Goety.utils.ItemHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.goety_cataclysm.common.blocks.GoetyBlocks;
import com.Polarice3.goety_cataclysm.common.entities.GCEntityType;
import com.Polarice3.goety_cataclysm.common.entities.ally.IABossSummon;
import com.Polarice3.goety_cataclysm.common.entities.ally.ai.InternalSummonAttackGoal;
import com.Polarice3.goety_cataclysm.common.entities.ally.ai.InternalSummonMoveGoal;
import com.Polarice3.goety_cataclysm.common.entities.ally.ai.InternalSummonStateGoal;
import com.Polarice3.goety_cataclysm.common.entities.ally.golem.NMPart;
import com.Polarice3.goety_cataclysm.common.entities.projectiles.FlareBomb;
import com.Polarice3.goety_cataclysm.common.items.CataclysmItems;
import com.Polarice3.goety_cataclysm.config.GCAttributesConfig;
import com.Polarice3.goety_cataclysm.config.GCMobsConfig;
import com.Polarice3.goety_cataclysm.init.CataclysmSounds;
import com.github.L_Ender.cataclysm.client.particle.RingParticle;
import com.github.L_Ender.cataclysm.client.particle.RoarParticle;
import com.github.L_Ender.cataclysm.config.CMConfig;
import com.github.L_Ender.cataclysm.entity.effect.Cm_Falling_Block_Entity;
import com.github.L_Ender.cataclysm.entity.effect.ScreenShake_Entity;
import com.github.L_Ender.cataclysm.entity.etc.SmartBodyHelper2;
import com.github.L_Ender.cataclysm.entity.etc.path.CMPathNavigateGround;
import com.github.L_Ender.cataclysm.entity.partentity.Cm_Part_Entity;
import com.github.L_Ender.cataclysm.entity.projectile.Flame_Jet_Entity;
import com.github.L_Ender.cataclysm.init.ModEffect;
import com.github.L_Ender.cataclysm.init.ModTag;
import com.github.L_Ender.cataclysm.util.CMMathUtil;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PlayerRideable;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.Tags;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.ForgeEventFactory;

public class NetheriteMonstrosityServant
extends IABossSummon
implements PlayerRideable,
IAutoRideable {
    public int frame;
    public float LayerBrightness;
    public float oLayerBrightness;
    public int LayerTicks;
    public static int IDLE = 0;
    public static int SLEEP = 1;
    public static int AWAKEN = 2;
    public static int SMASH_ATTACK = 3;
    public static int PHASE_SMASH_ATTACK = 4;
    public static int DEATH = 5;
    public static int MAGMA_ATTACK = 6;
    public static int DRAIN_LAVA = 7;
    public static int CHARGE_ATTACK = 8;
    public static int EARTHQUAKE_ATTACK = 9;
    public static int FLARE_ATTACK = 10;
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState sleepAnimationState = new AnimationState();
    public AnimationState awakeAnimationState = new AnimationState();
    public AnimationState smashsAnimationState = new AnimationState();
    public AnimationState phaseAnimationState = new AnimationState();
    public AnimationState fireAnimationState = new AnimationState();
    public AnimationState drainAnimationState = new AnimationState();
    public AnimationState shouldercheckAnimationState = new AnimationState();
    public AnimationState overpowerAnimationState = new AnimationState();
    public AnimationState flareshotAnimationState = new AnimationState();
    public AnimationState deathAnimationState = new AnimationState();
    public final NMPart headPart;
    public final NMPart[] monstrosityParts;
    private static final EntityDataAccessor<Boolean> IS_BERSERK = SynchedEntityData.m_135353_(NetheriteMonstrosityServant.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_AWAKEN = SynchedEntityData.m_135353_(NetheriteMonstrosityServant.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> AUTO_MODE = SynchedEntityData.m_135353_(NetheriteMonstrosityServant.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> MAGAZINE = SynchedEntityData.m_135353_(NetheriteMonstrosityServant.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public boolean Blocking = CMConfig.NetheritemonstrosityBodyBloking;
    private int blockBreakCounter;
    private int shoot_cooldown = 0;
    public static final int SHOOT_COOLDOWN = 240;
    private boolean onLava = false;
    private int check_cooldown = 0;
    public static final int CHECK_COOLDOWN = 80;
    private int overpower_cooldown = 0;
    public static final int OVERPOWER_COOLDOWN = 160;
    private int flare_shoot_cooldown = 0;
    public static final int FLARE_SHOOT_COOLDOWN = 120;
    private int timeWithoutTarget;
    private int wakeUp;
    private boolean intro;
    public boolean clientStop;

    public NetheriteMonstrosityServant(EntityType<? extends Summoned> entity, Level world) {
        super(entity, world);
        this.m_274367_(4.5f);
        this.headPart = new NMPart(this, 1.6f, 2.5f);
        this.monstrosityParts = new NMPart[]{this.headPart};
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
        this.m_21441_(BlockPathTypes.LAVA, 0.0f);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(5, (Goal)new Summoned.WanderGoal((PathfinderMob)this, 1.0, 80.0f));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new InternalSummonMoveGoal(this, false, 1.0){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && NetheriteMonstrosityServant.this.getAttackState() == 0;
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new InternalSummonAttackGoal(this, IDLE, SMASH_ATTACK, IDLE, 58, 12, 6.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && NetheriteMonstrosityServant.this.m_217043_().m_188501_() * 100.0f < 32.0f;
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new InternalSummonStateGoal(this, SLEEP, SLEEP, AWAKEN, 0, 0){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && !NetheriteMonstrosityServant.this.getIsAwaken();
            }

            @Override
            public void m_8037_() {
                this.entity.m_20334_(0.0, this.entity.m_20184_().f_82480_, 0.0);
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                NetheriteMonstrosityServant.this.setIsAwaken(true);
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new InternalSummonStateGoal(this, AWAKEN, AWAKEN, IDLE, 40, 0){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && NetheriteMonstrosityServant.this.getIsAwaken();
            }

            @Override
            public void m_8037_() {
                this.entity.m_20334_(0.0, this.entity.m_20184_().f_82480_, 0.0);
            }
        });
        this.f_21345_.m_25352_(0, (Goal)new InternalSummonStateGoal(this, SLEEP, AWAKEN, IDLE, 40, 0){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && NetheriteMonstrosityServant.this.wakeUp <= 0;
            }

            @Override
            public void m_8056_() {
                super.m_8056_();
                NetheriteMonstrosityServant.this.setIsAwaken(true);
                NetheriteMonstrosityServant.this.wakeUp = 20;
                NetheriteMonstrosityServant.this.intro = true;
            }
        });
        this.f_21345_.m_25352_(0, (Goal)new InternalSummonAttackGoal(this, SLEEP, AWAKEN, IDLE, 40, 0, 15.0f){

            @Override
            public boolean m_8036_() {
                LivingEntity target = this.entity.m_5448_();
                return super.m_8036_() && target != null && this.entity.m_21574_().m_148306_((Entity)target);
            }

            @Override
            public void m_8056_() {
                super.m_8056_();
                NetheriteMonstrosityServant.this.setIsAwaken(true);
            }
        });
        this.f_21345_.m_25352_(0, (Goal)new MonstrosityPhaseChangeGoal(this, IDLE, PHASE_SMASH_ATTACK, IDLE, 54));
        this.f_21345_.m_25352_(3, (Goal)new MagmaShoot(this, IDLE, MAGMA_ATTACK, IDLE, 44, 20, 40.0f, 19, 16.0f));
        this.f_21345_.m_25352_(3, (Goal)new FlareShoot(this, IDLE, FLARE_ATTACK, IDLE, 60, 35, 26.0f, 35, 18.0f));
        this.f_21345_.m_25352_(3, (Goal)new InternalSummonAttackGoal(this, IDLE, DRAIN_LAVA, IDLE, 60, 25, 1.0f){

            @Override
            public boolean m_8036_() {
                LivingEntity target = this.entity.m_5448_();
                FluidState below = this.entity.m_9236_().m_8055_(NetheriteMonstrosityServant.this.m_20099_()).m_60819_();
                return target != null && target.m_6084_() && this.entity.getAttackState() == 0 && (this.entity.m_20077_() || below.m_205070_(FluidTags.f_13132_)) && NetheriteMonstrosityServant.this.getMagazine() >= CMConfig.Lavabombmagazine;
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new ShoulderCheck(this, IDLE, CHARGE_ATTACK, IDLE, 70, 19, 16.0f, 19, 49, 12.0f));
        this.f_21345_.m_25352_(3, (Goal)new InternalSummonAttackGoal(this, IDLE, EARTHQUAKE_ATTACK, IDLE, 75, 7, 10.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && NetheriteMonstrosityServant.this.m_217043_().m_188501_() * 100.0f < 40.0f && NetheriteMonstrosityServant.this.overpower_cooldown <= 0;
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                NetheriteMonstrosityServant.this.overpower_cooldown = 160;
            }
        });
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 50.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, ((Double)GCAttributesConfig.NetheriteMonstrosityDamage.get()).doubleValue()).m_22268_(Attributes.f_22276_, ((Double)GCAttributesConfig.NetheriteMonstrosityHealth.get()).doubleValue()).m_22268_(Attributes.f_22284_, ((Double)GCAttributesConfig.NetheriteMonstrosityArmor.get()).doubleValue()).m_22268_(Attributes.f_22285_, 5.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes((AttributeInstance)this.m_21051_(Attributes.f_22276_), (double)((Double)GCAttributesConfig.NetheriteMonstrosityHealth.get()));
        MobUtil.setBaseAttributes((AttributeInstance)this.m_21051_(Attributes.f_22284_), (double)((Double)GCAttributesConfig.NetheriteMonstrosityArmor.get()));
        MobUtil.setBaseAttributes((AttributeInstance)this.m_21051_(Attributes.f_22281_), (double)((Double)GCAttributesConfig.NetheriteMonstrosityDamage.get()));
    }

    public int xpReward() {
        return 500;
    }

    public boolean attackEntityFromPart(NMPart nmPart, DamageSource source, float amount) {
        return this.m_6469_(source, amount);
    }

    @Override
    public boolean m_6469_(DamageSource source, float damage) {
        if (this.getAttackState() == PHASE_SMASH_ATTACK && !source.m_269533_(DamageTypeTags.f_268738_)) {
            return false;
        }
        double range = this.calculateRange(source);
        if (range > CMConfig.MonstrosityLongRangelimit * CMConfig.MonstrosityLongRangelimit && !source.m_269533_(DamageTypeTags.f_268738_)) {
            return false;
        }
        Entity entity = source.m_7640_();
        if (entity instanceof AbstractGolem) {
            damage *= 0.5f;
        }
        return super.m_6469_(source, damage);
    }

    protected int m_7302_(int air) {
        return air;
    }

    @Override
    public float DamageCap() {
        return (float)CMConfig.MonstrosityDamageCap;
    }

    @Override
    public int DamageTime() {
        return CMConfig.MonstrosityDamageTime;
    }

    public boolean m_5829_() {
        return this.m_6084_() && this.Blocking && this.getAttackState() != 8;
    }

    public boolean m_6094_() {
        return false;
    }

    public AnimationState getAnimationState(String input) {
        if (Objects.equals(input, "idle")) {
            return this.idleAnimationState;
        }
        if (Objects.equals(input, "sleep")) {
            return this.sleepAnimationState;
        }
        if (Objects.equals(input, "awake")) {
            return this.awakeAnimationState;
        }
        if (Objects.equals(input, "smash")) {
            return this.smashsAnimationState;
        }
        if (Objects.equals(input, "phase_two")) {
            return this.phaseAnimationState;
        }
        if (Objects.equals(input, "fire")) {
            return this.fireAnimationState;
        }
        if (Objects.equals(input, "death")) {
            return this.deathAnimationState;
        }
        if (Objects.equals(input, "drain")) {
            return this.drainAnimationState;
        }
        if (Objects.equals(input, "shoulder_check")) {
            return this.shouldercheckAnimationState;
        }
        if (Objects.equals(input, "overpower")) {
            return this.overpowerAnimationState;
        }
        if (Objects.equals(input, "flare_shot")) {
            return this.flareshotAnimationState;
        }
        return new AnimationState();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_BERSERK, (Object)false);
        this.f_19804_.m_135372_(IS_AWAKEN, (Object)false);
        this.f_19804_.m_135372_(AUTO_MODE, (Object)false);
        this.f_19804_.m_135372_(MAGAZINE, (Object)0);
    }

    public boolean isSleep() {
        return this.getAttackState() == SLEEP || this.getAttackState() == AWAKEN;
    }

    public boolean m_203441_(FluidState p_230285_1_) {
        return p_230285_1_.m_205070_(FluidTags.f_13132_);
    }

    public void setIsInBerserk(boolean isBerserk) {
        this.f_19804_.m_135381_(IS_BERSERK, (Object)isBerserk);
    }

    public boolean isInBerserk() {
        return (Boolean)this.f_19804_.m_135370_(IS_BERSERK);
    }

    public void setOnLava(boolean lava) {
        this.onLava = lava;
    }

    public boolean getOnLava() {
        return this.onLava;
    }

    public void setIsAwaken(boolean isAwaken) {
        this.f_19804_.m_135381_(IS_AWAKEN, (Object)isAwaken);
        if (!isAwaken) {
            this.setAttackState(1);
        }
    }

    public boolean getIsAwaken() {
        return (Boolean)this.f_19804_.m_135370_(IS_AWAKEN);
    }

    public void setMagazine(int isAwaken) {
        this.f_19804_.m_135381_(MAGAZINE, (Object)isAwaken);
    }

    public int getMagazine() {
        return (Integer)this.f_19804_.m_135370_(MAGAZINE);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        if (pReason == MobSpawnType.MOB_SUMMONED) {
            this.setIsAwaken(false);
            this.wakeUp = 20;
        } else {
            this.setIsAwaken(true);
        }
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public void m_7350_(EntityDataAccessor<?> p_21104_) {
        if (ATTACK_STATE.equals(p_21104_)) {
            switch (this.getAttackState()) {
                case 0: {
                    this.stopAllAnimationStates();
                    break;
                }
                case 1: {
                    this.stopAllAnimationStates();
                    this.sleepAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 2: {
                    this.stopAllAnimationStates();
                    this.awakeAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 3: {
                    this.stopAllAnimationStates();
                    this.smashsAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 4: {
                    this.stopAllAnimationStates();
                    this.phaseAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 5: {
                    this.stopAllAnimationStates();
                    this.deathAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 6: {
                    this.stopAllAnimationStates();
                    this.fireAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 7: {
                    this.stopAllAnimationStates();
                    this.drainAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 8: {
                    this.stopAllAnimationStates();
                    this.shouldercheckAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 9: {
                    this.stopAllAnimationStates();
                    this.overpowerAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 10: {
                    this.stopAllAnimationStates();
                    this.flareshotAnimationState.m_216982_(this.f_19797_);
                }
            }
        }
        super.m_7350_(p_21104_);
    }

    public void stopAllAnimationStates() {
        this.sleepAnimationState.m_216973_();
        this.awakeAnimationState.m_216973_();
        this.smashsAnimationState.m_216973_();
        this.phaseAnimationState.m_216973_();
        this.deathAnimationState.m_216973_();
        this.fireAnimationState.m_216973_();
        this.drainAnimationState.m_216973_();
        this.overpowerAnimationState.m_216973_();
        this.shouldercheckAnimationState.m_216973_();
        this.flareshotAnimationState.m_216973_();
    }

    @Override
    public void m_6667_(DamageSource p_21014_) {
        super.m_6667_(p_21014_);
        this.setAttackState(DEATH);
    }

    @Override
    public int deathTimer() {
        return 60;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Intro", this.intro);
        compound.m_128379_("is_Berserk", this.isInBerserk());
        compound.m_128379_("is_Awaken", this.getIsAwaken());
        compound.m_128405_("Magazine", this.getMagazine());
        compound.m_128405_("WakeUp", this.wakeUp);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Intro")) {
            this.intro = compound.m_128471_("Intro");
        }
        if (compound.m_128441_("is_Berserk")) {
            this.setIsInBerserk(compound.m_128471_("is_Berserk"));
        }
        if (compound.m_128441_("is_Awaken")) {
            this.setIsAwaken(compound.m_128471_("is_Awaken"));
        }
        if (compound.m_128441_("Magazine")) {
            this.setMagazine(compound.m_128451_("Magazine"));
        }
        if (compound.m_128441_("WakeUp")) {
            this.wakeUp = compound.m_128451_("WakeUp");
        }
    }

    private void floatStrider() {
        FluidState below = this.m_9236_().m_8055_(this.m_20099_()).m_60819_();
        Vec3 vec3 = this.m_20184_();
        if (this.getAttackState() == CHARGE_ATTACK) {
            CollisionContext lvt_1_1_;
            this.m_20242_(false);
            if (this.m_20077_() && (lvt_1_1_ = CollisionContext.m_82750_((Entity)this)).m_6513_(LiquidBlock.f_54690_, this.m_20183_().m_7495_(), true) && !this.m_9236_().m_6425_(this.m_20183_().m_7494_()).m_205070_(FluidTags.f_13132_)) {
                this.setOnLava(true);
            }
        } else if (below.m_205070_(FluidTags.f_13132_)) {
            this.m_6853_(true);
            if (this.m_20186_() + vec3.f_82480_ < (double)((float)this.m_20099_().m_123342_() + below.m_76182_())) {
                this.m_20242_(true);
                if (vec3.f_82480_ < 0.0) {
                    this.m_20256_(vec3.m_82542_(1.0, 0.0, 1.0));
                }
                this.m_6034_(this.m_20185_(), (float)this.m_20099_().m_123342_() + below.m_76182_(), this.m_20189_());
            }
        } else if (this.m_20077_()) {
            if (this.m_217043_().m_188501_() < 0.8f) {
                this.m_20256_(vec3.m_82520_(0.0, 0.08, 0.0));
            }
        } else {
            this.m_20242_(false);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.floatStrider();
        if (this.m_9236_().m_5776_()) {
            this.idleAnimationState.m_246184_(this.getAttackState() == 0, this.f_19797_);
        }
        ++this.frame;
        float moveX = (float)(this.m_20185_() - this.f_19854_);
        float moveZ = (float)(this.m_20189_() - this.f_19856_);
        float speed = Mth.m_14116_((float)(moveX * moveX + moveZ * moveZ));
        if (!this.m_20067_() && this.frame % 25 == 1 && (double)speed > 0.05 && this.getIsAwaken() && this.getAttackState() != 8) {
            this.m_5496_((SoundEvent)CataclysmSounds.MONSTROSITYSTEP.get(), 1.0f, 1.0f);
            ScreenShake_Entity.ScreenShake((Level)this.m_9236_(), (Vec3)this.m_20182_(), (float)15.0f, (float)0.08f, (int)0, (int)5);
        }
        this.BlockBreaking();
        if (this.blockBreakCounter > 0) {
            --this.blockBreakCounter;
        }
        if (this.shoot_cooldown > 0) {
            --this.shoot_cooldown;
        }
        if (this.overpower_cooldown > 0) {
            --this.overpower_cooldown;
        }
        if (this.check_cooldown > 0) {
            --this.check_cooldown;
        }
        if (this.flare_shoot_cooldown > 0) {
            --this.flare_shoot_cooldown;
        }
        if (this.wakeUp > 0 && !this.intro) {
            --this.wakeUp;
        }
        LivingEntity target = this.m_5448_();
        if (!this.m_9236_().f_46443_) {
            if (this.timeWithoutTarget > 0) {
                --this.timeWithoutTarget;
            }
            if (target != null) {
                this.timeWithoutTarget = 200;
            }
        }
        if (!this.m_21525_() && !this.getIsAwaken() && this.f_19797_ % 4 == 0) {
            this.m_5634_((float)CMConfig.MonstrosityNatureHealing);
        }
        this.setHeadPart();
        if (this.m_9236_().f_46443_) {
            ++this.LayerTicks;
            this.LayerBrightness += (0.0f - this.LayerBrightness) * 0.8f;
        }
        if (!this.m_9236_().f_46443_) {
            if (this.getAttackState() != 0) {
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)7);
            }
        }
    }

    protected void m_6763_(BlockState p_20005_) {
        if ((p_20005_.m_60713_(Blocks.f_50084_) || p_20005_.m_60713_(Blocks.f_50684_) && p_20005_.m_61138_((Property)CampfireBlock.f_51227_) && ((Boolean)p_20005_.m_61143_((Property)CampfireBlock.f_51227_)).booleanValue()) && this.timeWithoutTarget <= 0 && !this.m_21525_() && CMConfig.MonstrosityNatureHealing > 0.0 && this.f_19797_ % 20 == 0) {
            this.m_5634_((float)CMConfig.MonstrosityNatureHealing);
        }
    }

    private void setHeadPart() {
        if (!this.m_21525_()) {
            float f17 = this.f_20883_ * ((float)Math.PI / 180);
            float pitch = this.m_146909_() * ((float)Math.PI / 180);
            float f3 = Mth.m_14031_((float)f17) * (1.0f - Math.abs(this.m_146909_() / 90.0f));
            float f18 = Mth.m_14089_((float)f17) * (1.0f - Math.abs(this.m_146909_() / 90.0f));
            Vec3[] avector3d = new Vec3[this.monstrosityParts.length];
            for (int j = 0; j < this.monstrosityParts.length; ++j) {
                avector3d[j] = new Vec3(this.monstrosityParts[j].m_20185_(), this.monstrosityParts[j].m_20186_(), this.monstrosityParts[j].m_20189_());
            }
            float headY = 0.0f;
            float headxz = 0.0f;
            if (this.getAttackState() == SMASH_ATTACK) {
                int end = 40;
                float f = this.attackTicks > end ? CMMathUtil.cullAnimationTick((int)this.attackTicks, (float)1.2f, (float)1.0f, (int)13, (int)end) : CMMathUtil.cullAnimationTick((int)this.attackTicks, (float)2.0f, (float)1.0f, (int)13, (int)end);
                headxz = -1.6f * f;
                headY = -2.2f * f;
            }
            if (this.getAttackState() == MAGMA_ATTACK) {
                float f = CMMathUtil.cullAnimationTick((int)this.attackTicks, (float)0.5f, (float)1.0f, (int)0, (int)40);
                headxz = 4.0f * f;
                headY = 1.2f * f;
            }
            if (this.getAttackState() == CHARGE_ATTACK) {
                float f = CMMathUtil.cullAnimationTick((int)this.attackTicks, (float)2.0f, (float)1.0f, (int)0, (int)30);
                headxz = -4.0f * f;
            }
            this.setPartPosition(this.headPart, f3 * -1.65f + f3 * headxz, pitch + 2.4f + headY, -f18 * -1.65f - f18 * headxz);
            for (int l = 0; l < this.monstrosityParts.length; ++l) {
                this.monstrosityParts[l].f_19854_ = avector3d[l].f_82479_;
                this.monstrosityParts[l].f_19855_ = avector3d[l].f_82480_;
                this.monstrosityParts[l].f_19856_ = avector3d[l].f_82481_;
                this.monstrosityParts[l].f_19790_ = avector3d[l].f_82479_;
                this.monstrosityParts[l].f_19791_ = avector3d[l].f_82480_;
                this.monstrosityParts[l].f_19792_ = avector3d[l].f_82481_;
            }
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.getAttackState() == AWAKEN && this.attackTicks == 2) {
            this.m_5496_((SoundEvent)CataclysmSounds.MONSTROSITYAWAKEN.get(), 10.0f, 1.0f);
        }
        if (this.getAttackState() == SMASH_ATTACK && this.attackTicks == 19) {
            this.EarthQuake(6.25);
            ScreenShake_Entity.ScreenShake((Level)this.m_9236_(), (Vec3)this.m_20182_(), (float)20.0f, (float)0.3f, (int)0, (int)20);
            this.MakeParticle(4.75f, 2.5f);
            this.MakeParticle(4.75f, -2.5f);
        }
        if (this.getAttackState() == PHASE_SMASH_ATTACK) {
            if (this.attackTicks == 10) {
                this.m_5496_((SoundEvent)CataclysmSounds.MONSTROSITYGROWL.get(), 3.0f, 1.0f);
            }
            if (this.attackTicks == 16) {
                this.Roarparticle(3.5f, 2.7f, 10, 255, 255, 255, 0.4f, 1.0f, 0.8f, 8.0f);
            }
            if (this.attackTicks == 17) {
                this.berserkBlockBreaking(8, 8, 8);
                this.EarthQuake(6.25);
                ScreenShake_Entity.ScreenShake((Level)this.m_9236_(), (Vec3)this.m_20182_(), (float)20.0f, (float)0.3f, (int)0, (int)20);
                this.MakeParticle(4.4f, 2.0f);
                this.MakeParticle(4.4f, -2.0f);
            }
            if (this.attackTicks == 18) {
                this.Roarparticle(3.5f, 2.7f, 10, 255, 255, 255, 0.4f, 1.0f, 0.8f, 9.0f);
            }
            if (this.attackTicks == 20) {
                this.Roarparticle(3.5f, 2.7f, 10, 255, 255, 255, 0.4f, 1.0f, 0.8f, 9.0f);
            }
        }
        if (this.getAttackState() == DEATH && this.attackTicks == 26) {
            this.m_5496_((SoundEvent)CataclysmSounds.MONSTROSITYLAND.get(), 1.0f, 1.0f);
            ScreenShake_Entity.ScreenShake((Level)this.m_9236_(), (Vec3)this.m_20182_(), (float)20.0f, (float)0.3f, (int)0, (int)20);
        }
        if (this.getAttackState() == MAGMA_ATTACK && this.attackTicks == 19) {
            this.m_5496_((SoundEvent)CataclysmSounds.MONSTROSITYSHOOT.get(), 3.0f, 0.75f);
        }
        if (this.getAttackState() == DRAIN_LAVA) {
            if (this.attackTicks == 24) {
                this.setMagazine(0);
                ScreenShake_Entity.ScreenShake((Level)this.m_9236_(), (Vec3)this.m_20182_(), (float)20.0f, (float)0.3f, (int)0, (int)20);
                this.doAbsorptionEffects(4, 1, 4);
                this.m_5496_(SoundEvents.f_11783_, 6.0f, 0.5f);
                this.m_5634_(15.0f * (float)CMConfig.MonstrosityHealingMultiplier);
            }
            if (this.attackTicks == 26) {
                this.doAbsorptionEffects(8, 2, 8);
                this.m_5634_(15.0f * (float)CMConfig.MonstrosityHealingMultiplier);
            }
            if (this.attackTicks == 28) {
                this.doAbsorptionEffects(16, 4, 16);
                this.m_5634_(15.0f * (float)CMConfig.MonstrosityHealingMultiplier);
            }
        }
        if (this.getAttackState() == CHARGE_ATTACK) {
            if (this.attackTicks == 22 || this.attackTicks == 27 || this.attackTicks == 32 || this.attackTicks == 37 || this.attackTicks == 42 || this.attackTicks == 47) {
                ScreenShake_Entity.ScreenShake((Level)this.m_9236_(), (Vec3)this.m_20182_(), (float)20.0f, (float)0.15f, (int)0, (int)6);
                this.m_5496_((SoundEvent)CataclysmSounds.MONSTROSITYSTEP.get(), 1.0f, 1.0f);
            }
            if (this.attackTicks > 19 && this.attackTicks < 49) {
                if (((Boolean)GCMobsConfig.NetheriteMonstrosityGriefing.get()).booleanValue() && !this.m_9236_().f_46443_ && ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this)) {
                    this.ChargeBlockBreaking();
                }
                double yaw = Math.toRadians(this.m_146908_() + 90.0f);
                double xExpand = 2.0 * Math.cos(yaw);
                double zExpand = 2.0 * Math.sin(yaw);
                AABB attackRange = this.m_20191_().m_82377_(0.75, 0.75, 0.75).m_82363_(xExpand, 0.0, zExpand);
                for (LivingEntity Lentity : this.m_9236_().m_45976_(LivingEntity.class, attackRange)) {
                    boolean flag;
                    if (MobUtil.areAllies((Entity)this, (Entity)Lentity) || !(flag = Lentity.m_6469_(this.getServantAttack(), (float)this.m_21133_(Attributes.f_22281_) * 0.4f))) continue;
                    double theta = (double)this.f_20883_ * (Math.PI / 180);
                    double vec = -2.5;
                    double vecX = Math.cos(theta += 1.5707963267948966);
                    double vecZ = Math.sin(theta);
                    double d0 = Lentity.m_20185_() - (this.m_20185_() + vec * vecX);
                    double d1 = Lentity.m_20189_() - (this.m_20189_() + vec * vecZ);
                    double d2 = Math.max(d0 * d0 + d1 * d1, 0.05);
                    double vel = 4.0;
                    Lentity.m_5997_(d0 / d2 * vel, 0.3, d1 / d2 * vel);
                    Lentity.m_7292_(new MobEffectInstance((MobEffect)ModEffect.EFFECTBONE_FRACTURE.get(), 100));
                }
            }
        }
        if (this.getAttackState() == EARTHQUAKE_ATTACK) {
            if (this.attackTicks == 9) {
                this.OverPowerKnockBack(7.0);
                ScreenShake_Entity.ScreenShake((Level)this.m_9236_(), (Vec3)this.m_20182_(), (float)20.0f, (float)0.3f, (int)0, (int)20);
                this.MakeParticle(-0.3f, 3.4f);
                this.MakeParticle(-0.3f, -3.4f);
                this.CircleFlameJet(-0.3f, 3.4f, this.isInBerserk() ? 14 : 7, this.isInBerserk() ? 8 : 4, 3.0);
                this.CircleFlameJet(-0.3f, -3.4f, this.isInBerserk() ? 14 : 7, this.isInBerserk() ? 8 : 4, 3.0);
                this.m_5496_((SoundEvent)CataclysmSounds.REMNANT_STOMP.get(), 1.0f, 0.7f);
            }
            if (this.attackTicks == 26) {
                this.m_5496_((SoundEvent)CataclysmSounds.MONSTROSITYGROWL.get(), 3.0f, 1.0f);
            }
            if (this.attackTicks == 32) {
                this.Roarparticle(2.0f, 4.5f, 10, 255, 255, 255, 0.4f, 1.0f, 0.6f, 4.5f);
            }
            if (this.attackTicks == 34) {
                this.Roarparticle(2.0f, 4.5f, 10, 255, 255, 255, 0.4f, 1.0f, 0.6f, 5.0f);
            }
            if (this.attackTicks == 36) {
                this.Roarparticle(2.0f, 4.5f, 10, 255, 255, 255, 0.4f, 1.0f, 0.6f, 5.5f);
            }
            for (int l = 31; l <= 41; l += 2) {
                if (this.attackTicks != l) continue;
                int d = l - 27;
                int d2 = l - 26;
                float ds = (float)(d + d2) / 2.0f;
                this.StompDamage(0.6f, d, 5, 1.05f, -2.0f, 0.0f, 0, 0.7f);
                this.StompDamage(0.6f, d2, 5, 1.05f, -2.0f, 0.0f, 0, 0.7f);
                this.StompSound(ds, 0.0f);
            }
        }
        if (this.getAttackState() == FLARE_ATTACK && this.attackTicks == 35) {
            ScreenShake_Entity.ScreenShake((Level)this.m_9236_(), (Vec3)this.m_20182_(), (float)15.0f, (float)0.08f, (int)0, (int)10);
            this.m_5496_((SoundEvent)CataclysmSounds.MONSTROSITYSHOOT.get(), 3.0f, 0.75f);
        }
    }

    private void CircleFlameJet(float vec, float math, int vertexrune, int rune, double time) {
        float f = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        float f1 = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        double theta = (double)this.f_20883_ * (Math.PI / 180);
        double vecX = Math.cos(theta += 1.5707963267948966);
        double vecZ = Math.sin(theta);
        for (int i = 0; i < vertexrune; ++i) {
            float throwAngle = (float)i * (float)Math.PI / ((float)vertexrune / 2.0f);
            for (int k = 0; k < rune; ++k) {
                double d2 = 1.1 * (double)(k + 1);
                int d3 = (int)(time * (double)(k + 1));
                this.spawnJet(this.m_20185_() + (double)vec * vecX + (double)(f * math) + (double)Mth.m_14089_((float)throwAngle) * 1.25 * d2, this.m_20189_() + (double)vec * vecZ + (double)(f1 * math) + (double)Mth.m_14031_((float)throwAngle) * 1.25 * d2, this.m_20186_() - 2.0, this.m_20186_() + 2.0, throwAngle, d3);
            }
        }
    }

    private void spawnJet(double x, double z, double minY, double maxY, float rotation, int delay) {
        BlockPos blockpos = BlockPos.m_274561_((double)x, (double)maxY, (double)z);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1 = blockpos.m_7495_();
            BlockState blockstate = this.m_9236_().m_8055_(blockpos1);
            if (!blockstate.m_60783_((BlockGetter)this.m_9236_(), blockpos1, Direction.UP)) continue;
            if (!this.m_9236_().m_46859_(blockpos) && !(voxelshape = (blockstate1 = this.m_9236_().m_8055_(blockpos)).m_60812_((BlockGetter)this.m_9236_(), blockpos)).m_83281_()) {
                d0 = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)minY) - 1);
        if (flag) {
            this.m_9236_().m_7967_((Entity)new Flame_Jet_Entity(this.m_9236_(), x, (double)blockpos.m_123342_() + d0, z, rotation, delay, (float)CMConfig.FlameJetDamage, (LivingEntity)this));
        }
    }

    private void StompSound(float distance, float math) {
        double theta = (double)this.f_20883_ * (Math.PI / 180);
        double vecX = Math.cos(theta += 1.5707963267948966);
        double vecZ = Math.sin(theta);
        float f = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        float f1 = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        this.m_9236_().m_6263_(null, this.m_20185_() + (double)distance * vecX + (double)(f * math), this.m_20186_(), this.m_20189_() + (double)distance * vecZ + (double)(f1 * math), (SoundEvent)CataclysmSounds.REMNANT_STOMP.get(), this.m_5720_(), 0.6f, 1.0f);
    }

    private void StompDamage(float spreadarc, int distance, int height, float mxy, float vec, float math, int shieldbreakticks, float damage) {
        double perpFacing = (double)this.f_20883_ * (Math.PI / 180);
        double facingAngle = perpFacing + 1.5707963267948966;
        int hitY = Mth.m_14107_((double)(this.m_20191_().f_82289_ - 0.5));
        double spread = Math.PI * (double)spreadarc;
        int arcLen = Mth.m_14165_((double)((double)distance * spread));
        float f = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        float f1 = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        for (int i = 0; i < arcLen; ++i) {
            double theta = ((double)i / ((double)arcLen - 1.0) - 0.5) * spread + facingAngle;
            double vx = Math.cos(theta);
            double vz = Math.sin(theta);
            double px = this.m_20185_() + vx * (double)distance + (double)vec * Math.cos((double)(this.f_20883_ + 90.0f) * Math.PI / 180.0) + (double)(f * math);
            double pz = this.m_20189_() + vz * (double)distance + (double)vec * Math.sin((double)(this.f_20883_ + 90.0f) * Math.PI / 180.0 + (double)(f1 * math));
            float factor = 1.0f - (float)distance / 12.0f;
            int hitX = Mth.m_14107_((double)px);
            int hitZ = Mth.m_14107_((double)pz);
            BlockPos pos = new BlockPos(hitX, hitY + height, hitZ);
            BlockState block = this.m_9236_().m_8055_(pos);
            int maxDepth = 30;
            for (int depthCount = 0; depthCount < maxDepth && block.m_60799_() != RenderShape.MODEL; ++depthCount) {
                pos = pos.m_7495_();
                block = this.m_9236_().m_8055_(pos);
            }
            if (block.m_60799_() != RenderShape.MODEL) {
                block = Blocks.f_50016_.m_49966_();
            }
            this.spawnBlocks(hitX, hitY + height, hitZ, (int)(this.m_20186_() - (double)height), block, px, pz, mxy, vx, vz, factor, shieldbreakticks, damage);
        }
    }

    private boolean notLavaCliff(double distance) {
        double theta = (double)this.f_20883_ * (Math.PI / 180);
        double vecX = Math.cos(theta += 1.5707963267948966);
        double vecZ = Math.sin(theta);
        double px = this.m_20185_() + vecX * distance;
        double pz = this.m_20189_() + vecZ * distance;
        double checkHeight = -2.5;
        Vec3 forwardPosition = new Vec3(px, this.m_20186_() + checkHeight, pz);
        BlockState blockStateBelow = this.m_9236_().m_8055_(BlockPos.m_274446_((Position)forwardPosition));
        return !blockStateBelow.m_60795_();
    }

    private void spawnBlocks(int hitX, int hitY, int hitZ, int lowestYCheck, BlockState blockState, double px, double pz, float mxy, double vx, double vz, float factor, int shieldbreakticks, float damage) {
        BlockPos blockpos = new BlockPos(hitX, hitY, hitZ);
        BlockState block = this.m_9236_().m_8055_(blockpos);
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1 = blockpos.m_7495_();
            BlockState blockstate = this.m_9236_().m_8055_(blockpos1);
            if (!blockstate.m_60783_((BlockGetter)this.m_9236_(), blockpos1, Direction.UP)) continue;
            if (this.m_9236_().m_46859_(blockpos) || (voxelshape = (blockstate1 = this.m_9236_().m_8055_(blockpos)).m_60812_((BlockGetter)this.m_9236_(), blockpos)).m_83281_()) break;
            d0 = voxelshape.m_83297_(Direction.Axis.Y);
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14143_((float)lowestYCheck) - 1);
        Cm_Falling_Block_Entity fallingBlockEntity = new Cm_Falling_Block_Entity(this.m_9236_(), (double)hitX + 0.5, (double)blockpos.m_123342_() + d0 + 0.5, (double)hitZ + 0.5, blockState, 10);
        double b0 = (double)hitX - this.m_20185_();
        double b1 = (double)hitZ - this.m_20189_();
        double b2 = Math.max(b0 * b0 + b1 * b1, 0.001);
        fallingBlockEntity.m_5997_(b0 / b2 * 1.5, 0.2 + this.m_217043_().m_188583_() * 0.04, b1 / b2 * 1.5);
        this.m_9236_().m_7967_((Entity)fallingBlockEntity);
        AABB selection = new AABB(px - 0.5, (double)blockpos.m_123342_() + d0 - 1.0, pz - 0.5, px + 0.5, (double)blockpos.m_123342_() + d0 + (double)mxy, pz + 0.5);
        List hit = this.m_9236_().m_45976_(LivingEntity.class, selection);
        for (LivingEntity entity : hit) {
            if (MobUtil.areAllies((Entity)this, (Entity)entity)) continue;
            boolean flag = entity.m_6469_(this.getServantAttack(), (float)(this.m_21133_(Attributes.f_22281_) * (double)damage));
            if (entity.m_21275_(this.getServantAttack()) && shieldbreakticks > 0) {
                this.disableShield(entity, shieldbreakticks);
            }
            if (!flag) continue;
            double magnitude = 10.0;
            double x = vx * Math.max((double)factor, 0.2) * magnitude;
            double y = 0.0;
            if (entity.m_20096_()) {
                y += 0.15;
            }
            double z = vz * Math.max((double)factor, 0.2) * magnitude;
            entity.m_20256_(entity.m_20184_().m_82520_(x, y, z));
        }
    }

    private void doAbsorptionEffects(int x, int y, int z) {
        int MthX = Mth.m_14107_((double)this.m_20185_());
        int MthY = Mth.m_14107_((double)this.m_20186_());
        int MthZ = Mth.m_14107_((double)this.m_20189_());
        for (int k2 = -x; k2 <= x; ++k2) {
            for (int l2 = -z; l2 <= z; ++l2) {
                for (int j = -y; j <= y; ++j) {
                    int i3 = MthX + k2;
                    int k = MthY + j;
                    int l = MthZ + l2;
                    BlockPos blockpos = new BlockPos(i3, k, l);
                    this.doAbsorptionEffect(blockpos);
                }
            }
        }
    }

    private void doAbsorptionEffect(BlockPos pos) {
        BlockState state = this.m_9236_().m_8055_(pos);
        if (!this.m_9236_().f_46443_ && state.m_60713_(Blocks.f_49991_)) {
            this.m_9236_().m_46597_(pos, Blocks.f_50016_.m_49966_());
        }
    }

    private void EarthQuake(double area) {
        this.m_5496_(SoundEvents.f_11913_, 1.5f, 1.0f + this.m_217043_().m_188501_() * 0.1f);
        for (LivingEntity entity : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_(area))) {
            if (MobUtil.areAllies((Entity)this, (Entity)entity)) continue;
            boolean flag = entity.m_6469_(this.getServantAttack(), (float)((double)((float)this.m_21133_(Attributes.f_22281_)) + Math.min(this.m_21133_(Attributes.f_22281_), (double)entity.m_21233_() * CMConfig.MonstrositysHpdamage)));
            if (entity.m_21275_(this.getServantAttack())) {
                this.disableShield(entity, 120);
            }
            if (!flag) continue;
            this.launch((Entity)entity, 2.0, 0.6);
            if (!this.isInBerserk()) continue;
            entity.m_20254_(6);
        }
    }

    private void OverPowerKnockBack(double area) {
        for (LivingEntity entity : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_(area))) {
            if (MobUtil.areAllies((Entity)this, (Entity)entity)) continue;
            this.launch((Entity)entity, 3.0, 0.35);
        }
    }

    private void MakeParticle(float vec, float math) {
        if (this.m_9236_().f_46443_) {
            float f = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180)));
            float f1 = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180)));
            double theta = (double)this.f_20883_ * (Math.PI / 180);
            double vecX = Math.cos(theta += 1.5707963267948966);
            double vecZ = Math.sin(theta);
            for (int i1 = 0; i1 < 80 + this.f_19796_.m_188503_(12); ++i1) {
                double DeltaMovementX = this.m_217043_().m_188583_() * 0.07;
                double DeltaMovementY = this.m_217043_().m_188583_() * 0.07;
                double DeltaMovementZ = this.m_217043_().m_188583_() * 0.07;
                float angle = (float)Math.PI / 180 * this.f_20883_ + (float)i1;
                double extraX = 2.0f * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
                double extraY = 0.3f;
                double extraZ = 2.0f * Mth.m_14089_((float)angle);
                int hitX = Mth.m_14107_((double)(this.m_20185_() + (double)vec * vecX + extraX));
                int hitY = Mth.m_14107_((double)this.m_20186_());
                int hitZ = Mth.m_14107_((double)(this.m_20189_() + (double)vec * vecZ + extraZ));
                BlockPos hit = new BlockPos(hitX, hitY, hitZ);
                BlockState block = this.m_9236_().m_8055_(hit.m_7495_());
                if (this.isInBerserk()) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_() + (double)vec * vecX + extraX + (double)(f * math), this.m_20186_() + extraY, this.m_20189_() + (double)vec * vecZ + extraZ + (double)(f1 * math), DeltaMovementX, DeltaMovementY, DeltaMovementZ);
                    continue;
                }
                if (block.m_60799_() == RenderShape.INVISIBLE) continue;
                this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, block), this.m_20185_() + (double)vec * vecX + extraX + (double)(f * math), this.m_20186_() + extraY, this.m_20189_() + (double)vec * vecZ + extraZ + (double)(f1 * math), DeltaMovementX, DeltaMovementY, DeltaMovementZ);
            }
            if (this.isInBerserk()) {
                this.m_9236_().m_7106_((ParticleOptions)new RingParticle.RingData(0.0f, 1.5707964f, 35, 0.8f, 0.305f, 0.02f, 1.0f, 30.0f, false, RingParticle.EnumRingBehavior.GROW), this.m_20185_() + (double)vec * vecX + (double)(f * math), this.m_20186_() + (double)0.2f, this.m_20189_() + (double)vec * vecZ + (double)(f1 * math), 0.0, 0.0, 0.0);
            } else {
                this.m_9236_().m_7106_((ParticleOptions)new RingParticle.RingData(0.0f, 1.5707964f, 35, 1.0f, 1.0f, 1.0f, 1.0f, 30.0f, false, RingParticle.EnumRingBehavior.GROW), this.m_20185_() + (double)vec * vecX + (double)(f * math), this.m_20186_() + (double)0.2f, this.m_20189_() + (double)vec * vecZ + (double)(f1 * math), 0.0, 0.0, 0.0);
            }
        }
    }

    private void Roarparticle(float vec, float y, int duration, int r, int g, int b, float a, float start, float inc, float end) {
        if (this.m_9236_().f_46443_) {
            double theta = (double)this.f_20883_ * (Math.PI / 180);
            double vecX = Math.cos(theta += 1.5707963267948966);
            double vecZ = Math.sin(theta);
            this.m_9236_().m_7106_((ParticleOptions)new RoarParticle.RoarData(duration, r, g, b, a, start, inc, end), this.m_20185_() + (double)vec * vecX, this.m_20186_() + (double)y, this.m_20189_() + (double)vec * vecZ, 0.0, 0.0, 0.0);
        }
    }

    private void launch(Entity e, double XZpower, double Ypower) {
        double d0 = e.m_20185_() - this.m_20185_();
        double d1 = e.m_20189_() - this.m_20189_();
        double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
        e.m_5997_(d0 / d2 * XZpower, Ypower, d1 / d2 * XZpower);
    }

    private void ChargeBlockBreaking() {
        boolean flag = false;
        AABB aabb = this.m_20191_().m_82377_(0.5, 0.2, 0.5);
        for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)this.m_20186_()), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
            BlockState blockstate = this.m_9236_().m_8055_(blockpos);
            if (blockstate.m_60795_() || !blockstate.canEntityDestroy((BlockGetter)this.m_9236_(), blockpos, (Entity)this) || blockstate.m_204336_(ModTag.NETHERITE_MONSTROSITY_IMMUNE) || !ForgeEventFactory.onEntityDestroyBlock((LivingEntity)this, (BlockPos)blockpos, (BlockState)blockstate)) continue;
            if (this.f_19796_.m_188503_(6) == 0 && !blockstate.m_155947_()) {
                Cm_Falling_Block_Entity fallingBlockEntity = new Cm_Falling_Block_Entity(this.m_9236_(), (double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_() + 0.5, (double)blockpos.m_123343_() + 0.5, blockstate, 20);
                flag = this.m_9236_().m_46953_(blockpos, false, (Entity)this) || flag;
                fallingBlockEntity.m_20256_(fallingBlockEntity.m_20184_().m_82549_(this.m_20182_().m_82546_(fallingBlockEntity.m_20182_()).m_82542_((-1.2 + this.f_19796_.m_188500_()) / 3.0, 0.2 + this.m_217043_().m_188583_() * 0.15, (-1.2 + this.f_19796_.m_188500_()) / 3.0)));
                this.m_9236_().m_7967_((Entity)fallingBlockEntity);
                continue;
            }
            flag = this.m_9236_().m_46953_(blockpos, false, (Entity)this) || flag;
        }
    }

    private void berserkBlockBreaking(int x, int y, int z) {
        int MthX = Mth.m_14107_((double)this.m_20185_());
        int MthY = Mth.m_14107_((double)this.m_20186_());
        int MthZ = Mth.m_14107_((double)this.m_20189_());
        if (!this.m_9236_().f_46443_ && ((Boolean)GCMobsConfig.NetheriteMonstrosityGriefing.get()).booleanValue() && ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this)) {
            for (int k2 = -x; k2 <= x; ++k2) {
                for (int l2 = -z; l2 <= z; ++l2) {
                    for (int j = 0; j <= y; ++j) {
                        int i3 = MthX + k2;
                        int k = MthY + j;
                        int l = MthZ + l2;
                        BlockPos blockpos = new BlockPos(i3, k, l);
                        BlockState block = this.m_9236_().m_8055_(blockpos);
                        BlockEntity tileEntity = this.m_9236_().m_7702_(blockpos);
                        if (block.m_60795_() || block.m_204336_(ModTag.NETHERITE_MONSTROSITY_IMMUNE)) continue;
                        if (tileEntity == null && this.f_19796_.m_188503_(4) + 1 == 4) {
                            this.m_9236_().m_7471_(blockpos, true);
                            Cm_Falling_Block_Entity fallingBlockEntity = new Cm_Falling_Block_Entity(this.m_9236_(), (double)i3 + 0.5, (double)k + 0.5, (double)l + 0.5, block, 5);
                            this.m_9236_().m_7731_(blockpos, block.m_60819_().m_76188_(), 3);
                            fallingBlockEntity.m_20256_(fallingBlockEntity.m_20184_().m_82549_(this.m_20182_().m_82546_(fallingBlockEntity.m_20182_()).m_82542_((-1.2 + this.f_19796_.m_188500_()) / 3.0, (-1.1 + this.f_19796_.m_188500_()) / 3.0, (-1.2 + this.f_19796_.m_188500_()) / 3.0)));
                            this.m_9236_().m_7967_((Entity)fallingBlockEntity);
                            continue;
                        }
                        this.m_9236_().m_46961_(new BlockPos(i3, k, l), this.shouldDropItem(tileEntity));
                    }
                }
            }
        }
    }

    private void BlockBreaking() {
        if (!this.m_21525_() && !this.m_9236_().f_46443_ && this.blockBreakCounter == 0 && ((Boolean)GCMobsConfig.NetheriteMonstrosityGriefing.get()).booleanValue() && ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this)) {
            for (int a = (int)Math.round(this.m_20191_().f_82288_); a <= (int)Math.round(this.m_20191_().f_82291_); ++a) {
                for (int b = (int)Math.round(this.m_20191_().f_82289_); b <= (int)Math.round(this.m_20191_().f_82292_) + 1 && b <= 127; ++b) {
                    for (int c = (int)Math.round(this.m_20191_().f_82290_); c <= (int)Math.round(this.m_20191_().f_82293_); ++c) {
                        boolean flag;
                        BlockPos blockpos = new BlockPos(a, b, c);
                        BlockState block = this.m_9236_().m_8055_(blockpos);
                        BlockEntity tileEntity = this.m_9236_().m_7702_(blockpos);
                        if (block.m_60795_() || block.m_204336_(ModTag.NETHERITE_MONSTROSITY_IMMUNE) || !(flag = this.m_9236_().m_46961_(new BlockPos(a, b, c), this.shouldDropItem(tileEntity)))) continue;
                        this.blockBreakCounter = 10;
                    }
                }
            }
        }
    }

    private Vec3 rotateOffsetVec(Vec3 offset, float xRot, float yRot) {
        return offset.m_82496_(-xRot * ((float)Math.PI / 180)).m_82524_(-yRot * ((float)Math.PI / 180));
    }

    private boolean shouldDropItem(BlockEntity tileEntity) {
        if (tileEntity == null) {
            return this.f_19796_.m_188503_(3) + 1 == 3;
        }
        return true;
    }

    public boolean shouldGoBerserk() {
        return this.m_21223_() <= this.m_21233_() * 0.4f;
    }

    public boolean m_6063_() {
        return false;
    }

    public ItemEntity m_19983_(ItemStack stack) {
        ItemEntity itementity = this.m_5552_(stack, 0.0f);
        if (itementity != null) {
            itementity.m_20256_(itementity.m_20184_().m_82542_(0.0, 3.5, 0.0));
            itementity.m_146915_(true);
            itementity.m_32064_();
        }
        return itementity;
    }

    private void setPartPosition(NMPart part, double offsetX, double offsetY, double offsetZ) {
        part.m_6034_(this.m_20185_() + offsetX * (double)part.scale, this.m_20186_() + offsetY * (double)part.scale, this.m_20189_() + offsetZ * (double)part.scale);
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public PartEntity<?>[] getParts() {
        return this.monstrosityParts;
    }

    public void m_141965_(ClientboundAddEntityPacket packet) {
        super.m_141965_(packet);
        Cm_Part_Entity.assignPartIDs((Entity)this);
    }

    public void setAutonomous(boolean autonomous) {
        this.f_19804_.m_135381_(AUTO_MODE, (Object)autonomous);
        if (autonomous) {
            this.m_216990_(SoundEvents.f_11686_);
            if (!this.isWandering()) {
                this.setWandering(true);
                this.setStaying(false);
            }
        }
    }

    public boolean isAutonomous() {
        return (Boolean)this.f_19804_.m_135370_(AUTO_MODE);
    }

    @Nullable
    public LivingEntity m_6688_() {
        if (!this.m_21525_()) {
            Entity entity = this.m_146895_();
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                return mob;
            }
            if (entity instanceof LivingEntity && !this.isAutonomous()) {
                return (LivingEntity)entity;
            }
        }
        return null;
    }

    public boolean m_6109_() {
        return this.m_21515_();
    }

    public double m_6048_() {
        float f = Math.min(0.25f, this.f_267362_.m_267731_());
        float f1 = this.f_267362_.m_267756_();
        return (double)this.m_20206_() - 0.3 + (double)(0.12f * Mth.m_14089_((float)(f1 * 0.7f)) * 0.7f * f);
    }

    protected void doPlayerRide(Player player) {
        if (!this.m_9236_().f_46443_) {
            player.m_146922_(this.m_146908_());
            player.m_146926_(this.m_146909_());
            player.m_20329_((Entity)this);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void m_7023_(Vec3 pTravelVector) {
        if (!this.m_6084_()) return;
        LivingEntity rider = this.m_6688_();
        FluidState below = this.m_9236_().m_8055_(this.m_20099_()).m_60819_();
        if (this.m_20160_() && rider instanceof Player) {
            Player player = (Player)rider;
            if (!this.clientStopMoving() && !this.isAutonomous()) {
                this.m_146922_(rider.m_146908_());
                this.f_19859_ = this.m_146908_();
                this.m_146926_(rider.m_146909_() * 0.5f);
                this.m_19915_(this.m_146908_(), this.m_146909_());
                this.f_20885_ = this.f_20883_ = this.m_146908_();
                float speed = this.m_245547_(player);
                float f = rider.f_20900_ * speed;
                float f1 = rider.f_20902_ * speed;
                if (f1 <= 0.0f) {
                    f1 *= 0.25f;
                }
                Vec3 vec3 = new Vec3((double)f, pTravelVector.f_82480_, (double)f1);
                this.m_7910_((float)this.m_21133_(Attributes.f_22279_) * (this.m_20077_() || below.m_205070_(FluidTags.f_13132_) ? 0.2f : 1.0f));
                if (this.m_20077_() || below.m_205070_(FluidTags.f_13132_)) {
                    this.m_19920_(this.m_6113_(), vec3);
                    this.m_6478_(MoverType.SELF, this.m_20184_());
                    this.m_20256_(this.m_20184_().m_82490_(0.9));
                } else {
                    super.m_7023_(vec3);
                }
                this.f_20903_ = 0;
                this.m_267651_(false);
                return;
            }
        }
        this.m_7910_((float)this.m_21133_(Attributes.f_22279_) * (this.m_20077_() || below.m_205070_(FluidTags.f_13132_) ? 0.2f : 1.0f));
        if (this.m_20077_()) {
            this.m_19920_(this.m_6113_(), pTravelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            return;
        }
        super.m_7023_(pTravelVector);
    }

    public boolean clientStopMoving() {
        if (this.m_9236_().f_46443_) {
            return this.clientStop;
        }
        return this.getAttackState() != 0;
    }

    @Override
    public void m_7822_(byte p_21375_) {
        if (p_21375_ == 6) {
            this.clientStop = true;
        } else if (p_21375_ == 7) {
            this.clientStop = false;
        } else {
            super.m_7822_(p_21375_);
        }
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)CataclysmSounds.MONSTROSITYHURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)CataclysmSounds.MONSTROSITYDEATH.get();
    }

    protected BodyRotationControl m_7560_() {
        return new SmartBodyHelper2((Mob)this);
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new CMPathNavigateGround((Mob)this, worldIn);
    }

    public void tryKill(Player player) {
        if (this.killChance <= 0) {
            this.warnKill(player);
        } else {
            super.tryKill(player);
        }
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        if (!this.m_9236_().f_46443_) {
            ItemStack itemstack = pPlayer.m_21120_(pHand);
            if (this.getTrueOwner() != null && pPlayer == this.getTrueOwner()) {
                if ((itemstack.m_150930_(Items.f_42448_) || itemstack.m_204117_(Tags.Items.STORAGE_BLOCKS_NETHERITE) || itemstack.m_150930_(((Block)GoetyBlocks.REINFORCED_REDSTONE_BLOCK.get()).m_5456_()) || itemstack.m_150930_((Item)CataclysmItems.LAVA_POWER_CELL.get())) && this.m_21223_() < this.m_21233_()) {
                    if (!pPlayer.m_150110_().f_35937_) {
                        if (itemstack.m_150930_(Items.f_42448_)) {
                            this.m_5496_(SoundEvents.f_11780_, 1.0f, 1.0f);
                            ItemHelper.addAndConsumeItem((Player)pPlayer, (InteractionHand)pHand, (ItemStack)new ItemStack((ItemLike)Items.f_42446_));
                        } else {
                            itemstack.m_41774_(1);
                        }
                    }
                    if (itemstack.m_150930_(((Block)GoetyBlocks.REINFORCED_REDSTONE_BLOCK.get()).m_5456_()) || itemstack.m_204117_(Tags.Items.STORAGE_BLOCKS_NETHERITE)) {
                        this.m_5634_(this.m_21233_() / 4.0f);
                        this.m_5496_(SoundEvents.f_12009_, 1.0f, 1.25f);
                    } else if (itemstack.m_150930_(Items.f_42448_) || itemstack.m_150930_((Item)CataclysmItems.LAVA_POWER_CELL.get())) {
                        this.m_5634_(this.m_21233_() / 4.0f / 8.0f);
                        this.m_5496_(SoundEvents.f_12009_, 0.25f, 0.75f);
                    }
                    Level level = this.m_9236_();
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        for (int i = 0; i < 7; ++i) {
                            double d0 = serverLevel.f_46441_.m_188583_() * 0.02;
                            double d1 = serverLevel.f_46441_.m_188583_() * 0.02;
                            double d2 = serverLevel.f_46441_.m_188583_() * 0.02;
                            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.HEAL_EFFECT.get()), this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), 0, d0, d1, d2, 0.5);
                        }
                    }
                    return InteractionResult.SUCCESS;
                }
                if (this.m_146895_() != null && this.m_146895_() != pPlayer) {
                    this.m_146895_().m_8127_();
                    return InteractionResult.SUCCESS;
                }
                if (!(pPlayer.m_21120_(pHand).m_41720_() instanceof IWand)) {
                    this.doPlayerRide(pPlayer);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.PASS;
    }

    static class MonstrosityPhaseChangeGoal
    extends Goal {
        protected final NetheriteMonstrosityServant entity;
        private final int getAttackState;
        private final int attackState;
        private final int attackEndState;
        private final int attackMaxTick;

        public MonstrosityPhaseChangeGoal(NetheriteMonstrosityServant entity, int getAttackState, int attackState, int attackEndState, int attackMaxTick) {
            this.entity = entity;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
            this.getAttackState = getAttackState;
            this.attackState = attackState;
            this.attackEndState = attackEndState;
            this.attackMaxTick = attackMaxTick;
        }

        public boolean m_8036_() {
            return !this.entity.isInBerserk() && this.entity.getAttackState() == this.getAttackState && this.entity.shouldGoBerserk();
        }

        public boolean m_8045_() {
            return this.attackMaxTick > 0 ? this.entity.attackTicks <= this.attackMaxTick : this.m_8036_();
        }

        public void m_8056_() {
            this.entity.setIsInBerserk(true);
            if (this.getAttackState != this.attackState) {
                this.entity.setAttackState(this.attackState);
            }
        }

        public void m_8041_() {
            this.entity.setAttackState(this.attackEndState);
        }
    }

    static class MagmaShoot
    extends InternalSummonAttackGoal {
        private final NetheriteMonstrosityServant entity;
        private final int attackshot;
        private final float random;

        public MagmaShoot(NetheriteMonstrosityServant entity, int getAttackState, int attackstate, int attackendstate, int attackMaxtick, int attackseetick, float attackrange, int attackshot, float random) {
            super(entity, getAttackState, attackstate, attackendstate, attackMaxtick, attackseetick, attackrange);
            this.entity = entity;
            this.attackshot = attackshot;
            this.random = random;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        @Override
        public boolean m_8036_() {
            LivingEntity target = this.entity.m_5448_();
            return super.m_8036_() && target != null && this.entity.m_20270_((Entity)target) >= 14.0f && this.entity.m_217043_().m_188501_() * 100.0f < this.random && this.entity.m_21574_().m_148306_((Entity)target) && this.entity.getMagazine() < CMConfig.Lavabombmagazine && this.entity.shoot_cooldown <= 0;
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
        }

        @Override
        public void m_8041_() {
            super.m_8041_();
            this.entity.shoot_cooldown = 240;
            this.entity.setMagazine(this.entity.getMagazine() + 1);
        }

        @Override
        public void m_8037_() {
            LivingEntity target = this.entity.m_5448_();
            super.m_8037_();
            int shots = CMConfig.Lavabombamount;
            if (target != null && this.entity.attackTicks == this.attackshot) {
                for (int i = 0; i < shots; ++i) {
                    Pyroclast lava = new Pyroclast((LivingEntity)this.entity, this.entity.m_9236_());
                    lava.setExplosionPower((float)CMConfig.Lavabombradius);
                    double d0 = target.m_20185_() - this.entity.headPart.m_20185_();
                    double d1 = target.m_20191_().f_82289_ + (double)(target.m_20206_() / 3.0f) - lava.m_20186_();
                    double d2 = target.m_20189_() - this.entity.headPart.m_20189_();
                    double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
                    lava.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.0f, (float)(24 - this.entity.m_9236_().m_46791_().m_19028_() * 4));
                    this.entity.m_9236_().m_7967_((Entity)lava);
                }
            }
        }

        @Override
        public boolean m_183429_() {
            return true;
        }
    }

    static class FlareShoot
    extends InternalSummonAttackGoal {
        private final NetheriteMonstrosityServant entity;
        private final int attackshot;
        private final float random;

        public FlareShoot(NetheriteMonstrosityServant entity, int getAttackState, int attackstate, int attackendstate, int attackMaxtick, int attackseetick, float attackrange, int attackshot, float random) {
            super(entity, getAttackState, attackstate, attackendstate, attackMaxtick, attackseetick, attackrange);
            this.entity = entity;
            this.attackshot = attackshot;
            this.random = random;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        @Override
        public boolean m_8036_() {
            LivingEntity target = this.entity.m_5448_();
            return super.m_8036_() && target != null && this.entity.m_20270_((Entity)target) >= 10.0f && this.entity.m_217043_().m_188501_() * 100.0f < this.random && this.entity.m_21574_().m_148306_((Entity)target) && this.entity.flare_shoot_cooldown <= 0;
        }

        @Override
        public void m_8041_() {
            super.m_8041_();
            this.entity.flare_shoot_cooldown = 120;
        }

        @Override
        public void m_8037_() {
            LivingEntity target = this.entity.m_5448_();
            super.m_8037_();
            int shots = 5;
            if (target != null && this.entity.attackTicks == this.attackshot) {
                for (int i = 0; i < shots; ++i) {
                    float f = Mth.m_14089_((float)(this.entity.f_20883_ * ((float)Math.PI / 180)));
                    float f1 = Mth.m_14031_((float)(this.entity.f_20883_ * ((float)Math.PI / 180)));
                    double theta = (double)this.entity.f_20883_ * (Math.PI / 180);
                    double vecX = Math.cos(theta += 1.5707963267948966);
                    double vecZ = Math.sin(theta);
                    double vec = 2.2;
                    double math = 3.4;
                    FlareBomb lava = new FlareBomb((EntityType<? extends FlareBomb>)((EntityType)GCEntityType.FLARE_BOMB.get()), this.entity.m_9236_(), (LivingEntity)this.entity);
                    lava.m_20343_(this.entity.m_20185_() + vec * vecX + (double)f * math, this.entity.m_20227_(0.65), this.entity.m_20189_() + vec * vecZ + (double)f1 * math);
                    double d0 = target.m_20185_() - lava.m_20185_();
                    double d1 = target.m_20191_().f_82289_ + (double)(target.m_20206_() / 3.0f) - lava.m_20186_();
                    double d2 = target.m_20189_() - lava.m_20189_();
                    double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
                    lava.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.0f, 1 + i * 8);
                    this.entity.m_9236_().m_7967_((Entity)lava);
                }
            }
        }

        @Override
        public boolean m_183429_() {
            return true;
        }
    }

    static class ShoulderCheck
    extends InternalSummonAttackGoal {
        private final NetheriteMonstrosityServant entity;
        private final int attackShot;
        private final int attackEndShot;
        private final float random;

        public ShoulderCheck(NetheriteMonstrosityServant entity, int getAttackState, int attackState, int attackEndState, int attackMaxTick, int attackSeeTick, float attackRange, int attackShot, int attackEndShot, float random) {
            super(entity, getAttackState, attackState, attackEndState, attackMaxTick, attackSeeTick, attackRange);
            this.entity = entity;
            this.attackShot = attackShot;
            this.attackEndShot = attackEndShot;
            this.random = random;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        @Override
        public boolean m_8036_() {
            LivingEntity target = this.entity.m_5448_();
            return super.m_8036_() && !this.entity.isStaying() && target != null && this.entity.m_20270_((Entity)target) >= 5.75f && this.entity.m_217043_().m_188501_() * 100.0f < this.random && this.entity.m_21574_().m_148306_((Entity)target) && this.entity.check_cooldown <= 0;
        }

        @Override
        public void m_8041_() {
            super.m_8041_();
            this.entity.check_cooldown = 80;
        }

        @Override
        public void m_8037_() {
            super.m_8037_();
            if (this.entity.attackTicks > this.attackShot && this.entity.attackTicks < this.attackEndShot && (this.entity.m_20096_() || this.entity.getOnLava()) && this.entity.notLavaCliff(2.0)) {
                Vec3 vector3d = this.entity.m_20184_();
                float f = this.entity.m_146908_() * ((float)Math.PI / 180);
                Vec3 vector3d1 = new Vec3((double)(-Mth.m_14031_((float)f)), this.entity.m_20184_().f_82480_, (double)Mth.m_14089_((float)f)).m_82490_(0.5).m_82549_(vector3d.m_82490_(0.5));
                this.entity.m_20334_(vector3d1.f_82479_, this.entity.m_20184_().f_82480_, vector3d1.f_82481_);
            }
        }

        @Override
        public boolean m_183429_() {
            return true;
        }
    }
}

