/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.goety_cataclysm.common.entities.ally.undead;

import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.goety_cataclysm.common.entities.ally.AnimationSummon;
import com.Polarice3.goety_cataclysm.common.entities.ally.LLibraryBossSummon;
import com.Polarice3.goety_cataclysm.common.entities.ally.ai.SimpleSummonAnimationGoal;
import com.Polarice3.goety_cataclysm.config.GCAttributesConfig;
import com.Polarice3.goety_cataclysm.init.CataclysmSounds;
import com.github.L_Ender.cataclysm.client.particle.RingParticle;
import com.github.L_Ender.cataclysm.config.CMConfig;
import com.github.L_Ender.cataclysm.entity.effect.ScreenShake_Entity;
import com.github.L_Ender.cataclysm.entity.etc.CMEntityMoveHelper;
import com.github.L_Ender.cataclysm.entity.etc.SmartBodyHelper2;
import com.github.L_Ender.cataclysm.entity.etc.path.CMPathNavigateGround;
import com.github.L_Ender.cataclysm.entity.projectile.Amethyst_Cluster_Projectile_Entity;
import com.github.L_Ender.cataclysm.entity.projectile.EarthQuake_Entity;
import com.github.L_Ender.cataclysm.init.ModEntities;
import com.github.L_Ender.cataclysm.init.ModSounds;
import com.github.L_Ender.lionfishapi.server.animation.Animation;
import com.github.L_Ender.lionfishapi.server.animation.IAnimatedEntity;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ZombieAmethystCrab
extends LLibraryBossSummon {
    public static final Animation CRAB_SMASH = Animation.create((int)53);
    public static final Animation CRAB_SMASH_THREE = Animation.create((int)77);
    public static final Animation CRAB_DEATH = Animation.create((int)114);
    public static final Animation CRAB_BURROW = Animation.create((int)65);
    public static final Animation CRAB_BITE = Animation.create((int)48);
    public static final int BURROW_ATTACK_COOLDOWN = 240;
    private int burrow_cooldown = 0;

    public ZombieAmethystCrab(EntityType<? extends AnimationSummon> entity, Level world) {
        super(entity, world);
        this.m_274367_(1.5f);
        this.f_21342_ = new CMEntityMoveHelper((Mob)this, 45.0f);
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, CRAB_SMASH, CRAB_SMASH_THREE, CRAB_DEATH, CRAB_BURROW, CRAB_BITE};
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new CrabMoveGoal(this, false, 1.0));
        this.f_21345_.m_25352_(0, (Goal)new CrabSmashGoal(this, CRAB_SMASH));
        this.f_21345_.m_25352_(0, (Goal)new CrabAttack(this, CRAB_SMASH_THREE, 10));
        this.f_21345_.m_25352_(0, (Goal)new CrabBurrow(this, CRAB_BURROW));
        this.f_21345_.m_25352_(0, (Goal)new CrabAttack(this, CRAB_BITE, 17));
        this.f_21345_.m_25352_(6, (Goal)new Summoned.WanderGoal((PathfinderMob)this, 1.0, 80.0f));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22279_, 0.23).m_22268_(Attributes.f_22281_, ((Double)GCAttributesConfig.ZombieAmethystCrabDamage.get()).doubleValue()).m_22268_(Attributes.f_22276_, ((Double)GCAttributesConfig.ZombieAmethystCrabHealth.get()).doubleValue()).m_22268_(Attributes.f_22284_, ((Double)GCAttributesConfig.ZombieAmethystCrabArmor.get()).doubleValue()).m_22268_(Attributes.f_22278_, 1.0);
    }

    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes((AttributeInstance)this.m_21051_(Attributes.f_22276_), (double)((Double)GCAttributesConfig.ZombieAmethystCrabHealth.get()));
        MobUtil.setBaseAttributes((AttributeInstance)this.m_21051_(Attributes.f_22284_), (double)((Double)GCAttributesConfig.ZombieAmethystCrabArmor.get()));
        MobUtil.setBaseAttributes((AttributeInstance)this.m_21051_(Attributes.f_22281_), (double)((Double)GCAttributesConfig.ZombieAmethystCrabDamage.get()));
    }

    public int xpReward() {
        return 50;
    }

    protected int m_7302_(int air) {
        return air;
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public boolean m_142535_(float p_148711_, float p_148712_, DamageSource p_148713_) {
        return false;
    }

    public boolean isKrusty() {
        String s = ChatFormatting.m_126649_((String)this.m_7755_().getString());
        return s != null && (s.toLowerCase().contains("eugene harold krabs") || s.toLowerCase().contains("mr.krabs"));
    }

    @Override
    public boolean m_6469_(DamageSource source, float damage) {
        if (this.getAnimation() == CRAB_BURROW && this.getAnimationTick() > 9 && this.getAnimationTick() < 52 && !source.m_269533_(DamageTypeTags.f_268738_)) {
            this.m_5496_(SoundEvents.f_11668_, 0.4f, 2.0f);
            return false;
        }
        return super.m_6469_(source, damage);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.repelEntities(1.7f, 3.7f, 1.7f, 1.7f);
        if (this.burrow_cooldown > 0) {
            --this.burrow_cooldown;
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.getAnimation() == CRAB_SMASH && this.getAnimationTick() == 22) {
            this.AreaAttack(4.0f, 4.0f, 70.0f, 1.25f, 120);
            this.m_5496_(SoundEvents.f_11913_, 1.0f, 1.0f + this.m_217043_().m_188501_() * 0.1f);
            this.Attackparticle(2.4f, -0.4f);
            ScreenShake_Entity.ScreenShake((Level)this.m_9236_(), (Vec3)this.m_20182_(), (float)15.0f, (float)0.1f, (int)0, (int)20);
        }
        if (this.getAnimation() == CRAB_SMASH_THREE) {
            if (this.getAnimationTick() == 16) {
                this.Attackparticle(2.2f, -0.2f);
                this.EarthQuakeSummon(2.2f, -0.2f);
                this.m_5496_(SoundEvents.f_11913_, 1.0f, 1.0f + this.m_217043_().m_188501_() * 0.1f);
                ScreenShake_Entity.ScreenShake((Level)this.m_9236_(), (Vec3)this.m_20182_(), (float)15.0f, (float)0.1f, (int)0, (int)20);
            }
            if (this.getAnimationTick() == 36) {
                this.Attackparticle(1.8f, -1.5f);
                this.EarthQuakeSummon(1.8f, -1.5f);
                this.m_5496_(SoundEvents.f_11913_, 1.0f, 1.0f + this.m_217043_().m_188501_() * 0.1f);
                ScreenShake_Entity.ScreenShake((Level)this.m_9236_(), (Vec3)this.m_20182_(), (float)15.0f, (float)0.1f, (int)0, (int)20);
            }
            if (this.getAnimationTick() == 56) {
                this.Attackparticle(1.7f, 1.3f);
                this.EarthQuakeSummon(1.7f, 1.3f);
                this.m_5496_(SoundEvents.f_11913_, 1.0f, 1.0f + this.m_217043_().m_188501_() * 0.1f);
                ScreenShake_Entity.ScreenShake((Level)this.m_9236_(), (Vec3)this.m_20182_(), (float)15.0f, (float)0.1f, (int)0, (int)20);
            }
        }
        if (this.getAnimation() == CRAB_BURROW) {
            int l;
            for (l = 1; l <= 10; l += 3) {
                if (this.getAnimationTick() != l) continue;
                this.BurrowSound();
                this.BurrowParticle(0.6f, 0.0f, 2.0f);
            }
            for (l = 39; l <= 48; l += 3) {
                if (this.getAnimationTick() != l) continue;
                this.BurrowParticle(0.6f, 0.0f, 2.0f);
                this.BurrowSound();
            }
        }
        if (this.getAnimation() == CRAB_BITE) {
            if (this.getAnimationTick() == 14) {
                this.m_5496_((SoundEvent)ModSounds.CRAB_BITE.get(), 1.0f, 1.0f + this.m_217043_().m_188501_() * 0.1f);
            }
            if (this.getAnimationTick() == 17) {
                this.AreaAttack(4.5f, 4.5f, 110.0f, 1.25f, 120);
            }
        }
    }

    private void AreaAttack(float range, float height, float arc, float damage, int shieldbreakticks) {
        List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby(range, height, range, range);
        if (!this.m_9236_().f_46443_) {
            for (LivingEntity entityHit : entitiesHit) {
                float entityHitAngle = (float)((Math.atan2(entityHit.m_20189_() - this.m_20189_(), entityHit.m_20185_() - this.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
                float entityAttackingAngle = this.f_20883_ % 360.0f;
                if (entityHitAngle < 0.0f) {
                    entityHitAngle += 360.0f;
                }
                if (entityAttackingAngle < 0.0f) {
                    entityAttackingAngle += 360.0f;
                }
                float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
                float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - this.m_20189_()) * (entityHit.m_20189_() - this.m_20189_()) + (entityHit.m_20185_() - this.m_20185_()) * (entityHit.m_20185_() - this.m_20185_()));
                if (!(entityHitDistance <= range && entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f) && !(entityRelativeAngle <= -360.0f + arc / 2.0f) || MobUtil.areAllies((Entity)this, (Entity)entityHit)) continue;
                entityHit.m_6469_(this.getServantAttack(), (float)this.m_21133_(Attributes.f_22281_) * damage);
                if (!entityHit.m_21275_(this.getServantAttack()) || !(entityHit instanceof Player)) continue;
                Player player = (Player)entityHit;
                if (shieldbreakticks <= 0) continue;
                this.disableShield((LivingEntity)player, shieldbreakticks);
            }
        }
    }

    private void Attackparticle(float vec, float math) {
        if (this.m_9236_().f_46443_) {
            float f = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180)));
            float f1 = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180)));
            double theta = (double)this.f_20883_ * (Math.PI / 180);
            double vecX = Math.cos(theta += 1.5707963267948966);
            double vecZ = Math.sin(theta);
            for (int i1 = 0; i1 < 80 + this.f_19796_.m_188503_(12); ++i1) {
                double DeltaMovementX = this.m_217043_().m_188583_() * 0.07;
                double DeltaMovementY = this.m_217043_().m_188583_() * 0.07;
                double DeltaMovementZ = this.m_217043_().m_188583_() * 0.07;
                float angle = (float)Math.PI / 180 * this.f_20883_ + (float)i1;
                double extraX = 1.0 * (double)Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
                double extraY = 0.3f;
                double extraZ = 1.0 * (double)Mth.m_14089_((float)angle);
                int hitX = Mth.m_14107_((double)(this.m_20185_() + (double)vec * vecX + extraX));
                int hitY = Mth.m_14107_((double)this.m_20186_());
                int hitZ = Mth.m_14107_((double)(this.m_20189_() + (double)vec * vecZ + extraZ));
                BlockPos hit = new BlockPos(hitX, hitY, hitZ);
                BlockState block = this.m_9236_().m_8055_(hit.m_7495_());
                if (block.m_60799_() == RenderShape.INVISIBLE) continue;
                this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, block), this.m_20185_() + (double)vec * vecX + extraX + (double)(f * math), this.m_20186_() + extraY, this.m_20189_() + (double)vec * vecZ + extraZ + (double)(f1 * math), DeltaMovementX, DeltaMovementY, DeltaMovementZ);
            }
            this.m_9236_().m_7106_((ParticleOptions)new RingParticle.RingData(0.0f, 1.5707964f, 25, 1.0f, 1.0f, 1.0f, 1.0f, 25.0f, false, RingParticle.EnumRingBehavior.GROW_THEN_SHRINK), this.m_20185_() + (double)vec * vecX + (double)(f * math), this.m_20186_() + (double)0.3f, this.m_20189_() + (double)vec * vecZ + (double)(f1 * math), 0.0, 0.0, 0.0);
        }
    }

    private void BurrowParticle(float vec, float math, float size) {
        if (this.m_9236_().f_46443_) {
            for (int i1 = 0; i1 < 80 + this.f_19796_.m_188503_(12); ++i1) {
                double DeltaMovementX = this.m_217043_().m_188583_() * 0.07;
                double DeltaMovementY = this.m_217043_().m_188583_() * 0.1;
                double DeltaMovementZ = this.m_217043_().m_188583_() * 0.07;
                float angle = (float)Math.PI / 180 * this.f_20883_ + (float)i1;
                float f = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180)));
                float f1 = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180)));
                double extraX = size * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
                double extraY = 0.3f;
                double extraZ = size * Mth.m_14089_((float)angle);
                double theta = (double)this.f_20883_ * (Math.PI / 180);
                double vecX = Math.cos(theta += 1.5707963267948966);
                double vecZ = Math.sin(theta);
                int hitX = Mth.m_14107_((double)(this.m_20185_() + (double)vec * vecX + extraX));
                int hitY = Mth.m_14107_((double)this.m_20186_());
                int hitZ = Mth.m_14107_((double)(this.m_20189_() + (double)vec * vecZ + extraZ));
                BlockPos hit = new BlockPos(hitX, hitY, hitZ);
                BlockState block = this.m_9236_().m_8055_(hit.m_7495_());
                if (block.m_60799_() == RenderShape.INVISIBLE) continue;
                this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, block), this.m_20185_() + (double)vec * vecX + extraX + (double)(f * math), this.m_20186_() + extraY, this.m_20189_() + (double)vec * vecZ + extraZ + (double)(f1 * math), DeltaMovementX, DeltaMovementY, DeltaMovementZ);
            }
        }
    }

    private void BurrowSound() {
        float angle = (float)Math.PI / 180 * this.f_20883_;
        double extraX = 1.0 * (double)Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double extraZ = 1.0 * (double)Mth.m_14089_((float)angle);
        int hitX = Mth.m_14107_((double)(this.m_20185_() + extraX));
        int hitY = Mth.m_14107_((double)this.m_20186_());
        int hitZ = Mth.m_14107_((double)(this.m_20189_() + extraZ));
        BlockPos hit = new BlockPos(hitX, hitY, hitZ);
        BlockState block = this.m_9236_().m_8055_(hit.m_7495_());
        SoundType soundtype = block.getSoundType((LevelReader)this.m_9236_(), hit, (Entity)this);
        this.m_9236_().m_6269_((Player)null, (Entity)this, soundtype.m_56775_(), this.m_5720_(), 3.0f, 0.8f + this.m_217043_().m_188501_() * 0.1f);
    }

    private void EarthQuakeSummon(float vec, float math) {
        float f = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        float f1 = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        double theta = (double)this.f_20883_ * (Math.PI / 180);
        double vecX = Math.cos(theta += 1.5707963267948966);
        double vecZ = Math.sin(theta);
        int quakeCount = 16;
        float angle = 22.5f;
        for (int i = 0; i < 16; ++i) {
            EarthQuake_Entity peq = new EarthQuake_Entity(this.m_9236_(), (LivingEntity)this);
            peq.setDamage((float)CMConfig.AmethystCrabEarthQuakeDamage);
            peq.m_37251_((Entity)this, 0.0f, angle * (float)i, 0.0f, 0.25f, 0.0f);
            peq.m_6034_(this.m_20185_() + (double)vec * vecX + (double)(f * math), this.m_20186_(), this.m_20189_() + (double)vec * vecZ + (double)(f1 * math));
            this.m_9236_().m_7967_((Entity)peq);
        }
    }

    @Override
    public boolean canBePushedByEntity(Entity entity) {
        return false;
    }

    @Override
    @Nullable
    public Animation getDeathAnimation() {
        return CRAB_DEATH;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)CataclysmSounds.CRAB_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)CataclysmSounds.CRAB_DEATH.get();
    }

    protected BodyRotationControl m_7560_() {
        return new SmartBodyHelper2((Mob)this);
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new CMPathNavigateGround((Mob)this, worldIn);
    }

    static class CrabMoveGoal
    extends Goal {
        private final ZombieAmethystCrab crab;
        private final boolean followingTargetEvenIfNotSeen;
        private Path path;
        private int delayCounter;
        protected final double moveSpeed;

        public CrabMoveGoal(ZombieAmethystCrab boss, boolean followingTargetEvenIfNotSeen, double moveSpeed) {
            this.crab = boss;
            this.followingTargetEvenIfNotSeen = followingTargetEvenIfNotSeen;
            this.moveSpeed = moveSpeed;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            LivingEntity target = this.crab.m_5448_();
            return target != null && target.m_6084_() && this.crab.getAnimation() == IAnimatedEntity.NO_ANIMATION;
        }

        public void m_8041_() {
            this.crab.m_21573_().m_26573_();
            LivingEntity livingentity = this.crab.m_5448_();
            if (!EntitySelector.f_20406_.test(livingentity)) {
                this.crab.m_6710_(null);
            }
            this.crab.m_21561_(false);
            this.crab.m_21573_().m_26573_();
        }

        public boolean m_8045_() {
            LivingEntity target = this.crab.m_5448_();
            if (target == null) {
                return false;
            }
            if (!target.m_6084_()) {
                return false;
            }
            if (!this.followingTargetEvenIfNotSeen) {
                return !this.crab.m_21573_().m_26571_();
            }
            if (!this.crab.m_21444_(target.m_20183_())) {
                return false;
            }
            return !(target instanceof Player) || !target.m_5833_() && !((Player)target).m_7500_();
        }

        public void m_8056_() {
            this.crab.m_21573_().m_26536_(this.path, this.moveSpeed);
            this.crab.m_21561_(true);
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity target = this.crab.m_5448_();
            if (target != null) {
                this.crab.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                double distSq = this.crab.m_20275_(target.m_20185_(), target.m_20191_().f_82289_, target.m_20189_());
                if (--this.delayCounter <= 0) {
                    this.delayCounter = 4 + this.crab.m_217043_().m_188503_(7);
                    if (distSq > Math.pow(this.crab.m_21051_(Attributes.f_22277_).m_22135_(), 2.0)) {
                        if (!this.crab.m_21691_() && !this.crab.m_21573_().m_5624_((Entity)target, 1.0)) {
                            this.delayCounter += 5;
                        }
                    } else {
                        this.crab.m_21573_().m_5624_((Entity)target, this.moveSpeed);
                    }
                }
                if (target.m_6084_() && this.crab.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
                    if (this.crab.burrow_cooldown <= 0 && this.crab.m_217043_().m_188501_() * 100.0f < 6.0f && (double)this.crab.m_20270_((Entity)target) <= 8.0) {
                        this.crab.setAnimation(CRAB_BURROW);
                    } else if (this.crab.m_217043_().m_188501_() * 100.0f < 24.0f && (double)this.crab.m_20270_((Entity)target) <= 3.75) {
                        if (this.crab.f_19796_.m_188503_(2) == 0) {
                            this.crab.setAnimation(CRAB_BITE);
                        } else {
                            this.crab.setAnimation(CRAB_SMASH);
                        }
                    } else if (this.crab.m_217043_().m_188501_() * 100.0f < 16.0f && (double)this.crab.m_20270_((Entity)target) <= 3.75 && target.m_20096_()) {
                        this.crab.setAnimation(CRAB_SMASH_THREE);
                    }
                }
            }
        }
    }

    static class CrabSmashGoal
    extends SimpleSummonAnimationGoal<ZombieAmethystCrab> {
        public CrabSmashGoal(ZombieAmethystCrab entity, Animation animation) {
            super(entity, animation);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        public void m_8056_() {
            LivingEntity target = ((ZombieAmethystCrab)this.entity).m_5448_();
            if (target != null) {
                ((ZombieAmethystCrab)this.entity).m_21563_().m_24960_((Entity)target, 30.0f, 90.0f);
            }
            super.m_8056_();
        }

        public void m_8037_() {
            LivingEntity target = ((ZombieAmethystCrab)this.entity).m_5448_();
            if (((ZombieAmethystCrab)this.entity).getAnimationTick() < 19 && target != null) {
                ((ZombieAmethystCrab)this.entity).m_21391_((Entity)target, 30.0f, 30.0f);
                ((ZombieAmethystCrab)this.entity).m_21573_().m_5624_((Entity)target, 1.0);
                ((ZombieAmethystCrab)this.entity).m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            } else {
                ((ZombieAmethystCrab)this.entity).m_146922_(((ZombieAmethystCrab)this.entity).f_19859_);
            }
            if (((ZombieAmethystCrab)this.entity).getAnimationTick() == 19) {
                ((ZombieAmethystCrab)this.entity).m_21573_().m_26573_();
            }
        }
    }

    static class CrabAttack
    extends SimpleSummonAnimationGoal<ZombieAmethystCrab> {
        private final int look;

        public CrabAttack(ZombieAmethystCrab entity, Animation animation, int look) {
            super(entity, animation);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
            this.look = look;
        }

        public void m_8056_() {
            LivingEntity target = ((ZombieAmethystCrab)this.entity).m_5448_();
            if (target != null) {
                ((ZombieAmethystCrab)this.entity).m_21563_().m_24960_((Entity)target, 30.0f, 90.0f);
            }
            super.m_8056_();
        }

        public void m_8037_() {
            LivingEntity target = ((ZombieAmethystCrab)this.entity).m_5448_();
            if (((ZombieAmethystCrab)this.entity).getAnimationTick() < this.look && target != null) {
                ((ZombieAmethystCrab)this.entity).m_21391_((Entity)target, 30.0f, 30.0f);
                ((ZombieAmethystCrab)this.entity).m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            } else {
                ((ZombieAmethystCrab)this.entity).m_146922_(((ZombieAmethystCrab)this.entity).f_19859_);
            }
        }
    }

    static class CrabBurrow
    extends SimpleSummonAnimationGoal<ZombieAmethystCrab> {
        public CrabBurrow(ZombieAmethystCrab entity, Animation animation) {
            super(entity, animation);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        public void m_8056_() {
            LivingEntity target = ((ZombieAmethystCrab)this.entity).m_5448_();
            if (target != null) {
                ((ZombieAmethystCrab)this.entity).m_21563_().m_24960_((Entity)target, 30.0f, 90.0f);
            }
            ((ZombieAmethystCrab)this.entity).burrow_cooldown = 240;
            super.m_8056_();
        }

        public void m_8037_() {
            LivingEntity target = ((ZombieAmethystCrab)this.entity).m_5448_();
            if (((ZombieAmethystCrab)this.entity).getAnimationTick() < 48 && target != null) {
                ((ZombieAmethystCrab)this.entity).m_21391_((Entity)target, 30.0f, 30.0f);
                ((ZombieAmethystCrab)this.entity).m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            } else {
                ((ZombieAmethystCrab)this.entity).m_146922_(((ZombieAmethystCrab)this.entity).f_19859_);
            }
            if (((ZombieAmethystCrab)this.entity).getAnimationTick() == 50) {
                for (int i = 0; i < 32; ++i) {
                    float throwAngle = (float)i * (float)Math.PI / 16.0f;
                    double sx = ((ZombieAmethystCrab)this.entity).m_20185_() + (double)(Mth.m_14089_((float)throwAngle) * 1.0f);
                    double sy = ((ZombieAmethystCrab)this.entity).m_20186_() + (double)((ZombieAmethystCrab)this.entity).m_20206_() * 0.2;
                    double sz = ((ZombieAmethystCrab)this.entity).m_20189_() + (double)(Mth.m_14031_((float)throwAngle) * 1.0f);
                    double vx = Mth.m_14089_((float)throwAngle);
                    double vy = 0.0f + ((ZombieAmethystCrab)this.entity).f_19796_.m_188501_() * 0.3f;
                    double vz = Mth.m_14031_((float)throwAngle);
                    double v3 = Mth.m_14116_((float)((float)(vx * vx + vz * vz)));
                    Amethyst_Cluster_Projectile_Entity projectile = new Amethyst_Cluster_Projectile_Entity((EntityType)ModEntities.AMETHYST_CLUSTER_PROJECTILE.get(), ((ZombieAmethystCrab)this.entity).m_9236_(), (LivingEntity)this.entity, (float)CMConfig.AmethystClusterdamage);
                    projectile.m_7678_(sx, sy, sz, (float)i * 11.25f, ((ZombieAmethystCrab)this.entity).m_146909_());
                    float speed = 0.8f;
                    projectile.m_6686_(vx, vy + v3 * (double)0.2f, vz, speed, 1.0f);
                    ((ZombieAmethystCrab)this.entity).m_9236_().m_7967_((Entity)projectile);
                }
            }
        }
    }
}

