/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.goety_cataclysm.common.entities.ally.undead.draugr;

import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.goety_cataclysm.common.items.CataclysmItems;
import com.Polarice3.goety_cataclysm.config.GCAttributesConfig;
import com.Polarice3.goety_cataclysm.config.GCSpellConfig;
import com.Polarice3.goety_cataclysm.init.CataclysmSounds;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.common.Tags;

public class DraugrServant
extends Summoned {
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState attackAnimationState = new AnimationState();
    public AnimationState attack2AnimationState = new AnimationState();

    public DraugrServant(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new DraugrMeleeAttackGoal());
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 30.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, ((Double)GCAttributesConfig.DraugrDamage.get()).doubleValue()).m_22268_(Attributes.f_22276_, ((Double)GCAttributesConfig.DraugrHealth.get()).doubleValue()).m_22268_(Attributes.f_22284_, ((Double)GCAttributesConfig.DraugrArmor.get()).doubleValue()).m_22268_(Attributes.f_22278_, 0.05);
    }

    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes((AttributeInstance)this.m_21051_(Attributes.f_22276_), (double)((Double)GCAttributesConfig.DraugrHealth.get()));
        MobUtil.setBaseAttributes((AttributeInstance)this.m_21051_(Attributes.f_22284_), (double)((Double)GCAttributesConfig.DraugrArmor.get()));
        MobUtil.setBaseAttributes((AttributeInstance)this.m_21051_(Attributes.f_22281_), (double)((Double)GCAttributesConfig.DraugrDamage.get()));
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public Predicate<Entity> summonPredicate() {
        return entity -> entity instanceof DraugrServant;
    }

    public int getSummonLimit(LivingEntity owner) {
        return (Integer)GCSpellConfig.DraugrLimit.get();
    }

    public AnimationState getAnimationState(String input) {
        if (Objects.equals(input, "attack")) {
            return this.attackAnimationState;
        }
        if (Objects.equals(input, "attack2")) {
            return this.attack2AnimationState;
        }
        return Objects.equals(input, "idle") ? this.idleAnimationState : new AnimationState();
    }

    public void stopAllAnimationStates() {
        this.attackAnimationState.m_216973_();
        this.attack2AnimationState.m_216973_();
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.LEFT;
    }

    public void m_7822_(byte p_219360_) {
        if (p_219360_ == 4) {
            if (this.f_19796_.m_188499_()) {
                this.attackAnimationState.m_216977_(this.f_19797_);
            } else {
                this.attack2AnimationState.m_216977_(this.f_19797_);
            }
        } else {
            super.m_7822_(p_219360_);
        }
    }

    public boolean m_7327_(Entity p_219472_) {
        this.m_9236_().m_7605_((Entity)this, (byte)4);
        return super.m_7327_(p_219472_);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_34088_, DifficultyInstance p_34089_, MobSpawnType p_34090_, @Nullable SpawnGroupData p_34091_, @Nullable CompoundTag p_34092_) {
        SpawnGroupData spawngroupdata = super.m_6518_(p_34088_, p_34089_, p_34090_, p_34091_, p_34092_);
        this.m_8061_(EquipmentSlot.MAINHAND, this.createSpawnWeapon());
        this.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
        return spawngroupdata;
    }

    private ItemStack createSpawnWeapon() {
        return this.f_19796_.m_188499_() ? new ItemStack((ItemLike)CataclysmItems.BLACK_STEEL_AXE.get()) : new ItemStack((ItemLike)CataclysmItems.BLACK_STEEL_SWORD.get());
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.idleAnimationState.m_246184_(true, this.f_19797_);
        }
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)CataclysmSounds.DRAUGR_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)CataclysmSounds.DRAUGR_DEATH.get();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)CataclysmSounds.DRAUGR_IDLE.get();
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand p_230254_2_) {
        ItemStack itemstack = pPlayer.m_21120_(p_230254_2_);
        if (this.getTrueOwner() != null && pPlayer == this.getTrueOwner() && (itemstack.m_150930_(Items.f_42583_) || itemstack.m_204117_(Tags.Items.BONES)) && this.m_21223_() < this.m_21233_()) {
            if (!pPlayer.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            this.m_5496_(SoundEvents.f_11912_, 1.0f, 1.0f);
            this.m_5634_(2.0f);
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i = 0; i < 7; ++i) {
                    double d0 = this.f_19796_.m_188583_() * 0.02;
                    double d1 = this.f_19796_.m_188583_() * 0.02;
                    double d2 = this.f_19796_.m_188583_() * 0.02;
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.HEAL_EFFECT.get()), this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0, d0, d1, d2, 0.5);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    class DraugrMeleeAttackGoal
    extends MeleeAttackGoal {
        public DraugrMeleeAttackGoal() {
            super((PathfinderMob)DraugrServant.this, 1.0, true);
        }

        protected double m_6639_(LivingEntity p_33377_) {
            float f = DraugrServant.this.m_20205_();
            return f * 2.25f * f * 2.25f + p_33377_.m_20205_();
        }
    }
}

