/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.goety_cataclysm.common.magic.spells.wind;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.utils.WandUtil;
import com.Polarice3.goety_cataclysm.common.entities.projectiles.Sandstorm;
import com.Polarice3.goety_cataclysm.config.GCSpellConfig;
import com.Polarice3.goety_cataclysm.init.CataclysmSounds;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class SandstormSpell
extends Spell {
    public int defaultSoulCost() {
        return (Integer)GCSpellConfig.SandstormCost.get();
    }

    public int defaultCastDuration() {
        return (Integer)GCSpellConfig.SandstormDuration.get();
    }

    @Nullable
    public SoundEvent CastingSound() {
        return (SoundEvent)CataclysmSounds.REMNANT_ROAR.get();
    }

    public int defaultSpellCooldown() {
        return (Integer)GCSpellConfig.SandstormCoolDown.get();
    }

    public SpellType getSpellType() {
        return SpellType.WIND;
    }

    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.DURATION.get());
        return list;
    }

    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        int potency = spellStat.getPotency();
        int duration = spellStat.getDuration();
        if (WandUtil.enchantedFocus((LivingEntity)caster)) {
            potency += WandUtil.getLevels((Enchantment)((Enchantment)ModEnchantments.POTENCY.get()), (LivingEntity)caster);
            duration += WandUtil.getLevels((Enchantment)((Enchantment)ModEnchantments.DURATION.get()), (LivingEntity)caster);
        }
        int i = this.rightStaff(staff) ? 4 : 1;
        for (int l = 0; l < i; ++l) {
            float angle = (float)l * (float)Math.PI / 1.5f;
            double sx = caster.m_20185_() + (double)(Mth.m_14089_((float)angle) * 8.0f);
            double sy = caster.m_20186_();
            double sz = caster.m_20189_() + (double)(Mth.m_14031_((float)angle) * 8.0f);
            Sandstorm sandstorm = new Sandstorm((Level)worldIn, sx, sy, sz, 300 * (duration + 1), angle, caster);
            sandstorm.setExtraDamage(potency);
            worldIn.m_7967_((Entity)sandstorm);
        }
    }
}

