/*
 * Decompiled with CFR 0.152.
 */
package io.github.jumperonjava.customcursor.editor;

import io.github.jumperonjava.customcursor.editor.ScrollListWidget;
import io.github.jumperonjava.customcursor.editor.TextureFolder;
import io.github.jumperonjava.customcursor.editor.TextureWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class FolderTextureAskList
extends Screen {
    public static final int gap = 2;
    private final TextureFolder folder;
    private final Consumer<ResourceLocation> onSuccess;
    ScrollListWidget list;
    protected ResourceLocation EMPTY_TEXTURE = ResourceLocation.tryBuild((String)"minecraft", (String)"empty");
    private List<ResourceLocation> textures = new ArrayList<ResourceLocation>();
    private ResourceLocation selectedTexture = this.EMPTY_TEXTURE;
    private Screen parent;
    private String lastFilter = "";

    public FolderTextureAskList(TextureFolder folder, Consumer<ResourceLocation> onSuccess) {
        super((Component)Component.empty());
        this.onSuccess = onSuccess;
        this.folder = folder;
    }

    public static void ask(FolderTextureAskList askScreen) {
        Minecraft client = Minecraft.getInstance();
        Screen currentScreen = client.screen;
        if (currentScreen == null) {
            client.setScreen((Screen)askScreen);
            return;
        }
        client.setScreen((Screen)askScreen);
        askScreen.parent = currentScreen;
    }

    protected void init() {
        this.list = new ScrollListWidget(this.minecraft, this.width, this.height - 64, 0, 22, 40);
        EditBox search = new EditBox(this.minecraft.font, 0, 0, this.width, 20, (Component)Component.empty());
        Button.Builder accept = new Button.Builder((Component)Component.translatable((String)"customcursor.folder.accept"), b1 -> {
            if (this.selectedTexture != this.EMPTY_TEXTURE) {
                this.success(this.selectedTexture);
            }
        });
        Button.Builder cancel1 = new Button.Builder((Component)Component.translatable((String)"customcursor.folder.cancel"), b1 -> this.closeScreen());
        Button.Builder cancel = new Button.Builder((Component)Component.translatable((String)"customcursor.folder.openfolder"), b -> this.openCursorFolder());
        accept.bounds(42, this.height - 20 - 2, 100, 20);
        cancel1.bounds(143, this.height - 20 - 2, 100, 20);
        cancel.bounds(244, this.height - 20 - 2, 100, 20);
        this.refreshListByFilter("");
        this.addRenderableWidget((GuiEventListener)this.list);
        search.setResponder(this::refreshListByFilter);
        this.addRenderableWidget((GuiEventListener)search);
        this.addRenderableWidget((GuiEventListener)accept.build());
        this.addRenderableWidget((GuiEventListener)cancel1.build());
        this.addRenderableWidget((GuiEventListener)cancel.build());
        this.addRenderableOnly((context, mouseX, mouseY, delta) -> {
            ResourceLocation texture = this.selectedTexture == this.EMPTY_TEXTURE ? ResourceLocation.tryBuild((String)"minecraft", (String)"textures/item/barrier.png") : this.selectedTexture;
            TextureWidget.render(context, texture, 1, this.height - 40 - 1, 40, 40);
        });
        this.setTexturesCallback(this::setTextures);
        this.addRenderableOnly((context, mouseX, mouseY, delta) -> context.drawString(this.font, (Component)Component.translatable((String)"customcursor.folder.selected").append(": ").append(this.selectedTexture.toString()), 45, this.height - 30 - 6 - 1, -1, true));
    }

    private void openCursorFolder() {
        Util.getPlatform().openFile(this.folder.path.toFile());
    }

    public void setTexturesCallback(Consumer<List<ResourceLocation>> consumer) {
        if (!this.textures.isEmpty()) {
            consumer.accept(this.textures);
        }
        this.folder.redefineTextures(() -> {
            this.textures = this.folder.getTextures();
            consumer.accept(this.textures);
        });
    }

    public void setTextures(List<ResourceLocation> identifiers) {
        this.textures = identifiers;
        this.refreshListByFilter(this.lastFilter);
    }

    private void refreshListByFilter(String s) {
        this.lastFilter = s;
        this.list.children.clear();
        this.list.setScrollAmount(0.0);
        for (ResourceLocation key : this.textures) {
            this.extracted(s, key);
        }
    }

    private void extracted(String s, ResourceLocation key) {
        if (key == null) {
            return;
        }
        String id = key.toString();
        if (!id.toLowerCase().contains(s.toLowerCase())) {
            return;
        }
        ResourceLocation finalKey = key;
        ScrollListWidget.ScrollListEntry entry = new ScrollListWidget.ScrollListEntry(key, () -> {
            this.selectedTexture = finalKey;
        });
        this.list.addEntry(entry);
    }

    public void success(ResourceLocation ret) {
        this.onSuccess.accept(ret);
        this.closeScreen();
    }

    private void closeScreen() {
        Minecraft.getInstance().setScreen(this.parent);
    }
}

