/*
 * Decompiled with CFR 0.152.
 */
package io.github.jumperonjava.customcursor.editor;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraft.ResourceLocationException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;

public class TextureFolder {
    public final Path path;
    public final String namespace;
    private List<ResourceLocation> textures = new ArrayList<ResourceLocation>();

    public TextureFolder(Path path, String namespace) {
        this.path = path;
        this.namespace = namespace;
        if (Files.isRegularFile(path, new LinkOption[0])) {
            throw new RuntimeException("Path %s is not a directory".formatted(path));
        }
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void redefineTextures() {
        this.redefineTextures(() -> {});
    }

    public void redefineTextures(Runnable onFinishedCallback) {
        ArrayList l = new ArrayList();
        this.reregisterTextures(onFinishedCallback, this.getAllTexturesRecursive(this.path));
    }

    private List<Path> getAllTexturesRecursive(Path path) {
        try {
            ArrayList<Path> l = new ArrayList<Path>();
            Stream<Path> objects = Files.list(path);
            for (Path object : objects.toList()) {
                if (Files.isDirectory(object, new LinkOption[0])) {
                    l.addAll(this.getAllTexturesRecursive(object));
                }
                if (!Files.isRegularFile(object, new LinkOption[0]) || !object.toString().toLowerCase().endsWith(".png")) continue;
                l.add(object);
            }
            return l;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void reregisterTextures(Runnable onFinishedCallback, List<Path> toRegister) {
        RenderSystem.recordRenderCall(() -> this.ONLY_RENDERTHREAD_register(onFinishedCallback, toRegister));
    }

    private void ONLY_RENDERTHREAD_register(Runnable onFinishedCallback, List<Path> toRegister) {
        TextureManager tman = Minecraft.getInstance().getTextureManager();
        this.textures.forEach(arg_0 -> ((TextureManager)tman).release(arg_0));
        this.textures.clear();
        HashMap<ResourceLocation, NativeImage> textureMap = new HashMap<ResourceLocation, NativeImage>();
        toRegister.forEach(p -> {
            try {
                InputStream stream = Files.newInputStream(p, StandardOpenOption.READ);
                NativeImage nativeImage = NativeImage.read((InputStream)stream);
                stream.close();
                ResourceLocation name = this.getIdentifierFor((Path)p);
                textureMap.put(name, nativeImage);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        textureMap.forEach((identifier, nativeImage) -> {
            DynamicTexture texture = new DynamicTexture(nativeImage);
            tman.register(identifier, (AbstractTexture)texture);
            this.textures.add((ResourceLocation)identifier);
        });
        onFinishedCallback.run();
    }

    private ResourceLocation getIdentifierFor(Path p) {
        String s = p.toAbsolutePath().toString().replaceAll(Pattern.quote(this.path.toAbsolutePath().toString()), "").replace("\\", "/").toLowerCase().substring(1);
        try {
            ResourceLocation name = ResourceLocation.tryBuild((String)this.namespace, (String)s);
            if (name != null) {
                return name;
            }
            throw new ResourceLocationException(this.namespace + ":" + s);
        }
        catch (ResourceLocationException e) {
            return ResourceLocation.tryBuild((String)this.namespace, (String)("wrongfilename" + s.hashCode()));
        }
    }

    public List<ResourceLocation> getTextures() {
        return new ArrayList<ResourceLocation>(this.textures);
    }
}

