/*
 * Decompiled with CFR 0.152.
 */
package io.github.jumperonjava.customcursor;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.jumperonjava.customcursor.CursorConfigStorage;
import io.github.jumperonjava.customcursor.CursorSettings;
import io.github.jumperonjava.customcursor.CustomCursorInit;
import io.github.jumperonjava.customcursor.util.FolderTextureAskList;
import io.github.jumperonjava.customcursor.util.SliderWidget;
import io.github.jumperonjava.customcursor.util.VersionFunctions;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_9848;

public class CursorEditScreen
extends class_437 {
    private final Consumer<CursorSettings> onSuccess;
    private final CursorSettings targetConfig;
    private final class_437 parent;
    private int centerX;
    private int centerY;
    private final int previewSize = 128;
    private int previewPosX;
    private int previewPosY;
    private float bgx = 0.0f;
    private float bgy = 0.0f;
    private float color;

    public CursorEditScreen(class_437 parent, CursorSettings cursorConfig, Consumer<CursorSettings> onSuccess) {
        super((class_2561)class_2561.method_43473());
        this.parent = parent;
        this.onSuccess = onSuccess;
        this.targetConfig = cursorConfig.clone();
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    protected void method_25426() {
        int i;
        this.centerX = this.field_22789 / 2;
        this.centerY = this.field_22790 / 2;
        this.previewPosX = (this.field_22789 - 128) / 2;
        this.previewPosY = this.centerY;
        super.method_25426();
        Function<Boolean, class_2561> textfunc = b -> class_2561.method_43471((String)("customcursor.edit.enabled." + b));
        class_4185.class_7840 toggleWidget = new class_4185.class_7840(textfunc.apply(this.targetConfig.enabled), buttonWidget -> {
            this.targetConfig.enabled = !this.targetConfig.enabled;
            buttonWidget.method_25355((class_2561)textfunc.apply(this.targetConfig.enabled));
        });
        class_4185.class_7840 confrmButton = new class_4185.class_7840((class_2561)class_2561.method_43471((String)"customcursor.edit.confirm"), this::confirm);
        class_4185.class_7840 cancelButton = new class_4185.class_7840((class_2561)class_2561.method_43471((String)"customcursor.edit.cancel"), f -> this.method_25419());
        class_4185.class_7840 folderButton = new class_4185.class_7840((class_2561)class_2561.method_43471((String)"customcursor.edit.folder"), b -> FolderTextureAskList.ask(new FolderTextureAskList(CustomCursorInit.getTextureFolder(), this::setIdentifier)));
        int rowSize = 24;
        int columnSize = 128;
        int rowCount = 6;
        int columnCount = 2;
        int startColumnPos = this.centerX - columnCount * columnSize / 2;
        int startRowPos = this.centerY - rowCount * rowSize;
        int[] rows = new int[rowCount];
        int[] columns = new int[columnCount];
        int padding = 2;
        int sizePadding = padding * 2;
        for (i = 0; i < rowCount; ++i) {
            rows[i] = startRowPos + rowSize * i + padding;
        }
        for (i = 0; i < columnCount; ++i) {
            columns[i] = startColumnPos + columnSize * i + padding;
        }
        int columnSizePadding = columnSize - sizePadding;
        int twoColumnSizePadding = columnSize * 2 - sizePadding;
        int rowSizePadding = rowSize - sizePadding;
        toggleWidget = toggleWidget.method_46434(columns[0], rows[0], twoColumnSizePadding, rowSizePadding);
        folderButton = folderButton.method_46434(columns[0], rows[3], twoColumnSizePadding, rowSizePadding);
        confrmButton = confrmButton.method_46434(columns[0], rows[5], columnSizePadding, rowSizePadding);
        cancelButton = cancelButton.method_46434(columns[1], rows[5], columnSizePadding, rowSizePadding);
        double maxsize = 256.0;
        class_342 imagePathField = new class_342(this.field_22787.field_1772, columns[0], rows[4], twoColumnSizePadding, rowSizePadding, (class_2561)class_2561.method_43473());
        SliderWidget sizeSlider = new SliderWidget(columns[0], rows[1], twoColumnSizePadding, rowSizePadding, (class_2561)class_2561.method_43471((String)"customcursor.edit.size"), this.targetConfig.size, 0.0, maxsize, 256);
        SliderWidget xPosSlider = new SliderWidget(columns[0], rows[2], columnSizePadding, rowSizePadding, (class_2561)class_2561.method_43471((String)"customcursor.edit.x"), this.targetConfig.x, 0.0, 1.0, 64);
        SliderWidget yPosSlider = new SliderWidget(columns[1], rows[2], columnSizePadding, rowSizePadding, (class_2561)class_2561.method_43471((String)"customcursor.edit.y"), this.targetConfig.y, 0.0, 1.0, 64);
        xPosSlider.setChangedListener(d -> {
            this.targetConfig.x = (float)d.doubleValue();
        });
        yPosSlider.setChangedListener(d -> {
            this.targetConfig.y = (float)d.doubleValue();
        });
        sizeSlider.setChangedListener(d -> {
            this.targetConfig.size = (int)d.doubleValue();
        });
        imagePathField.method_1880(512);
        imagePathField.method_1852(this.targetConfig.identifier.toString());
        imagePathField.method_1863(s -> {
            try {
                this.setIdentifier(class_2960.method_12829((String)s));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        this.method_37063((class_364)toggleWidget.method_46431());
        this.method_37063((class_364)confrmButton.method_46431());
        this.method_37063((class_364)cancelButton.method_46431());
        this.method_37063((class_364)folderButton.method_46431());
        this.method_37063((class_364)imagePathField);
        this.method_37063((class_364)sizeSlider);
        this.method_37063((class_364)xPosSlider);
        this.method_37063((class_364)yPosSlider);
        this.method_37060(this::renderCheckerboard);
        this.method_37060(this::renderPreview);
    }

    private void setIdentifier(class_2960 identifier) {
        this.targetConfig.identifier = identifier;
    }

    private void confirm(class_4185 buttonWidget) {
        try {
            this.onSuccess.accept(this.targetConfig);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.method_25419();
    }

    private void renderPreview(class_332 context, int mouseX, int mouseY, float delta) {
        VersionFunctions.drawTexture(context, this.targetConfig.identifier, this.previewPosX, this.previewPosY, 0.0f, 0.0f, 128, 128, 128, 128);
        VersionFunctions.drawTexture(context, class_2960.method_60655((String)"customcursor", (String)"textures/gui/pointer.png"), (int)((float)this.previewPosX + this.targetConfig.x * 128.0f) - 4, (int)((float)this.previewPosY + this.targetConfig.y * 128.0f) - 4, 0.0f, 0.0f, 8, 8, 8, 8);
    }

    private void renderCheckerboard(class_332 context, int mouseX, int mouseY, float delta) {
        this.color += delta * 0.05f;
        int n = 2;
        int color1 = class_9848.method_61324((int)255, (int)((int)(128.0 + 64.0 * Math.pow(Math.sin((double)this.color + 0.0), n))), (int)((int)(128.0 + 64.0 * Math.pow(Math.sin((double)this.color + 2.0943951023931953), n))), (int)((int)(128.0 + 64.0 * Math.pow(Math.sin((double)this.color + 4.1887902047863905), n))));
        int color2 = class_9848.method_61324((int)255, (int)((int)(192.0 + 63.0 * Math.pow(Math.cos((double)this.color + 0.0), n))), (int)((int)(192.0 + 63.0 * Math.pow(Math.cos((double)this.color + 2.0943951023931953), n))), (int)((int)(192.0 + 63.0 * Math.pow(Math.cos((double)this.color + 4.1887902047863905), n))));
        float r = (float)class_9848.method_61327((int)color1) / 255.0f;
        float g = (float)class_9848.method_61329((int)color1) / 255.0f;
        float b = (float)class_9848.method_61331((int)color1) / 255.0f;
        class_241 vec = new class_241((float)mouseX - ((float)this.previewPosX + 64.0f), (float)mouseY - ((float)this.previewPosY + 64.0f)).method_35581().method_35582(delta);
        this.bgx += vec.field_1343;
        this.bgy += vec.field_1342;
        context.method_25294(this.previewPosX, this.previewPosY, this.previewPosX + 128, this.previewPosY + 128, color2);
        context.method_44379(this.previewPosX, this.previewPosY, this.previewPosX + 128, this.previewPosY + 128);
        int cellsize = 16;
        context.method_51448().method_22903();
        context.method_51448().method_46416((float)this.previewPosX + class_3532.method_15341((float)this.bgx, (float)cellsize) - (float)cellsize, (float)this.previewPosY + class_3532.method_15341((float)this.bgy, (float)cellsize) - (float)cellsize, 0.0f);
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)255.0f);
        int checkerRenderSize = 128 + cellsize;
        VersionFunctions.drawTexture(context, class_2960.method_60655((String)"customcursor", (String)"textures/gui/backgroundcheckerboard.png"), 0, 0, 0.0f, 0.0f, checkerRenderSize, checkerRenderSize, checkerRenderSize, checkerRenderSize);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        context.method_51448().method_22909();
        context.method_44380();
    }

    public static CursorEditScreen createCursorEditScreen(class_437 parent) {
        return new CursorEditScreen(parent, CustomCursorInit.getConfig().pointer, c -> {
            CursorConfigStorage cfg = new CursorConfigStorage();
            cfg.pointer = c;
            CustomCursorInit.setConfig(cfg);
        });
    }
}

