/*
 * Decompiled with CFR 0.152.
 */
package io.github.jumperonjava.customcursor.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_151;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class TextureFolder {
    public final Path path;
    public final String namespace;
    private List<class_2960> textures = new ArrayList<class_2960>();

    public TextureFolder(Path path, String namespace) {
        this.path = path;
        this.namespace = namespace;
        if (Files.isRegularFile(path, new LinkOption[0])) {
            throw new RuntimeException("Path %s is not a directory".formatted(path));
        }
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void redefineTextures() {
        this.redefineTextures(() -> {});
    }

    public void redefineTextures(Runnable onFinishedCallback) {
        ArrayList l = new ArrayList();
        this.reregisterTextures(onFinishedCallback, this.getAllTexturesRecursive(this.path));
    }

    private List<Path> getAllTexturesRecursive(Path path) {
        try {
            ArrayList<Path> l = new ArrayList<Path>();
            Stream<Path> objects = Files.list(path);
            for (Path object : objects.toList()) {
                if (Files.isDirectory(object, new LinkOption[0])) {
                    l.addAll(this.getAllTexturesRecursive(object));
                }
                if (!Files.isRegularFile(object, new LinkOption[0]) || !object.toString().toLowerCase().endsWith(".png")) continue;
                l.add(object);
            }
            return l;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void reregisterTextures(Runnable onFinishedCallback, List<Path> toRegister) {
        this.ONLY_RENDERTHREAD_register(onFinishedCallback, toRegister);
    }

    private void ONLY_RENDERTHREAD_register(Runnable onFinishedCallback, List<Path> toRegister) {
        class_1060 tman = class_310.method_1551().method_1531();
        this.textures.forEach(arg_0 -> ((class_1060)tman).method_4615(arg_0));
        this.textures.clear();
        HashMap<class_2960, class_1011> textureMap = new HashMap<class_2960, class_1011>();
        toRegister.forEach(p -> {
            try {
                InputStream stream = Files.newInputStream(p, StandardOpenOption.READ);
                class_1011 nativeImage = class_1011.method_4309((InputStream)stream);
                stream.close();
                class_2960 name = this.getIdentifierFor((Path)p);
                textureMap.put(name, nativeImage);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        textureMap.forEach((identifier, nativeImage) -> {
            class_1043 texture = new class_1043(() -> ((class_2960)identifier).toString(), nativeImage);
            tman.method_4616(identifier, (class_1044)texture);
            this.textures.add((class_2960)identifier);
        });
        onFinishedCallback.run();
    }

    private class_2960 getIdentifierFor(Path p) {
        String s = p.toAbsolutePath().toString().replaceAll(Pattern.quote(this.path.toAbsolutePath().toString()), "").replace("\\", "/").toLowerCase().substring(1);
        try {
            class_2960 name = class_2960.method_60655((String)this.namespace, (String)s);
            if (name != null) {
                return name;
            }
            throw new class_151(this.namespace + ":" + s);
        }
        catch (class_151 e) {
            return class_2960.method_60655((String)this.namespace, (String)("wrongfilename" + s.hashCode()));
        }
    }

    public List<class_2960> getTextures() {
        return new ArrayList<class_2960>(this.textures);
    }
}

