/*
 * Decompiled with CFR 0.152.
 */
package io.github.jumperonjava.customcursor;

import com.google.gson.Gson;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.gui.cursor.Cursor;
import net.minecraft.client.gui.cursor.StandardCursors;
import net.minecraft.resources.ResourceLocation;

public class CursorSettings
implements Cloneable {
    public static Cursor globalCursor;
    public int size = 32;
    public boolean enabled = false;
    public boolean dynamicEnabled = true;
    public final CursorSprite arrow = new CursorSprite(0.0625f, 0.0625f, 0.0f, false, ResourceLocation.fromNamespaceAndPath((String)"customcursor", (String)"cursors/arrow.png"));
    public final CursorSprite ibeam = new CursorSprite(0.5f, 0.5f, 0.0f, false, ResourceLocation.fromNamespaceAndPath((String)"customcursor", (String)"cursors/ibeam.png"));
    public final CursorSprite crosshair = new CursorSprite(0.5f, 0.5f, 0.0f, false, ResourceLocation.fromNamespaceAndPath((String)"customcursor", (String)"cursors/crosshair.png"));
    public final CursorSprite pointing_hand = new CursorSprite(0.375f, 0.0f, 0.0f, false, ResourceLocation.fromNamespaceAndPath((String)"customcursor", (String)"cursors/pointing_hand.png"));
    public final CursorSprite resize_ns = new CursorSprite(0.5f, 0.5f, 0.0f, false, ResourceLocation.fromNamespaceAndPath((String)"customcursor", (String)"cursors/resize_ns.png"));
    public final CursorSprite resize_ew = new CursorSprite(0.5f, 0.5f, 0.0f, false, ResourceLocation.fromNamespaceAndPath((String)"customcursor", (String)"cursors/resize_ew.png"));
    public final CursorSprite resize_all = new CursorSprite(0.5f, 0.5f, 0.0f, false, ResourceLocation.fromNamespaceAndPath((String)"customcursor", (String)"cursors/resize_all.png"));
    public final CursorSprite not_allowed = new CursorSprite(0.5f, 0.5f, 0.0f, false, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/item/barrier.png"));
    public static final List<String> cursorOrder;

    public Map<String, CursorSprite> allCursors() {
        return Map.of("arrow", this.arrow, "ibeam", this.ibeam, "crosshair", this.crosshair, "pointing_hand", this.pointing_hand, "resize_ns", this.resize_ns, "resize_ew", this.resize_ew, "resize_all", this.resize_all, "not_allowed", this.not_allowed);
    }

    public static Map<String, Cursor> cursors() {
        return Map.of("arrow", StandardCursors.ARROW, "ibeam", StandardCursors.IBEAM, "crosshair", StandardCursors.CROSSHAIR, "pointing_hand", StandardCursors.POINTING_HAND, "resize_ns", StandardCursors.RESIZE_NS, "resize_ew", StandardCursors.RESIZE_EW, "resize_all", StandardCursors.RESIZE_ALL, "not_allowed", StandardCursors.NOT_ALLOWED);
    }

    public CursorSprite cursorToSprite(Cursor cursor) {
        if (!this.dynamicEnabled) {
            return this.arrow;
        }
        Map<Cursor, CursorSprite> map = Map.of(Cursor.DEFAULT, this.arrow, StandardCursors.ARROW, this.arrow, StandardCursors.IBEAM, this.ibeam, StandardCursors.CROSSHAIR, this.crosshair, StandardCursors.POINTING_HAND, this.pointing_hand, StandardCursors.RESIZE_NS, this.resize_ns, StandardCursors.RESIZE_EW, this.resize_ew, StandardCursors.RESIZE_ALL, this.resize_all, StandardCursors.NOT_ALLOWED, this.not_allowed);
        return map.get(cursor);
    }

    public CursorSettings clone() {
        return (CursorSettings)new Gson().fromJson(new Gson().toJson((Object)this), CursorSettings.class);
    }

    static {
        cursorOrder = List.of("arrow", "ibeam", "crosshair", "pointing_hand", "resize_ns", "resize_ew", "resize_all", "not_allowed");
    }

    public static final class CursorSprite {
        public float x;
        public float y;
        public float rotation;
        public boolean mirroredX;
        public boolean mirroredY;
        public ResourceLocation identifier;

        public CursorSprite(float x, float y, float rotation, boolean mirror, ResourceLocation identifier) {
            this.x = x;
            this.y = y;
            this.rotation = rotation;
            this.mirroredX = mirror;
            this.identifier = identifier;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            CursorSprite that = (CursorSprite)obj;
            return Float.floatToIntBits(this.x) == Float.floatToIntBits(that.x) && Float.floatToIntBits(this.y) == Float.floatToIntBits(that.y) && Float.floatToIntBits(this.rotation) == Float.floatToIntBits(that.rotation) && this.mirroredX == that.mirroredX && Objects.equals(this.identifier, that.identifier);
        }

        public int hashCode() {
            return Objects.hash(Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.rotation), this.mirroredX, this.identifier);
        }

        public String toString() {
            return "CursorSprite[x=" + this.x + ", y=" + this.y + ", rotation=" + this.rotation + ", mirror=" + this.mirroredX + ", identifier=" + String.valueOf(this.identifier) + "]";
        }
    }
}

