/*
 * Decompiled with CFR 0.152.
 */
package io.github.jumperonjava.customcursor;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.github.jumperonjava.customcursor.CursorConfigStorage;
import io.github.jumperonjava.customcursor.editor.TextureFolder;
import io.github.jumperonjava.customcursor.util.FileReadWrite;
import java.io.File;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomCursorInit {
    public static final String MOD_ID = "customcursorcomm";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"CustomCursor");
    private static TextureFolder TEXTURE_FOLDER;
    private static CursorConfigStorage config;
    private static Gson gson;

    public static void entrypoint(Function<String, Boolean> isModLoaded) {
        CustomCursorInit.getConfig();
    }

    private static CursorConfigStorage loadConfig() {
        if (CustomCursorInit.getConfigFile().exists()) {
            return (CursorConfigStorage)gson.fromJson(FileReadWrite.read(CustomCursorInit.getConfigFile()), CursorConfigStorage.class);
        }
        return new CursorConfigStorage();
    }

    private static File getConfigFile() {
        return Minecraft.getInstance().gameDirectory.toPath().resolve("config/customcursor.json").toFile();
    }

    public static CursorConfigStorage getConfig() {
        if (config == null) {
            CustomCursorInit.setConfig(CustomCursorInit.loadConfig());
        }
        return config;
    }

    public static void setConfig(CursorConfigStorage config) {
        String json = gson.toJson((Object)config);
        FileReadWrite.write(CustomCursorInit.getConfigFile(), json);
        CustomCursorInit.config = config;
    }

    public static TextureFolder getTextureFolder() {
        if (TEXTURE_FOLDER == null) {
            TEXTURE_FOLDER = new TextureFolder(Minecraft.getInstance().gameDirectory.toPath().resolve("cursors"), "cursorfolder");
        }
        return TEXTURE_FOLDER;
    }

    static {
        gson = new GsonBuilder().setPrettyPrinting().create();
    }
}

