/*
 * Decompiled with CFR 0.152.
 */
package io.github.jumperonjava.customcursor;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.jumperonjava.customcursor.CursorConfigStorage;
import io.github.jumperonjava.customcursor.CursorSettings;
import io.github.jumperonjava.customcursor.CustomCursorInit;
import io.github.jumperonjava.customcursor.util.FolderTextureAskList;
import io.github.jumperonjava.customcursor.util.SliderWidget;
import io.github.jumperonjava.customcursor.util.VersionFunctions;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;

public class CursorEditScreen
extends Screen {
    private final Consumer<CursorSettings> onSuccess;
    private final CursorSettings targetConfig;
    private final Screen parent;
    private int centerX;
    private int centerY;
    private final int previewSize = 128;
    private int previewPosX;
    private int previewPosY;
    private float bgx = 0.0f;
    private float bgy = 0.0f;
    private float color;

    public CursorEditScreen(Screen parent, CursorSettings cursorConfig, Consumer<CursorSettings> onSuccess) {
        super((Component)Component.m_237119_());
        this.parent = parent;
        this.onSuccess = onSuccess;
        this.targetConfig = cursorConfig.clone();
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    protected void m_7856_() {
        int i;
        this.centerX = this.f_96543_ / 2;
        this.centerY = this.f_96544_ / 2;
        this.previewPosX = (this.f_96543_ - 128) / 2;
        this.previewPosY = this.centerY;
        super.m_7856_();
        Function<Boolean, Component> textfunc = b -> Component.m_237115_((String)("customcursor.edit.enabled." + b));
        Button.Builder toggleWidget = new Button.Builder(textfunc.apply(this.targetConfig.enabled), buttonWidget -> {
            this.targetConfig.enabled = !this.targetConfig.enabled;
            buttonWidget.m_93666_((Component)textfunc.apply(this.targetConfig.enabled));
        });
        Button.Builder confrmButton = new Button.Builder((Component)Component.m_237115_((String)"customcursor.edit.confirm"), this::confirm);
        Button.Builder cancelButton = new Button.Builder((Component)Component.m_237115_((String)"customcursor.edit.cancel"), f -> this.m_7379_());
        Button.Builder folderButton = new Button.Builder((Component)Component.m_237115_((String)"customcursor.edit.folder"), b -> FolderTextureAskList.ask(new FolderTextureAskList(CustomCursorInit.getTextureFolder(), this::setIdentifier)));
        int rowSize = 24;
        int columnSize = 128;
        int rowCount = 6;
        int columnCount = 2;
        int startColumnPos = this.centerX - columnCount * columnSize / 2;
        int startRowPos = this.centerY - rowCount * rowSize;
        int[] rows = new int[rowCount];
        int[] columns = new int[columnCount];
        int padding = 2;
        int sizePadding = padding * 2;
        for (i = 0; i < rowCount; ++i) {
            rows[i] = startRowPos + rowSize * i + padding;
        }
        for (i = 0; i < columnCount; ++i) {
            columns[i] = startColumnPos + columnSize * i + padding;
        }
        int columnSizePadding = columnSize - sizePadding;
        int twoColumnSizePadding = columnSize * 2 - sizePadding;
        int rowSizePadding = rowSize - sizePadding;
        toggleWidget = toggleWidget.m_252987_(columns[0], rows[0], twoColumnSizePadding, rowSizePadding);
        folderButton = folderButton.m_252987_(columns[0], rows[3], twoColumnSizePadding, rowSizePadding);
        confrmButton = confrmButton.m_252987_(columns[0], rows[5], columnSizePadding, rowSizePadding);
        cancelButton = cancelButton.m_252987_(columns[1], rows[5], columnSizePadding, rowSizePadding);
        double maxsize = 256.0;
        EditBox imagePathField = new EditBox(this.f_96541_.f_91062_, columns[0], rows[4], twoColumnSizePadding, rowSizePadding, (Component)Component.m_237119_());
        SliderWidget sizeSlider = new SliderWidget(columns[0], rows[1], twoColumnSizePadding, rowSizePadding, (Component)Component.m_237115_((String)"customcursor.edit.size"), this.targetConfig.size, 0.0, maxsize, 256);
        SliderWidget xPosSlider = new SliderWidget(columns[0], rows[2], columnSizePadding, rowSizePadding, (Component)Component.m_237115_((String)"customcursor.edit.x"), this.targetConfig.x, 0.0, 1.0, 64);
        SliderWidget yPosSlider = new SliderWidget(columns[1], rows[2], columnSizePadding, rowSizePadding, (Component)Component.m_237115_((String)"customcursor.edit.y"), this.targetConfig.y, 0.0, 1.0, 64);
        xPosSlider.setChangedListener(d -> {
            this.targetConfig.x = (float)d.doubleValue();
        });
        yPosSlider.setChangedListener(d -> {
            this.targetConfig.y = (float)d.doubleValue();
        });
        sizeSlider.setChangedListener(d -> {
            this.targetConfig.size = (int)d.doubleValue();
        });
        imagePathField.m_94199_(512);
        imagePathField.m_94144_(this.targetConfig.identifier.toString());
        imagePathField.m_94151_(s -> {
            try {
                this.setIdentifier(ResourceLocation.m_135820_((String)s));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        this.m_142416_((GuiEventListener)toggleWidget.m_253136_());
        this.m_142416_((GuiEventListener)confrmButton.m_253136_());
        this.m_142416_((GuiEventListener)cancelButton.m_253136_());
        this.m_142416_((GuiEventListener)folderButton.m_253136_());
        this.m_142416_((GuiEventListener)imagePathField);
        this.m_142416_((GuiEventListener)sizeSlider);
        this.m_142416_((GuiEventListener)xPosSlider);
        this.m_142416_((GuiEventListener)yPosSlider);
        this.m_169394_(this::renderCheckerboard);
        this.m_169394_(this::renderPreview);
    }

    private void setIdentifier(ResourceLocation identifier) {
        this.targetConfig.identifier = identifier;
    }

    private void confirm(Button buttonWidget) {
        try {
            this.onSuccess.accept(this.targetConfig);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.m_7379_();
    }

    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        this.m_280273_(context);
        super.m_88315_(context, mouseX, mouseY, delta);
    }

    private void renderPreview(GuiGraphics context, int mouseX, int mouseY, float delta) {
        VersionFunctions.drawTexture(context, this.targetConfig.identifier, this.previewPosX, this.previewPosY, 0.0f, 0.0f, 128, 128, 128, 128);
        VersionFunctions.drawTexture(context, ResourceLocation.m_214293_((String)"customcursor", (String)"textures/gui/pointer.png"), (int)((float)this.previewPosX + this.targetConfig.x * 128.0f) - 4, (int)((float)this.previewPosY + this.targetConfig.y * 128.0f) - 4, 0.0f, 0.0f, 8, 8, 8, 8);
    }

    private void renderCheckerboard(GuiGraphics context, int mouseX, int mouseY, float delta) {
        this.color += delta * 0.05f;
        int n = 2;
        int color1 = FastColor.ARGB32.m_13660_((int)255, (int)((int)(128.0 + 64.0 * Math.pow(Math.sin((double)this.color + 0.0), n))), (int)((int)(128.0 + 64.0 * Math.pow(Math.sin((double)this.color + 2.0943951023931953), n))), (int)((int)(128.0 + 64.0 * Math.pow(Math.sin((double)this.color + 4.1887902047863905), n))));
        int color2 = FastColor.ARGB32.m_13660_((int)255, (int)((int)(192.0 + 63.0 * Math.pow(Math.cos((double)this.color + 0.0), n))), (int)((int)(192.0 + 63.0 * Math.pow(Math.cos((double)this.color + 2.0943951023931953), n))), (int)((int)(192.0 + 63.0 * Math.pow(Math.cos((double)this.color + 4.1887902047863905), n))));
        float r = (float)FastColor.ARGB32.m_13665_((int)color1) / 255.0f;
        float g = (float)FastColor.ARGB32.m_13667_((int)color1) / 255.0f;
        float b = (float)FastColor.ARGB32.m_13669_((int)color1) / 255.0f;
        Vec2 vec = new Vec2((float)mouseX - ((float)this.previewPosX + 64.0f), (float)mouseY - ((float)this.previewPosY + 64.0f)).m_165902_().m_165903_(delta);
        this.bgx += vec.f_82470_;
        this.bgy += vec.f_82471_;
        context.m_280509_(this.previewPosX, this.previewPosY, this.previewPosX + 128, this.previewPosY + 128, color2);
        context.m_280588_(this.previewPosX, this.previewPosY, this.previewPosX + 128, this.previewPosY + 128);
        int cellsize = 16;
        context.m_280168_().m_85836_();
        context.m_280168_().m_252880_((float)this.previewPosX + Mth.m_14091_((float)this.bgx, (float)cellsize) - (float)cellsize, (float)this.previewPosY + Mth.m_14091_((float)this.bgy, (float)cellsize) - (float)cellsize, 0.0f);
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)255.0f);
        int checkerRenderSize = 128 + cellsize;
        VersionFunctions.drawTexture(context, ResourceLocation.m_214293_((String)"customcursor", (String)"textures/gui/backgroundcheckerboard.png"), 0, 0, 0.0f, 0.0f, checkerRenderSize, checkerRenderSize, checkerRenderSize, checkerRenderSize);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        context.m_280168_().m_85849_();
        context.m_280618_();
    }

    public static CursorEditScreen createCursorEditScreen(Screen parent) {
        return new CursorEditScreen(parent, CustomCursorInit.getConfig().pointer, c -> {
            CursorConfigStorage cfg = new CursorConfigStorage();
            cfg.pointer = c;
            CustomCursorInit.setConfig(cfg);
        });
    }
}

