/*
 * Decompiled with CFR 0.152.
 */
package io.github.jumperonjava.customcursor.util;

import io.github.jumperonjava.customcursor.util.ScrollListWidget;
import io.github.jumperonjava.customcursor.util.TextureFolder;
import io.github.jumperonjava.customcursor.util.TextureWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class FolderTextureAskList
extends Screen {
    public static final int gap = 2;
    private final TextureFolder folder;
    private final Consumer<ResourceLocation> onSuccess;
    ScrollListWidget list;
    protected ResourceLocation EMPTY_TEXTURE = ResourceLocation.m_214293_((String)"minecraft", (String)"empty");
    private List<ResourceLocation> textures = new ArrayList<ResourceLocation>();
    private ResourceLocation selectedTexture = this.EMPTY_TEXTURE;
    private Screen parent;
    private String lastFilter = "";

    public FolderTextureAskList(TextureFolder folder, Consumer<ResourceLocation> onSuccess) {
        super((Component)Component.m_237119_());
        this.onSuccess = onSuccess;
        this.folder = folder;
    }

    public static void ask(FolderTextureAskList askScreen) {
        Minecraft client = Minecraft.m_91087_();
        Screen currentScreen = client.f_91080_;
        if (currentScreen == null) {
            client.m_91152_((Screen)askScreen);
            return;
        }
        client.m_91152_((Screen)askScreen);
        askScreen.parent = currentScreen;
    }

    protected void m_7856_() {
        this.list = new ScrollListWidget(this.f_96541_, this.f_96543_, this.f_96544_ - 64, 0, 22, 40);
        EditBox search = new EditBox(this.f_96541_.f_91062_, 0, 0, this.f_96543_, 20, (Component)Component.m_237119_());
        Button.Builder accept = new Button.Builder((Component)Component.m_237115_((String)"customcursor.folder.accept"), b1 -> {
            if (this.selectedTexture != this.EMPTY_TEXTURE) {
                this.success(this.selectedTexture);
            }
        });
        Button.Builder cancel1 = new Button.Builder((Component)Component.m_237115_((String)"customcursor.folder.cancel"), b1 -> this.closeScreen());
        Button.Builder cancel = new Button.Builder((Component)Component.m_237115_((String)"customcursor.folder.openfolder"), b -> this.openCursorFolder());
        accept.m_252987_(42, this.f_96544_ - 20 - 2, 100, 20);
        cancel1.m_252987_(143, this.f_96544_ - 20 - 2, 100, 20);
        cancel.m_252987_(244, this.f_96544_ - 20 - 2, 100, 20);
        this.refreshListByFilter("");
        this.m_142416_((GuiEventListener)this.list);
        search.m_94151_(this::refreshListByFilter);
        this.m_142416_((GuiEventListener)search);
        this.m_142416_((GuiEventListener)accept.m_253136_());
        this.m_142416_((GuiEventListener)cancel1.m_253136_());
        this.m_142416_((GuiEventListener)cancel.m_253136_());
        this.m_169394_((context, mouseX, mouseY, delta) -> {
            ResourceLocation texture = this.selectedTexture == this.EMPTY_TEXTURE ? ResourceLocation.m_214293_((String)"minecraft", (String)"textures/item/barrier.png") : this.selectedTexture;
            TextureWidget.render(context, texture, 1, this.f_96544_ - 40 - 1, 40, 40);
        });
        this.setTexturesCallback(this::setTextures);
        this.m_169394_((context, mouseX, mouseY, delta) -> context.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"customcursor.folder.selected").m_130946_(": ").m_130946_(this.selectedTexture.toString()), 45, this.f_96544_ - 30 - 6 - 1, -1, true));
    }

    private void openCursorFolder() {
        Util.m_137581_().m_137644_(this.folder.path.toFile());
    }

    public void setTexturesCallback(Consumer<List<ResourceLocation>> consumer) {
        if (!this.textures.isEmpty()) {
            consumer.accept(this.textures);
        }
        this.folder.redefineTextures(() -> {
            this.textures = this.folder.getTextures();
            consumer.accept(this.textures);
        });
    }

    public void setTextures(List<ResourceLocation> identifiers) {
        this.textures = identifiers;
        this.refreshListByFilter(this.lastFilter);
    }

    private void refreshListByFilter(String s) {
        this.lastFilter = s;
        this.list.m_6702_().clear();
        this.list.m_93410_(0.0);
        for (ResourceLocation key : this.textures) {
            this.extracted(s, key);
        }
    }

    private void extracted(String s, ResourceLocation key) {
        if (key == null) {
            return;
        }
        String id = key.toString();
        if (!id.toLowerCase().contains(s.toLowerCase())) {
            return;
        }
        ResourceLocation finalKey = key;
        ScrollListWidget.ScrollListEntry entry = new ScrollListWidget.ScrollListEntry(key, () -> {
            this.selectedTexture = finalKey;
        });
        this.list.addEntry(entry);
    }

    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        this.m_280273_(context);
        super.m_88315_(context, mouseX, mouseY, delta);
    }

    public void success(ResourceLocation ret) {
        this.onSuccess.accept(ret);
        this.closeScreen();
    }

    private void closeScreen() {
        Minecraft.m_91087_().m_91152_(this.parent);
    }
}

