/*
 * Decompiled with CFR 0.152.
 */
package io.github.jumperonjava.customcursor;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.jumperonjava.customcursor.CursorConfigStorage;
import io.github.jumperonjava.customcursor.CursorSettings;
import io.github.jumperonjava.customcursor.CustomCursorInit;
import io.github.jumperonjava.customcursor.util.FolderTextureAskList;
import io.github.jumperonjava.customcursor.util.SliderWidget;
import io.github.jumperonjava.customcursor.util.VersionFunctions;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;

public class CursorEditScreen
extends Screen {
    private final Consumer<CursorSettings> onSuccess;
    private final CursorSettings targetConfig;
    private final Screen parent;
    private int centerX;
    private int centerY;
    private final int previewSize = 128;
    private int previewPosX;
    private int previewPosY;
    private float bgx = 0.0f;
    private float bgy = 0.0f;
    private float color;

    public CursorEditScreen(Screen parent, CursorSettings cursorConfig, Consumer<CursorSettings> onSuccess) {
        super((Component)Component.empty());
        this.parent = parent;
        this.onSuccess = onSuccess;
        this.targetConfig = cursorConfig.clone();
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    protected void init() {
        int i;
        this.centerX = this.width / 2;
        this.centerY = this.height / 2;
        this.previewPosX = (this.width - 128) / 2;
        this.previewPosY = this.centerY;
        super.init();
        Function<Boolean, Component> textfunc = b -> Component.translatable((String)("customcursor.edit.enabled." + b));
        Button.Builder toggleWidget = new Button.Builder(textfunc.apply(this.targetConfig.enabled), buttonWidget -> {
            this.targetConfig.enabled = !this.targetConfig.enabled;
            buttonWidget.setMessage((Component)textfunc.apply(this.targetConfig.enabled));
        });
        Button.Builder confrmButton = new Button.Builder((Component)Component.translatable((String)"customcursor.edit.confirm"), this::confirm);
        Button.Builder cancelButton = new Button.Builder((Component)Component.translatable((String)"customcursor.edit.cancel"), f -> this.onClose());
        Button.Builder folderButton = new Button.Builder((Component)Component.translatable((String)"customcursor.edit.folder"), b -> FolderTextureAskList.ask(new FolderTextureAskList(CustomCursorInit.getTextureFolder(), this::setIdentifier)));
        int rowSize = 24;
        int columnSize = 128;
        int rowCount = 6;
        int columnCount = 2;
        int startColumnPos = this.centerX - columnCount * columnSize / 2;
        int startRowPos = this.centerY - rowCount * rowSize;
        int[] rows = new int[rowCount];
        int[] columns = new int[columnCount];
        int padding = 2;
        int sizePadding = padding * 2;
        for (i = 0; i < rowCount; ++i) {
            rows[i] = startRowPos + rowSize * i + padding;
        }
        for (i = 0; i < columnCount; ++i) {
            columns[i] = startColumnPos + columnSize * i + padding;
        }
        int columnSizePadding = columnSize - sizePadding;
        int twoColumnSizePadding = columnSize * 2 - sizePadding;
        int rowSizePadding = rowSize - sizePadding;
        toggleWidget = toggleWidget.bounds(columns[0], rows[0], twoColumnSizePadding, rowSizePadding);
        folderButton = folderButton.bounds(columns[0], rows[3], twoColumnSizePadding, rowSizePadding);
        confrmButton = confrmButton.bounds(columns[0], rows[5], columnSizePadding, rowSizePadding);
        cancelButton = cancelButton.bounds(columns[1], rows[5], columnSizePadding, rowSizePadding);
        double maxsize = 256.0;
        EditBox imagePathField = new EditBox(this.minecraft.font, columns[0], rows[4], twoColumnSizePadding, rowSizePadding, (Component)Component.empty());
        SliderWidget sizeSlider = new SliderWidget(columns[0], rows[1], twoColumnSizePadding, rowSizePadding, (Component)Component.translatable((String)"customcursor.edit.size"), this.targetConfig.size, 0.0, maxsize, 256);
        SliderWidget xPosSlider = new SliderWidget(columns[0], rows[2], columnSizePadding, rowSizePadding, (Component)Component.translatable((String)"customcursor.edit.x"), this.targetConfig.x, 0.0, 1.0, 64);
        SliderWidget yPosSlider = new SliderWidget(columns[1], rows[2], columnSizePadding, rowSizePadding, (Component)Component.translatable((String)"customcursor.edit.y"), this.targetConfig.y, 0.0, 1.0, 64);
        xPosSlider.setChangedListener(d -> {
            this.targetConfig.x = (float)d.doubleValue();
        });
        yPosSlider.setChangedListener(d -> {
            this.targetConfig.y = (float)d.doubleValue();
        });
        sizeSlider.setChangedListener(d -> {
            this.targetConfig.size = (int)d.doubleValue();
        });
        imagePathField.setMaxLength(512);
        imagePathField.setValue(this.targetConfig.identifier.toString());
        imagePathField.setResponder(s -> {
            try {
                this.setIdentifier(ResourceLocation.tryParse((String)s));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        this.addRenderableWidget((GuiEventListener)toggleWidget.build());
        this.addRenderableWidget((GuiEventListener)confrmButton.build());
        this.addRenderableWidget((GuiEventListener)cancelButton.build());
        this.addRenderableWidget((GuiEventListener)folderButton.build());
        this.addRenderableWidget((GuiEventListener)imagePathField);
        this.addRenderableWidget((GuiEventListener)sizeSlider);
        this.addRenderableWidget((GuiEventListener)xPosSlider);
        this.addRenderableWidget((GuiEventListener)yPosSlider);
        this.addRenderableOnly(this::renderCheckerboard);
        this.addRenderableOnly(this::renderPreview);
    }

    private void setIdentifier(ResourceLocation identifier) {
        this.targetConfig.identifier = identifier;
    }

    private void confirm(Button buttonWidget) {
        try {
            this.onSuccess.accept(this.targetConfig);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.onClose();
    }

    private void renderPreview(GuiGraphics context, int mouseX, int mouseY, float delta) {
        VersionFunctions.drawTexture(context, this.targetConfig.identifier, this.previewPosX, this.previewPosY, 0.0f, 0.0f, 128, 128, 128, 128);
        VersionFunctions.drawTexture(context, ResourceLocation.fromNamespaceAndPath((String)"customcursor", (String)"textures/gui/pointer.png"), (int)((float)this.previewPosX + this.targetConfig.x * 128.0f) - 4, (int)((float)this.previewPosY + this.targetConfig.y * 128.0f) - 4, 0.0f, 0.0f, 8, 8, 8, 8);
    }

    private void renderCheckerboard(GuiGraphics context, int mouseX, int mouseY, float delta) {
        this.color += delta * 0.05f;
        int n = 2;
        int color1 = ARGB.color((int)255, (int)((int)(128.0 + 64.0 * Math.pow(Math.sin((double)this.color + 0.0), n))), (int)((int)(128.0 + 64.0 * Math.pow(Math.sin((double)this.color + 2.0943951023931953), n))), (int)((int)(128.0 + 64.0 * Math.pow(Math.sin((double)this.color + 4.1887902047863905), n))));
        int color2 = ARGB.color((int)255, (int)((int)(192.0 + 63.0 * Math.pow(Math.cos((double)this.color + 0.0), n))), (int)((int)(192.0 + 63.0 * Math.pow(Math.cos((double)this.color + 2.0943951023931953), n))), (int)((int)(192.0 + 63.0 * Math.pow(Math.cos((double)this.color + 4.1887902047863905), n))));
        float r = (float)ARGB.red((int)color1) / 255.0f;
        float g = (float)ARGB.green((int)color1) / 255.0f;
        float b = (float)ARGB.blue((int)color1) / 255.0f;
        Vec2 vec = new Vec2((float)mouseX - ((float)this.previewPosX + 64.0f), (float)mouseY - ((float)this.previewPosY + 64.0f)).normalized().scale(delta);
        this.bgx += vec.x;
        this.bgy += vec.y;
        context.fill(this.previewPosX, this.previewPosY, this.previewPosX + 128, this.previewPosY + 128, color2);
        context.enableScissor(this.previewPosX, this.previewPosY, this.previewPosX + 128, this.previewPosY + 128);
        int cellsize = 16;
        context.pose().pushPose();
        context.pose().translate((float)this.previewPosX + Mth.positiveModulo((float)this.bgx, (float)cellsize) - (float)cellsize, (float)this.previewPosY + Mth.positiveModulo((float)this.bgy, (float)cellsize) - (float)cellsize, 0.0f);
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)255.0f);
        int checkerRenderSize = 128 + cellsize;
        VersionFunctions.drawTexture(context, ResourceLocation.fromNamespaceAndPath((String)"customcursor", (String)"textures/gui/backgroundcheckerboard.png"), 0, 0, 0.0f, 0.0f, checkerRenderSize, checkerRenderSize, checkerRenderSize, checkerRenderSize);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        context.pose().popPose();
        context.disableScissor();
    }

    public static CursorEditScreen createCursorEditScreen(Screen parent) {
        return new CursorEditScreen(parent, CustomCursorInit.getConfig().pointer, c -> {
            CursorConfigStorage cfg = new CursorConfigStorage();
            cfg.pointer = c;
            CustomCursorInit.setConfig(cfg);
        });
    }
}

