/*
 * Decompiled with CFR 0.152.
 */
package io.github.jumperonjava.customcursor.editor;

import io.github.jumperonjava.customcursor.CursorConfigStorage;
import io.github.jumperonjava.customcursor.CursorSettings;
import io.github.jumperonjava.customcursor.CustomCursorInit;
import io.github.jumperonjava.customcursor.editor.BackgroundCheckerboard;
import io.github.jumperonjava.customcursor.editor.FolderTextureAskList;
import io.github.jumperonjava.customcursor.editor.PreviewWidget;
import io.github.jumperonjava.customcursor.editor.SliderWidget;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class CursorEditScreen
extends Screen {
    private final Consumer<CursorSettings> onSuccess;
    private final CursorSettings targetConfig;
    private final Screen parent;
    private CursorSettings.CursorSprite targetCursor;
    private PreviewWidget previewWidget;
    private int centerX;
    private int centerY;
    float time = 0.0f;

    public CursorEditScreen(Screen parent, CursorSettings cursorConfig, Consumer<CursorSettings> onSuccess) {
        super((Component)Component.m_237119_());
        this.parent = parent;
        this.onSuccess = onSuccess;
        this.targetConfig = cursorConfig.clone();
        this.targetCursor = this.targetConfig.arrow;
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    protected void m_7856_() {
        int i;
        this.centerX = this.f_96543_ / 2;
        this.centerY = this.f_96544_ / 2;
        super.m_7856_();
        Function<Boolean, Component> enableText = b -> Component.m_237115_((String)("customcursor.edit.enabled." + b));
        Button.Builder toggleWidget = new Button.Builder(enableText.apply(this.targetConfig.enabled), buttonWidget -> {
            this.targetConfig.enabled = !this.targetConfig.enabled;
            buttonWidget.m_93666_((Component)enableText.apply(this.targetConfig.enabled));
        });
        Function<Boolean, Component> dynamicText = b -> Component.m_237115_((String)("customcursor.edit.dynamic." + b));
        Button.Builder dynmicWidget = new Button.Builder(dynamicText.apply(this.targetConfig.dynamicEnabled), buttonWidget -> {
            boolean bl = this.targetConfig.dynamicEnabled = !this.targetConfig.dynamicEnabled;
            if (!this.targetConfig.dynamicEnabled) {
                this.targetCursor = this.targetConfig.arrow;
            }
            buttonWidget.m_93666_((Component)dynamicText.apply(this.targetConfig.dynamicEnabled));
        });
        Button.Builder save__Button = new Button.Builder((Component)Component.m_237115_((String)"customcursor.edit.save"), this::save);
        Button.Builder cancelButton = new Button.Builder((Component)Component.m_237115_((String)"customcursor.edit.exit"), f -> this.m_7379_());
        Button.Builder folderButton = new Button.Builder((Component)Component.m_237115_((String)"customcursor.edit.folder"), b -> FolderTextureAskList.ask(new FolderTextureAskList(CustomCursorInit.getTextureFolder(), this::setIdentifier)));
        int rowSize = 24;
        int columnSize = 128;
        int rowCount = 4;
        int columnCount = 2;
        int previewSize = 128;
        int startColumnPos = this.centerX - columnCount * columnSize / 2;
        int startRowPos = this.centerY - (rowCount * rowSize + previewSize) / 2;
        int[] rows = new int[100];
        int[] columns = new int[columnCount];
        int padding = 2;
        int sizePadding = padding * 2;
        for (i = 0; i < 100; ++i) {
            rows[i] = startRowPos + rowSize * i + padding;
        }
        for (i = 0; i < columnCount; ++i) {
            columns[i] = startColumnPos + columnSize * i + padding;
        }
        int columnSizePadding = columnSize - sizePadding;
        int twoColumnSizePadding = columnSize * 2 - sizePadding;
        int rowSizePadding = rowSize - sizePadding;
        int previewPosX = (this.f_96543_ - previewSize) / 2;
        int previewPosY = rows[rowCount];
        toggleWidget = toggleWidget.m_252987_(columns[0], rows[0], twoColumnSizePadding, rowSizePadding);
        dynmicWidget = dynmicWidget.m_252987_(10000, 10000, 20, 20);
        folderButton = folderButton.m_252987_(columns[0] + twoColumnSizePadding - rowSizePadding, rows[2], rowSizePadding, rowSizePadding);
        save__Button = save__Button.m_252987_(columns[0], rows[3], columnSizePadding, rowSizePadding);
        cancelButton = cancelButton.m_252987_(columns[1], rows[3], columnSizePadding, rowSizePadding);
        double maxsize = 256.0;
        EditBox imagePathField = new EditBox(this.f_96541_.f_91062_, columns[0], rows[2], twoColumnSizePadding - rowSize, rowSizePadding, (Component)Component.m_237119_());
        SliderWidget sizeSlider = new SliderWidget(columns[0], rows[1], twoColumnSizePadding, rowSizePadding, (Component)Component.m_237115_((String)"customcursor.edit.size"), this.targetConfig.size, 0.0, maxsize, 256);
        SliderWidget xPosSlider = new SliderWidget(columns[0], rows[2], columnSizePadding, rowSizePadding, (Component)Component.m_237115_((String)"customcursor.edit.x"), this.targetCursor.x, 0.0, 1.0, 64);
        SliderWidget yPosSlider = new SliderWidget(columns[1], rows[2], columnSizePadding, rowSizePadding, (Component)Component.m_237115_((String)"customcursor.edit.y"), this.targetCursor.y, 0.0, 1.0, 64);
        xPosSlider.setChangedListener(d -> {
            this.targetCursor.x = (float)d.doubleValue();
        });
        yPosSlider.setChangedListener(d -> {
            this.targetCursor.y = (float)d.doubleValue();
        });
        sizeSlider.setChangedListener(d -> {
            this.targetConfig.size = (int)d.doubleValue();
        });
        imagePathField.m_94199_(512);
        imagePathField.m_94144_(this.targetCursor.identifier.toString());
        imagePathField.m_94151_(s -> {
            try {
                this.setIdentifier(ResourceLocation.m_135820_((String)s));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        this.m_142416_((GuiEventListener)toggleWidget.m_253136_());
        this.m_142416_((GuiEventListener)dynmicWidget.m_253136_());
        this.m_142416_((GuiEventListener)save__Button.m_253136_());
        this.m_142416_((GuiEventListener)cancelButton.m_253136_());
        this.m_142416_((GuiEventListener)folderButton.m_253136_());
        this.m_142416_((GuiEventListener)imagePathField);
        this.m_142416_((GuiEventListener)sizeSlider);
        this.previewWidget = new PreviewWidget("", this.targetCursor, previewPosX, previewPosY, previewSize, (x, y) -> {
            x = (double)Math.round(x * 16.0) / 16.0;
            y = (double)Math.round(y * 16.0) / 16.0;
            xPosSlider.m_93611_((double)x);
            yPosSlider.m_93611_((double)y);
        });
        Object ref = new Object(){
            int count = 0;
        };
        Button.Builder rotateCCW_builder = new Button.Builder((Component)Component.m_237113_((String)"\u27f3"), buttonWidget -> {
            this.targetCursor.rotation += 90.0f;
            if (this.targetCursor.rotation >= 360.0f) {
                this.targetCursor.rotation -= 360.0f;
            }
        });
        Button.Builder rotateCW_builder = new Button.Builder((Component)Component.m_237113_((String)"\u27f2 "), buttonWidget -> {
            this.targetCursor.rotation -= 90.0f;
            if (this.targetCursor.rotation < 0.0f) {
                this.targetCursor.rotation += 360.0f;
            }
        });
        Button.Builder mirror_builder = new Button.Builder((Component)Component.m_237113_((String)"|"), buttonWidget -> {
            if (this.targetCursor.rotation == 0.0f || this.targetCursor.rotation == 180.0f) {
                boolean bl = this.targetCursor.mirroredX = !this.targetCursor.mirroredX;
            }
            if (this.targetCursor.rotation == 90.0f || this.targetCursor.rotation == 270.0f) {
                this.targetCursor.mirroredY = !this.targetCursor.mirroredY;
            }
        });
        rotateCW_builder.m_252987_(previewPosX - 24, previewPosY + previewSize / 2 - 12, 22, 22);
        rotateCCW_builder.m_252987_(previewPosX + 2 + previewSize, previewPosY + previewSize / 2 - 12, 22, 22);
        mirror_builder.m_252987_(previewPosX + previewSize / 2 - 11, previewPosY + previewSize + 2, 22, 22);
        this.m_142416_((GuiEventListener)rotateCCW_builder.m_253136_());
        this.m_142416_((GuiEventListener)rotateCW_builder.m_253136_());
        this.m_142416_((GuiEventListener)mirror_builder.m_253136_());
        this.m_169394_(new BackgroundCheckerboard(this, previewPosX, previewPosY, previewSize));
        this.m_142416_(this.previewWidget);
        this.m_169394_(this::testcursor);
    }

    private void testcursor(GuiGraphics context, int mouseX, int mouseY, float delta) {
    }

    private void setIdentifier(ResourceLocation identifier) {
        this.targetCursor.identifier = identifier;
    }

    private void save(Button buttonWidget) {
        try {
            this.onSuccess.accept(this.targetConfig);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void dynamic(Button buttonWidget) {
        this.targetConfig.dynamicEnabled = !this.targetConfig.dynamicEnabled;
    }

    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        this.m_280273_(context);
        super.m_88315_(context, mouseX, mouseY, delta);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        this.previewWidget.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public static CursorEditScreen createCursorEditScreen(Screen parent) {
        return new CursorEditScreen(parent, CustomCursorInit.getConfig().settings, c -> {
            CursorConfigStorage cfg = new CursorConfigStorage();
            cfg.settings = c.clone();
            CustomCursorInit.setConfig(cfg);
        });
    }
}

