/*
 * Decompiled with CFR 0.152.
 */
package io.github.jumperonjava.customcursor.editor;

import io.github.jumperonjava.customcursor.CursorSettings;
import io.github.jumperonjava.customcursor.util.VersionFunctions;
import java.util.function.BiConsumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.resources.ResourceLocation;

public class PreviewWidget
implements Renderable,
GuiEventListener,
NarratableEntry {
    private final String key;
    private final int x;
    private final int y;
    private final int size;
    private final BiConsumer<Double, Double> callback;
    private CursorSettings.CursorSprite sprite;
    boolean focused = false;

    public PreviewWidget(String key, CursorSettings.CursorSprite sprite, int x, int y, int size, BiConsumer<Double, Double> callback) {
        this.key = key;
        this.sprite = sprite;
        this.x = x;
        this.y = y;
        this.size = size;
        this.callback = callback;
    }

    boolean update(double mouseX, double mouseY) {
        if (this.m_5953_(mouseX, mouseY)) {
            this.callback.accept((mouseX - (double)this.x) / (double)this.size, (mouseY - (double)this.y) / (double)this.size);
            return true;
        }
        return false;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return this.update(mouseX, mouseY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return this.update(mouseX, mouseY);
    }

    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        VersionFunctions.pushMatrix(context);
        VersionFunctions.rotateAbout(context, (float)Math.toRadians(this.sprite.rotation), (float)this.x + (float)this.size / 2.0f, (float)this.y + (float)this.size / 2.0f);
        VersionFunctions.drawTexture(context, this.sprite.identifier, this.x, this.y, 0.0f, 0.0f, this.size, this.size, this.size * (this.sprite.mirroredX ? -1 : 1), this.size * (this.sprite.mirroredY ? -1 : 1));
        VersionFunctions.popMatrix(context);
        VersionFunctions.drawTexture(context, ResourceLocation.m_214293_((String)"customcursor", (String)"textures/gui/pointer.png"), (int)((float)this.x + this.sprite.x * (float)this.size) - 4, (int)((float)this.y + this.sprite.y * (float)this.size) - 4, 0.0f, 0.0f, 8, 8, 8, 8);
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        int minx = this.x;
        int maxx = this.x + this.size;
        int miny = this.y;
        int maxy = this.y + this.size;
        return mouseX >= (double)minx && mouseX < (double)maxx && mouseY >= (double)miny && mouseY < (double)maxy;
    }

    public void m_93692_(boolean focused) {
        this.focused = focused;
    }

    public boolean m_93696_() {
        return this.focused;
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.FOCUSED;
    }

    public void m_142291_(NarrationElementOutput builder) {
    }

    public void setSprite(CursorSettings.CursorSprite value) {
        this.sprite = value;
    }
}

