/*
 * Decompiled with CFR 0.152.
 */
package io.github.jumperonjava.customcursor.util;

import io.github.jumperonjava.customcursor.util.TextureWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ScrollListWidget
extends ObjectSelectionList<ScrollListEntry> {
    public ScrollListWidget(Minecraft client, int width, int height, int x, int y, int itemHeight) {
        super(client, width, height, y, itemHeight);
    }

    public int getRowWidth() {
        return this.width;
    }

    public int addEntry(ScrollListEntry entry) {
        return super.addEntry((AbstractSelectionList.Entry)entry);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void renderWidget(GuiGraphics context, int mouseX, int mouseY, float delta) {
        context.enableScissor(this.getX(), this.getY(), this.getX() + this.width, this.getBottom());
        super.renderWidget(context, mouseX, mouseY, delta);
        context.disableScissor();
    }

    public static class ScrollListEntry
    extends ObjectSelectionList.Entry<ScrollListEntry> {
        private final ResourceLocation key;
        private final Runnable event;

        public ScrollListEntry(ResourceLocation key, Runnable onClick) {
            this.key = key;
            this.event = onClick;
        }

        public void render(GuiGraphics context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float delta) {
            TextureWidget.render(context, this.key, x, y, entryHeight, entryHeight);
            context.drawString(Minecraft.getInstance().font, this.key.toString(), x + entryHeight + 5, y + entryHeight / 2 - 5, -1, true);
        }

        public Component getNarration() {
            return Component.literal((String)this.key.toString());
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            boolean b = super.mouseClicked(mouseX, mouseY, button);
            if (this.isMouseOver(mouseX, mouseY)) {
                this.event.run();
                return true;
            }
            return b;
        }
    }
}

