/*
 * Decompiled with CFR 0.152.
 */
package io.github.jumperonjava.customcursor.editor;

import java.util.function.Consumer;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class SliderWidget
extends AbstractSliderButton {
    private final int steps;
    private Consumer<Double> changedListener;
    private Component text;
    public double min;
    public double max;

    public SliderWidget(int x, int y, int width, int height, Component text, double initialValue, double minValue, double maxValue, int steps) {
        super(x, y, width, height, text, Mth.map((double)initialValue, (double)minValue, (double)maxValue, (double)0.0, (double)1.0));
        this.min = minValue;
        this.max = maxValue;
        this.text = text;
        this.steps = steps;
        this.updateMessage();
    }

    public void updateMessage() {
        double mappedValue = this.getMappedValue();
        String stringValue = mappedValue == (double)((int)mappedValue) ? String.valueOf((int)mappedValue) : String.valueOf(mappedValue);
        this.setMessage((Component)this.text.copy().append(" ").append(stringValue));
    }

    private double getMappedValue() {
        double value = this.value;
        value = Math.floor(value * (double)this.steps) / (double)this.steps;
        value = Mth.lerp((double)value, (double)this.min, (double)this.max);
        return value;
    }

    protected void applyValue() {
        if (this.changedListener == null) {
            return;
        }
        this.changedListener.accept(this.getMappedValue());
    }

    public void setChangedListener(Consumer<Double> changedListener) {
        this.changedListener = changedListener;
    }
}

