/*
 * Decompiled with CFR 0.152.
 */
package io.github.jumperonjava.customcursor;

import com.mojang.blaze3d.platform.cursor.CursorType;
import io.github.jumperonjava.customcursor.CursorSettings;
import io.github.jumperonjava.customcursor.CustomCursorInit;
import io.github.jumperonjava.customcursor.util.VersionFunctions;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.ResourceLocation;
import org.lwjgl.glfw.GLFW;

public class CursorRenderer {
    public static void render(GuiGraphics context, double mouseX, double mouseY, float donotuse_delta) {
        CursorSettings config = CustomCursorInit.getConfig().settings;
        if (Minecraft.getInstance().screen == null) {
            return;
        }
        if (!config.enabled) {
            GLFW.glfwSetInputMode((long)Minecraft.getInstance().getWindow().handle(), (int)208897, (int)212993);
            return;
        }
        int scale = Minecraft.getInstance().getWindow().getGuiScale();
        CursorSettings.CursorSprite sprite = config.arrow;
        CursorType contextCursor = context.pendingCursor;
        sprite = config.cursorToSprite(contextCursor);
        ResourceLocation identifier = sprite.identifier;
        mouseX = (float)Minecraft.getInstance().mouseHandler.xpos();
        mouseY = (float)Minecraft.getInstance().mouseHandler.ypos();
        int x = (int)Math.round(mouseX - (double)((float)config.size * sprite.x));
        int y = (int)Math.round(mouseY - (double)((float)config.size * sprite.y));
        float u = 0.0f;
        float v = 0.0f;
        int width = config.size;
        int height = config.size;
        int textureWidth = config.size;
        int textureHeight = config.size;
        VersionFunctions.pushMatrix(context);
        context.pose().scale(1.0f / (float)scale, 1.0f / (float)scale);
        VersionFunctions.rotateAbout(context, (float)Math.toRadians(sprite.rotation), (float)x + (float)textureWidth / 2.0f, (float)y + (float)textureHeight / 2.0f);
        context.blit(RenderPipelines.GUI_TEXTURED, identifier, x, y, u, v, width, height, textureWidth * (sprite.mirroredX ? -1 : 1), textureHeight * (sprite.mirroredY ? -1 : 1));
        VersionFunctions.popMatrix(context);
        GLFW.glfwSetInputMode((long)Minecraft.getInstance().getWindow().handle(), (int)208897, (int)212994);
    }
}

