/*
 * Decompiled with CFR 0.152.
 */
package io.github.jumperonjava.customcursor.editor;

import io.github.jumperonjava.customcursor.CursorConfigStorage;
import io.github.jumperonjava.customcursor.CursorSettings;
import io.github.jumperonjava.customcursor.CustomCursorInit;
import io.github.jumperonjava.customcursor.editor.BackgroundCheckerboard;
import io.github.jumperonjava.customcursor.editor.CursorWidget;
import io.github.jumperonjava.customcursor.editor.FolderTextureAskList;
import io.github.jumperonjava.customcursor.editor.PreviewWidget;
import io.github.jumperonjava.customcursor.editor.SliderWidget;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class CursorEditScreen
extends Screen {
    private final Consumer<CursorSettings> onSuccess;
    private final CursorSettings targetConfig;
    private final Screen parent;
    private CursorSettings.CursorSprite targetCursor;
    private PreviewWidget previewWidget;
    private int centerX;
    private int centerY;
    float time = 0.0f;

    public CursorEditScreen(Screen parent, CursorSettings cursorConfig, Consumer<CursorSettings> onSuccess) {
        super((Component)Component.empty());
        this.parent = parent;
        this.onSuccess = onSuccess;
        this.targetConfig = cursorConfig.clone();
        this.targetCursor = this.targetConfig.arrow;
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    protected void init() {
        int i;
        this.centerX = this.width / 2;
        this.centerY = this.height / 2;
        super.init();
        Function<Boolean, Component> enableText = b -> Component.translatable((String)("customcursor.edit.enabled." + b));
        Button.Builder toggleWidget = new Button.Builder(enableText.apply(this.targetConfig.enabled), buttonWidget -> {
            this.targetConfig.enabled = !this.targetConfig.enabled;
            buttonWidget.setMessage((Component)enableText.apply(this.targetConfig.enabled));
        });
        Function<Boolean, Component> dynamicText = b -> Component.translatable((String)("customcursor.edit.dynamic." + b));
        Button.Builder dynmicWidget = new Button.Builder(dynamicText.apply(this.targetConfig.dynamicEnabled), buttonWidget -> {
            boolean bl = this.targetConfig.dynamicEnabled = !this.targetConfig.dynamicEnabled;
            if (!this.targetConfig.dynamicEnabled) {
                this.targetCursor = this.targetConfig.arrow;
            }
            buttonWidget.setMessage((Component)dynamicText.apply(this.targetConfig.dynamicEnabled));
        });
        Button.Builder save__Button = new Button.Builder((Component)Component.translatable((String)"customcursor.edit.save"), this::save);
        Button.Builder cancelButton = new Button.Builder((Component)Component.translatable((String)"customcursor.edit.exit"), f -> this.onClose());
        Button.Builder folderButton = new Button.Builder((Component)Component.translatable((String)"customcursor.edit.folder"), b -> FolderTextureAskList.ask(new FolderTextureAskList(CustomCursorInit.getTextureFolder(), this::setIdentifier)));
        int rowSize = 24;
        int columnSize = 128;
        int rowCount = 4;
        int columnCount = 2;
        int previewSize = 128;
        int startColumnPos = this.centerX - columnCount * columnSize / 2;
        int startRowPos = this.centerY - (rowCount * rowSize + previewSize) / 2;
        int[] rows = new int[100];
        int[] columns = new int[columnCount];
        int padding = 2;
        int sizePadding = padding * 2;
        for (i = 0; i < 100; ++i) {
            rows[i] = startRowPos + rowSize * i + padding;
        }
        for (i = 0; i < columnCount; ++i) {
            columns[i] = startColumnPos + columnSize * i + padding;
        }
        int columnSizePadding = columnSize - sizePadding;
        int twoColumnSizePadding = columnSize * 2 - sizePadding;
        int rowSizePadding = rowSize - sizePadding;
        int previewPosX = (this.width - previewSize) / 2;
        int previewPosY = rows[rowCount];
        toggleWidget = toggleWidget.bounds(columns[0], rows[0], columnSizePadding, rowSizePadding);
        dynmicWidget = dynmicWidget.bounds(columns[1], rows[0], columnSizePadding, rowSizePadding);
        folderButton = folderButton.bounds(columns[0] + twoColumnSizePadding - rowSizePadding, rows[2], rowSizePadding, rowSizePadding);
        save__Button = save__Button.bounds(columns[0], rows[3], columnSizePadding, rowSizePadding);
        cancelButton = cancelButton.bounds(columns[1], rows[3], columnSizePadding, rowSizePadding);
        double maxsize = 256.0;
        EditBox imagePathField = new EditBox(this.minecraft.font, columns[0], rows[2], twoColumnSizePadding - rowSize, rowSizePadding, (Component)Component.empty());
        SliderWidget sizeSlider = new SliderWidget(columns[0], rows[1], twoColumnSizePadding, rowSizePadding, (Component)Component.translatable((String)"customcursor.edit.size"), this.targetConfig.size, 0.0, maxsize, 256);
        SliderWidget xPosSlider = new SliderWidget(columns[0], rows[2], columnSizePadding, rowSizePadding, (Component)Component.translatable((String)"customcursor.edit.x"), this.targetCursor.x, 0.0, 1.0, 64);
        SliderWidget yPosSlider = new SliderWidget(columns[1], rows[2], columnSizePadding, rowSizePadding, (Component)Component.translatable((String)"customcursor.edit.y"), this.targetCursor.y, 0.0, 1.0, 64);
        xPosSlider.setChangedListener(d -> {
            this.targetCursor.x = (float)d.doubleValue();
        });
        yPosSlider.setChangedListener(d -> {
            this.targetCursor.y = (float)d.doubleValue();
        });
        sizeSlider.setChangedListener(d -> {
            this.targetConfig.size = (int)d.doubleValue();
        });
        imagePathField.setMaxLength(512);
        imagePathField.setValue(this.targetCursor.identifier.toString());
        imagePathField.setResponder(s -> {
            try {
                this.setIdentifier(ResourceLocation.tryParse((String)s));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        this.addRenderableWidget((GuiEventListener)toggleWidget.build());
        this.addRenderableWidget((GuiEventListener)dynmicWidget.build());
        this.addRenderableWidget((GuiEventListener)save__Button.build());
        this.addRenderableWidget((GuiEventListener)cancelButton.build());
        this.addRenderableWidget((GuiEventListener)folderButton.build());
        this.addRenderableWidget((GuiEventListener)imagePathField);
        this.addRenderableWidget((GuiEventListener)sizeSlider);
        this.previewWidget = new PreviewWidget("", this.targetCursor, previewPosX, previewPosY, previewSize, (x, y) -> {
            x = (double)Math.round(x * 16.0) / 16.0;
            y = (double)Math.round(y * 16.0) / 16.0;
            xPosSlider.setValue((double)x);
            yPosSlider.setValue((double)y);
        });
        Object ref = new Object(this){
            int count = 0;
        };
        CursorSettings.cursorOrder.forEach(arg_0 -> this.lambda$init$13(ref, startColumnPos, padding, rows, xPosSlider, yPosSlider, imagePathField, arg_0));
        Button.Builder rotateCCW_builder = new Button.Builder((Component)Component.literal((String)"\u27f3"), buttonWidget -> {
            this.targetCursor.rotation += 90.0f;
            if (this.targetCursor.rotation >= 360.0f) {
                this.targetCursor.rotation -= 360.0f;
            }
        });
        Button.Builder rotateCW_builder = new Button.Builder((Component)Component.literal((String)"\u27f2 "), buttonWidget -> {
            this.targetCursor.rotation -= 90.0f;
            if (this.targetCursor.rotation < 0.0f) {
                this.targetCursor.rotation += 360.0f;
            }
        });
        Button.Builder mirror_builder = new Button.Builder((Component)Component.literal((String)"|"), buttonWidget -> {
            if (this.targetCursor.rotation == 0.0f || this.targetCursor.rotation == 180.0f) {
                boolean bl = this.targetCursor.mirroredX = !this.targetCursor.mirroredX;
            }
            if (this.targetCursor.rotation == 90.0f || this.targetCursor.rotation == 270.0f) {
                this.targetCursor.mirroredY = !this.targetCursor.mirroredY;
            }
        });
        rotateCW_builder.bounds(previewPosX - 24, previewPosY + previewSize / 2 - 12, 22, 22);
        rotateCCW_builder.bounds(previewPosX + 2 + previewSize, previewPosY + previewSize / 2 - 12, 22, 22);
        mirror_builder.bounds(previewPosX + previewSize / 2 - 11, previewPosY + previewSize + 2, 22, 22);
        this.addRenderableWidget((GuiEventListener)rotateCCW_builder.build());
        this.addRenderableWidget((GuiEventListener)rotateCW_builder.build());
        this.addRenderableWidget((GuiEventListener)mirror_builder.build());
        this.addRenderableOnly(new BackgroundCheckerboard(this, previewPosX, previewPosY, previewSize));
        this.addRenderableWidget(this.previewWidget);
        this.addRenderableOnly(this::testcursor);
    }

    private void testcursor(GuiGraphics context, int mouseX, int mouseY, float delta) {
    }

    private void setIdentifier(ResourceLocation identifier) {
        this.targetCursor.identifier = identifier;
    }

    private void save(Button buttonWidget) {
        try {
            this.onSuccess.accept(this.targetConfig);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void dynamic(Button buttonWidget) {
        this.targetConfig.dynamicEnabled = !this.targetConfig.dynamicEnabled;
    }

    public boolean mouseDragged(MouseButtonEvent click, double offsetX, double offsetY) {
        this.previewWidget.mouseDragged(click, offsetX, offsetY);
        return super.mouseDragged(click, offsetX, offsetY);
    }

    public static CursorEditScreen createCursorEditScreen(Screen parent) {
        return new CursorEditScreen(parent, CustomCursorInit.getConfig().settings, c -> {
            CursorConfigStorage cfg = new CursorConfigStorage();
            cfg.settings = c.clone();
            CustomCursorInit.setConfig(cfg);
        });
    }

    private /* synthetic */ void lambda$init$13(1 ref, int startColumnPos, int padding, int[] rows, SliderWidget xPosSlider, SliderWidget yPosSlider, EditBox imagePathField, String key) {
        CursorSettings.CursorSprite value = this.targetConfig.allCursors().get(key);
        int index = ref.count++;
        int size = 16;
        int left = startColumnPos - size - padding;
        int top = rows[0] + index * (size + padding);
        this.addRenderableWidget(new CursorWidget(key, value, left, top, size, () -> {
            this.targetCursor = value;
            xPosSlider.setValue(value.x);
            yPosSlider.setValue(value.y);
            imagePathField.setValue(value.identifier.toString());
            this.previewWidget.setSprite(value);
        }){

            @Override
            public void render(GuiGraphics context, int mouseX, int mouseY, float deltaTicks) {
                if (!CursorEditScreen.this.targetConfig.dynamicEnabled) {
                    return;
                }
                super.render(context, mouseX, mouseY, deltaTicks);
            }

            @Override
            public boolean mouseClicked(MouseButtonEvent click, boolean doubled) {
                if (!CursorEditScreen.this.targetConfig.dynamicEnabled) {
                    return false;
                }
                return super.mouseClicked(click, doubled);
            }
        });
        this.addRenderableOnly((ctx, x, y, td) -> {
            if (!this.targetConfig.dynamicEnabled) {
                return;
            }
            MutableComponent text = Component.translatable((String)("customcursor.cursortype." + key));
            int width = this.font.width((FormattedText)text);
            ctx.drawString(this.font, (Component)text, left - width - padding, top + 3, -1);
        });
    }
}

