/*
 * Decompiled with CFR 0.152.
 */
package io.github.jumperonjava.customcursor.editor;

import io.github.jumperonjava.customcursor.CursorSettings;
import io.github.jumperonjava.customcursor.util.VersionFunctions;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.input.MouseButtonEvent;

public class CursorWidget
implements Renderable,
GuiEventListener,
NarratableEntry {
    private final String key;
    private final CursorSettings.CursorSprite sprite;
    private final int x;
    private final int y;
    private final int size;
    private final Runnable callback;
    boolean focused = false;

    public CursorWidget(String key, CursorSettings.CursorSprite sprite, int x, int y, int size, Runnable callback) {
        this.key = key;
        this.sprite = sprite;
        this.x = x;
        this.y = y;
        this.size = size;
        this.callback = callback;
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float deltaTicks) {
        context.pose().pushMatrix();
        context.pose().rotateAbout((float)Math.toRadians(this.sprite.rotation), (float)this.x + (float)this.size / 2.0f, (float)this.y + (float)this.size / 2.0f);
        if (this.isMouseOver(mouseX, mouseY)) {
            context.requestCursor(CursorSettings.cursors().get(this.key));
            context.fill(this.x, this.y, this.x + this.size, this.y + this.size, 0x7F000000);
        }
        VersionFunctions.drawTexture(context, this.sprite.identifier, this.x, this.y, 0.0f, 0.0f, this.size, this.size, this.size * (this.sprite.mirroredX ? -1 : 1), this.size * (this.sprite.mirroredY ? -1 : 1));
        context.pose().popMatrix();
    }

    public boolean mouseClicked(MouseButtonEvent click, boolean doubled) {
        if (this.isMouseOver(click.x(), click.y())) {
            this.callback.run();
            return true;
        }
        return false;
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        int minx = this.x;
        int maxx = this.x + this.size;
        int miny = this.y;
        int maxy = this.y + this.size;
        return mouseX >= (double)minx && mouseX < (double)maxx && mouseY >= (double)miny && mouseY < (double)maxy;
    }

    public void setFocused(boolean focused) {
        this.focused = focused;
    }

    public boolean isFocused() {
        return this.focused;
    }

    public NarratableEntry.NarrationPriority narrationPriority() {
        return NarratableEntry.NarrationPriority.FOCUSED;
    }

    public void updateNarration(NarrationElementOutput builder) {
    }
}

