/*
 * Decompiled with CFR 0.152.
 */
package io.github.jumperonjava.customcursor.editor;

import io.github.jumperonjava.customcursor.editor.TextureWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ScrollListWidget
extends ObjectSelectionList<ScrollListEntry> {
    public ScrollListWidget(Minecraft client, int width, int height, int x, int y, int itemHeight) {
        super(client, width, height, y, itemHeight);
    }

    public int getRowWidth() {
        return this.width;
    }

    public int addEntry(ScrollListEntry entry) {
        return super.addEntry((AbstractSelectionList.Entry)entry);
    }

    public void renderWidget(GuiGraphics context, int mouseX, int mouseY, float delta) {
        context.enableScissor(this.getX(), this.getY(), this.getX() + this.width, this.getBottom());
        super.renderWidget(context, mouseX, mouseY, delta);
        context.disableScissor();
    }

    public static class ScrollListEntry
    extends ObjectSelectionList.Entry<ScrollListEntry> {
        private final ResourceLocation key;
        private final Runnable event;

        public ScrollListEntry(ResourceLocation key, Runnable onClick) {
            this.key = key;
            this.event = onClick;
        }

        public void renderContent(GuiGraphics context, int mouseX, int mouseY, boolean hovered, float deltaTicks) {
            int x = this.getX();
            int y = this.getY();
            int entryHeight = this.getContentHeight();
            TextureWidget.render(context, this.key, x, y, entryHeight, entryHeight);
            context.drawString(Minecraft.getInstance().font, this.key.toString(), x + entryHeight + 5, y + entryHeight / 2 - 5, -1, true);
        }

        public Component getNarration() {
            return Component.literal((String)this.key.toString());
        }

        public boolean mouseClicked(MouseButtonEvent click, boolean doubled) {
            boolean b = super.mouseClicked(click, doubled);
            if (this.isMouseOver(click.x(), click.y())) {
                this.event.run();
                return true;
            }
            return b;
        }
    }
}

