/*
 * Decompiled with CFR 0.152.
 */
package io.github.jumperonjava.customcursor.editor;

import io.github.jumperonjava.customcursor.CursorConfigStorage;
import io.github.jumperonjava.customcursor.CursorSettings;
import io.github.jumperonjava.customcursor.CustomCursorInit;
import io.github.jumperonjava.customcursor.editor.BackgroundCheckerboard;
import io.github.jumperonjava.customcursor.editor.FolderTextureAskList;
import io.github.jumperonjava.customcursor.editor.PreviewWidget;
import io.github.jumperonjava.customcursor.editor.SliderWidget;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;

public class CursorEditScreen
extends class_437 {
    private final Consumer<CursorSettings> onSuccess;
    private final CursorSettings targetConfig;
    private final class_437 parent;
    private CursorSettings.CursorSprite targetCursor;
    private PreviewWidget previewWidget;
    private int centerX;
    private int centerY;
    float time = 0.0f;

    public CursorEditScreen(class_437 parent, CursorSettings cursorConfig, Consumer<CursorSettings> onSuccess) {
        super((class_2561)class_2561.method_43473());
        this.parent = parent;
        this.onSuccess = onSuccess;
        this.targetConfig = cursorConfig.clone();
        this.targetCursor = this.targetConfig.arrow;
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    protected void method_25426() {
        int i;
        this.centerX = this.field_22789 / 2;
        this.centerY = this.field_22790 / 2;
        super.method_25426();
        Function<Boolean, class_2561> enableText = b -> class_2561.method_43471((String)("customcursor.edit.enabled." + b));
        class_4185.class_7840 toggleWidget = new class_4185.class_7840(enableText.apply(this.targetConfig.enabled), buttonWidget -> {
            this.targetConfig.enabled = !this.targetConfig.enabled;
            buttonWidget.method_25355((class_2561)enableText.apply(this.targetConfig.enabled));
        });
        Function<Boolean, class_2561> dynamicText = b -> class_2561.method_43471((String)("customcursor.edit.dynamic." + b));
        class_4185.class_7840 dynmicWidget = new class_4185.class_7840(dynamicText.apply(this.targetConfig.dynamicEnabled), buttonWidget -> {
            boolean bl = this.targetConfig.dynamicEnabled = !this.targetConfig.dynamicEnabled;
            if (!this.targetConfig.dynamicEnabled) {
                this.targetCursor = this.targetConfig.arrow;
            }
            buttonWidget.method_25355((class_2561)dynamicText.apply(this.targetConfig.dynamicEnabled));
        });
        class_4185.class_7840 save__Button = new class_4185.class_7840((class_2561)class_2561.method_43471((String)"customcursor.edit.save"), this::save);
        class_4185.class_7840 cancelButton = new class_4185.class_7840((class_2561)class_2561.method_43471((String)"customcursor.edit.exit"), f -> this.method_25419());
        class_4185.class_7840 folderButton = new class_4185.class_7840((class_2561)class_2561.method_43471((String)"customcursor.edit.folder"), b -> FolderTextureAskList.ask(new FolderTextureAskList(CustomCursorInit.getTextureFolder(), this::setIdentifier)));
        int rowSize = 24;
        int columnSize = 128;
        int rowCount = 4;
        int columnCount = 2;
        int previewSize = 128;
        int startColumnPos = this.centerX - columnCount * columnSize / 2;
        int startRowPos = this.centerY - (rowCount * rowSize + previewSize) / 2;
        int[] rows = new int[100];
        int[] columns = new int[columnCount];
        int padding = 2;
        int sizePadding = padding * 2;
        for (i = 0; i < 100; ++i) {
            rows[i] = startRowPos + rowSize * i + padding;
        }
        for (i = 0; i < columnCount; ++i) {
            columns[i] = startColumnPos + columnSize * i + padding;
        }
        int columnSizePadding = columnSize - sizePadding;
        int twoColumnSizePadding = columnSize * 2 - sizePadding;
        int rowSizePadding = rowSize - sizePadding;
        int previewPosX = (this.field_22789 - previewSize) / 2;
        int previewPosY = rows[rowCount];
        toggleWidget = toggleWidget.method_46434(columns[0], rows[0], twoColumnSizePadding, rowSizePadding);
        dynmicWidget = dynmicWidget.method_46434(10000, 10000, 20, 20);
        folderButton = folderButton.method_46434(columns[0] + twoColumnSizePadding - rowSizePadding, rows[2], rowSizePadding, rowSizePadding);
        save__Button = save__Button.method_46434(columns[0], rows[3], columnSizePadding, rowSizePadding);
        cancelButton = cancelButton.method_46434(columns[1], rows[3], columnSizePadding, rowSizePadding);
        double maxsize = 256.0;
        class_342 imagePathField = new class_342(this.field_22787.field_1772, columns[0], rows[2], twoColumnSizePadding - rowSize, rowSizePadding, (class_2561)class_2561.method_43473());
        SliderWidget sizeSlider = new SliderWidget(columns[0], rows[1], twoColumnSizePadding, rowSizePadding, (class_2561)class_2561.method_43471((String)"customcursor.edit.size"), this.targetConfig.size, 0.0, maxsize, 256);
        SliderWidget xPosSlider = new SliderWidget(columns[0], rows[2], columnSizePadding, rowSizePadding, (class_2561)class_2561.method_43471((String)"customcursor.edit.x"), this.targetCursor.x, 0.0, 1.0, 64);
        SliderWidget yPosSlider = new SliderWidget(columns[1], rows[2], columnSizePadding, rowSizePadding, (class_2561)class_2561.method_43471((String)"customcursor.edit.y"), this.targetCursor.y, 0.0, 1.0, 64);
        xPosSlider.setChangedListener(d -> {
            this.targetCursor.x = (float)d.doubleValue();
        });
        yPosSlider.setChangedListener(d -> {
            this.targetCursor.y = (float)d.doubleValue();
        });
        sizeSlider.setChangedListener(d -> {
            this.targetConfig.size = (int)d.doubleValue();
        });
        imagePathField.method_1880(512);
        imagePathField.method_1852(this.targetCursor.identifier.toString());
        imagePathField.method_1863(s -> {
            try {
                this.setIdentifier(class_2960.method_12829((String)s));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        this.method_37063((class_364)toggleWidget.method_46431());
        this.method_37063((class_364)dynmicWidget.method_46431());
        this.method_37063((class_364)save__Button.method_46431());
        this.method_37063((class_364)cancelButton.method_46431());
        this.method_37063((class_364)folderButton.method_46431());
        this.method_37063((class_364)imagePathField);
        this.method_37063((class_364)sizeSlider);
        this.previewWidget = new PreviewWidget("", this.targetCursor, previewPosX, previewPosY, previewSize, (x, y) -> {
            x = (double)Math.round(x * 16.0) / 16.0;
            y = (double)Math.round(y * 16.0) / 16.0;
            xPosSlider.method_25347((double)x);
            yPosSlider.method_25347((double)y);
        });
        Object ref = new Object(){
            int count = 0;
        };
        class_4185.class_7840 rotateCCW_builder = new class_4185.class_7840((class_2561)class_2561.method_43470((String)"\u27f3"), buttonWidget -> {
            this.targetCursor.rotation += 90.0f;
            if (this.targetCursor.rotation >= 360.0f) {
                this.targetCursor.rotation -= 360.0f;
            }
        });
        class_4185.class_7840 rotateCW_builder = new class_4185.class_7840((class_2561)class_2561.method_43470((String)"\u27f2 "), buttonWidget -> {
            this.targetCursor.rotation -= 90.0f;
            if (this.targetCursor.rotation < 0.0f) {
                this.targetCursor.rotation += 360.0f;
            }
        });
        class_4185.class_7840 mirror_builder = new class_4185.class_7840((class_2561)class_2561.method_43470((String)"|"), buttonWidget -> {
            if (this.targetCursor.rotation == 0.0f || this.targetCursor.rotation == 180.0f) {
                boolean bl = this.targetCursor.mirroredX = !this.targetCursor.mirroredX;
            }
            if (this.targetCursor.rotation == 90.0f || this.targetCursor.rotation == 270.0f) {
                this.targetCursor.mirroredY = !this.targetCursor.mirroredY;
            }
        });
        rotateCW_builder.method_46434(previewPosX - 24, previewPosY + previewSize / 2 - 12, 22, 22);
        rotateCCW_builder.method_46434(previewPosX + 2 + previewSize, previewPosY + previewSize / 2 - 12, 22, 22);
        mirror_builder.method_46434(previewPosX + previewSize / 2 - 11, previewPosY + previewSize + 2, 22, 22);
        this.method_37063((class_364)rotateCCW_builder.method_46431());
        this.method_37063((class_364)rotateCW_builder.method_46431());
        this.method_37063((class_364)mirror_builder.method_46431());
        this.method_37060(new BackgroundCheckerboard(this, previewPosX, previewPosY, previewSize));
        this.method_37063(this.previewWidget);
        this.method_37060(this::testcursor);
    }

    private void testcursor(class_332 context, int mouseX, int mouseY, float delta) {
    }

    private void setIdentifier(class_2960 identifier) {
        this.targetCursor.identifier = identifier;
    }

    private void save(class_4185 buttonWidget) {
        try {
            this.onSuccess.accept(this.targetConfig);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void dynamic(class_4185 buttonWidget) {
        this.targetConfig.dynamicEnabled = !this.targetConfig.dynamicEnabled;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context);
        super.method_25394(context, mouseX, mouseY, delta);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        this.previewWidget.method_25403(mouseX, mouseY, button, deltaX, deltaY);
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public static CursorEditScreen createCursorEditScreen(class_437 parent) {
        return new CursorEditScreen(parent, CustomCursorInit.getConfig().settings, c -> {
            CursorConfigStorage cfg = new CursorConfigStorage();
            cfg.settings = c.clone();
            CustomCursorInit.setConfig(cfg);
        });
    }
}

