/*
 * Decompiled with CFR 0.152.
 */
package fuzs.armorquickswap.client.handler;

import com.google.common.collect.Maps;
import fuzs.armorquickswap.client.handler.LocalArmorStandGearHandler;
import fuzs.puzzleslib.api.client.screen.v2.ScreenHelper;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Objects;
import java.util.function.UnaryOperator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class InventoryArmorClickHandler {
    private static final Map<Class<? extends Slot>, UnaryOperator<Slot>> SLOT_CLAZZ_METHOD_HANDLES = Maps.newIdentityHashMap();

    public static EventResult onBeforeMouseClick(AbstractContainerScreen<?> screen, double mouseX, double mouseY, int button) {
        Item item;
        if (button != 1) {
            return EventResult.PASS;
        }
        Slot hoveredSlot = ScreenHelper.INSTANCE.findSlot(screen, mouseX, mouseY);
        if (hoveredSlot != null && (item = hoveredSlot.m_7993_().m_41720_()) instanceof ArmorItem) {
            ArmorItem item2 = (ArmorItem)item;
            Minecraft minecraft = ScreenHelper.INSTANCE.getMinecraft(screen);
            Inventory inventory = minecraft.f_91074_.m_150109_();
            hoveredSlot = InventoryArmorClickHandler.findNestedSlot(hoveredSlot);
            if (hoveredSlot.f_40218_ != inventory) {
                return EventResult.PASS;
            }
            Slot armorSlot = LocalArmorStandGearHandler.findInventorySlot(screen.m_6262_(), item2.m_40402_().m_147068_(inventory.f_35974_.size()));
            if (armorSlot == null) {
                return EventResult.PASS;
            }
            if (!ItemStack.m_150942_((ItemStack)hoveredSlot.m_7993_(), (ItemStack)armorSlot.m_7993_())) {
                if (minecraft.f_91072_.m_105290_()) {
                    InventoryArmorClickHandler.performCreativeItemSwap((Player)minecraft.f_91074_, hoveredSlot, armorSlot);
                } else {
                    minecraft.f_91072_.m_171799_(screen.m_6262_().f_38840_, armorSlot.f_40219_, hoveredSlot.m_150661_(), ClickType.SWAP, (Player)minecraft.f_91074_);
                }
            }
            return EventResult.INTERRUPT;
        }
        return EventResult.PASS;
    }

    private static void performCreativeItemSwap(Player player, Slot hoveredSlot, Slot armorSlot) {
        ItemStack hoveredItem = hoveredSlot.m_7993_();
        ItemStack armorItem = armorSlot.m_7993_();
        player.m_150109_().m_6836_(hoveredSlot.m_150661_(), armorItem.m_41777_());
        player.m_150109_().m_6836_(armorSlot.m_150661_(), hoveredItem.m_41777_());
        player.f_36095_.m_38946_();
    }

    public static Slot findNestedSlot(Slot slot) {
        return InventoryArmorClickHandler.findNestedSlot(slot, 5);
    }

    private static Slot findNestedSlot(Slot slot, int searchDepth) {
        Objects.requireNonNull(slot, "slot is null");
        slot = (Slot)SLOT_CLAZZ_METHOD_HANDLES.computeIfAbsent(slot.getClass(), clazz -> InventoryArmorClickHandler.findNestedSlot(clazz, searchDepth)).apply(slot);
        Objects.requireNonNull(slot, "slot is null");
        return slot;
    }

    private static UnaryOperator<Slot> findNestedSlot(Class<? extends Slot> clazz, int searchDepth) {
        if (searchDepth >= 0 && clazz != Slot.class) {
            for (Field field : clazz.getDeclaredFields()) {
                if (!Slot.class.isAssignableFrom(field.getType()) || clazz.isAssignableFrom(field.getType())) continue;
                field.setAccessible(true);
                try {
                    MethodHandle methodHandle = MethodHandles.lookup().unreflectGetter(field);
                    return innerSlot -> {
                        try {
                            return InventoryArmorClickHandler.findNestedSlot(methodHandle.invoke((Slot)innerSlot), searchDepth - 1);
                        }
                        catch (Throwable e) {
                            throw new RuntimeException(e);
                        }
                    };
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return UnaryOperator.identity();
    }
}

