/*
 * Decompiled with CFR 0.152.
 */
package fuzs.armorquickswap.client.handler;

import fuzs.armorquickswap.client.handler.InventoryArmorClickHandler;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class LocalArmorStandGearHandler {
    public static EventResult onUseInteraction(Minecraft minecraft, LocalPlayer player, InteractionHand interactionHand, HitResult hitResult) {
        Entity entity;
        if (ModLoaderEnvironment.INSTANCE.isModPresentServerside("armorquickswap")) {
            return EventResult.PASS;
        }
        if (hitResult.m_6662_() == HitResult.Type.ENTITY && (entity = ((EntityHitResult)hitResult).m_82443_()) instanceof ArmorStand) {
            ArmorStand armorStand = (ArmorStand)entity;
            if (player.m_6144_()) {
                AbstractContainerMenu containerMenu = player.f_36096_;
                Slot slot = LocalArmorStandGearHandler.findInventorySlot(containerMenu, player.m_150109_().f_35977_);
                if (slot == null) {
                    return EventResult.PASS;
                }
                ItemStack itemStack = slot.m_7993_();
                boolean hasItemInHand = slot.m_6657_();
                if (hasItemInHand) {
                    int selectedItemCount = itemStack.m_41613_();
                    minecraft.f_91072_.m_171799_(containerMenu.f_38840_, slot.f_40219_, 0, ClickType.PICKUP, (Player)player);
                    itemStack.m_41764_(selectedItemCount);
                }
                for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
                    Slot armorSlot;
                    if (!equipmentSlot.m_254934_() || (armorSlot = LocalArmorStandGearHandler.findInventorySlot(containerMenu, equipmentSlot.m_147068_(player.m_150109_().f_35974_.size()))) == null) continue;
                    boolean playerHasArmor = armorSlot.m_6657_();
                    boolean armorStandHasArmor = armorStand.m_21033_(equipmentSlot);
                    if (!playerHasArmor && !armorStandHasArmor) continue;
                    minecraft.f_91072_.m_171799_(containerMenu.f_38840_, armorSlot.f_40219_, slot.m_150661_(), ClickType.SWAP, (Player)player);
                    Vec3 hitVector = hitResult.m_82450_();
                    if (!playerHasArmor) {
                        hitVector = new Vec3(hitVector.m_7096_(), armorStand.m_20186_() + LocalArmorStandGearHandler.getEquipmentClickHeight(equipmentSlot, armorStand.m_31666_()), hitVector.m_7094_());
                    }
                    minecraft.f_91072_.m_105230_((Player)player, (Entity)armorStand, new EntityHitResult((Entity)armorStand, hitVector), interactionHand);
                    LocalArmorStandGearHandler.interactAt(armorStand, (Player)player, hitVector.m_82546_(armorStand.m_20182_()), interactionHand);
                    if (!armorStandHasArmor && minecraft.f_91072_.m_105290_()) {
                        containerMenu.m_38853_(slot.f_40219_).m_269060_(ItemStack.f_41583_);
                        minecraft.f_91072_.m_105241_(ItemStack.f_41583_, slot.f_40219_);
                    }
                    minecraft.f_91072_.m_171799_(containerMenu.f_38840_, armorSlot.f_40219_, slot.m_150661_(), ClickType.SWAP, (Player)player);
                }
                if (hasItemInHand) {
                    minecraft.f_91072_.m_171799_(containerMenu.f_38840_, slot.f_40219_, 0, ClickType.PICKUP, (Player)player);
                }
                player.m_6674_(interactionHand);
                return EventResult.INTERRUPT;
            }
        }
        return EventResult.PASS;
    }

    @Nullable
    public static Slot findInventorySlot(AbstractContainerMenu containerMenu, int slotNum) {
        for (Slot slot : containerMenu.f_38839_) {
            slot = InventoryArmorClickHandler.findNestedSlot(slot);
            if (!(slot.f_40218_ instanceof Inventory) || slot.m_150661_() != slotNum) continue;
            return slot;
        }
        return null;
    }

    private static double getEquipmentClickHeight(EquipmentSlot equipmentSlot, boolean isSmall) {
        return (switch (equipmentSlot) {
            case EquipmentSlot.FEET -> {
                if (isSmall) {
                    yield 0.5;
                }
                yield 0.375;
            }
            case EquipmentSlot.CHEST -> {
                if (isSmall) {
                    yield 1.55;
                }
                yield 1.25;
            }
            case EquipmentSlot.LEGS -> {
                if (isSmall) {
                    yield 0.9;
                }
                yield 0.8;
            }
            case EquipmentSlot.HEAD -> 1.95;
            default -> throw new RuntimeException();
        }) * (isSmall ? 0.5 : 1.0);
    }

    private static InteractionResult interactAt(ArmorStand armorStand, Player player, Vec3 hitVector, InteractionHand interactionHand) {
        ItemStack itemInHand = player.m_21120_(interactionHand);
        if (!armorStand.m_31677_() && !itemInHand.m_150930_(Items.f_42656_)) {
            if (player.m_5833_()) {
                return InteractionResult.SUCCESS;
            }
            EquipmentSlot slot = Mob.m_147233_((ItemStack)itemInHand);
            if (itemInHand.m_41619_()) {
                EquipmentSlot equipmentSlot = LocalArmorStandGearHandler.getClickedSlot(armorStand, hitVector);
                if (armorStand.m_21033_(equipmentSlot) && LocalArmorStandGearHandler.swapItem(armorStand, player, equipmentSlot, itemInHand, interactionHand)) {
                    return InteractionResult.SUCCESS;
                }
            } else {
                if (slot.m_20743_() == EquipmentSlot.Type.HAND && !armorStand.m_31671_()) {
                    return InteractionResult.FAIL;
                }
                if (LocalArmorStandGearHandler.swapItem(armorStand, player, slot, itemInHand, interactionHand)) {
                    return InteractionResult.SUCCESS;
                }
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static EquipmentSlot getClickedSlot(ArmorStand armorStand, Vec3 hitVector) {
        EquipmentSlot equipmentSlot = EquipmentSlot.MAINHAND;
        boolean bl = armorStand.m_31666_();
        double d = bl ? hitVector.f_82480_ * 2.0 : hitVector.f_82480_;
        EquipmentSlot equipmentSlot2 = EquipmentSlot.FEET;
        if (d >= 0.1) {
            double d2 = bl ? 0.8 : 0.45;
            if (d < 0.1 + d2 && armorStand.m_21033_(equipmentSlot2)) {
                return EquipmentSlot.FEET;
            }
        }
        double d3 = bl ? 0.3 : 0.0;
        if (d >= 0.9 + d3) {
            double d4 = bl ? 1.0 : 0.7;
            if (d < 0.9 + d4 && armorStand.m_21033_(EquipmentSlot.CHEST)) {
                return EquipmentSlot.CHEST;
            }
        }
        if (d >= 0.4) {
            double d5 = bl ? 1.0 : 0.8;
            if (d < 0.4 + d5 && armorStand.m_21033_(EquipmentSlot.LEGS)) {
                return EquipmentSlot.LEGS;
            }
        }
        if (d >= 1.6 && armorStand.m_21033_(EquipmentSlot.HEAD)) {
            return EquipmentSlot.HEAD;
        }
        if (armorStand.m_21033_(EquipmentSlot.MAINHAND)) return equipmentSlot;
        if (!armorStand.m_21033_(EquipmentSlot.OFFHAND)) return equipmentSlot;
        return EquipmentSlot.OFFHAND;
    }

    private static boolean swapItem(ArmorStand armorStand, Player player, EquipmentSlot slot, ItemStack stack, InteractionHand hand) {
        ItemStack itemInSlot = armorStand.m_6844_(slot);
        if (player.m_150110_().f_35937_ && itemInSlot.m_41619_() && !stack.m_41619_()) {
            armorStand.m_8061_(slot, stack.m_255036_(1));
            return true;
        }
        if (!stack.m_41619_() && stack.m_41613_() > 1) {
            if (!itemInSlot.m_41619_()) {
                return false;
            }
            armorStand.m_8061_(slot, stack.m_41620_(1));
            return true;
        }
        armorStand.m_8061_(slot, stack);
        player.m_21008_(hand, itemInSlot);
        return true;
    }
}

