/*
 * Decompiled with CFR 0.152.
 */
package fuzs.armorquickswap.client.handler;

import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class LocalArmorStandGearHandler {
    public static EventResult onUseInteraction(Minecraft minecraft, LocalPlayer player, InteractionHand interactionHand, HitResult hitResult) {
        Entity entity;
        if (ModLoaderEnvironment.INSTANCE.isModPresentServerside("armorquickswap")) {
            return EventResult.PASS;
        }
        if (hitResult.getType() == HitResult.Type.ENTITY && (entity = ((EntityHitResult)hitResult).getEntity()) instanceof ArmorStand) {
            ArmorStand armorStand = (ArmorStand)entity;
            if (player.isShiftKeyDown()) {
                AbstractContainerMenu containerMenu = player.containerMenu;
                Slot slot = LocalArmorStandGearHandler.findInventorySlot(containerMenu, player.getInventory().getSelectedSlot());
                if (slot == null) {
                    return EventResult.PASS;
                }
                ItemStack itemStack = slot.getItem();
                boolean hasItemInHand = slot.hasItem();
                if (hasItemInHand) {
                    int selectedItemCount = itemStack.getCount();
                    minecraft.gameMode.handleInventoryMouseClick(containerMenu.containerId, slot.index, 0, ClickType.PICKUP, (Player)player);
                    itemStack.setCount(selectedItemCount);
                }
                for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
                    Slot armorSlot;
                    if (!equipmentSlot.isArmor() || (armorSlot = LocalArmorStandGearHandler.findInventorySlot(containerMenu, equipmentSlot.getIndex(player.getInventory().getNonEquipmentItems().size()))) == null) continue;
                    boolean playerHasArmor = armorSlot.hasItem();
                    boolean armorStandHasArmor = armorStand.hasItemInSlot(equipmentSlot);
                    if (!playerHasArmor && !armorStandHasArmor) continue;
                    minecraft.gameMode.handleInventoryMouseClick(containerMenu.containerId, armorSlot.index, slot.getContainerSlot(), ClickType.SWAP, (Player)player);
                    Vec3 hitVector = hitResult.getLocation();
                    if (!playerHasArmor) {
                        hitVector = new Vec3(hitVector.x(), armorStand.getY() + LocalArmorStandGearHandler.getEquipmentClickHeight(equipmentSlot, armorStand.isSmall()), hitVector.z());
                    }
                    minecraft.gameMode.interactAt((Player)player, (Entity)armorStand, new EntityHitResult((Entity)armorStand, hitVector), interactionHand);
                    LocalArmorStandGearHandler.interactAt(armorStand, (Player)player, hitVector.subtract(armorStand.position()), interactionHand);
                    if (!armorStandHasArmor && minecraft.player.hasInfiniteMaterials()) {
                        containerMenu.getSlot(slot.index).setByPlayer(ItemStack.EMPTY);
                        minecraft.gameMode.handleCreativeModeItemAdd(ItemStack.EMPTY, slot.index);
                    }
                    minecraft.gameMode.handleInventoryMouseClick(containerMenu.containerId, armorSlot.index, slot.getContainerSlot(), ClickType.SWAP, (Player)player);
                }
                if (hasItemInHand) {
                    minecraft.gameMode.handleInventoryMouseClick(containerMenu.containerId, slot.index, 0, ClickType.PICKUP, (Player)player);
                }
                player.swing(interactionHand);
                return EventResult.INTERRUPT;
            }
        }
        return EventResult.PASS;
    }

    @Nullable
    public static Slot findInventorySlot(AbstractContainerMenu containerMenu, int slotNum) {
        for (Slot slot : containerMenu.slots) {
            if (slot instanceof CreativeModeInventoryScreen.SlotWrapper) {
                CreativeModeInventoryScreen.SlotWrapper slotWrapper = (CreativeModeInventoryScreen.SlotWrapper)slot;
                slot = slotWrapper.target;
            }
            if (!(slot.container instanceof Inventory) || slot.getContainerSlot() != slotNum) continue;
            return slot;
        }
        return null;
    }

    private static double getEquipmentClickHeight(EquipmentSlot equipmentSlot, boolean isSmall) {
        return (switch (equipmentSlot) {
            case EquipmentSlot.FEET -> {
                if (isSmall) {
                    yield 0.5;
                }
                yield 0.375;
            }
            case EquipmentSlot.CHEST -> {
                if (isSmall) {
                    yield 1.55;
                }
                yield 1.25;
            }
            case EquipmentSlot.LEGS -> {
                if (isSmall) {
                    yield 0.9;
                }
                yield 0.8;
            }
            case EquipmentSlot.HEAD -> 1.95;
            default -> throw new RuntimeException();
        }) * (isSmall ? 0.5 : 1.0);
    }

    private static InteractionResult interactAt(ArmorStand armorStand, Player player, Vec3 hitVector, InteractionHand interactionHand) {
        ItemStack itemInHand = player.getItemInHand(interactionHand);
        if (!armorStand.isMarker() && !itemInHand.is(Items.NAME_TAG)) {
            if (player.isSpectator()) {
                return InteractionResult.SUCCESS;
            }
            EquipmentSlot slot = player.getEquipmentSlotForItem(itemInHand);
            if (itemInHand.isEmpty()) {
                EquipmentSlot equipmentSlot = LocalArmorStandGearHandler.getClickedSlot(armorStand, hitVector);
                if (armorStand.hasItemInSlot(equipmentSlot) && LocalArmorStandGearHandler.swapItem(armorStand, player, equipmentSlot, itemInHand, interactionHand)) {
                    return InteractionResult.SUCCESS;
                }
            } else {
                if (slot.getType() == EquipmentSlot.Type.HAND && !armorStand.showArms()) {
                    return InteractionResult.FAIL;
                }
                if (LocalArmorStandGearHandler.swapItem(armorStand, player, slot, itemInHand, interactionHand)) {
                    return InteractionResult.SUCCESS;
                }
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static EquipmentSlot getClickedSlot(ArmorStand armorStand, Vec3 hitVector) {
        EquipmentSlot equipmentSlot = EquipmentSlot.MAINHAND;
        boolean bl = armorStand.isSmall();
        double d = bl ? hitVector.y * 2.0 : hitVector.y;
        EquipmentSlot equipmentSlot2 = EquipmentSlot.FEET;
        if (d >= 0.1) {
            double d2 = bl ? 0.8 : 0.45;
            if (d < 0.1 + d2 && armorStand.hasItemInSlot(equipmentSlot2)) {
                return EquipmentSlot.FEET;
            }
        }
        double d3 = bl ? 0.3 : 0.0;
        if (d >= 0.9 + d3) {
            double d4 = bl ? 1.0 : 0.7;
            if (d < 0.9 + d4 && armorStand.hasItemInSlot(EquipmentSlot.CHEST)) {
                return EquipmentSlot.CHEST;
            }
        }
        if (d >= 0.4) {
            double d5 = bl ? 1.0 : 0.8;
            if (d < 0.4 + d5 && armorStand.hasItemInSlot(EquipmentSlot.LEGS)) {
                return EquipmentSlot.LEGS;
            }
        }
        if (d >= 1.6 && armorStand.hasItemInSlot(EquipmentSlot.HEAD)) {
            return EquipmentSlot.HEAD;
        }
        if (armorStand.hasItemInSlot(EquipmentSlot.MAINHAND)) return equipmentSlot;
        if (!armorStand.hasItemInSlot(EquipmentSlot.OFFHAND)) return equipmentSlot;
        return EquipmentSlot.OFFHAND;
    }

    private static boolean swapItem(ArmorStand armorStand, Player player, EquipmentSlot slot, ItemStack stack, InteractionHand hand) {
        ItemStack itemInSlot = armorStand.getItemBySlot(slot);
        if (player.getAbilities().instabuild && itemInSlot.isEmpty() && !stack.isEmpty()) {
            armorStand.setItemSlot(slot, stack.copyWithCount(1));
            return true;
        }
        if (!stack.isEmpty() && stack.getCount() > 1) {
            if (!itemInSlot.isEmpty()) {
                return false;
            }
            armorStand.setItemSlot(slot, stack.split(1));
            return true;
        }
        armorStand.setItemSlot(slot, stack);
        player.setItemInHand(hand, itemInSlot);
        return true;
    }
}

