/*
 * Decompiled with CFR 0.152.
 */
package fuzs.armorquickswap.client.handler;

import fuzs.armorquickswap.client.handler.LocalArmorStandGearHandler;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.Equippable;

public class InventoryArmorClickHandler {
    public static EventResult onBeforeMouseClick(AbstractContainerScreen<?> screen, double mouseX, double mouseY, int button) {
        ItemStack itemStack;
        if (button != 1) {
            return EventResult.PASS;
        }
        Slot hoveredSlot = screen.getHoveredSlot(mouseX, mouseY);
        if (hoveredSlot != null && (itemStack = hoveredSlot.getItem()).has(DataComponents.EQUIPPABLE) && !itemStack.isStackable()) {
            Inventory inventory;
            if (hoveredSlot instanceof CreativeModeInventoryScreen.SlotWrapper) {
                CreativeModeInventoryScreen.SlotWrapper slotWrapper = (CreativeModeInventoryScreen.SlotWrapper)hoveredSlot;
                hoveredSlot = slotWrapper.target;
            }
            if (hoveredSlot.container != (inventory = screen.minecraft.player.getInventory())) {
                return EventResult.PASS;
            }
            int armorSlotIndex = ((Equippable)itemStack.get(DataComponents.EQUIPPABLE)).slot().getIndex(inventory.getNonEquipmentItems().size());
            Slot armorSlot = LocalArmorStandGearHandler.findInventorySlot(screen.getMenu(), armorSlotIndex);
            if (armorSlot != null && !ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)armorSlot.getItem())) {
                InventoryArmorClickHandler.swapInventorySlots(screen.minecraft.gameMode, (Player)screen.minecraft.player, armorSlot, hoveredSlot);
                return EventResult.INTERRUPT;
            }
        }
        return EventResult.PASS;
    }

    private static void swapInventorySlots(MultiPlayerGameMode gameMode, Player player, Slot destinationSlot, Slot clickedSlot) {
        if (player.hasInfiniteMaterials()) {
            InventoryArmorClickHandler.swapCreativeInventorySlots(player, destinationSlot, clickedSlot);
        } else {
            InventoryArmorClickHandler.swapSurvivalInventorySlots(gameMode, player, destinationSlot, clickedSlot);
        }
    }

    private static void swapCreativeInventorySlots(Player player, Slot destinationSlot, Slot clickedSlot) {
        ItemStack hoveredItemStack = clickedSlot.getItem();
        ItemStack armorItemStack = destinationSlot.getItem();
        player.getInventory().setItem(clickedSlot.getContainerSlot(), armorItemStack.copy());
        player.getInventory().setItem(destinationSlot.getContainerSlot(), hoveredItemStack.copy());
        player.inventoryMenu.broadcastChanges();
    }

    private static void swapSurvivalInventorySlots(MultiPlayerGameMode gameMode, Player player, Slot destinationSlot, Slot clickedSlot) {
        if (clickedSlot.getContainerSlot() >= 0 && clickedSlot.getContainerSlot() < Inventory.getSelectionSize()) {
            gameMode.handleInventoryMouseClick(player.containerMenu.containerId, destinationSlot.index, clickedSlot.getContainerSlot(), ClickType.SWAP, player);
        } else {
            gameMode.handleInventoryMouseClick(player.containerMenu.containerId, clickedSlot.index, 0, ClickType.PICKUP, player);
            gameMode.handleInventoryMouseClick(player.containerMenu.containerId, destinationSlot.index, 0, ClickType.PICKUP, player);
            gameMode.handleInventoryMouseClick(player.containerMenu.containerId, clickedSlot.index, 0, ClickType.PICKUP, player);
        }
    }
}

