/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.metro.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.cubexmc.metro.Metro;
import org.cubexmc.metro.lang.LanguageManager;
import org.cubexmc.metro.manager.LineManager;
import org.cubexmc.metro.manager.StopManager;
import org.cubexmc.metro.model.Line;
import org.cubexmc.metro.model.Stop;
import org.cubexmc.metro.util.LocationUtil;

public class MetroAdminCommand
implements CommandExecutor {
    private final Metro plugin;

    public MetroAdminCommand(Metro plugin) {
        this.plugin = plugin;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getLanguageManager().getMessage("plugin.players_only"));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("metro.admin")) {
            player.sendMessage(this.plugin.getLanguageManager().getMessage("plugin.no_permission"));
            return true;
        }
        if (args.length == 0) {
            this.sendHelpMessage(player);
            return true;
        }
        LineManager lineManager = this.plugin.getLineManager();
        StopManager stopManager = this.plugin.getStopManager();
        String mainCommand = args[0].toLowerCase();
        if (mainCommand.equals("line")) {
            String subCommand;
            if (args.length < 2) {
                this.sendLineHelpMessage(player);
                return true;
            }
            switch (subCommand = args[1].toLowerCase()) {
                case "create": {
                    if (args.length < 4) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.usage_create"));
                        return true;
                    }
                    String lineId = args[2];
                    String lineName = args[3];
                    if (lineManager.createLine(lineId, lineName)) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.create_success", LanguageManager.put(LanguageManager.args(), "line_id", lineId)));
                        return true;
                    }
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("line.create_exists", LanguageManager.put(LanguageManager.args(), "line_id", lineId)));
                    return true;
                }
                case "delete": {
                    if (args.length < 3) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.usage_delete"));
                        return true;
                    }
                    String lineId = args[2];
                    if (lineManager.deleteLine(lineId)) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.delete_success", LanguageManager.put(LanguageManager.args(), "line_id", lineId)));
                        return true;
                    }
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("line.delete_not_found", LanguageManager.put(LanguageManager.args(), "line_id", lineId)));
                    return true;
                }
                case "list": {
                    List<Line> lines = lineManager.getAllLines();
                    if (lines.isEmpty()) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.list_empty"));
                        return true;
                    }
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("line.list_header"));
                    for (Line line : lines) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.list_item_format", LanguageManager.put(LanguageManager.put(LanguageManager.args(), "line_name", line.getName()), "line_id", line.getId())));
                    }
                    return true;
                }
                case "setcolor": {
                    if (args.length < 4) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.usage_setcolor"));
                        return true;
                    }
                    String lineId = args[2];
                    String color = args[3];
                    if (lineManager.setLineColor(lineId, color)) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.setcolor_success", LanguageManager.put(LanguageManager.put(LanguageManager.args(), "line_id", lineId), "color", color)));
                        return true;
                    }
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("line.delete_not_found", LanguageManager.put(LanguageManager.args(), "line_id", lineId)));
                    return true;
                }
                case "setterminus": {
                    if (args.length < 3) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.usage_setterminus"));
                        return true;
                    }
                    String lineId = args[2];
                    if (args.length == 3) {
                        if (lineManager.setLineTerminusName(lineId, null)) {
                            player.sendMessage(this.plugin.getLanguageManager().getMessage("line.setterminus_success", LanguageManager.put(LanguageManager.put(LanguageManager.args(), "line_id", lineId), "terminus_name", "")));
                            return true;
                        } else {
                            player.sendMessage(this.plugin.getLanguageManager().getMessage("line.delete_not_found", LanguageManager.put(LanguageManager.args(), "line_id", lineId)));
                        }
                        return true;
                    }
                    String terminusName = args[3];
                    if (lineManager.setLineTerminusName(lineId, terminusName)) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.setterminus_success", LanguageManager.put(LanguageManager.put(LanguageManager.args(), "line_id", lineId), "terminus_name", terminusName)));
                        return true;
                    }
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("line.delete_not_found", LanguageManager.put(LanguageManager.args(), "line_id", lineId)));
                    return true;
                }
                case "setmaxspeed": {
                    if (args.length < 4) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.usage_setmaxspeed"));
                        return true;
                    }
                    String lineId = args[2];
                    try {
                        double maxSpeed = Double.parseDouble(args[3]);
                        if (maxSpeed < 0.0) {
                            player.sendMessage(this.plugin.getLanguageManager().getMessage("line.setmaxspeed_invalid"));
                            return true;
                        }
                        if (lineManager.setLineMaxSpeed(lineId, maxSpeed)) {
                            player.sendMessage(this.plugin.getLanguageManager().getMessage("line.setmaxspeed_success", LanguageManager.put(LanguageManager.put(LanguageManager.args(), "line_id", lineId), "max_speed", String.valueOf(maxSpeed))));
                            return true;
                        }
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.delete_not_found", LanguageManager.put(LanguageManager.args(), "line_id", lineId)));
                        return true;
                    }
                    catch (NumberFormatException e) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.setmaxspeed_invalid"));
                    }
                    return true;
                }
                case "rename": {
                    if (args.length < 4) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.usage_rename"));
                        return true;
                    }
                    String lineId = args[2];
                    String newName = args[3];
                    if (lineManager.setLineName(lineId, newName)) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.rename_success", LanguageManager.put(LanguageManager.put(LanguageManager.args(), "line_id", lineId), "new_name", newName)));
                        return true;
                    }
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("line.rename_fail"));
                    return true;
                }
                case "addstop": {
                    if (args.length < 4) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.usage_addstop"));
                        return true;
                    }
                    String lineId = args[2];
                    String stopId = args[3];
                    Line lineToAdd = lineManager.getLine(lineId);
                    if (lineToAdd == null) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.addstop_fail"));
                        return true;
                    }
                    int index = -1;
                    if (args.length > 4) {
                        try {
                            index = Integer.parseInt(args[4]);
                        }
                        catch (NumberFormatException e) {
                            player.sendMessage(this.plugin.getLanguageManager().getMessage("line.index_format"));
                            return true;
                        }
                    }
                    if (lineToAdd.isCircular() && index != -1 && index >= lineToAdd.getOrderedStopIds().size() - 1) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.addstop_circular_invalid_index"));
                        return true;
                    }
                    boolean wasCircular = lineToAdd.isCircular();
                    if (lineManager.addStopToLine(lineId, stopId, index)) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.addstop_success", LanguageManager.put(LanguageManager.put(LanguageManager.args(), "stop_id", stopId), "line_id", lineId)));
                        Line updatedLine = lineManager.getLine(lineId);
                        if (wasCircular || !updatedLine.isCircular()) return true;
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.made_circular", LanguageManager.put(LanguageManager.args(), "line_id", lineId)));
                        return true;
                    }
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("line.addstop_fail"));
                    return true;
                }
                case "delstop": {
                    if (args.length < 4) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.usage_delstop"));
                        return true;
                    }
                    String lineId = args[2];
                    String stopId = args[3];
                    Line lineToDel = lineManager.getLine(lineId);
                    if (lineToDel == null) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.delstop_fail"));
                        return true;
                    }
                    boolean wasCircularBeforeDelete = lineToDel.isCircular();
                    if (lineManager.removeStopFromLine(lineId, stopId)) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.delstop_success", LanguageManager.put(LanguageManager.put(LanguageManager.args(), "stop_id", stopId), "line_id", lineId)));
                        Line updatedLine = lineManager.getLine(lineId);
                        if (!wasCircularBeforeDelete || updatedLine.isCircular()) return true;
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.made_normal", LanguageManager.put(LanguageManager.args(), "line_id", lineId)));
                        return true;
                    }
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("line.delstop_fail"));
                    return true;
                }
                case "stops": {
                    if (args.length < 3) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.usage_stops"));
                        return true;
                    }
                    String lineId = args[2];
                    Line line = lineManager.getLine(lineId);
                    if (line == null) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.line_not_found", LanguageManager.put(LanguageManager.args(), "line_id", lineId)));
                        return true;
                    }
                    List<String> stopIds = line.getOrderedStopIds();
                    if (stopIds.isEmpty()) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.stops_list_empty", LanguageManager.put(LanguageManager.args(), "line_name", line.getName())));
                        return true;
                    }
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("line.stops_list_header"));
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(line.getColor() + line.getName() + " &f(" + line.getId() + ")")));
                    for (int i = 0; i < stopIds.size(); ++i) {
                        String currentStopId = stopIds.get(i);
                        Stop stop = stopManager.getStop(currentStopId);
                        if (stop != null) {
                            String status = "";
                            if (i == 0) {
                                status = this.plugin.getLanguageManager().getMessage("line.stops_status_start");
                            }
                            if (i == stopIds.size() - 1) {
                                status = this.plugin.getLanguageManager().getMessage("line.stops_status_end");
                            }
                            TextComponent message = new TextComponent(this.plugin.getLanguageManager().getMessage("line.stops_list_prefix", LanguageManager.put(LanguageManager.args(), "index", String.valueOf(i + 1))));
                            message.addExtra((BaseComponent)this.createTeleportComponent(stop));
                            String suffixText = this.plugin.getLanguageManager().getMessage("line.stops_list_suffix", LanguageManager.put(LanguageManager.put(LanguageManager.args(), "stop_id", stop.getId()), "status", status));
                            message.addExtra((BaseComponent)new TextComponent(" " + suffixText));
                            player.spigot().sendMessage((BaseComponent)message);
                            continue;
                        }
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.stops_list_invalid_stop", LanguageManager.put(LanguageManager.put(LanguageManager.args(), "index", String.valueOf(i + 1)), "stop_id", currentStopId)));
                    }
                    return true;
                }
                default: {
                    this.sendLineHelpMessage(player);
                    return true;
                }
            }
        }
        if (mainCommand.equals("stop")) {
            if (args.length < 2) {
                this.sendStopHelpMessage(player);
                return true;
            }
            String subCommand = args[1].toLowerCase();
            if ("tp".equals(subCommand)) {
                if (args.length < 3) {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.usage_tp"));
                    return true;
                }
                String stopId = args[2];
                Stop stop = stopManager.getStop(stopId);
                if (stop == null) {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.stop_not_found", LanguageManager.put(LanguageManager.args(), "stop_id", stopId)));
                    return true;
                }
                if (stop.getStopPointLocation() == null) {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.stoppoint_not_set", LanguageManager.put(LanguageManager.args(), "stop_name", stop.getName())));
                    return true;
                }
                player.teleportAsync(stop.getStopPointLocation()).thenAccept(success -> {
                    if (success.booleanValue()) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.tp_success", LanguageManager.put(LanguageManager.args(), "stop_name", stop.getName())));
                    } else {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "Teleport failed. The destination might be unsafe.");
                    }
                });
                return true;
            }
            if ("info".equals(subCommand)) {
                if (args.length < 3) {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.usage_info"));
                    return true;
                }
                String stopId = args[2];
                Stop stop = stopManager.getStop(stopId);
                if (stop == null) {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.stop_not_found", LanguageManager.put(LanguageManager.args(), "stop_id", stopId)));
                    return true;
                }
                player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.info_header", LanguageManager.put(LanguageManager.args(), "stop_name", stop.getName())));
                player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.info_id", LanguageManager.put(LanguageManager.args(), "stop_id", stop.getId())));
                TextComponent nameComponent = new TextComponent(this.plugin.getLanguageManager().getMessage("stop.info_name", LanguageManager.put(LanguageManager.args(), "stop_name", stop.getName())));
                nameComponent.addExtra((BaseComponent)this.createTeleportComponent(stop));
                player.spigot().sendMessage((BaseComponent)nameComponent);
                Location corner1 = stop.getCorner1();
                Location corner2 = stop.getCorner2();
                player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.info_corner1", LanguageManager.put(LanguageManager.args(), "corner1", corner1 != null ? LocationUtil.locationToString(corner1) : "Not set")));
                player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.info_corner2", LanguageManager.put(LanguageManager.args(), "corner2", corner2 != null ? LocationUtil.locationToString(corner2) : "Not set")));
                Location stopPoint = stop.getStopPointLocation();
                player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.info_stoppoint", LanguageManager.put(LanguageManager.args(), "stoppoint", stopPoint != null ? LocationUtil.locationToString(stopPoint) : "Not set")));
                return true;
            }
            if (subCommand.equals("addtransfer")) {
                if (args.length < 4) {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.usage_addtransfer"));
                    return true;
                }
                String stopId = args[2];
                String transferLineId = args[3];
                Stop stop = stopManager.getStop(stopId);
                if (stop == null) {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.stop_not_found", LanguageManager.put(LanguageManager.args(), "stop_id", stopId)));
                    return true;
                }
                Line transferLine = lineManager.getLine(transferLineId);
                if (transferLine == null) {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("line.line_not_found", LanguageManager.put(LanguageManager.args(), "line_id", transferLineId)));
                    return true;
                }
                if (stopManager.addTransferLine(stopId, transferLineId)) {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.addtransfer_success", LanguageManager.put(LanguageManager.put(LanguageManager.args(), "transfer_line_name", transferLine.getName()), "stop_name", stop.getName())));
                    return true;
                } else {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.addtransfer_exists", LanguageManager.put(LanguageManager.put(LanguageManager.args(), "stop_name", stop.getName()), "transfer_line_name", transferLine.getName())));
                }
                return true;
            }
            if (subCommand.equals("deltransfer")) {
                if (args.length < 4) {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.usage_deltransfer"));
                    return true;
                }
                String stopId = args[2];
                String transferLineId = args[3];
                Stop stop = stopManager.getStop(stopId);
                if (stop == null) {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.stop_not_found", LanguageManager.put(LanguageManager.args(), "stop_id", stopId)));
                    return true;
                }
                Line transferLine = lineManager.getLine(transferLineId);
                if (transferLine == null) {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("line.line_not_found", LanguageManager.put(LanguageManager.args(), "line_id", transferLineId)));
                    return true;
                }
                if (stopManager.removeTransferLine(stopId, transferLineId)) {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.deltransfer_success", LanguageManager.put(LanguageManager.put(LanguageManager.args(), "stop_name", stop.getName()), "transfer_line_name", transferLine.getName())));
                    return true;
                } else {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.deltransfer_not_exists", LanguageManager.put(LanguageManager.put(LanguageManager.args(), "stop_name", stop.getName()), "transfer_line_name", transferLine.getName())));
                }
                return true;
            }
            if (subCommand.equals("listtransfers")) {
                if (args.length < 3) {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.usage_listtransfers"));
                    return true;
                }
                String stopId = args[2];
                Stop stop = stopManager.getStop(stopId);
                if (stop == null) {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.stop_not_found", LanguageManager.put(LanguageManager.args(), "stop_id", stopId)));
                    return true;
                }
                List<String> transferLineIds = stopManager.getTransferableLines(stopId);
                if (transferLineIds.isEmpty()) {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.transfers_empty", LanguageManager.put(LanguageManager.args(), "stop_name", stop.getName())));
                    return true;
                }
                player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.transfers_header", LanguageManager.put(LanguageManager.args(), "stop_name", stop.getName())));
                for (String id : transferLineIds) {
                    Line txLine = lineManager.getLine(id);
                    if (txLine != null) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.transfers_format", LanguageManager.put(LanguageManager.args(), "line_name", txLine.getName())));
                        continue;
                    }
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.transfers_invalid", LanguageManager.put(LanguageManager.args(), "line_id", id)));
                }
                return true;
            }
            if (subCommand.equals("settitle")) {
                if (args.length < 6) {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.usage_settitle"));
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.title_types"));
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.title_keys"));
                    return true;
                }
                String stopId = args[2];
                String titleType = args[3];
                String key = args[4];
                String value = args[5];
                Stop stop = stopManager.getStop(stopId);
                if (stop == null) {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.stop_not_found", LanguageManager.put(LanguageManager.args(), "stop_id", stopId)));
                    return true;
                }
                if (!this.isValidTitleType(titleType)) {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.title_type_invalid", LanguageManager.put(LanguageManager.args(), "title_type", titleType)));
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.title_types"));
                    return true;
                }
                if (!this.isValidTitleKey(key)) {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.title_key_invalid", LanguageManager.put(LanguageManager.args(), "title_key", key)));
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.title_keys"));
                    return true;
                }
                Map<String, String> titleConfig = stop.getCustomTitle(titleType);
                if (titleConfig == null) {
                    titleConfig = new HashMap<String, String>();
                }
                titleConfig.put(key, value);
                stop.setCustomTitle(titleType, titleConfig);
                stopManager.saveConfig();
                player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.settitle_success", LanguageManager.put(LanguageManager.put(LanguageManager.put(LanguageManager.put(LanguageManager.args(), "stop_name", stop.getName()), "title_type", titleType), "title_key", key), "title_value", value)));
                return true;
            }
            if (subCommand.equals("deltitle")) {
                if (args.length < 4) {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.usage_deltitle"));
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.title_types"));
                    return true;
                }
                String stopId = args[2];
                String titleType = args[3];
                String key = args.length > 4 ? args[4] : null;
                Stop stop = stopManager.getStop(stopId);
                if (stop == null) {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.stop_not_found", LanguageManager.put(LanguageManager.args(), "stop_id", stopId)));
                    return true;
                }
                if (!this.isValidTitleType(titleType)) {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.title_type_invalid", LanguageManager.put(LanguageManager.args(), "title_type", titleType)));
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.title_types"));
                    return true;
                }
                if (key == null) {
                    if (stop.removeCustomTitle(titleType)) {
                        stopManager.saveConfig();
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.deltitle_type_success", LanguageManager.put(LanguageManager.put(LanguageManager.args(), "stop_name", stop.getName()), "title_type", titleType)));
                        return true;
                    } else {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.deltitle_type_not_found", LanguageManager.put(LanguageManager.put(LanguageManager.args(), "stop_name", stop.getName()), "title_type", titleType)));
                    }
                    return true;
                } else {
                    Map<String, String> titleConfig = stop.getCustomTitle(titleType);
                    if (titleConfig != null && titleConfig.containsKey(key)) {
                        titleConfig.remove(key);
                        if (titleConfig.isEmpty()) {
                            stop.removeCustomTitle(titleType);
                        } else {
                            stop.setCustomTitle(titleType, titleConfig);
                        }
                        stopManager.saveConfig();
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.deltitle_success", LanguageManager.put(LanguageManager.put(LanguageManager.put(LanguageManager.args(), "stop_name", stop.getName()), "title_type", titleType), "title_key", key)));
                        return true;
                    } else {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.deltitle_not_found", LanguageManager.put(LanguageManager.put(LanguageManager.put(LanguageManager.args(), "stop_name", stop.getName()), "title_type", titleType), "title_key", key)));
                    }
                }
                return true;
            }
            if (subCommand.equals("listtitles")) {
                String[] titleTypes;
                if (args.length < 3) {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.usage_listtitles"));
                    return true;
                }
                String stopId = args[2];
                Stop stop = stopManager.getStop(stopId);
                if (stop == null) {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.stop_not_found", LanguageManager.put(LanguageManager.args(), "stop_id", stopId)));
                    return true;
                }
                player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.listtitles_header"));
                boolean hasCustomTitles = false;
                for (String titleType : titleTypes = new String[]{"stop_continuous", "arrive_stop", "terminal_stop", "departure"}) {
                    Map<String, String> titleConfig = stop.getCustomTitle(titleType);
                    if (titleConfig == null || titleConfig.isEmpty()) continue;
                    hasCustomTitles = true;
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.listtitles_type", LanguageManager.put(LanguageManager.args(), "title_type", titleType)));
                    for (Map.Entry<String, String> entry : titleConfig.entrySet()) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.listtitles_item", LanguageManager.put(LanguageManager.put(LanguageManager.args(), "title_key", entry.getKey()), "title_value", entry.getValue())));
                    }
                }
                if (hasCustomTitles) return true;
                player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.listtitles_no_titles"));
                return true;
            }
            if (subCommand.equals("rename")) {
                if (args.length < 4) {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.usage_rename"));
                    return true;
                }
                String stopId = args[2];
                StringBuilder newName = new StringBuilder();
                for (int i = 3; i < args.length; ++i) {
                    if (i > 3) {
                        newName.append(" ");
                    }
                    newName.append(args[i]);
                }
                Stop stop = stopManager.getStop(stopId);
                if (stop == null) {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.stop_not_found", LanguageManager.put(LanguageManager.args(), "stop_id", stopId)));
                    return true;
                }
                String oldName = stop.getName();
                if (stopManager.setStopName(stopId, newName.toString())) {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.rename_success", LanguageManager.put(LanguageManager.put(LanguageManager.args(), "old_name", oldName), "new_name", newName.toString())));
                    return true;
                } else {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.rename_fail"));
                }
                return true;
            }
            switch (subCommand) {
                case "create": {
                    if (args.length < 3) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.usage_create"));
                        return true;
                    }
                    String stopId = args[2];
                    StringBuilder nameBuilder = new StringBuilder();
                    for (int i = 3; i < args.length; ++i) {
                        nameBuilder.append(args[i]).append(" ");
                    }
                    String stopName = nameBuilder.toString().trim();
                    Stop newStop = stopManager.createStop(stopId, stopName);
                    if (newStop != null) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.create_success", LanguageManager.put(LanguageManager.args(), "stop_name", stopName)));
                        return true;
                    }
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.stop_exists", LanguageManager.put(LanguageManager.args(), "stop_id", stopId)));
                    return true;
                }
                case "delete": {
                    if (args.length < 3) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.usage_delete"));
                        return true;
                    }
                    String stopId = args[2];
                    if (stopManager.deleteStop(stopId)) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.delete_success", LanguageManager.put(LanguageManager.args(), "stop_id", stopId)));
                        return true;
                    }
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.delete_fail"));
                    return true;
                }
                case "list": {
                    ArrayList stops = new ArrayList(stopManager.getAllStopIds().stream().map(stopManager::getStop).filter(Objects::nonNull).collect(Collectors.toList()));
                    if (stops.isEmpty()) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.list_empty"));
                        return true;
                    }
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.list_header"));
                    stops.sort((s1, s2) -> s1.getId().compareTo(s2.getId()));
                    for (int i = 0; i < stops.size(); ++i) {
                        Stop stop = (Stop)stops.get(i);
                        TextComponent message = new TextComponent(this.plugin.getLanguageManager().getMessage("stop.list_prefix", LanguageManager.put(LanguageManager.args(), "index", String.valueOf(i + 1))));
                        message.addExtra((BaseComponent)this.createTeleportComponent(stop));
                        String suffixText = this.plugin.getLanguageManager().getMessage("stop.list_suffix", LanguageManager.put(LanguageManager.args(), "stop_id", stop.getId()));
                        message.addExtra((BaseComponent)new TextComponent(" " + suffixText));
                        player.spigot().sendMessage((BaseComponent)message);
                    }
                    return true;
                }
                case "setcorner1": {
                    if (args.length < 3) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.usage_setcorner1"));
                        return true;
                    }
                    String stopId = args[2];
                    Location location = player.getLocation();
                    if (stopManager.setStopCorner1(stopId, location)) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.setcorner1_success", LanguageManager.put(LanguageManager.put(LanguageManager.args(), "stop_id", stopId), "location", LocationUtil.locationToString(location))));
                        return true;
                    }
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.setcorner1_fail"));
                    return true;
                }
                case "setcorner2": {
                    if (args.length < 3) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.usage_setcorner2"));
                        return true;
                    }
                    String stopId = args[2];
                    Location location = player.getLocation();
                    if (stopManager.setStopCorner2(stopId, location)) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.setcorner2_success", LanguageManager.put(LanguageManager.put(LanguageManager.args(), "stop_id", stopId), "location", LocationUtil.locationToString(location))));
                        return true;
                    }
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.setcorner2_fail"));
                    return true;
                }
                case "setpoint": {
                    Location location = player.getLocation();
                    if (!LocationUtil.isRail(location)) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.setpoint_not_rail"));
                        return true;
                    }
                    Stop stop = stopManager.getStopContainingLocation(location);
                    if (stop == null) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.no_stop_found_at_location"));
                        return true;
                    }
                    String stopId = stop.getId();
                    float yaw = player.getLocation().getYaw();
                    if (args.length > 2) {
                        try {
                            yaw = Float.parseFloat(args[2]);
                        }
                        catch (NumberFormatException e) {
                            player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.setpoint_yaw_invalid"));
                            return true;
                        }
                    }
                    if (stopManager.setStopPoint(stopId, location, yaw)) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.setpoint_success", LanguageManager.put(LanguageManager.put(LanguageManager.args(), "stop_id", stopId), "yaw", String.valueOf(yaw))));
                        return true;
                    }
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.setpoint_fail"));
                    return true;
                }
                default: {
                    this.sendStopHelpMessage(player);
                }
            }
            return true;
        }
        if (mainCommand.equals("reload")) {
            this.plugin.ensureDefaultConfigs();
            this.plugin.reloadConfig();
            lineManager.reload();
            stopManager.reload();
            this.plugin.getLanguageManager().loadLanguages();
            player.sendMessage(this.plugin.getLanguageManager().getMessage("plugin.reload"));
            return true;
        } else {
            player.sendMessage(this.plugin.getLanguageManager().getMessage("command.unknown"));
            this.sendHelpMessage(player);
        }
        return true;
    }

    private void sendHelpMessage(Player player) {
        player.sendMessage(this.plugin.getLanguageManager().getMessage("command.help_header"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("command.help_line"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("command.help_stop"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("command.help_reload"));
    }

    private void sendLineHelpMessage(Player player) {
        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.help_header"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.help_create"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.help_delete"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.help_list"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.help_info"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.help_rename"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.help_setcolor"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.help_setterminus"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.help_setmaxspeed"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.help_addstop"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.help_removestop"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.help_stops"));
    }

    private void sendStopHelpMessage(Player player) {
        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.help_header"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.help_create"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.help_delete"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.help_list"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.help_info"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.help_rename"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.help_setcorner1"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.help_setcorner2"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.help_setpoint"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.help_tp"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.help_addtransfer"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.help_deltransfer"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.help_listtransfers"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.help_settitle"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.help_deltitle"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.help_listtitles"));
    }

    private boolean isValidTitleType(String titleType) {
        return titleType.equals("stop_continuous") || titleType.equals("arrive_stop") || titleType.equals("terminal_stop") || titleType.equals("departure");
    }

    private boolean isValidTitleKey(String key) {
        return key.equals("title") || key.equals("subtitle") || key.equals("actionbar");
    }

    private TextComponent createTeleportComponent(Stop stop) {
        TextComponent stopComponent = new TextComponent(stop.getName());
        if (stop.getStopPointLocation() != null) {
            stopComponent.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/metro stop tp " + stop.getId()));
            stopComponent.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(this.plugin.getLanguageManager().getMessage("command.teleport_to", LanguageManager.put(LanguageManager.args(), "stop_name", stop.getName()))).create()));
        }
        return stopComponent;
    }
}

