/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.metro.listener;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.cubexmc.metro.Metro;
import org.cubexmc.metro.manager.LineManager;
import org.cubexmc.metro.manager.StopManager;
import org.cubexmc.metro.model.Line;
import org.cubexmc.metro.model.Stop;
import org.cubexmc.metro.util.SchedulerUtil;
import org.cubexmc.metro.util.TextUtil;

public class PlayerMoveListener
implements Listener {
    private final Metro plugin;
    private final Map<UUID, String> playerInStopMap = new HashMap<UUID, String>();
    private final Map<UUID, Object> continuousInfoTasks = new HashMap<UUID, Object>();
    private final Map<UUID, Object> actionBarTasks = new HashMap<UUID, Object>();

    public PlayerMoveListener(Metro plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent event) {
        Minecart minecart;
        if (this.isSameBlock(event.getFrom(), event.getTo())) {
            return;
        }
        Player player = event.getPlayer();
        if (!player.hasPermission("metro.use")) {
            return;
        }
        if (player.isInsideVehicle() && player.getVehicle() instanceof Minecart && "MetroMinecart".equals((minecart = (Minecart)player.getVehicle()).getCustomName())) {
            UUID playerId = player.getUniqueId();
            String currentStopId = this.playerInStopMap.remove(playerId);
            if (currentStopId != null) {
                this.cancelContinuousInfoTask(playerId);
                this.cancelActionBarTask(playerId);
            }
            return;
        }
        Location location = player.getLocation();
        StopManager stopManager = this.plugin.getStopManager();
        Stop stop = stopManager.getStopContainingLocation(location);
        UUID playerId = player.getUniqueId();
        String currentStopId = this.playerInStopMap.get(playerId);
        if (stop != null) {
            String stopId = stop.getId();
            if (!stopId.equals(currentStopId)) {
                this.playerInStopMap.put(playerId, stopId);
                this.cancelContinuousInfoTask(playerId);
                if (this.plugin.getConfig().getBoolean("titles.stop_continuous.enabled", true)) {
                    this.startContinuousInfoTask(player, stop);
                }
            }
        } else if (currentStopId != null) {
            this.playerInStopMap.remove(playerId);
            this.cancelContinuousInfoTask(playerId);
            this.cancelActionBarTask(playerId);
            String lastStopId = currentStopId;
            if (lastStopId != null) {
                player.removeMetadata("metro_first_run_" + lastStopId, (Plugin)this.plugin);
            }
        }
    }

    private boolean isSameBlock(Location from, Location to) {
        if (from == null || to == null) {
            return true;
        }
        return from.getBlockX() == to.getBlockX() && from.getBlockY() == to.getBlockY() && from.getBlockZ() == to.getBlockZ();
    }

    private void startContinuousInfoTask(final Player player, final Stop stop) {
        boolean isEndStop;
        final UUID playerId = player.getUniqueId();
        this.cancelActionBarTask(playerId);
        LineManager lineManager = this.plugin.getLineManager();
        Line line = this.findLineForStop(stop);
        if (line == null) {
            return;
        }
        int interval = this.plugin.getConfig().getInt("titles.stop_continuous.interval", 60);
        boolean alwaysShow = this.plugin.getConfig().getBoolean("titles.stop_continuous.always", true);
        String lastStopId = line.getPreviousStopId(stop.getId());
        String nextStopId = line.getNextStopId(stop.getId());
        StopManager stopManager = this.plugin.getStopManager();
        Stop lastStop = lastStopId != null ? stopManager.getStop(lastStopId) : null;
        Stop nextStop = nextStopId != null ? stopManager.getStop(nextStopId) : null;
        List<String> stopIds = line.getOrderedStopIds();
        Stop terminalStop = null;
        if (!stopIds.isEmpty()) {
            String terminalStopId = stopIds.get(stopIds.size() - 1);
            terminalStop = stopManager.getStop(terminalStopId);
        }
        Object configPath = "titles.stop_continuous";
        boolean isStartStop = lastStop == null;
        boolean bl = isEndStop = nextStop == null;
        if (isStartStop) {
            configPath = (String)configPath + ".start_stop";
        } else if (isEndStop) {
            configPath = (String)configPath + ".end_stop";
        }
        String title = this.plugin.getConfig().getString((String)configPath + ".title", this.plugin.getConfig().getString("titles.stop_continuous.title", "{line_color_code}{line}"));
        String subtitle = this.plugin.getConfig().getString((String)configPath + ".subtitle", this.plugin.getConfig().getString("titles.stop_continuous.subtitle", "\u5f00\u5f80 &d{terminus_name} &f\u65b9\u5411 | \u4e0b\u4e00\u7ad9: &e{next_stop_name}"));
        String actionbar = this.plugin.getConfig().getString((String)configPath + ".actionbar", this.plugin.getConfig().getString("titles.stop_continuous.actionbar", "\u00a7f\u4e0a\u4e00\u7ad9: \u00a77{last_stop_name} \u00a7f| \u4e0b\u4e00\u7ad9: \u00a7a{next_stop_name} \u00a7f| \u00a7e\u53ef\u6362\u4e58: {transfer_lines}"));
        Map<String, String> customTitle = stop.getCustomTitle("stop_continuous");
        if (customTitle != null) {
            if (customTitle.containsKey("title")) {
                title = customTitle.get("title");
            }
            if (customTitle.containsKey("subtitle")) {
                subtitle = customTitle.get("subtitle");
            }
            if (customTitle.containsKey("actionbar")) {
                actionbar = customTitle.get("actionbar");
            }
        }
        final String finalTitle = TextUtil.replacePlaceholders(title, line, stop, lastStop, nextStop, terminalStop, lineManager);
        final String finalSubtitle = TextUtil.replacePlaceholders(subtitle, line, stop, lastStop, nextStop, terminalStop, lineManager);
        final String finalActionbar = TextUtil.replacePlaceholders(actionbar, line, stop, lastStop, nextStop, terminalStop, lineManager);
        if (alwaysShow) {
            Object actionBarTaskId = SchedulerUtil.globalRun((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    Minecart minecart;
                    if (!PlayerMoveListener.this.actionBarTasks.containsKey(playerId)) {
                        return;
                    }
                    if (!player.isOnline() || !stop.isInStop(player.getLocation())) {
                        return;
                    }
                    if (player.isInsideVehicle() && player.getVehicle() instanceof Minecart && "MetroMinecart".equals((minecart = (Minecart)player.getVehicle()).getCustomName())) {
                        return;
                    }
                    player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)ChatColor.translateAlternateColorCodes((char)'&', (String)finalActionbar)));
                }
            }, 0L, 20L);
            this.actionBarTasks.put(playerId, actionBarTaskId);
            Object titleTaskId = SchedulerUtil.globalRun((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    Minecart minecart;
                    if (!PlayerMoveListener.this.continuousInfoTasks.containsKey(playerId)) {
                        return;
                    }
                    if (!player.isOnline() || !stop.isInStop(player.getLocation())) {
                        return;
                    }
                    if (player.isInsideVehicle() && player.getVehicle() instanceof Minecart && "MetroMinecart".equals((minecart = (Minecart)player.getVehicle()).getCustomName())) {
                        return;
                    }
                    player.sendTitle(ChatColor.translateAlternateColorCodes((char)'&', (String)finalTitle), ChatColor.translateAlternateColorCodes((char)'&', (String)finalSubtitle), 0, 40, 0);
                }
            }, 0L, interval);
            this.continuousInfoTasks.put(playerId, titleTaskId);
        } else {
            String metaKey = "metro_first_run_" + stop.getId();
            List metaList = player.getMetadata(metaKey);
            if (metaList.isEmpty()) {
                Minecart mc_vehicle;
                player.setMetadata(metaKey, (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
                boolean inMetroMinecart = false;
                if (player.isInsideVehicle() && player.getVehicle() instanceof Minecart && "MetroMinecart".equals((mc_vehicle = (Minecart)player.getVehicle()).getCustomName())) {
                    inMetroMinecart = true;
                }
                if (!inMetroMinecart) {
                    int fadeIn = this.plugin.getConfig().getInt("titles.stop_continuous.fade_in", 10);
                    int stay = this.plugin.getConfig().getInt("titles.stop_continuous.stay", 40);
                    int fadeOut = this.plugin.getConfig().getInt("titles.stop_continuous.fade_out", 10);
                    player.sendTitle(ChatColor.translateAlternateColorCodes((char)'&', (String)finalTitle), ChatColor.translateAlternateColorCodes((char)'&', (String)finalSubtitle), fadeIn, stay, fadeOut);
                    final int totalDisplayTime = stay + fadeOut;
                    Object actionBarTaskId = SchedulerUtil.globalRun((Plugin)this.plugin, new Runnable(){
                        private int count = 0;
                        private final int maxCount = totalDisplayTime / 20 + 1;

                        @Override
                        public void run() {
                            Minecart minecart;
                            if (!player.isOnline() || this.count >= this.maxCount || !stop.isInStop(player.getLocation())) {
                                PlayerMoveListener.this.cancelActionBarTask(playerId);
                                return;
                            }
                            if (player.isInsideVehicle() && player.getVehicle() instanceof Minecart && "MetroMinecart".equals((minecart = (Minecart)player.getVehicle()).getCustomName())) {
                                ++this.count;
                                return;
                            }
                            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)ChatColor.translateAlternateColorCodes((char)'&', (String)finalActionbar)));
                            ++this.count;
                        }
                    }, 0L, 20L);
                    this.actionBarTasks.put(playerId, actionBarTaskId);
                }
            }
        }
    }

    private Line findLineForStop(Stop stop) {
        if (stop == null) {
            return null;
        }
        LineManager lineManager = this.plugin.getLineManager();
        for (Line line : lineManager.getAllLines()) {
            if (!line.containsStop(stop.getId())) continue;
            return line;
        }
        return null;
    }

    private void cancelContinuousInfoTask(UUID playerId) {
        Object taskId = this.continuousInfoTasks.remove(playerId);
        if (taskId != null) {
            SchedulerUtil.cancelTask(taskId);
        }
    }

    private void cancelActionBarTask(UUID playerId) {
        Object taskId = this.actionBarTasks.remove(playerId);
        if (taskId != null) {
            SchedulerUtil.cancelTask(taskId);
        }
    }
}

