/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.metro.manager;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.cubexmc.metro.Metro;
import org.cubexmc.metro.model.Line;

public class LineManager {
    private final Metro plugin;
    private final File configFile;
    private FileConfiguration config;
    private final Map<String, Line> lines;

    public LineManager(Metro plugin) {
        this.plugin = plugin;
        this.configFile = new File(plugin.getDataFolder(), "lines.yml");
        this.lines = new HashMap<String, Line>();
        this.loadConfig();
    }

    private void loadConfig() {
        if (!this.configFile.exists()) {
            this.plugin.saveResource("lines.yml", false);
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        this.loadLines();
    }

    private void loadLines() {
        this.lines.clear();
        ConfigurationSection linesSection = this.config.getConfigurationSection("");
        if (linesSection != null) {
            for (String lineId : linesSection.getKeys(false)) {
                Double maxSpeed;
                String terminusName;
                String name = this.config.getString(lineId + ".name");
                Line line = new Line(lineId, name);
                List stopIds = this.config.getStringList(lineId + ".ordered_stop_ids");
                for (String stopId : stopIds) {
                    line.addStop(stopId, -1);
                }
                String color = this.config.getString(lineId + ".color");
                if (color != null) {
                    line.setColor(color);
                }
                if ((terminusName = this.config.getString(lineId + ".terminus_name")) != null) {
                    line.setTerminusName(terminusName);
                }
                if ((maxSpeed = Double.valueOf(this.config.getDouble(lineId + ".max_speed", -1.0))) >= 0.0) {
                    line.setMaxSpeed(maxSpeed);
                }
                this.lines.put(lineId, line);
            }
        }
    }

    public void saveConfig() {
        try {
            for (Line line : this.lines.values()) {
                String lineId = line.getId();
                this.config.set(lineId + ".name", (Object)line.getName());
                this.config.set(lineId + ".ordered_stop_ids", line.getOrderedStopIds());
                this.config.set(lineId + ".color", (Object)line.getColor());
                this.config.set(lineId + ".terminus_name", (Object)line.getTerminusName());
                if (line.getMaxSpeed() != null) {
                    this.config.set(lineId + ".max_speed", (Object)line.getMaxSpeed());
                    continue;
                }
                this.config.set(lineId + ".max_speed", null);
            }
            this.config.save(this.configFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "\u65e0\u6cd5\u4fdd\u5b58\u7ebf\u8def\u914d\u7f6e", e);
        }
    }

    public Line getLine(String lineId) {
        return this.lines.get(lineId);
    }

    public boolean createLine(String lineId, String name) {
        if (this.lines.containsKey(lineId)) {
            return false;
        }
        Line line = new Line(lineId, name);
        this.lines.put(lineId, line);
        this.saveConfig();
        return true;
    }

    public boolean deleteLine(String lineId) {
        if (!this.lines.containsKey(lineId)) {
            return false;
        }
        this.lines.remove(lineId);
        this.config.set(lineId, null);
        this.saveConfig();
        return true;
    }

    public boolean addStopToLine(String lineId, String stopId, int index) {
        Line line = this.lines.get(lineId);
        if (line == null) {
            return false;
        }
        line.addStop(stopId, index);
        this.saveConfig();
        return true;
    }

    public boolean removeStopFromLine(String lineId, String stopId) {
        Line line = this.lines.get(lineId);
        if (line == null) {
            return false;
        }
        line.removeStop(stopId);
        this.saveConfig();
        return true;
    }

    public void removeStopFromAllLines(String stopId) {
        for (Line line : this.lines.values()) {
            if (!line.containsStop(stopId)) continue;
            line.removeStop(stopId);
        }
        this.saveConfig();
    }

    public List<Line> getLinesContainingStop(String stopId) {
        ArrayList<Line> result = new ArrayList<Line>();
        for (Line line : this.lines.values()) {
            if (!line.containsStop(stopId)) continue;
            result.add(line);
        }
        return result;
    }

    public List<Line> getAllLines() {
        return new ArrayList<Line>(this.lines.values());
    }

    public void reload() {
        this.loadConfig();
    }

    public boolean setLineColor(String lineId, String color) {
        Line line = this.lines.get(lineId);
        if (line == null) {
            return false;
        }
        line.setColor(color);
        this.saveConfig();
        return true;
    }

    public boolean setLineTerminusName(String lineId, String terminusName) {
        Line line = this.lines.get(lineId);
        if (line == null) {
            return false;
        }
        line.setTerminusName(terminusName);
        this.saveConfig();
        return true;
    }

    public boolean setLineName(String lineId, String name) {
        Line line = this.lines.get(lineId);
        if (line == null) {
            return false;
        }
        line.setName(name);
        this.saveConfig();
        return true;
    }

    public boolean setLineMaxSpeed(String lineId, Double maxSpeed) {
        Line line = this.lines.get(lineId);
        if (line == null) {
            return false;
        }
        line.setMaxSpeed(maxSpeed);
        this.saveConfig();
        return true;
    }
}

