/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.metro.manager;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.cubexmc.metro.Metro;
import org.cubexmc.metro.manager.LineManager;
import org.cubexmc.metro.model.Stop;

public class StopManager {
    private final Metro plugin;
    private final File configFile;
    private FileConfiguration config;
    private final Map<String, Stop> stops = new HashMap<String, Stop>();
    private final Map<Location, String> locationToStopId = new HashMap<Location, String>();

    public StopManager(Metro plugin) {
        this.plugin = plugin;
        this.configFile = new File(plugin.getDataFolder(), "stops.yml");
        this.loadConfig();
    }

    private void loadConfig() {
        if (!this.configFile.exists()) {
            this.plugin.saveResource("stops.yml", false);
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        this.stops.clear();
        this.locationToStopId.clear();
        ConfigurationSection stopsSection = this.config.getConfigurationSection("");
        if (stopsSection != null) {
            Set stopIds = stopsSection.getKeys(false);
            for (String stopId : stopIds) {
                ConfigurationSection stopSection = stopsSection.getConfigurationSection(stopId);
                if (stopSection == null) continue;
                Stop stop = new Stop(stopId, stopSection);
                this.stops.put(stopId, stop);
                if (stop.getStopPointLocation() == null) continue;
                this.locationToStopId.put(stop.getStopPointLocation(), stopId);
            }
        }
        this.plugin.getLogger().info("Loaded " + this.stops.size() + " stops");
    }

    public void saveConfig() {
        for (Map.Entry<String, Stop> entry : this.stops.entrySet()) {
            String stopId = entry.getKey();
            Stop stop = entry.getValue();
            ConfigurationSection section = this.config.createSection(stopId);
            stop.saveToConfig(section);
        }
        try {
            this.config.save(this.configFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save stops config: " + e.getMessage());
        }
    }

    public Stop createStop(String stopId, String displayName) {
        if (this.stops.containsKey(stopId)) {
            return null;
        }
        Stop stop = new Stop(stopId, displayName);
        this.stops.put(stopId, stop);
        this.saveConfig();
        return stop;
    }

    public boolean deleteStop(String stopId) {
        Stop stop = this.stops.get(stopId);
        if (stop == null) {
            return false;
        }
        LineManager lineManager = this.plugin.getLineManager();
        lineManager.removeStopFromAllLines(stopId);
        if (stop.getStopPointLocation() != null) {
            this.locationToStopId.remove(stop.getStopPointLocation());
        }
        this.stops.remove(stopId);
        this.config.set(stopId, null);
        this.saveConfig();
        return true;
    }

    public boolean setStopPoint(String stopId, Location location, float yaw) {
        Stop stop = this.stops.get(stopId);
        if (stop == null) {
            return false;
        }
        if (stop.getStopPointLocation() != null) {
            this.locationToStopId.remove(stop.getStopPointLocation());
        }
        stop.setStopPointLocation(location);
        stop.setLaunchYaw(yaw);
        this.locationToStopId.put(location, stopId);
        this.saveConfig();
        return true;
    }

    public boolean setStopCorner1(String stopId, Location location) {
        Stop stop = this.stops.get(stopId);
        if (stop == null) {
            return false;
        }
        stop.setCorner1(location);
        this.saveConfig();
        return true;
    }

    public boolean setStopCorner2(String stopId, Location location) {
        Stop stop = this.stops.get(stopId);
        if (stop == null) {
            return false;
        }
        stop.setCorner2(location);
        this.saveConfig();
        return true;
    }

    public boolean setStopName(String stopId, String name) {
        Stop stop = this.stops.get(stopId);
        if (stop == null) {
            return false;
        }
        stop.setName(name);
        this.saveConfig();
        return true;
    }

    public Stop getStop(String stopId) {
        return this.stops.get(stopId);
    }

    public Stop getStopByLocation(Location location) {
        String stopId = this.locationToStopId.get(location);
        if (stopId != null) {
            return this.stops.get(stopId);
        }
        return null;
    }

    public Stop getStopContainingLocation(Location location) {
        for (Stop stop : this.stops.values()) {
            if (!stop.isInStop(location)) continue;
            return stop;
        }
        return null;
    }

    public Set<String> getAllStopIds() {
        return this.stops.keySet();
    }

    public List<Stop> getAllStops() {
        return new ArrayList<Stop>(this.stops.values());
    }

    public boolean addTransferLine(String stopId, String lineId) {
        Stop stop = this.stops.get(stopId);
        if (stop == null) {
            return false;
        }
        boolean added = stop.addTransferableLine(lineId);
        if (added) {
            this.saveConfig();
        }
        return added;
    }

    public boolean removeTransferLine(String stopId, String lineId) {
        Stop stop = this.stops.get(stopId);
        if (stop == null) {
            return false;
        }
        boolean removed = stop.removeTransferableLine(lineId);
        if (removed) {
            this.saveConfig();
        }
        return removed;
    }

    public List<String> getTransferableLines(String stopId) {
        Stop stop = this.stops.get(stopId);
        if (stop == null) {
            return new ArrayList<String>();
        }
        return stop.getTransferableLines();
    }

    public void reload() {
        this.loadConfig();
    }
}

