/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.metro.listener;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import org.cubexmc.metro.Metro;
import org.cubexmc.metro.manager.LineManager;
import org.cubexmc.metro.manager.StopManager;
import org.cubexmc.metro.model.Line;
import org.cubexmc.metro.model.Stop;
import org.cubexmc.metro.train.ScoreboardManager;
import org.cubexmc.metro.util.LocationUtil;
import org.cubexmc.metro.util.SchedulerUtil;

public class VehicleListener
implements Listener {
    private final Metro plugin;
    private final Map<UUID, Object> trainMovementTasks = new HashMap<UUID, Object>();

    public VehicleListener(Metro plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onVehicleExit(VehicleExitEvent event) {
        Vehicle vehicle = event.getVehicle();
        LivingEntity passenger = event.getExited();
        if (!(vehicle instanceof Minecart) || !(passenger instanceof Player)) {
            return;
        }
        Player player = (Player)passenger;
        Minecart minecart = (Minecart)vehicle;
        if (!"MetroMinecart".equals(minecart.getCustomName())) {
            return;
        }
        ScoreboardManager.clearPlayerDisplay(player);
        this.cancelTrainMovementTask(player.getUniqueId());
        Location location = minecart.getLocation();
        if (!this.isAtStop(location)) {
            Minecart finalMinecart = minecart;
            SchedulerUtil.regionRun((Plugin)this.plugin, location, () -> {
                if (finalMinecart != null && !finalMinecart.isDead()) {
                    finalMinecart.remove();
                }
            }, 1L, -1L);
            return;
        }
        int despawnDelay = this.plugin.getConfig().getInt("settings.cart_despawn_delay", 60);
        Minecart finalMinecart = minecart;
        SchedulerUtil.regionRun((Plugin)this.plugin, location, () -> {
            if (finalMinecart != null && !finalMinecart.isDead()) {
                finalMinecart.remove();
            }
        }, despawnDelay, -1L);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onVehicleMove(VehicleMoveEvent event) {
        Vehicle vehicle = event.getVehicle();
        if (!(vehicle instanceof Minecart)) {
            return;
        }
        Minecart minecart = (Minecart)vehicle;
        if (!"MetroMinecart".equals(minecart.getCustomName())) {
            return;
        }
        Location from = event.getFrom();
        Location to = event.getTo();
        if (LocationUtil.isOnRail(to)) {
            if (to.getY() > from.getY()) {
                Vector direction = LocationUtil.getDirectionVector(from, to);
                minecart.setVelocity(direction.multiply(0.4));
            }
        } else {
            minecart.eject();
            minecart.remove();
        }
    }

    private void cancelTrainMovementTask(UUID playerId) {
        Object taskId = this.trainMovementTasks.remove(playerId);
        if (taskId != null) {
            SchedulerUtil.cancelTask(taskId);
        }
    }

    private Line findLineForStop(Stop stop) {
        if (stop == null) {
            return null;
        }
        LineManager lineManager = this.plugin.getLineManager();
        for (Line line : lineManager.getAllLines()) {
            if (!line.containsStop(stop.getId())) continue;
            return line;
        }
        return null;
    }

    private boolean isAtStop(Location location) {
        StopManager stopManager = this.plugin.getStopManager();
        return stopManager.getStopContainingLocation(location) != null;
    }
}

