/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.metro.train;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Scoreboard;
import org.cubexmc.metro.Metro;
import org.cubexmc.metro.manager.LineManager;
import org.cubexmc.metro.manager.StopManager;
import org.cubexmc.metro.model.Line;
import org.cubexmc.metro.model.Stop;
import org.cubexmc.metro.util.SchedulerUtil;

public class ScoreboardManager {
    private static final Map<UUID, Scoreboard> playerScoreboards = new HashMap<UUID, Scoreboard>();
    private static Metro plugin;

    public static void initialize(Metro metroPlugin) {
        plugin = metroPlugin;
    }

    public static void createScoreboard(Player player, String title) {
        if (player == null || !player.isOnline() || plugin == null) {
            return;
        }
        if (!plugin.getConfig().getBoolean("scoreboard.enabled", true)) {
            return;
        }
        org.bukkit.scoreboard.ScoreboardManager manager = Bukkit.getScoreboardManager();
        if (manager == null) {
            return;
        }
        Scoreboard scoreboard = manager.getNewScoreboard();
        Objective objective = scoreboard.registerNewObjective("metro", "dummy", title);
        objective.setDisplaySlot(DisplaySlot.SIDEBAR);
        player.setScoreboard(scoreboard);
        playerScoreboards.put(player.getUniqueId(), scoreboard);
    }

    public static void setLine(Player player, int score, String text) {
        if (player == null || !player.isOnline()) {
            return;
        }
        Scoreboard scoreboard = playerScoreboards.get(player.getUniqueId());
        if (scoreboard == null) {
            return;
        }
        Objective objective = scoreboard.getObjective("metro");
        if (objective == null) {
            return;
        }
        Score scoreObj = objective.getScore(text);
        scoreObj.setScore(score);
    }

    public static void updateEnteringStopScoreboard(Player player, Line line, String currentStopId) {
        if (player == null || !player.isOnline() || line == null || plugin == null) {
            return;
        }
        if (!plugin.getConfig().getBoolean("scoreboard.enabled", true)) {
            return;
        }
        String nextStopId = line.getNextStopId(currentStopId);
        ScoreboardManager.updateScoreboardInternal(player, line, currentStopId, nextStopId);
    }

    public static void updateTravelingScoreboard(Player player, Line line, String targetStopId) {
        if (player == null || !player.isOnline() || line == null || plugin == null) {
            return;
        }
        if (!plugin.getConfig().getBoolean("scoreboard.enabled", true)) {
            return;
        }
        ScoreboardManager.updateScoreboardInternal(player, line, null, targetStopId);
    }

    public static void updateTerminalScoreboard(Player player, Line line, String currentStopId) {
        if (player == null || !player.isOnline() || line == null || plugin == null) {
            return;
        }
        if (!plugin.getConfig().getBoolean("scoreboard.enabled", true)) {
            return;
        }
        ScoreboardManager.updateScoreboardInternal(player, line, currentStopId, null);
    }

    private static void updateScoreboardInternal(Player player, Line line, String currentStopId, String nextStopId) {
        if (SchedulerUtil.isFolia()) {
            return;
        }
        org.bukkit.scoreboard.ScoreboardManager manager = Bukkit.getScoreboardManager();
        if (manager == null) {
            return;
        }
        Scoreboard scoreboard = playerScoreboards.getOrDefault(player.getUniqueId(), manager.getNewScoreboard());
        if (scoreboard == null) {
            plugin.getLogger().info("Scoreboard is null");
        }
        if (scoreboard.getObjective("metro") != null) {
            scoreboard.getObjective("metro").unregister();
        }
        Objective objective = scoreboard.registerNewObjective("metro", "dummy", String.valueOf(ChatColor.GOLD) + String.valueOf(ChatColor.BOLD) + line.getName());
        objective.setDisplaySlot(DisplaySlot.SIDEBAR);
        List<String> stopIds = line.getOrderedStopIds();
        StopManager stopManager = plugin.getStopManager();
        LineManager lineManager = plugin.getLineManager();
        String currentStopStyle = plugin.getConfig().getString("scoreboard.styles.current_stop", "&f");
        String nextStopStyle = plugin.getConfig().getString("scoreboard.styles.next_stop", "&a");
        String otherStopsStyle = plugin.getConfig().getString("scoreboard.styles.other_stops", "&7");
        currentStopStyle = ChatColor.translateAlternateColorCodes((char)'&', (String)currentStopStyle);
        nextStopStyle = ChatColor.translateAlternateColorCodes((char)'&', (String)nextStopStyle);
        otherStopsStyle = ChatColor.translateAlternateColorCodes((char)'&', (String)otherStopsStyle);
        String lineSymbol = plugin.getConfig().getString("scoreboard.line_symbol", "\u25a0");
        int scoreValue = stopIds.size();
        HashMap<String, String> displayedStops = new HashMap<String, String>();
        int currentStopIndex = currentStopId != null ? stopIds.indexOf(currentStopId) : -1;
        int nextStopIndex = nextStopId != null ? stopIds.indexOf(nextStopId) : -1;
        for (int i = 0; i < stopIds.size(); ++i) {
            String displayName;
            String stopId = stopIds.get(i);
            Stop stop = stopManager.getStop(stopId);
            if (stop == null || displayedStops.containsKey(displayName = stop.getName())) continue;
            displayedStops.put(displayName, displayName);
            List<String> transferableLines = stop.getTransferableLines();
            StringBuilder transferInfo = new StringBuilder();
            if (!transferableLines.isEmpty()) {
                ArrayList<String> filteredLines = new ArrayList<String>(transferableLines);
                filteredLines.remove(line.getId());
                if (!filteredLines.isEmpty()) {
                    for (String transferLineId : filteredLines) {
                        Line transferLine = lineManager.getLine(transferLineId);
                        if (transferLine == null) continue;
                        String coloredSymbol = ChatColor.translateAlternateColorCodes((char)'&', (String)transferLine.getColor()) + lineSymbol + " ";
                        transferInfo.append(coloredSymbol);
                    }
                }
            }
            String formattedName = i == currentStopIndex ? currentStopStyle + displayName : (i == nextStopIndex ? nextStopStyle + displayName : otherStopsStyle + displayName);
            if (transferInfo.length() > 0) {
                formattedName = formattedName + " " + String.valueOf(transferInfo);
            }
            Score score = objective.getScore(formattedName);
            score.setScore(scoreValue--);
        }
        player.setScoreboard(scoreboard);
        playerScoreboards.put(player.getUniqueId(), scoreboard);
    }

    public static void clearScoreboard(Player player) {
        if (SchedulerUtil.isFolia()) {
            return;
        }
        if (player == null || !player.isOnline()) {
            return;
        }
        org.bukkit.scoreboard.ScoreboardManager manager = Bukkit.getScoreboardManager();
        if (manager != null) {
            player.setScoreboard(manager.getNewScoreboard());
            playerScoreboards.remove(player.getUniqueId());
        }
    }

    public static void clearPlayerDisplay(Player player) {
        ScoreboardManager.clearScoreboard(player);
        if (player != null && player.isOnline()) {
            player.sendTitle("", "", 0, 0, 0);
        }
    }
}

