/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.metro.util;

import java.util.List;
import org.cubexmc.metro.manager.LineManager;
import org.cubexmc.metro.model.Line;
import org.cubexmc.metro.model.Stop;

public class TextUtil {
    public static String replacePlaceholders(String text, Line line, Stop stop, Stop lastStop, Stop nextStop, Stop terminalStop, LineManager lineManager) {
        String transferLines;
        if (text == null) {
            return "";
        }
        String result = text;
        if (line != null) {
            result = result.replace("{line}", line.getName());
            result = result.replace("{line_id}", line.getId());
            result = result.replace("{line_color_code}", line.getColor());
            String termName = line.getTerminusName();
            if (line.isCircular()) {
                if (termName == null || termName.isEmpty()) {
                    termName = nextStop != null ? nextStop.getName() : "";
                }
            } else if (termName == null || termName.isEmpty()) {
                termName = terminalStop != null ? terminalStop.getName() : "";
            }
            result = result.replace("{terminus_name}", termName);
            if (!line.getOrderedStopIds().isEmpty()) {
                String destStopId = line.getOrderedStopIds().get(line.getOrderedStopIds().size() - 1);
                result = result.replace("{destination_stop_id}", destStopId);
            } else {
                result = result.replace("{destination_stop_id}", "");
            }
        }
        if (stop != null) {
            result = result.replace("{stop_name}", stop.getName());
            result = result.replace("{stop_id}", stop.getId());
            if (lineManager != null) {
                transferLines = TextUtil.formatTransferableLines(stop, lineManager);
                result = result.replace("{stop_transfers}", transferLines);
            } else {
                result = result.replace("{stop_transfers}", "");
            }
        }
        if (lastStop != null) {
            result = result.replace("{last_stop_name}", lastStop.getName());
            result = result.replace("{last_stop_id}", lastStop.getId());
        } else {
            result = result.replace("{last_stop_name}", "");
            result = result.replace("{last_stop_id}", "");
        }
        if (nextStop != null) {
            result = result.replace("{next_stop_name}", nextStop.getName());
            result = result.replace("{next_stop_id}", nextStop.getId());
            if (lineManager != null) {
                transferLines = TextUtil.formatTransferableLines(nextStop, lineManager);
                result = result.replace("{next_stop_transfers}", transferLines);
            } else {
                result = result.replace("{next_stop_transfers}", "");
            }
        } else {
            result = result.replace("{next_stop_name}", "");
            result = result.replace("{next_stop_id}", "");
            result = result.replace("{next_stop_transfers}", "");
        }
        if (terminalStop != null) {
            result = result.replace("{terminal_stop_name}", terminalStop.getName());
            result = result.replace("{terminal_stop_id}", terminalStop.getId());
            result = result.replace("{destination_stop_name}", terminalStop.getName());
        } else {
            result = result.replace("{terminal_stop_name}", "");
            result = result.replace("{terminal_stop_id}", "");
            result = result.replace("{destination_stop_name}", "");
        }
        return result;
    }

    private static String formatTransferableLines(Stop stop, LineManager lineManager) {
        if (stop == null || lineManager == null) {
            return "";
        }
        List<String> transferableLineIds = stop.getTransferableLines();
        if (transferableLineIds == null) {
            return "";
        }
        if (transferableLineIds.isEmpty()) {
            return "\u65e0";
        }
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (String lineId : transferableLineIds) {
            Line transferLine = lineManager.getLine(lineId);
            if (transferLine == null) continue;
            if (!first) {
                result.append("\u00a7f, ");
            }
            result.append(transferLine.getColor()).append(transferLine.getName());
            first = false;
        }
        return result.toString();
    }

    public static String replacePlaceholders(String text, Line line, Stop stop) {
        return TextUtil.replacePlaceholders(text, line, stop, null, null, null, null);
    }

    public static String replacePlaceholders(String text, Line line, Stop stop, Stop lastStop, Stop nextStop) {
        return TextUtil.replacePlaceholders(text, line, stop, lastStop, nextStop, null, null);
    }

    public static String replacePlaceholders(String text, Line line, Stop stop, Stop lastStop, Stop nextStop, Stop terminalStop) {
        return TextUtil.replacePlaceholders(text, line, stop, lastStop, nextStop, terminalStop, null);
    }

    public static String formatCurrentStationTransferableLines(Stop stop, LineManager lineManager) {
        return TextUtil.formatTransferableLines(stop, lineManager);
    }
}

