/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.metro.model;

import java.util.ArrayList;
import java.util.List;

public class Line {
    private String id;
    private String name;
    private final List<String> orderedStopIds;
    private String color;
    private String terminusName;
    private Double maxSpeed;

    public Line(String id, String name) {
        this.id = id;
        this.name = name;
        this.orderedStopIds = new ArrayList<String>();
        this.color = "&f";
        this.terminusName = "";
        this.maxSpeed = null;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public String getTerminusName() {
        return this.terminusName;
    }

    public void setTerminusName(String terminusName) {
        this.terminusName = terminusName;
    }

    public Double getMaxSpeed() {
        if (this.maxSpeed == null) {
            return -1.0;
        }
        return this.maxSpeed;
    }

    public void setMaxSpeed(Double maxSpeed) {
        this.maxSpeed = maxSpeed;
    }

    public List<String> getOrderedStopIds() {
        return new ArrayList<String>(this.orderedStopIds);
    }

    public void addStop(String stopId, int index) {
        if (this.orderedStopIds.contains(stopId)) {
            this.orderedStopIds.remove(stopId);
        }
        if (index >= 0 && index < this.orderedStopIds.size()) {
            this.orderedStopIds.add(index, stopId);
        } else {
            this.orderedStopIds.add(stopId);
        }
    }

    public void removeStop(String stopId) {
        this.orderedStopIds.remove(stopId);
    }

    public int getStopIndex(String stopId) {
        return this.orderedStopIds.indexOf(stopId);
    }

    public boolean containsStop(String stopId) {
        return this.orderedStopIds.contains(stopId);
    }

    public String getNextStopId(String currentStopId) {
        int index = this.orderedStopIds.indexOf(currentStopId);
        if (index == -1 || index == this.orderedStopIds.size() - 1) {
            return null;
        }
        return this.orderedStopIds.get(index + 1);
    }

    public String getPreviousStopId(String currentStopId) {
        int index = this.orderedStopIds.indexOf(currentStopId);
        if (index <= 0) {
            return null;
        }
        return this.orderedStopIds.get(index - 1);
    }
}

