/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.metro.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.cubexmc.metro.Metro;
import org.cubexmc.metro.manager.LanguageManager;
import org.cubexmc.metro.manager.LineManager;
import org.cubexmc.metro.manager.SelectionManager;
import org.cubexmc.metro.manager.StopManager;
import org.cubexmc.metro.model.Line;
import org.cubexmc.metro.model.Stop;
import org.cubexmc.metro.util.LocationUtil;
import org.cubexmc.metro.util.OwnershipUtil;

public class MetroAdminCommand
implements CommandExecutor {
    private final Metro plugin;

    public MetroAdminCommand(Metro plugin) {
        this.plugin = plugin;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getLanguageManager().getMessage("plugin.players_only"));
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            this.sendHelpMessage(player);
            return true;
        }
        LineManager lineManager = this.plugin.getLineManager();
        StopManager stopManager = this.plugin.getStopManager();
        String mainCommand = args[0].toLowerCase();
        if (mainCommand.equals("line")) {
            String subCommand;
            if (args.length < 2) {
                this.sendLineHelpMessage(player);
                return true;
            }
            switch (subCommand = args[1].toLowerCase()) {
                case "create": {
                    if (args.length < 4) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.usage_create"));
                        return true;
                    }
                    if (!OwnershipUtil.canCreateLine((CommandSender)player)) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.permission_create"));
                        return true;
                    }
                    String lineId = args[2];
                    String lineName = args[3];
                    if (lineManager.createLine(lineId, lineName, player.getUniqueId())) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.create_success", LanguageManager.put(LanguageManager.args(), "line_id", lineId)));
                        return true;
                    }
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("line.create_exists", LanguageManager.put(LanguageManager.args(), "line_id", lineId)));
                    return true;
                }
                case "delete": {
                    if (args.length < 3) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.usage_delete"));
                        return true;
                    }
                    String lineId = args[2];
                    Line lineToDelete = lineManager.getLine(lineId);
                    if (lineToDelete == null) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.delete_not_found", LanguageManager.put(LanguageManager.args(), "line_id", lineId)));
                        return true;
                    }
                    if (!OwnershipUtil.canManageLine((CommandSender)player, lineToDelete)) {
                        this.sendLinePermissionDenied(player, lineToDelete);
                        return true;
                    }
                    if (lineManager.deleteLine(lineId)) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.delete_success", LanguageManager.put(LanguageManager.args(), "line_id", lineId)));
                        return true;
                    }
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("line.delete_fail", LanguageManager.put(LanguageManager.args(), "line_id", lineId)));
                    return true;
                }
                case "list": {
                    List<Line> lines = lineManager.getAllLines();
                    if (lines.isEmpty()) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.list_empty"));
                        return true;
                    }
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("line.list_header"));
                    for (Line line : lines) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.list_item_format", LanguageManager.put(LanguageManager.put(LanguageManager.args(), "line_name", line.getName()), "line_id", line.getId())));
                    }
                    return true;
                }
                case "setcolor": {
                    if (args.length < 4) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.usage_setcolor"));
                        return true;
                    }
                    String lineId = args[2];
                    String color = args[3];
                    Line colorLine = lineManager.getLine(lineId);
                    if (colorLine == null) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.delete_not_found", LanguageManager.put(LanguageManager.args(), "line_id", lineId)));
                        return true;
                    }
                    if (!OwnershipUtil.canManageLine((CommandSender)player, colorLine)) {
                        this.sendLinePermissionDenied(player, colorLine);
                        return true;
                    }
                    if (lineManager.setLineColor(lineId, color)) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.setcolor_success", LanguageManager.put(LanguageManager.put(LanguageManager.args(), "line_id", lineId), "color", color)));
                        return true;
                    }
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("line.setcolor_fail", LanguageManager.put(LanguageManager.args(), "line_id", lineId)));
                    return true;
                }
                case "setterminus": {
                    if (args.length < 3) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.usage_setterminus"));
                        return true;
                    }
                    String lineId = args[2];
                    Line terminusLine = lineManager.getLine(lineId);
                    if (terminusLine == null) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.delete_not_found", LanguageManager.put(LanguageManager.args(), "line_id", lineId)));
                        return true;
                    }
                    if (!OwnershipUtil.canManageLine((CommandSender)player, terminusLine)) {
                        this.sendLinePermissionDenied(player, terminusLine);
                        return true;
                    }
                    if (args.length == 3) {
                        if (lineManager.setLineTerminusName(lineId, null)) {
                            player.sendMessage(this.plugin.getLanguageManager().getMessage("line.setterminus_success", LanguageManager.put(LanguageManager.put(LanguageManager.args(), "line_id", lineId), "terminus_name", "")));
                            return true;
                        } else {
                            player.sendMessage(this.plugin.getLanguageManager().getMessage("line.delete_not_found", LanguageManager.put(LanguageManager.args(), "line_id", lineId)));
                        }
                        return true;
                    }
                    String terminusName = args[3];
                    if (lineManager.setLineTerminusName(lineId, terminusName)) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.setterminus_success", LanguageManager.put(LanguageManager.put(LanguageManager.args(), "line_id", lineId), "terminus_name", terminusName)));
                        return true;
                    }
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("line.delete_not_found", LanguageManager.put(LanguageManager.args(), "line_id", lineId)));
                    return true;
                }
                case "setmaxspeed": {
                    if (args.length < 4) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.usage_setmaxspeed"));
                        return true;
                    }
                    String lineId = args[2];
                    Line maxSpeedLine = lineManager.getLine(lineId);
                    if (maxSpeedLine == null) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.delete_not_found", LanguageManager.put(LanguageManager.args(), "line_id", lineId)));
                        return true;
                    }
                    if (!OwnershipUtil.canManageLine((CommandSender)player, maxSpeedLine)) {
                        this.sendLinePermissionDenied(player, maxSpeedLine);
                        return true;
                    }
                    try {
                        double maxSpeed = Double.parseDouble(args[3]);
                        if (maxSpeed < 0.0) {
                            player.sendMessage(this.plugin.getLanguageManager().getMessage("line.setmaxspeed_invalid"));
                            return true;
                        }
                        if (lineManager.setLineMaxSpeed(lineId, maxSpeed)) {
                            player.sendMessage(this.plugin.getLanguageManager().getMessage("line.setmaxspeed_success", LanguageManager.put(LanguageManager.put(LanguageManager.args(), "line_id", lineId), "max_speed", String.valueOf(maxSpeed))));
                            return true;
                        }
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.delete_not_found", LanguageManager.put(LanguageManager.args(), "line_id", lineId)));
                        return true;
                    }
                    catch (NumberFormatException e) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.setmaxspeed_invalid"));
                    }
                    return true;
                }
                case "rename": {
                    if (args.length < 4) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.usage_rename"));
                        return true;
                    }
                    String lineId = args[2];
                    String newName = args[3];
                    Line renameLine = lineManager.getLine(lineId);
                    if (renameLine == null) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.rename_fail"));
                        return true;
                    }
                    if (!OwnershipUtil.canManageLine((CommandSender)player, renameLine)) {
                        this.sendLinePermissionDenied(player, renameLine);
                        return true;
                    }
                    if (lineManager.setLineName(lineId, newName)) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.rename_success", LanguageManager.put(LanguageManager.put(LanguageManager.args(), "line_id", lineId), "new_name", newName)));
                        return true;
                    }
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("line.rename_fail"));
                    return true;
                }
                case "addstop": {
                    if (args.length < 4) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.usage_addstop"));
                        return true;
                    }
                    String lineId = args[2];
                    String stopId = args[3];
                    Line lineToAdd = lineManager.getLine(lineId);
                    if (lineToAdd == null) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.addstop_fail"));
                        return true;
                    }
                    if (!OwnershipUtil.canManageLine((CommandSender)player, lineToAdd)) {
                        this.sendLinePermissionDenied(player, lineToAdd);
                        return true;
                    }
                    Stop stopToAdd = stopManager.getStop(stopId);
                    if (stopToAdd == null) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.stop_not_found", LanguageManager.put(LanguageManager.args(), "stop_id", stopId)));
                        return true;
                    }
                    if (!OwnershipUtil.canLinkStopToLine((CommandSender)player, lineToAdd, stopToAdd)) {
                        this.sendStopLinkDenied(player, lineToAdd, stopToAdd);
                        return true;
                    }
                    int index = -1;
                    if (args.length > 4) {
                        try {
                            index = Integer.parseInt(args[4]);
                        }
                        catch (NumberFormatException e) {
                            player.sendMessage(this.plugin.getLanguageManager().getMessage("line.index_format"));
                            return true;
                        }
                    }
                    if (lineToAdd.isCircular() && index != -1 && index >= lineToAdd.getOrderedStopIds().size() - 1) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.addstop_circular_invalid_index"));
                        return true;
                    }
                    boolean wasCircular = lineToAdd.isCircular();
                    if (lineManager.addStopToLine(lineId, stopId, index)) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.addstop_success", LanguageManager.put(LanguageManager.put(LanguageManager.args(), "stop_id", stopId), "line_id", lineId)));
                        Line updatedLine = lineManager.getLine(lineId);
                        if (wasCircular || !updatedLine.isCircular()) return true;
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.made_circular", LanguageManager.put(LanguageManager.args(), "line_id", lineId)));
                        return true;
                    }
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("line.addstop_fail"));
                    return true;
                }
                case "delstop": {
                    if (args.length < 4) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.usage_delstop"));
                        return true;
                    }
                    String lineId = args[2];
                    String stopId = args[3];
                    Line lineToDel = lineManager.getLine(lineId);
                    if (lineToDel == null) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.delstop_fail"));
                        return true;
                    }
                    if (!OwnershipUtil.canManageLine((CommandSender)player, lineToDel)) {
                        this.sendLinePermissionDenied(player, lineToDel);
                        return true;
                    }
                    boolean wasCircularBeforeDelete = lineToDel.isCircular();
                    if (lineManager.delStopFromLine(lineId, stopId)) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.delstop_success", LanguageManager.put(LanguageManager.put(LanguageManager.args(), "stop_id", stopId), "line_id", lineId)));
                        Line updatedLine = lineManager.getLine(lineId);
                        if (!wasCircularBeforeDelete || updatedLine.isCircular()) return true;
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.made_normal", LanguageManager.put(LanguageManager.args(), "line_id", lineId)));
                        return true;
                    }
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("line.delstop_fail"));
                    return true;
                }
                case "stops": {
                    if (args.length < 3) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.usage_stops"));
                        return true;
                    }
                    String lineId = args[2];
                    Line line = lineManager.getLine(lineId);
                    if (line == null) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.line_not_found", LanguageManager.put(LanguageManager.args(), "line_id", lineId)));
                        return true;
                    }
                    List<String> stopIds = line.getOrderedStopIds();
                    if (stopIds.isEmpty()) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.stops_list_empty", LanguageManager.put(LanguageManager.args(), "line_name", line.getName())));
                        return true;
                    }
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("line.stops_list_header"));
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(line.getColor() + line.getName() + " &f(" + line.getId() + ")")));
                    for (int i = 0; i < stopIds.size(); ++i) {
                        String currentStopId = stopIds.get(i);
                        Stop stop = stopManager.getStop(currentStopId);
                        if (stop != null) {
                            String status = "";
                            if (i == 0) {
                                status = this.plugin.getLanguageManager().getMessage("line.stops_status_start");
                            }
                            if (i == stopIds.size() - 1) {
                                status = this.plugin.getLanguageManager().getMessage("line.stops_status_end");
                            }
                            TextComponent message = new TextComponent(this.plugin.getLanguageManager().getMessage("line.stops_list_prefix", LanguageManager.put(LanguageManager.args(), "index", String.valueOf(i + 1))));
                            message.addExtra((BaseComponent)this.createTeleportComponent(stop));
                            String suffixText = this.plugin.getLanguageManager().getMessage("line.stops_list_suffix", LanguageManager.put(LanguageManager.put(LanguageManager.args(), "stop_id", stop.getId()), "status", status));
                            message.addExtra((BaseComponent)new TextComponent(" " + suffixText));
                            player.spigot().sendMessage((BaseComponent)message);
                            continue;
                        }
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.stops_list_invalid_stop", LanguageManager.put(LanguageManager.put(LanguageManager.args(), "index", String.valueOf(i + 1)), "stop_id", currentStopId)));
                    }
                    return true;
                }
                case "info": {
                    if (args.length < 3) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.usage_info"));
                        return true;
                    }
                    String lineId = args[2];
                    Line infoLine = lineManager.getLine(lineId);
                    if (infoLine == null) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.delete_not_found", LanguageManager.put(LanguageManager.args(), "line_id", lineId)));
                        return true;
                    }
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("line.info_header", LanguageManager.put(LanguageManager.put(LanguageManager.args(), "line_id", infoLine.getId()), "line_name", infoLine.getName())));
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("line.info_owner", LanguageManager.put(LanguageManager.args(), "owner", this.resolvePlayerName(infoLine.getOwner()))));
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("line.info_admins", LanguageManager.put(LanguageManager.args(), "admins", this.formatAdminNames(infoLine.getAdmins(), infoLine.getOwner()))));
                    return true;
                }
                case "trust": {
                    if (args.length < 4) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.usage_trust"));
                        return true;
                    }
                    String lineId = args[2];
                    String trustTargetName = args[3];
                    Line trustLine = lineManager.getLine(lineId);
                    if (trustLine == null) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.delete_not_found", LanguageManager.put(LanguageManager.args(), "line_id", lineId)));
                        return true;
                    }
                    if (!OwnershipUtil.canManageLine((CommandSender)player, trustLine)) {
                        this.sendLinePermissionDenied(player, trustLine);
                        return true;
                    }
                    UUID trustTargetId = this.resolvePlayerUUID(trustTargetName);
                    if (trustTargetId == null) {
                        this.sendPlayerNotFound(player, trustTargetName);
                        return true;
                    }
                    if (!lineManager.addLineAdmin(lineId, trustTargetId)) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.trust_exists", LanguageManager.put(LanguageManager.args(), "player", trustTargetName)));
                        return true;
                    }
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("line.trust_success", LanguageManager.put(LanguageManager.put(LanguageManager.args(), "line_id", lineId), "player", this.resolvePlayerName(trustTargetId))));
                    return true;
                }
                case "untrust": {
                    if (args.length < 4) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.usage_untrust"));
                        return true;
                    }
                    String lineId = args[2];
                    String untrustTargetName = args[3];
                    Line untrustLine = lineManager.getLine(lineId);
                    if (untrustLine == null) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.delete_not_found", LanguageManager.put(LanguageManager.args(), "line_id", lineId)));
                        return true;
                    }
                    if (!OwnershipUtil.canManageLine((CommandSender)player, untrustLine)) {
                        this.sendLinePermissionDenied(player, untrustLine);
                        return true;
                    }
                    UUID untrustTargetId = this.resolvePlayerUUID(untrustTargetName);
                    if (untrustTargetId == null) {
                        this.sendPlayerNotFound(player, untrustTargetName);
                        return true;
                    }
                    if (!lineManager.removeLineAdmin(lineId, untrustTargetId)) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.untrust_fail", LanguageManager.put(LanguageManager.args(), "player", untrustTargetName)));
                        return true;
                    }
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("line.untrust_success", LanguageManager.put(LanguageManager.put(LanguageManager.args(), "line_id", lineId), "player", this.resolvePlayerName(untrustTargetId))));
                    return true;
                }
                case "owner": {
                    if (args.length < 4) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.usage_owner"));
                        return true;
                    }
                    String lineId = args[2];
                    String newOwnerName = args[3];
                    Line ownerLine = lineManager.getLine(lineId);
                    if (ownerLine == null) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.delete_not_found", LanguageManager.put(LanguageManager.args(), "line_id", lineId)));
                        return true;
                    }
                    UUID requesterId = player.getUniqueId();
                    if (!(OwnershipUtil.hasAdminBypass((CommandSender)player) || ownerLine.getOwner() != null && requesterId.equals(ownerLine.getOwner()))) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.permission_owner"));
                        return true;
                    }
                    UUID newOwnerId = this.resolvePlayerUUID(newOwnerName);
                    if (newOwnerId == null) {
                        this.sendPlayerNotFound(player, newOwnerName);
                        return true;
                    }
                    if (lineManager.setLineOwner(lineId, newOwnerId)) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.owner_success", LanguageManager.put(LanguageManager.put(LanguageManager.args(), "line_id", lineId), "owner", this.resolvePlayerName(newOwnerId))));
                        return true;
                    }
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("line.owner_fail", LanguageManager.put(LanguageManager.args(), "line_id", lineId)));
                    return true;
                }
                default: {
                    this.sendLineHelpMessage(player);
                    return true;
                }
            }
        }
        if (mainCommand.equals("stop")) {
            if (args.length < 2) {
                this.sendStopHelpMessage(player);
                return true;
            }
            String subCommand = args[1].toLowerCase();
            if ("tp".equals(subCommand)) {
                if (args.length < 3) {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.usage_tp"));
                    return true;
                }
                String stopId = args[2];
                Stop stop = stopManager.getStop(stopId);
                if (stop == null) {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.stop_not_found", LanguageManager.put(LanguageManager.args(), "stop_id", stopId)));
                    return true;
                }
                if (!OwnershipUtil.canManageStop((CommandSender)player, stop)) {
                    this.sendStopPermissionDenied(player, stop);
                    return true;
                }
                if (stop.getStopPointLocation() == null) {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.stoppoint_not_set", LanguageManager.put(LanguageManager.args(), "stop_name", stop.getName())));
                    return true;
                }
                player.teleportAsync(stop.getStopPointLocation()).thenAccept(success -> {
                    if (success.booleanValue()) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.tp_success", LanguageManager.put(LanguageManager.args(), "stop_name", stop.getName())));
                    } else {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "Teleport failed. The destination might be unsafe.");
                    }
                });
                return true;
            }
            if ("info".equals(subCommand)) {
                if (args.length < 3) {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.usage_info"));
                    return true;
                }
                String stopId = args[2];
                Stop stop = stopManager.getStop(stopId);
                if (stop == null) {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.stop_not_found", LanguageManager.put(LanguageManager.args(), "stop_id", stopId)));
                    return true;
                }
                if (!OwnershipUtil.canManageStop((CommandSender)player, stop)) {
                    this.sendStopPermissionDenied(player, stop);
                    return true;
                }
                player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.info_header", LanguageManager.put(LanguageManager.args(), "stop_name", stop.getName())));
                player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.info_id", LanguageManager.put(LanguageManager.args(), "stop_id", stop.getId())));
                TextComponent nameComponent = new TextComponent(this.plugin.getLanguageManager().getMessage("stop.info_name", LanguageManager.put(LanguageManager.args(), "stop_name", stop.getName())));
                nameComponent.addExtra((BaseComponent)this.createTeleportComponent(stop));
                player.spigot().sendMessage((BaseComponent)nameComponent);
                Location corner1 = stop.getCorner1();
                Location corner2 = stop.getCorner2();
                player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.info_corner1", LanguageManager.put(LanguageManager.args(), "corner1", corner1 != null ? LocationUtil.locationToString(corner1) : "Not set")));
                player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.info_corner2", LanguageManager.put(LanguageManager.args(), "corner2", corner2 != null ? LocationUtil.locationToString(corner2) : "Not set")));
                Location stopPoint = stop.getStopPointLocation();
                player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.info_stoppoint", LanguageManager.put(LanguageManager.args(), "stoppoint", stopPoint != null ? LocationUtil.locationToString(stopPoint) : "Not set")));
                player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.info_owner", LanguageManager.put(LanguageManager.args(), "owner", this.resolvePlayerName(stop.getOwner()))));
                player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.info_admins", LanguageManager.put(LanguageManager.args(), "admins", this.formatAdminNames(stop.getAdmins(), stop.getOwner()))));
                player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.info_linked_lines", LanguageManager.put(LanguageManager.args(), "lines", this.formatLineIds(stop.getLinkedLineIds()))));
                return true;
            }
            if (subCommand.equals("addtransfer")) {
                if (args.length < 4) {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.usage_addtransfer"));
                    return true;
                }
                String stopId = args[2];
                String transferLineId = args[3];
                Stop stop = stopManager.getStop(stopId);
                if (stop == null) {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.stop_not_found", LanguageManager.put(LanguageManager.args(), "stop_id", stopId)));
                    return true;
                }
                if (!OwnershipUtil.canManageStop((CommandSender)player, stop)) {
                    this.sendStopPermissionDenied(player, stop);
                    return true;
                }
                Line transferLine = lineManager.getLine(transferLineId);
                if (transferLine == null) {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("line.line_not_found", LanguageManager.put(LanguageManager.args(), "line_id", transferLineId)));
                    return true;
                }
                if (stopManager.addTransferLine(stopId, transferLineId)) {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.addtransfer_success", LanguageManager.put(LanguageManager.put(LanguageManager.args(), "transfer_line_name", transferLine.getName()), "stop_name", stop.getName())));
                    return true;
                } else {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.addtransfer_exists", LanguageManager.put(LanguageManager.put(LanguageManager.args(), "stop_name", stop.getName()), "transfer_line_name", transferLine.getName())));
                }
                return true;
            }
            if (subCommand.equals("deltransfer")) {
                if (args.length < 4) {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.usage_deltransfer"));
                    return true;
                }
                String stopId = args[2];
                String transferLineId = args[3];
                Stop stop = stopManager.getStop(stopId);
                if (stop == null) {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.stop_not_found", LanguageManager.put(LanguageManager.args(), "stop_id", stopId)));
                    return true;
                }
                if (!OwnershipUtil.canManageStop((CommandSender)player, stop)) {
                    this.sendStopPermissionDenied(player, stop);
                    return true;
                }
                Line transferLine = lineManager.getLine(transferLineId);
                if (transferLine == null) {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("line.line_not_found", LanguageManager.put(LanguageManager.args(), "line_id", transferLineId)));
                    return true;
                }
                if (stopManager.removeTransferLine(stopId, transferLineId)) {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.deltransfer_success", LanguageManager.put(LanguageManager.put(LanguageManager.args(), "stop_name", stop.getName()), "transfer_line_name", transferLine.getName())));
                    return true;
                } else {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.deltransfer_not_exists", LanguageManager.put(LanguageManager.put(LanguageManager.args(), "stop_name", stop.getName()), "transfer_line_name", transferLine.getName())));
                }
                return true;
            }
            if (subCommand.equals("listtransfers")) {
                if (args.length < 3) {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.usage_listtransfers"));
                    return true;
                }
                String stopId = args[2];
                Stop stop = stopManager.getStop(stopId);
                if (stop == null) {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.stop_not_found", LanguageManager.put(LanguageManager.args(), "stop_id", stopId)));
                    return true;
                }
                List<String> transferLineIds = stopManager.getTransferableLines(stopId);
                if (transferLineIds.isEmpty()) {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.transfers_empty", LanguageManager.put(LanguageManager.args(), "stop_name", stop.getName())));
                    return true;
                }
                player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.transfers_header", LanguageManager.put(LanguageManager.args(), "stop_name", stop.getName())));
                for (String id : transferLineIds) {
                    Line txLine = lineManager.getLine(id);
                    if (txLine != null) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.transfers_format", LanguageManager.put(LanguageManager.args(), "line_name", txLine.getName())));
                        continue;
                    }
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.transfers_invalid", LanguageManager.put(LanguageManager.args(), "line_id", id)));
                }
                return true;
            }
            if (subCommand.equals("settitle")) {
                if (args.length < 6) {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.usage_settitle"));
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.title_types"));
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.title_keys"));
                    return true;
                }
                String stopId = args[2];
                String titleType = args[3];
                String key = args[4];
                String value = args[5];
                Stop stop = stopManager.getStop(stopId);
                if (stop == null) {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.stop_not_found", LanguageManager.put(LanguageManager.args(), "stop_id", stopId)));
                    return true;
                }
                if (!this.isValidTitleType(titleType)) {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.title_type_invalid", LanguageManager.put(LanguageManager.args(), "title_type", titleType)));
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.title_types"));
                    return true;
                }
                if (!this.isValidTitleKey(key)) {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.title_key_invalid", LanguageManager.put(LanguageManager.args(), "title_key", key)));
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.title_keys"));
                    return true;
                }
                Map<String, String> titleConfig = stop.getCustomTitle(titleType);
                if (titleConfig == null) {
                    titleConfig = new HashMap<String, String>();
                }
                titleConfig.put(key, value);
                stop.setCustomTitle(titleType, titleConfig);
                stopManager.saveConfig();
                player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.settitle_success", LanguageManager.put(LanguageManager.put(LanguageManager.put(LanguageManager.put(LanguageManager.args(), "stop_name", stop.getName()), "title_type", titleType), "title_key", key), "title_value", value)));
                return true;
            }
            if (subCommand.equals("deltitle")) {
                if (args.length < 4) {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.usage_deltitle"));
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.title_types"));
                    return true;
                }
                String stopId = args[2];
                String titleType = args[3];
                String key = args.length > 4 ? args[4] : null;
                Stop stop = stopManager.getStop(stopId);
                if (stop == null) {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.stop_not_found", LanguageManager.put(LanguageManager.args(), "stop_id", stopId)));
                    return true;
                }
                if (!this.isValidTitleType(titleType)) {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.title_type_invalid", LanguageManager.put(LanguageManager.args(), "title_type", titleType)));
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.title_types"));
                    return true;
                }
                if (key == null) {
                    if (stop.removeCustomTitle(titleType)) {
                        stopManager.saveConfig();
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.deltitle_type_success", LanguageManager.put(LanguageManager.put(LanguageManager.args(), "stop_name", stop.getName()), "title_type", titleType)));
                        return true;
                    } else {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.deltitle_type_not_found", LanguageManager.put(LanguageManager.put(LanguageManager.args(), "stop_name", stop.getName()), "title_type", titleType)));
                    }
                    return true;
                } else {
                    Map<String, String> titleConfig = stop.getCustomTitle(titleType);
                    if (titleConfig != null && titleConfig.containsKey(key)) {
                        titleConfig.remove(key);
                        if (titleConfig.isEmpty()) {
                            stop.removeCustomTitle(titleType);
                        } else {
                            stop.setCustomTitle(titleType, titleConfig);
                        }
                        stopManager.saveConfig();
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.deltitle_success", LanguageManager.put(LanguageManager.put(LanguageManager.put(LanguageManager.args(), "stop_name", stop.getName()), "title_type", titleType), "title_key", key)));
                        return true;
                    } else {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.deltitle_not_found", LanguageManager.put(LanguageManager.put(LanguageManager.put(LanguageManager.args(), "stop_name", stop.getName()), "title_type", titleType), "title_key", key)));
                    }
                }
                return true;
            }
            if (subCommand.equals("listtitles")) {
                String[] titleTypes;
                if (args.length < 3) {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.usage_listtitles"));
                    return true;
                }
                String stopId = args[2];
                Stop stop = stopManager.getStop(stopId);
                if (stop == null) {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.stop_not_found", LanguageManager.put(LanguageManager.args(), "stop_id", stopId)));
                    return true;
                }
                player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.listtitles_header"));
                boolean hasCustomTitles = false;
                for (String titleType : titleTypes = new String[]{"stop_continuous", "arrive_stop", "terminal_stop", "departure"}) {
                    Map<String, String> titleConfig = stop.getCustomTitle(titleType);
                    if (titleConfig == null || titleConfig.isEmpty()) continue;
                    hasCustomTitles = true;
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.listtitles_type", LanguageManager.put(LanguageManager.args(), "title_type", titleType)));
                    for (Map.Entry<String, String> entry : titleConfig.entrySet()) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.listtitles_item", LanguageManager.put(LanguageManager.put(LanguageManager.args(), "title_key", entry.getKey()), "title_value", entry.getValue())));
                    }
                }
                if (hasCustomTitles) return true;
                player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.listtitles_empty"));
                return true;
            }
            if (subCommand.equals("rename")) {
                if (args.length < 4) {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.usage_rename"));
                    return true;
                }
                String stopId = args[2];
                StringBuilder newName = new StringBuilder();
                for (int i = 3; i < args.length; ++i) {
                    if (i > 3) {
                        newName.append(" ");
                    }
                    newName.append(args[i]);
                }
                Stop stop = stopManager.getStop(stopId);
                if (stop == null) {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.stop_not_found", LanguageManager.put(LanguageManager.args(), "stop_id", stopId)));
                    return true;
                }
                if (!OwnershipUtil.canManageStop((CommandSender)player, stop)) {
                    this.sendStopPermissionDenied(player, stop);
                    return true;
                }
                String oldName = stop.getName();
                if (stopManager.setStopName(stopId, newName.toString())) {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.rename_success", LanguageManager.put(LanguageManager.put(LanguageManager.args(), "old_name", oldName), "new_name", newName.toString())));
                    return true;
                } else {
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.rename_fail"));
                }
                return true;
            }
            switch (subCommand) {
                case "create": {
                    Location corner2;
                    if (args.length < 3) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.usage_create"));
                        return true;
                    }
                    if (!OwnershipUtil.canCreateStop((CommandSender)player)) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.permission_create"));
                        return true;
                    }
                    String stopId = args[2];
                    StringBuilder nameBuilder = new StringBuilder();
                    for (int i = 3; i < args.length; ++i) {
                        nameBuilder.append(args[i]).append(" ");
                    }
                    String stopName = nameBuilder.toString().trim();
                    SelectionManager selectionManager = this.plugin.getSelectionManager();
                    if (!selectionManager.isSelectionComplete(player)) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.selection_not_complete"));
                        return true;
                    }
                    Location corner1 = selectionManager.getCorner1(player);
                    Stop newStop = stopManager.createStop(stopId, stopName, corner1, corner2 = selectionManager.getCorner2(player), player.getUniqueId());
                    if (newStop != null) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.create_success", LanguageManager.put(LanguageManager.args(), "stop_name", stopName)));
                        return true;
                    }
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.stop_exists", LanguageManager.put(LanguageManager.args(), "stop_id", stopId)));
                    return true;
                }
                case "setcorners": {
                    if (args.length < 3) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.usage_setcorners"));
                        return true;
                    }
                    String stopId = args[2];
                    SelectionManager selectionManagerCorners = this.plugin.getSelectionManager();
                    if (!selectionManagerCorners.isSelectionComplete(player)) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.selection_not_complete"));
                        return true;
                    }
                    Location corner1ToSet = selectionManagerCorners.getCorner1(player);
                    Location corner2ToSet = selectionManagerCorners.getCorner2(player);
                    Stop cornersStop = stopManager.getStop(stopId);
                    if (cornersStop == null) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.stop_not_found", LanguageManager.put(LanguageManager.args(), "stop_id", stopId)));
                        return true;
                    }
                    if (!OwnershipUtil.canManageStop((CommandSender)player, cornersStop)) {
                        this.sendStopPermissionDenied(player, cornersStop);
                        return true;
                    }
                    if (stopManager.setStopCorners(stopId, corner1ToSet, corner2ToSet)) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.setcorners_success", LanguageManager.put(LanguageManager.args(), "stop_id", stopId)));
                        return true;
                    }
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.stop_not_found", LanguageManager.put(LanguageManager.args(), "stop_id", stopId)));
                    return true;
                }
                case "delete": {
                    if (args.length < 3) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.usage_delete"));
                        return true;
                    }
                    String stopId = args[2];
                    Stop stopToDelete = stopManager.getStop(stopId);
                    if (stopToDelete == null) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.stop_not_found", LanguageManager.put(LanguageManager.args(), "stop_id", stopId)));
                        return true;
                    }
                    if (!OwnershipUtil.canManageStop((CommandSender)player, stopToDelete)) {
                        this.sendStopPermissionDenied(player, stopToDelete);
                        return true;
                    }
                    if (stopManager.deleteStop(stopId)) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.delete_success", LanguageManager.put(LanguageManager.args(), "stop_id", stopId)));
                        return true;
                    }
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.delete_fail"));
                    return true;
                }
                case "list": {
                    ArrayList stops = new ArrayList(stopManager.getAllStopIds().stream().map(stopManager::getStop).filter(Objects::nonNull).collect(Collectors.toList()));
                    if (stops.isEmpty()) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.list_empty"));
                        return true;
                    }
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.list_header"));
                    stops.sort((s1, s2) -> s1.getId().compareTo(s2.getId()));
                    for (int i = 0; i < stops.size(); ++i) {
                        Stop stop = (Stop)stops.get(i);
                        TextComponent message = new TextComponent(this.plugin.getLanguageManager().getMessage("stop.list_prefix", LanguageManager.put(LanguageManager.args(), "index", String.valueOf(i + 1))));
                        message.addExtra((BaseComponent)this.createTeleportComponent(stop));
                        String suffixText = this.plugin.getLanguageManager().getMessage("stop.list_suffix", LanguageManager.put(LanguageManager.args(), "stop_id", stop.getId()));
                        message.addExtra((BaseComponent)new TextComponent(" " + suffixText));
                        player.spigot().sendMessage((BaseComponent)message);
                    }
                    return true;
                }
                case "setpoint": {
                    Location location = player.getLocation();
                    if (!LocationUtil.isRail(location)) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.setpoint_not_rail"));
                        return true;
                    }
                    Stop stop = stopManager.getStopContainingLocation(location);
                    if (stop == null) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.no_stop_found_at_location"));
                        return true;
                    }
                    if (!OwnershipUtil.canManageStop((CommandSender)player, stop)) {
                        this.sendStopPermissionDenied(player, stop);
                        return true;
                    }
                    String stopId = stop.getId();
                    float yaw = player.getLocation().getYaw();
                    if (args.length > 2) {
                        try {
                            yaw = Float.parseFloat(args[2]);
                        }
                        catch (NumberFormatException e) {
                            player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.setpoint_yaw_invalid"));
                            return true;
                        }
                    }
                    if (stopManager.setStopPoint(stopId, location, yaw)) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.setpoint_success", LanguageManager.put(LanguageManager.put(LanguageManager.args(), "stop_id", stopId), "yaw", String.valueOf(yaw))));
                        return true;
                    }
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.setpoint_fail"));
                    return true;
                }
                case "trust": {
                    if (args.length < 4) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.usage_trust"));
                        return true;
                    }
                    String stopId = args[2];
                    String stopTrustTarget = args[3];
                    Stop trustStop = stopManager.getStop(stopId);
                    if (trustStop == null) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.stop_not_found", LanguageManager.put(LanguageManager.args(), "stop_id", stopId)));
                        return true;
                    }
                    if (!OwnershipUtil.canManageStop((CommandSender)player, trustStop)) {
                        this.sendStopPermissionDenied(player, trustStop);
                        return true;
                    }
                    UUID trustStopUuid = this.resolvePlayerUUID(stopTrustTarget);
                    if (trustStopUuid == null) {
                        this.sendPlayerNotFound(player, stopTrustTarget);
                        return true;
                    }
                    if (!stopManager.addStopAdmin(stopId, trustStopUuid)) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.trust_exists", LanguageManager.put(LanguageManager.args(), "player", stopTrustTarget)));
                        return true;
                    }
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.trust_success", LanguageManager.put(LanguageManager.put(LanguageManager.args(), "stop_id", stopId), "player", this.resolvePlayerName(trustStopUuid))));
                    return true;
                }
                case "untrust": {
                    if (args.length < 4) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.usage_untrust"));
                        return true;
                    }
                    String stopId = args[2];
                    String stopUntrustTarget = args[3];
                    Stop untrustStop = stopManager.getStop(stopId);
                    if (untrustStop == null) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.stop_not_found", LanguageManager.put(LanguageManager.args(), "stop_id", stopId)));
                        return true;
                    }
                    if (!OwnershipUtil.canManageStop((CommandSender)player, untrustStop)) {
                        this.sendStopPermissionDenied(player, untrustStop);
                        return true;
                    }
                    UUID untrustStopUuid = this.resolvePlayerUUID(stopUntrustTarget);
                    if (untrustStopUuid == null) {
                        this.sendPlayerNotFound(player, stopUntrustTarget);
                        return true;
                    }
                    if (!stopManager.removeStopAdmin(stopId, untrustStopUuid)) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.untrust_fail", LanguageManager.put(LanguageManager.args(), "player", stopUntrustTarget)));
                        return true;
                    }
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.untrust_success", LanguageManager.put(LanguageManager.put(LanguageManager.args(), "stop_id", stopId), "player", this.resolvePlayerName(untrustStopUuid))));
                    return true;
                }
                case "owner": {
                    if (args.length < 4) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.usage_owner"));
                        return true;
                    }
                    String stopId = args[2];
                    String stopOwnerName = args[3];
                    Stop ownerStop = stopManager.getStop(stopId);
                    if (ownerStop == null) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.stop_not_found", LanguageManager.put(LanguageManager.args(), "stop_id", stopId)));
                        return true;
                    }
                    UUID stopRequester = player.getUniqueId();
                    if (!(OwnershipUtil.hasAdminBypass((CommandSender)player) || ownerStop.getOwner() != null && stopRequester.equals(ownerStop.getOwner()))) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.permission_owner"));
                        return true;
                    }
                    UUID newStopOwner = this.resolvePlayerUUID(stopOwnerName);
                    if (newStopOwner == null) {
                        this.sendPlayerNotFound(player, stopOwnerName);
                        return true;
                    }
                    if (stopManager.setStopOwner(stopId, newStopOwner)) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.owner_success", LanguageManager.put(LanguageManager.put(LanguageManager.args(), "stop_id", stopId), "owner", this.resolvePlayerName(newStopOwner))));
                        return true;
                    }
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.owner_fail", LanguageManager.put(LanguageManager.args(), "stop_id", stopId)));
                    return true;
                }
                case "link": {
                    if (args.length < 5) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.usage_link"));
                        return true;
                    }
                    String action = args[2].toLowerCase();
                    String stopId = args[3];
                    String targetLineId = args[4];
                    Stop linkStop = stopManager.getStop(stopId);
                    if (linkStop == null) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.stop_not_found", LanguageManager.put(LanguageManager.args(), "stop_id", stopId)));
                        return true;
                    }
                    if (!OwnershipUtil.canManageStop((CommandSender)player, linkStop)) {
                        this.sendStopPermissionDenied(player, linkStop);
                        return true;
                    }
                    Line targetLine = lineManager.getLine(targetLineId);
                    if (targetLine == null) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.line_not_found", LanguageManager.put(LanguageManager.args(), "line_id", targetLineId)));
                        return true;
                    }
                    if ("allow".equals(action)) {
                        if (stopManager.allowLineLink(stopId, targetLineId)) {
                            player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.link_allow_success", LanguageManager.put(LanguageManager.put(LanguageManager.args(), "stop_id", stopId), "line_id", targetLineId)));
                            return true;
                        }
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.link_allow_exists", LanguageManager.put(LanguageManager.put(LanguageManager.args(), "stop_id", stopId), "line_id", targetLineId)));
                        return true;
                    }
                    if ("deny".equals(action)) {
                        if (stopManager.denyLineLink(stopId, targetLineId)) {
                            player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.link_deny_success", LanguageManager.put(LanguageManager.put(LanguageManager.args(), "stop_id", stopId), "line_id", targetLineId)));
                            return true;
                        }
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.link_deny_missing", LanguageManager.put(LanguageManager.put(LanguageManager.args(), "stop_id", stopId), "line_id", targetLineId)));
                        return true;
                    }
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.usage_link"));
                    return true;
                }
                default: {
                    this.sendStopHelpMessage(player);
                }
            }
            return true;
        }
        if (mainCommand.equals("reload")) {
            this.plugin.ensureDefaultConfigs();
            this.plugin.reloadConfig();
            lineManager.reload();
            stopManager.reload();
            this.plugin.getLanguageManager().loadLanguages();
            player.sendMessage(this.plugin.getLanguageManager().getMessage("plugin.reload"));
            return true;
        } else {
            player.sendMessage(this.plugin.getLanguageManager().getMessage("command.unknown"));
            this.sendHelpMessage(player);
        }
        return true;
    }

    private void sendHelpMessage(Player player) {
        player.sendMessage(this.plugin.getLanguageManager().getMessage("command.help_header"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("command.help_line"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("command.help_stop"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("command.help_reload"));
    }

    private void sendLineHelpMessage(Player player) {
        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.help_header"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.help_create"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.help_delete"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.help_list"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.help_info"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.help_rename"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.help_setcolor"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.help_setterminus"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.help_setmaxspeed"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.help_addstop"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.help_delstop"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.help_stops"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.help_trust"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.help_untrust"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.help_owner"));
    }

    private void sendStopHelpMessage(Player player) {
        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.help_header"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.help_create"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.help_delete"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.help_list"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.help_info"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.help_rename"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.help_setcorners"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.help_setpoint"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.help_tp"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.help_addtransfer"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.help_deltransfer"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.help_listtransfers"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.help_settitle"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.help_deltitle"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.help_listtitles"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.help_trust"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.help_untrust"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.help_owner"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.help_link"));
    }

    private boolean isValidTitleType(String titleType) {
        return titleType.equals("stop_continuous") || titleType.equals("arrive_stop") || titleType.equals("terminal_stop") || titleType.equals("departure");
    }

    private boolean isValidTitleKey(String key) {
        return key.equals("title") || key.equals("subtitle") || key.equals("actionbar");
    }

    private TextComponent createTeleportComponent(Stop stop) {
        TextComponent stopComponent = new TextComponent(stop.getName());
        if (stop.getStopPointLocation() != null) {
            stopComponent.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/metro stop tp " + stop.getId()));
            stopComponent.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(this.plugin.getLanguageManager().getMessage("command.teleport_to", LanguageManager.put(LanguageManager.args(), "stop_name", stop.getName()))).create()));
        }
        return stopComponent;
    }

    private void sendLinePermissionDenied(Player player, Line line) {
        String ownerName = this.resolvePlayerName(line.getOwner());
        String adminNames = this.formatAdminNames(line.getAdmins(), line.getOwner());
        player.sendMessage(this.plugin.getLanguageManager().getMessage("line.permission_manage", LanguageManager.put(LanguageManager.put(LanguageManager.put(LanguageManager.args(), "line_id", line.getId()), "owner", ownerName), "admins", adminNames)));
    }

    private void sendStopPermissionDenied(Player player, Stop stop) {
        String ownerName = this.resolvePlayerName(stop.getOwner());
        String adminNames = this.formatAdminNames(stop.getAdmins(), stop.getOwner());
        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.permission_manage", LanguageManager.put(LanguageManager.put(LanguageManager.put(LanguageManager.args(), "stop_id", stop.getId()), "owner", ownerName), "admins", adminNames)));
    }

    private void sendStopLinkDenied(Player player, Line line, Stop stop) {
        String ownerName = this.resolvePlayerName(stop.getOwner());
        player.sendMessage(this.plugin.getLanguageManager().getMessage("stop.permission_link", LanguageManager.put(LanguageManager.put(LanguageManager.put(LanguageManager.args(), "stop_id", stop.getId()), "owner", ownerName), "line_id", line.getId())));
    }

    private String resolvePlayerName(UUID uuid) {
        if (uuid == null) {
            return this.plugin.getLanguageManager().getMessage("ownership.server");
        }
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
        if (offlinePlayer != null && offlinePlayer.getName() != null) {
            return offlinePlayer.getName();
        }
        return uuid.toString();
    }

    private UUID resolvePlayerUUID(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)name);
        if (offlinePlayer != null) {
            return offlinePlayer.getUniqueId();
        }
        return null;
    }

    private String formatAdminNames(Set<UUID> adminIds, UUID ownerId) {
        HashSet<String> names = new HashSet<String>();
        for (UUID uuid : adminIds) {
            if (uuid == null || ownerId != null && ownerId.equals(uuid)) continue;
            names.add(this.resolvePlayerName(uuid));
        }
        if (names.isEmpty()) {
            return this.plugin.getLanguageManager().getMessage("ownership.none");
        }
        return String.join((CharSequence)", ", names);
    }

    private void sendPlayerNotFound(Player player, String name) {
        player.sendMessage(this.plugin.getLanguageManager().getMessage("command.player_not_found", LanguageManager.put(LanguageManager.args(), "player", name)));
    }

    private String formatLineIds(Set<String> lineIds) {
        if (lineIds == null || lineIds.isEmpty()) {
            return this.plugin.getLanguageManager().getMessage("ownership.none");
        }
        return String.join((CharSequence)", ", lineIds);
    }
}

