/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.metro.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;
import org.cubexmc.metro.Metro;
import org.cubexmc.metro.manager.LineManager;
import org.cubexmc.metro.manager.StopManager;
import org.cubexmc.metro.model.Line;
import org.cubexmc.metro.model.Stop;
import org.cubexmc.metro.util.OwnershipUtil;

public class MetroAdminTabCompleter
implements TabCompleter {
    private final Metro plugin;
    private static final List<String> MAIN_COMMANDS = Arrays.asList("line", "stop", "reload");
    private static final List<String> LINE_SUBCOMMANDS = Arrays.asList("create", "delete", "list", "setcolor", "setterminus", "addstop", "delstop", "stops", "rename", "setmaxspeed", "info", "trust", "untrust", "owner");
    private static final List<String> STOP_SUBCOMMANDS = Arrays.asList("create", "delete", "list", "setcorners", "setpoint", "tp", "addtransfer", "deltransfer", "listtransfers", "settitle", "deltitle", "listtitles", "rename", "info", "trust", "untrust", "owner", "link");
    private static final List<String> COLOR_CODES = Arrays.asList("&0", "&1", "&2", "&3", "&4", "&5", "&6", "&7", "&8", "&9", "&a", "&b", "&c", "&d", "&e", "&f");
    private static final List<String> TITLE_TYPES = Arrays.asList("stop_continuous", "arrive_stop", "terminal_stop", "departure");
    private static final List<String> TITLE_KEYS = Arrays.asList("title", "subtitle", "actionbar");

    public MetroAdminTabCompleter(Metro plugin) {
        this.plugin = plugin;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        String subCommand;
        if (!(sender instanceof Player)) {
            return Collections.emptyList();
        }
        Player player = (Player)sender;
        if (args.length == 1) {
            return this.getCompletions(args[0], MAIN_COMMANDS);
        }
        String mainCommand = args[0].toLowerCase();
        if ("stop".equals(mainCommand) && args.length >= 3 && "link".equals(args[1].toLowerCase())) {
            if (args.length == 3) {
                return this.getCompletions(args[2], Arrays.asList("allow", "deny"));
            }
            if (args.length == 4) {
                return this.getStopIds(player, true);
            }
            if (args.length == 5) {
                return this.getLineIds(player, false);
            }
            return Collections.emptyList();
        }
        if (args.length == 2) {
            if ("line".equals(mainCommand)) {
                return this.getCompletions(args[1], LINE_SUBCOMMANDS);
            }
            if ("stop".equals(mainCommand)) {
                return this.getCompletions(args[1], STOP_SUBCOMMANDS);
            }
        }
        if (args.length == 3) {
            if ("line".equals(mainCommand)) {
                subCommand = args[1].toLowerCase();
                if (this.isLineManageCommand(subCommand)) {
                    return this.getLineIds(player, true);
                }
                if ("stops".equals(subCommand) || "info".equals(subCommand)) {
                    return this.getLineIds(player, false);
                }
            } else if ("stop".equals(mainCommand)) {
                subCommand = args[1].toLowerCase();
                if (this.isStopManageCommand(subCommand)) {
                    return this.getStopIds(player, true);
                }
                if ("tp".equals(subCommand) || "info".equals(subCommand) || "list".equals(subCommand) || "listtransfers".equals(subCommand) || "listtitles".equals(subCommand)) {
                    return this.getStopIds(player, false);
                }
            }
        }
        if (args.length == 4) {
            if ("line".equals(mainCommand)) {
                subCommand = args[1].toLowerCase();
                if ("setcolor".equals(subCommand)) {
                    return this.getCompletions(args[3], COLOR_CODES);
                }
                if ("addstop".equals(subCommand)) {
                    return this.getStopIds(player, false);
                }
                if ("setmaxspeed".equals(subCommand)) {
                    return this.getCompletions(args[3], Arrays.asList("0.4", "0.6", "0.8", "1.0"));
                }
                if ("trust".equals(subCommand) || "untrust".equals(subCommand) || "owner".equals(subCommand)) {
                    return this.getPlayerNames(args[3]);
                }
            } else if ("stop".equals(mainCommand)) {
                subCommand = args[1].toLowerCase();
                if ("addtransfer".equals(subCommand) || "deltransfer".equals(subCommand)) {
                    return this.getLineIds(player, false);
                }
                if ("settitle".equals(subCommand) || "deltitle".equals(subCommand)) {
                    return this.getCompletions(args[3], TITLE_TYPES);
                }
                if ("trust".equals(subCommand) || "untrust".equals(subCommand) || "owner".equals(subCommand)) {
                    return this.getPlayerNames(args[3]);
                }
            }
        }
        if (args.length == 5 && "stop".equals(mainCommand) && ("settitle".equals(subCommand = args[1].toLowerCase()) || "deltitle".equals(subCommand))) {
            return this.getCompletions(args[4], TITLE_KEYS);
        }
        return Collections.emptyList();
    }

    private List<String> getCompletions(String currentArg, List<String> options) {
        ArrayList<String> completions = new ArrayList<String>();
        StringUtil.copyPartialMatches((String)currentArg, options, completions);
        Collections.sort(completions);
        return completions;
    }

    private List<String> getLineIds(Player player, boolean requireManage) {
        LineManager lineManager = this.plugin.getLineManager();
        return lineManager.getAllLines().stream().filter(line -> !requireManage || OwnershipUtil.canManageLine((CommandSender)player, line)).map(Line::getId).collect(Collectors.toList());
    }

    private List<String> getStopIds(Player player, boolean requireManage) {
        StopManager stopManager = this.plugin.getStopManager();
        return stopManager.getAllStopIds().stream().filter(stopId -> {
            if (!requireManage) {
                return true;
            }
            Stop stop = stopManager.getStop((String)stopId);
            return stop != null && OwnershipUtil.canManageStop((CommandSender)player, stop);
        }).collect(Collectors.toList());
    }

    private List<String> getPlayerNames(String currentArg) {
        List<String> names = Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList());
        return this.getCompletions(currentArg, names);
    }

    private boolean isLineManageCommand(String subCommand) {
        switch (subCommand) {
            case "delete": 
            case "setcolor": 
            case "setterminus": 
            case "addstop": 
            case "delstop": 
            case "rename": 
            case "setmaxspeed": 
            case "trust": 
            case "untrust": 
            case "owner": {
                return true;
            }
        }
        return false;
    }

    private boolean isStopManageCommand(String subCommand) {
        switch (subCommand) {
            case "delete": 
            case "setcorners": 
            case "setpoint": 
            case "addtransfer": 
            case "deltransfer": 
            case "settitle": 
            case "deltitle": 
            case "rename": 
            case "trust": 
            case "untrust": 
            case "owner": 
            case "link": {
                return true;
            }
        }
        return false;
    }
}

