/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.metro.listener;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.cubexmc.metro.Metro;
import org.cubexmc.metro.manager.LanguageManager;
import org.cubexmc.metro.manager.LineManager;
import org.cubexmc.metro.manager.SelectionManager;
import org.cubexmc.metro.manager.StopManager;
import org.cubexmc.metro.model.Line;
import org.cubexmc.metro.model.Stop;
import org.cubexmc.metro.train.TrainMovementTask;
import org.cubexmc.metro.util.SchedulerUtil;
import org.cubexmc.metro.util.SoundUtil;

public class PlayerInteractListener
implements Listener {
    private final Metro plugin;
    private final SelectionManager selectionManager;
    private final Map<UUID, Long> lastInteractTime = new HashMap<UUID, Long>();
    private static final int INTERACT_COOLDOWN = 2000;
    private final Map<String, Long> pendingMinecarts = new HashMap<String, Long>();
    private static final int MINECART_PENDING_TIMEOUT = 60000;

    public PlayerInteractListener(Metro plugin) {
        this.plugin = plugin;
        this.selectionManager = plugin.getSelectionManager();
        SchedulerUtil.globalRun((Plugin)plugin, () -> {
            long currentTime = System.currentTimeMillis();
            this.pendingMinecarts.entrySet().removeIf(entry -> currentTime - (Long)entry.getValue() > 60000L);
        }, 1200L, 1200L);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerInteract(PlayerInteractEvent event) {
        boolean handled;
        String stopId;
        long lastTime;
        Player player = event.getPlayer();
        Action action = event.getAction();
        Block clickedBlock = event.getClickedBlock();
        if (player.hasPermission("metro.admin") && player.getInventory().getItemInMainHand().getType() == Material.GOLDEN_HOE) {
            if (action == Action.LEFT_CLICK_BLOCK) {
                this.selectionManager.setCorner1(player, clickedBlock.getLocation());
                player.sendMessage(this.plugin.getLanguageManager().getMessage("selection.corner1_set", LanguageManager.put(LanguageManager.args(), "location", clickedBlock.getLocation().getBlockX() + ", " + clickedBlock.getLocation().getBlockY() + ", " + clickedBlock.getLocation().getBlockZ())));
                event.setCancelled(true);
                return;
            }
            if (action == Action.RIGHT_CLICK_BLOCK) {
                this.selectionManager.setCorner2(player, clickedBlock.getLocation());
                player.sendMessage(this.plugin.getLanguageManager().getMessage("selection.corner2_set", LanguageManager.put(LanguageManager.args(), "location", clickedBlock.getLocation().getBlockX() + ", " + clickedBlock.getLocation().getBlockY() + ", " + clickedBlock.getLocation().getBlockZ())));
                event.setCancelled(true);
                return;
            }
        }
        if (action != Action.RIGHT_CLICK_BLOCK || clickedBlock == null) {
            return;
        }
        if (!clickedBlock.getType().name().contains("RAIL")) {
            return;
        }
        UUID playerId = player.getUniqueId();
        long currentTime = System.currentTimeMillis();
        if (this.lastInteractTime.containsKey(playerId) && currentTime - (lastTime = this.lastInteractTime.get(playerId).longValue()) < 2000L) {
            event.setCancelled(true);
            return;
        }
        StopManager stopManager = this.plugin.getStopManager();
        Stop stop = stopManager.getStopContainingLocation(clickedBlock.getLocation());
        if (stop != null && this.pendingMinecarts.containsKey(stopId = stop.getId())) {
            long pendingTime = this.pendingMinecarts.get(stopId);
            if (currentTime - pendingTime < 60000L) {
                player.sendMessage(this.plugin.getLanguageManager().getMessage("interact.train_pending"));
                event.setCancelled(true);
                return;
            }
            this.pendingMinecarts.remove(stopId);
        }
        if (handled = this.checkAndHandleStopPoint(player, clickedBlock.getLocation())) {
            this.lastInteractTime.put(playerId, currentTime);
            event.setCancelled(true);
            UUID finalPlayerId = playerId;
            SchedulerUtil.asyncRun((Plugin)this.plugin, () -> this.lastInteractTime.remove(finalPlayerId), 40L);
        }
    }

    private boolean checkAndHandleStopPoint(Player player, Location location) {
        if (!player.hasPermission("metro.use")) {
            return false;
        }
        StopManager stopManager = this.plugin.getStopManager();
        Stop stop = stopManager.getStopContainingLocation(location);
        if (stop != null) {
            if (stop.getStopPointLocation() == null) {
                player.sendMessage(this.plugin.getLanguageManager().getMessage("interact.stop_no_point"));
                return false;
            }
            this.handleStopPoint(player, stop);
            return true;
        }
        return false;
    }

    private void handleStopPoint(Player player, Stop stop) {
        LineManager lineManager = this.plugin.getLineManager();
        Line line = null;
        for (Line l : lineManager.getAllLines()) {
            if (!l.containsStop(stop.getId())) continue;
            line = l;
            break;
        }
        if (line == null) {
            player.sendMessage(this.plugin.getLanguageManager().getMessage("interact.stop_no_line"));
            return;
        }
        String nextStopId = line.getNextStopId(stop.getId());
        if (nextStopId == null) {
            player.sendMessage(this.plugin.getLanguageManager().getMessage("interact.terminal_stop"));
            return;
        }
        this.pendingMinecarts.put(stop.getId(), System.currentTimeMillis());
        this.showLineInfo(player, stop, line);
        this.playStationArrivalSound(player);
        this.spawnMinecart(player, stop, line);
    }

    private void showLineInfo(Player player, Stop stop, Line line) {
        String nextStopId = line.getNextStopId(stop.getId());
        String nextStopName = "\u7ec8\u70b9\u7ad9";
        if (nextStopId != null) {
            Stop nextStop = this.plugin.getStopManager().getStop(nextStopId);
            if (nextStop != null) {
                nextStopName = nextStop.getName();
            }
        } else {
            return;
        }
        String message = String.valueOf(ChatColor.GOLD) + line.getName() + String.valueOf(ChatColor.WHITE) + " - \u4e0b\u4e00\u7ad9: " + String.valueOf(ChatColor.YELLOW) + nextStopName;
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)message));
    }

    private void playStationArrivalSound(Player player) {
        if (this.plugin.isStationArrivalSoundEnabled() && !this.plugin.getStationArrivalNotes().isEmpty()) {
            SoundUtil.playNoteSequence(this.plugin, player, this.plugin.getStationArrivalNotes(), this.plugin.getStationArrivalInitialDelay());
        }
    }

    private void spawnMinecart(Player player, Stop stop, Line line) {
        Location location = stop.getStopPointLocation();
        float yaw = stop.getLaunchYaw();
        if (location != null) {
            String stopId = stop.getId();
            Location spawnLocation = location.clone();
            spawnLocation.setYaw(yaw);
            long spawnDelay = this.plugin.getCartSpawnDelay();
            player.sendMessage(this.plugin.getLanguageManager().getMessage("interact.train_coming"));
            SchedulerUtil.regionRun((Plugin)this.plugin, location, () -> {
                try {
                    Minecart minecart = (Minecart)location.getWorld().spawnEntity(spawnLocation, EntityType.MINECART);
                    minecart.setCustomName("MetroMinecart");
                    minecart.setCustomNameVisible(false);
                    minecart.setPersistent(false);
                    minecart.setGravity(false);
                    minecart.setSlowWhenEmpty(false);
                    double max_speed = line.getMaxSpeed();
                    if (max_speed == -1.0) {
                        max_speed = this.plugin.getCartSpeed();
                    }
                    minecart.setMaxSpeed(max_speed);
                    if (!minecart.addPassenger((Entity)player)) {
                        minecart.remove();
                        this.pendingMinecarts.remove(stopId);
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("interact.train_error"));
                        return;
                    }
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("interact.train_spawned", LanguageManager.put(LanguageManager.args(), "departure_seconds", String.valueOf(this.plugin.getCartDepartureDelay() / 20L))));
                    TrainMovementTask.startTrainTask(this.plugin, minecart, player, line.getId(), stop.getId());
                    this.pendingMinecarts.remove(stopId);
                }
                catch (Exception e) {
                    this.pendingMinecarts.remove(stopId);
                    player.sendMessage(this.plugin.getLanguageManager().getMessage("interact.train_error"));
                    e.printStackTrace();
                }
            }, spawnDelay, -1L);
        }
    }
}

