/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.metro.manager;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.cubexmc.metro.Metro;
import org.cubexmc.metro.model.Line;

public class LineManager {
    private final Metro plugin;
    private final File configFile;
    private FileConfiguration config;
    private final Map<String, Line> lines;

    public LineManager(Metro plugin) {
        this.plugin = plugin;
        this.configFile = new File(plugin.getDataFolder(), "lines.yml");
        this.lines = new HashMap<String, Line>();
        this.loadConfig();
    }

    private void loadConfig() {
        if (!this.configFile.exists()) {
            this.plugin.saveResource("lines.yml", false);
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        this.loadLines();
    }

    private void loadLines() {
        this.lines.clear();
        ConfigurationSection linesSection = this.config.getConfigurationSection("");
        if (linesSection != null) {
            for (String lineId : linesSection.getKeys(false)) {
                List adminStrings;
                String ownerString;
                Double maxSpeed;
                String terminusName;
                String name = this.config.getString(lineId + ".name");
                Line line = new Line(lineId, name);
                List stopIds = this.config.getStringList(lineId + ".ordered_stop_ids");
                for (String stopId : stopIds) {
                    line.addStop(stopId, -1);
                }
                String color = this.config.getString(lineId + ".color");
                if (color != null) {
                    line.setColor(color);
                }
                if ((terminusName = this.config.getString(lineId + ".terminus_name")) != null) {
                    line.setTerminusName(terminusName);
                }
                if ((maxSpeed = Double.valueOf(this.config.getDouble(lineId + ".max_speed", -1.0))) >= 0.0) {
                    line.setMaxSpeed(maxSpeed);
                }
                if ((ownerString = this.config.getString(lineId + ".owner")) != null && !ownerString.isEmpty()) {
                    try {
                        line.setOwner(UUID.fromString(ownerString));
                    }
                    catch (IllegalArgumentException ignored) {
                        line.setOwner(null);
                    }
                }
                if ((adminStrings = this.config.getStringList(lineId + ".admins")) != null && !adminStrings.isEmpty()) {
                    HashSet<UUID> adminIds = new HashSet<UUID>();
                    for (String adminString : adminStrings) {
                        try {
                            adminIds.add(UUID.fromString(adminString));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                    }
                    line.setAdmins(adminIds);
                }
                this.lines.put(lineId, line);
            }
        }
    }

    public void saveConfig() {
        try {
            for (Line line : this.lines.values()) {
                String lineId = line.getId();
                this.config.set(lineId + ".name", (Object)line.getName());
                this.config.set(lineId + ".ordered_stop_ids", line.getOrderedStopIds());
                this.config.set(lineId + ".color", (Object)line.getColor());
                this.config.set(lineId + ".terminus_name", (Object)line.getTerminusName());
                this.config.set(lineId + ".max_speed", (Object)(line.getMaxSpeed() != null ? line.getMaxSpeed() : null));
                this.config.set(lineId + ".owner", line.getOwner() != null ? line.getOwner().toString() : null);
                ArrayList<String> adminStrings = new ArrayList<String>();
                for (UUID adminId : line.getAdmins()) {
                    if (line.getOwner() != null && line.getOwner().equals(adminId)) continue;
                    adminStrings.add(adminId.toString());
                }
                this.config.set(lineId + ".admins", adminStrings.isEmpty() ? null : adminStrings);
            }
            this.config.save(this.configFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "\u65e0\u6cd5\u4fdd\u5b58\u7ebf\u8def\u914d\u7f6e", e);
        }
    }

    public Line getLine(String lineId) {
        return this.lines.get(lineId);
    }

    public boolean createLine(String lineId, String name, UUID ownerId) {
        if (this.lines.containsKey(lineId)) {
            return false;
        }
        Line line = new Line(lineId, name);
        line.setOwner(ownerId);
        this.lines.put(lineId, line);
        this.saveConfig();
        return true;
    }

    public boolean deleteLine(String lineId) {
        if (!this.lines.containsKey(lineId)) {
            return false;
        }
        this.lines.remove(lineId);
        this.config.set(lineId, null);
        this.saveConfig();
        return true;
    }

    public boolean addStopToLine(String lineId, String stopId, int index) {
        Line line = this.lines.get(lineId);
        if (line == null) {
            return false;
        }
        line.addStop(stopId, index);
        this.saveConfig();
        return true;
    }

    public boolean delStopFromLine(String lineId, String stopId) {
        Line line = this.lines.get(lineId);
        if (line == null) {
            return false;
        }
        line.delStop(stopId);
        this.saveConfig();
        return true;
    }

    public void delStopFromAllLines(String stopId) {
        for (Line line : this.lines.values()) {
            if (!line.containsStop(stopId)) continue;
            line.delStop(stopId);
        }
        this.saveConfig();
    }

    public List<Line> getAllLines() {
        return new ArrayList<Line>(this.lines.values());
    }

    public void reload() {
        this.loadConfig();
    }

    public boolean setLineColor(String lineId, String color) {
        Line line = this.lines.get(lineId);
        if (line == null) {
            return false;
        }
        line.setColor(color);
        this.saveConfig();
        return true;
    }

    public boolean setLineTerminusName(String lineId, String terminusName) {
        Line line = this.lines.get(lineId);
        if (line == null) {
            return false;
        }
        line.setTerminusName(terminusName);
        this.saveConfig();
        return true;
    }

    public boolean setLineName(String lineId, String name) {
        Line line = this.lines.get(lineId);
        if (line == null) {
            return false;
        }
        line.setName(name);
        this.saveConfig();
        return true;
    }

    public boolean setLineMaxSpeed(String lineId, Double maxSpeed) {
        Line line = this.lines.get(lineId);
        if (line == null) {
            return false;
        }
        line.setMaxSpeed(maxSpeed);
        this.saveConfig();
        return true;
    }

    public boolean setLineOwner(String lineId, UUID ownerId) {
        Line line = this.lines.get(lineId);
        if (line == null) {
            return false;
        }
        line.setOwner(ownerId);
        this.saveConfig();
        return true;
    }

    public boolean addLineAdmin(String lineId, UUID adminId) {
        Line line = this.lines.get(lineId);
        if (line == null) {
            return false;
        }
        boolean changed = line.addAdmin(adminId);
        if (changed) {
            this.saveConfig();
        }
        return changed;
    }

    public boolean removeLineAdmin(String lineId, UUID adminId) {
        Line line = this.lines.get(lineId);
        if (line == null) {
            return false;
        }
        boolean changed = line.removeAdmin(adminId);
        if (changed) {
            this.saveConfig();
        }
        return changed;
    }
}

